/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.dialogs;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.internal.corext.util.CollectionsUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.OpenTypeHistory;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.TypeFilter;
import org.eclipse.jdt.internal.corext.util.TypeInfoFilter;
import org.eclipse.jdt.internal.corext.util.TypeInfoRequestorAdapter;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.TypeNameMatchLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.jdt.ui.dialogs.ITypeInfoImageProvider;
import org.eclipse.jdt.ui.dialogs.ITypeSelectionComponent;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.SearchPattern;

public class FilteredTypesSelectionDialog
extends FilteredItemsSelectionDialog
implements ITypeSelectionComponent {
    private static final boolean BUG_184693 = true;
    private static final String DIALOG_SETTINGS = "org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog";
    private static final String SHOW_CONTAINER_FOR_DUPLICATES = "ShowContainerForDuplicates";
    private static final String WORKINGS_SET_SETTINGS = "WorkingSet";
    private WorkingSetFilterActionGroup fFilterActionGroup;
    private final TypeItemLabelProvider fTypeInfoLabelProvider;
    private String fTitle;
    private ShowContainerForDuplicatesAction fShowContainerForDuplicatesAction;
    private IJavaSearchScope fSearchScope;
    private boolean fAllowScopeSwitching;
    private final int fElementKinds;
    private final ITypeInfoFilterExtension fFilterExtension;
    private final TypeSelectionExtension fExtension;
    private ISelectionStatusValidator fValidator;
    private final TypeInfoUtil fTypeInfoUtil;
    private static boolean fgFirstTime = true;
    private final TypeItemsComparator fTypeItemsComparator;
    private int fTypeFilterVersion = 0;
    private TypeItemsFilter fFilter;

    public FilteredTypesSelectionDialog(Shell parent, boolean multi, IRunnableContext context, IJavaSearchScope scope, int elementKinds) {
        this(parent, multi, context, scope, elementKinds, null);
    }

    public FilteredTypesSelectionDialog(Shell shell, boolean multi, IRunnableContext context, IJavaSearchScope scope, int elementKinds, TypeSelectionExtension extension) {
        super(shell, multi);
        this.setSelectionHistory(new TypeSelectionHistory());
        if (scope == null) {
            this.fAllowScopeSwitching = true;
            scope = SearchEngine.createWorkspaceScope();
        }
        this.fElementKinds = elementKinds;
        this.fExtension = extension;
        this.fFilterExtension = extension == null ? null : extension.getFilterExtension();
        this.fSearchScope = scope;
        if (extension != null) {
            this.fValidator = extension.getSelectionValidator();
        }
        this.fTypeInfoUtil = new TypeInfoUtil(extension != null ? extension.getImageProvider() : null);
        this.fTypeInfoLabelProvider = new TypeItemLabelProvider();
        this.setListLabelProvider((ILabelProvider)this.fTypeInfoLabelProvider);
        this.setListSelectionLabelDecorator(this.fTypeInfoLabelProvider);
        this.setDetailsLabelProvider((ILabelProvider)new TypeItemDetailsLabelProvider(this.fTypeInfoUtil));
        this.fTypeItemsComparator = new TypeItemsComparator();
    }

    public void setTitle(String title) {
        super.setTitle(title);
        this.fTitle = title;
    }

    private void setSubtitle(String text) {
        if (text == null || text.length() == 0) {
            this.getShell().setText(this.fTitle);
        } else {
            this.getShell().setText(Messages.format(JavaUIMessages.FilteredTypeSelectionDialog_titleFormat, new String[]{this.fTitle, text}));
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = JavaPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected void storeDialog(IDialogSettings settings) {
        super.storeDialog(settings);
        if (this.fFilterActionGroup != null) {
            XMLMemento memento = XMLMemento.createWriteRoot((String)"workingSet");
            this.fFilterActionGroup.saveState((IMemento)memento);
            this.fFilterActionGroup.dispose();
            StringWriter writer = new StringWriter();
            try {
                memento.save((Writer)writer);
                settings.put(WORKINGS_SET_SETTINGS, writer.getBuffer().toString());
            }
            catch (IOException e) {
                JavaPlugin.log(e);
            }
        }
    }

    protected void restoreDialog(IDialogSettings settings) {
        super.restoreDialog(settings);
        this.fTypeInfoLabelProvider.setContainerInfo(true);
        if (this.fAllowScopeSwitching) {
            IWorkingSet ws;
            String setting = settings.get(WORKINGS_SET_SETTINGS);
            if (setting != null) {
                try {
                    XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(setting));
                    this.fFilterActionGroup.restoreState((IMemento)memento);
                }
                catch (WorkbenchException e) {
                    JavaPlugin.log(e);
                }
            }
            if ((ws = this.fFilterActionGroup.getWorkingSet()) == null || ws.isAggregateWorkingSet() && ws.isEmpty()) {
                this.setSearchScope(SearchEngine.createWorkspaceScope());
                this.setSubtitle(null);
            } else {
                this.setSearchScope(JavaSearchScopeFactory.getInstance().createJavaSearchScope(ws, true));
                this.setSubtitle(ws.getLabel());
            }
        }
    }

    protected void fillViewMenu(IMenuManager menuManager) {
        super.fillViewMenu(menuManager);
        if (this.fAllowScopeSwitching) {
            this.fFilterActionGroup = new WorkingSetFilterActionGroup(this.getShell(), JavaPlugin.getActivePage(), new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    IWorkingSet ws = (IWorkingSet)event.getNewValue();
                    if (ws == null || ws.isAggregateWorkingSet() && ws.isEmpty()) {
                        FilteredTypesSelectionDialog.this.setSearchScope(SearchEngine.createWorkspaceScope());
                        FilteredTypesSelectionDialog.this.setSubtitle(null);
                    } else {
                        FilteredTypesSelectionDialog.this.setSearchScope(JavaSearchScopeFactory.getInstance().createJavaSearchScope(ws, true));
                        FilteredTypesSelectionDialog.this.setSubtitle(ws.getLabel());
                    }
                    FilteredTypesSelectionDialog.this.applyFilter();
                }
            });
            this.fFilterActionGroup.fillViewMenu(menuManager);
        }
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)new TypeFiltersPreferencesAction());
    }

    protected Control createExtendedContentArea(Composite parent) {
        Control addition = null;
        if (this.fExtension != null) {
            addition = this.fExtension.createContentArea(parent);
            if (addition != null) {
                GridData gd = new GridData(768);
                gd.horizontalSpan = 2;
                addition.setLayoutData((Object)gd);
            }
            this.fExtension.initialize(this);
        }
        return addition;
    }

    protected void setResult(List newResult) {
        ArrayList<IType> resultToReturn = new ArrayList<IType>();
        int i = 0;
        while (i < newResult.size()) {
            if (newResult.get(i) instanceof TypeNameMatch) {
                IType type = ((TypeNameMatch)newResult.get(i)).getType();
                if (type.exists()) {
                    resultToReturn.add(type);
                } else {
                    TypeNameMatch typeInfo = (TypeNameMatch)newResult.get(i);
                    IPackageFragmentRoot root = typeInfo.getPackageFragmentRoot();
                    String containerName = JavaElementLabels.getElementLabel((IJavaElement)root, 0x20000000000L);
                    String message = Messages.format(JavaUIMessages.FilteredTypesSelectionDialog_dialogMessage, new String[]{TypeNameMatchLabelProvider.getText(typeInfo, 1), containerName});
                    MessageDialog.openError((Shell)this.getShell(), (String)this.fTitle, (String)message);
                    this.getSelectionHistory().remove((Object)typeInfo);
                }
            }
            ++i;
        }
        super.setResult(resultToReturn);
    }

    public void create() {
        super.create();
        Control patternControl = this.getPatternControl();
        if (patternControl instanceof Text) {
            TextFieldNavigationHandler.install((Text)patternControl);
        }
    }

    public int open() {
        String text;
        ISelection selection;
        IWorkbenchWindow window;
        if (this.getInitialPattern() == null && (window = JavaPlugin.getActiveWorkbenchWindow()) != null && (selection = window.getSelectionService().getSelection()) instanceof ITextSelection && (text = ((ITextSelection)selection).getText()) != null && (text = text.trim()).length() > 0 && JavaConventions.validateJavaTypeName((String)text, (String)"1.3", (String)"1.3").isOK()) {
            this.setInitialPattern(text, 2);
        }
        return super.open();
    }

    public void setValidator(ISelectionStatusValidator validator) {
        this.fValidator = validator;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        this.fFilter = new TypeItemsFilter(this.fSearchScope, this.fElementKinds, this.fFilterExtension);
        return this.fFilter;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.jdt.ui.type_selection_dialog2_context");
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider provider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        TypeItemsFilter typeSearchFilter = (TypeItemsFilter)itemsFilter;
        TypeSearchRequestor requestor = new TypeSearchRequestor(provider, typeSearchFilter);
        SearchEngine engine = new SearchEngine(null);
        String packPattern = typeSearchFilter.getPackagePattern();
        progressMonitor.setTaskName(JavaUIMessages.FilteredTypesSelectionDialog_searchJob_taskName);
        String typePattern = typeSearchFilter.getNamePattern();
        int matchRule = typeSearchFilter.getMatchRule();
        typeSearchFilter.setMatchEverythingMode(true);
        try {
            engine.searchAllTypeNames(packPattern == null ? null : packPattern.toCharArray(), typeSearchFilter.getPackageFlags(), typePattern.toCharArray(), matchRule, typeSearchFilter.getElementKind(), typeSearchFilter.getSearchScope(), (TypeNameMatchRequestor)requestor, 3, progressMonitor);
        }
        finally {
            typeSearchFilter.setMatchEverythingMode(false);
        }
    }

    protected Comparator getItemsComparator() {
        return this.fTypeItemsComparator;
    }

    public String getElementName(Object item) {
        TypeNameMatch type = (TypeNameMatch)item;
        return type.getSimpleTypeName();
    }

    protected IStatus validateItem(Object item) {
        if (item == null) {
            return new Status(4, JavaPlugin.getPluginId(), 4, "", null);
        }
        if (this.fValidator != null) {
            IType type = ((TypeNameMatch)item).getType();
            if (!type.exists()) {
                String qualifiedName = TypeNameMatchLabelProvider.getText((TypeNameMatch)item, 1);
                return new Status(4, JavaPlugin.getPluginId(), 4, Messages.format(JavaUIMessages.FilteredTypesSelectionDialog_error_type_doesnot_exist, qualifiedName), null);
            }
            Object[] elements = new Object[]{type};
            return this.fValidator.validate(elements);
        }
        return Status.OK_STATUS;
    }

    private void setSearchScope(IJavaSearchScope scope) {
        this.fSearchScope = scope;
    }

    public void reloadCache(boolean checkDuplicates, IProgressMonitor monitor) {
        IProgressMonitor remainingMonitor;
        if (ConsistencyRunnable.needsExecution()) {
            monitor.beginTask(JavaUIMessages.TypeSelectionDialog_progress_consistency, 10);
            try {
                ConsistencyRunnable runnable = new ConsistencyRunnable();
                runnable.run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, JavaUIMessages.TypeSelectionDialog_error3Title, JavaUIMessages.TypeSelectionDialog_error3Message);
                this.close();
                return;
            }
            catch (InterruptedException interruptedException) {
                this.close();
                return;
            }
            remainingMonitor = new SubProgressMonitor(monitor, 9);
        } else {
            remainingMonitor = monitor;
        }
        super.reloadCache(checkDuplicates, remainingMonitor);
        monitor.done();
    }

    @Override
    public void triggerSearch() {
        ++this.fTypeFilterVersion;
        this.applyFilter();
    }

    private static class ConsistencyRunnable
    implements IRunnableWithProgress {
        private ConsistencyRunnable() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            if (fgFirstTime) {
                IJobManager manager = Job.getJobManager();
                manager.join((Object)"org.eclipse.jdt.ui", monitor);
            }
            OpenTypeHistory history = OpenTypeHistory.getInstance();
            if (fgFirstTime || history.isEmpty()) {
                if (history.needConsistencyCheck()) {
                    monitor.beginTask(JavaUIMessages.TypeSelectionDialog_progress_consistency, 100);
                    this.refreshSearchIndices((IProgressMonitor)new SubProgressMonitor(monitor, 90));
                    history.checkConsistency((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                } else {
                    this.refreshSearchIndices(monitor);
                }
                monitor.done();
                fgFirstTime = false;
            } else {
                history.checkConsistency(monitor);
            }
        }

        public static boolean needsExecution() {
            OpenTypeHistory history = OpenTypeHistory.getInstance();
            return fgFirstTime || history.isEmpty() || history.needConsistencyCheck();
        }

        private void refreshSearchIndices(IProgressMonitor monitor) throws InvocationTargetException {
            try {
                new SearchEngine().searchAllTypeNames(null, 0, "_______________".toCharArray(), 8, 7, SearchEngine.createWorkspaceScope(), new TypeNameRequestor(){}, 3, monitor);
            }
            catch (JavaModelException e) {
                throw new InvocationTargetException(e);
            }
        }
    }

    private class ShowContainerForDuplicatesAction
    extends Action {
        public ShowContainerForDuplicatesAction() {
            super(JavaUIMessages.FilteredTypeSelectionDialog_showContainerForDuplicatesAction, 2);
        }

        public void run() {
            FilteredTypesSelectionDialog.this.fTypeInfoLabelProvider.setContainerInfo(this.isChecked());
        }
    }

    private class TypeFiltersPreferencesAction
    extends Action {
        public TypeFiltersPreferencesAction() {
            super(JavaUIMessages.FilteredTypesSelectionDialog_TypeFiltersPreferencesAction_label);
        }

        public void run() {
            String typeFilterID = "org.eclipse.jdt.ui.preferences.TypeFilterPreferencePage";
            PreferencesUtil.createPreferenceDialogOn((Shell)FilteredTypesSelectionDialog.this.getShell(), (String)typeFilterID, (String[])new String[]{typeFilterID}, null).open();
            FilteredTypesSelectionDialog.this.triggerSearch();
        }
    }

    private static class TypeInfoUtil {
        private final ITypeInfoImageProvider fProviderExtension;
        private final TypeInfoRequestorAdapter fAdapter = new TypeInfoRequestorAdapter();
        private final Map<IPath, String> fLib2Name = new HashMap<IPath, String>();
        private final IPath[] fInstallLocations;
        private final String[] fVMNames;

        public TypeInfoUtil(ITypeInfoImageProvider extension) {
            this.fProviderExtension = extension;
            ArrayList<IPath> locations = new ArrayList<IPath>();
            ArrayList<String> labels = new ArrayList<String>();
            IVMInstallType[] installs = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < installs.length) {
                this.processVMInstallType(installs[i], locations, labels);
                ++i;
            }
            this.fInstallLocations = CollectionsUtil.toArray(locations, IPath.class);
            this.fVMNames = labels.toArray(new String[labels.size()]);
        }

        private void processVMInstallType(IVMInstallType installType, List<IPath> locations, List<String> labels) {
            if (installType != null) {
                IVMInstall[] installs = installType.getVMInstalls();
                boolean isMac = "macosx".equals(Platform.getOS());
                int i = 0;
                while (i < installs.length) {
                    String label = this.getFormattedLabel(installs[i].getName());
                    LibraryLocation[] libLocations = installs[i].getLibraryLocations();
                    if (libLocations != null) {
                        this.processLibraryLocation(libLocations, label);
                    } else {
                        IPath filePath = Path.fromOSString((String)installs[i].getInstallLocation().getAbsolutePath());
                        if (isMac && "Home".equals(filePath.lastSegment())) {
                            filePath = filePath.removeLastSegments(1);
                        }
                        locations.add(filePath);
                        labels.add(label);
                    }
                    ++i;
                }
            }
        }

        private void processLibraryLocation(LibraryLocation[] libLocations, String label) {
            int l = 0;
            while (l < libLocations.length) {
                LibraryLocation location = libLocations[l];
                this.fLib2Name.put(location.getSystemLibraryPath(), label);
                ++l;
            }
        }

        private String getFormattedLabel(String name) {
            return Messages.format(JavaUIMessages.FilteredTypesSelectionDialog_library_name_format, name);
        }

        public String getQualifiedText(TypeNameMatch type) {
            StringBuffer result = new StringBuffer();
            result.append(type.getSimpleTypeName());
            String containerName = type.getTypeContainerName();
            result.append(JavaElementLabels.CONCAT_STRING);
            if (containerName.length() > 0) {
                result.append(containerName);
            } else {
                result.append(JavaUIMessages.FilteredTypesSelectionDialog_default_package);
            }
            return result.toString();
        }

        public String getFullyQualifiedText(TypeNameMatch type) {
            StringBuffer result = new StringBuffer();
            result.append(type.getSimpleTypeName());
            String containerName = type.getTypeContainerName();
            if (containerName.length() > 0) {
                result.append(JavaElementLabels.CONCAT_STRING);
                result.append(containerName);
            }
            result.append(JavaElementLabels.CONCAT_STRING);
            result.append(this.getContainerName(type));
            return result.toString();
        }

        public String getQualificationText(TypeNameMatch type) {
            StringBuffer result = new StringBuffer();
            String containerName = type.getTypeContainerName();
            if (containerName.length() > 0) {
                result.append(containerName);
                result.append(JavaElementLabels.CONCAT_STRING);
            }
            result.append(this.getContainerName(type));
            return result.toString();
        }

        public ImageDescriptor getContributedImageDescriptor(Object element) {
            TypeNameMatch type = (TypeNameMatch)element;
            if (this.fProviderExtension != null) {
                this.fAdapter.setMatch(type);
                return this.fProviderExtension.getImageDescriptor(this.fAdapter);
            }
            return null;
        }

        private String getContainerName(TypeNameMatch type) {
            IPackageFragmentRoot root = type.getPackageFragmentRoot();
            if (root.isExternal()) {
                IPath path = root.getPath();
                int i = 0;
                while (i < this.fInstallLocations.length) {
                    if (this.fInstallLocations[i].isPrefixOf(path)) {
                        return this.fVMNames[i];
                    }
                    ++i;
                }
                String lib = this.fLib2Name.get(path);
                if (lib != null) {
                    return lib;
                }
            }
            StringBuffer buf = new StringBuffer();
            JavaElementLabels.getPackageFragmentRootLabel(root, 0x30000000000L, buf);
            return buf.toString();
        }
    }

    private static class TypeItemDetailsLabelProvider
    extends LabelProvider {
        private final TypeInfoUtil fTypeInfoUtil;

        public TypeItemDetailsLabelProvider(TypeInfoUtil typeInfoUtil) {
            this.fTypeInfoUtil = typeInfoUtil;
        }

        public Image getImage(Object element) {
            if (element instanceof TypeNameMatch) {
                return TypeNameMatchLabelProvider.getImage((TypeNameMatch)element, 32);
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof TypeNameMatch) {
                return BasicElementLabels.getJavaElementName(this.fTypeInfoUtil.getQualificationText((TypeNameMatch)element));
            }
            return super.getText(element);
        }
    }

    private class TypeItemLabelProvider
    extends LabelProvider
    implements ILabelDecorator,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private boolean fContainerInfo;
        private LocalResourceManager fImageManager = new LocalResourceManager(JFaceResources.getResources());
        private Font fBoldFont;
        private StyledString.Styler fBoldStyler = this.createBoldStyler();
        private StyledString.Styler fBoldQualifierStyler = this.createBoldQualifierStyler();

        public void dispose() {
            super.dispose();
            this.fImageManager.dispose();
            if (this.fBoldFont != null) {
                this.fBoldFont.dispose();
                this.fBoldFont = null;
            }
        }

        public void setContainerInfo(boolean containerInfo) {
            this.fContainerInfo = containerInfo;
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }

        public Image getImage(Object element) {
            if (!(element instanceof TypeNameMatch)) {
                return super.getImage(element);
            }
            ImageDescriptor contributedImageDescriptor = FilteredTypesSelectionDialog.this.fTypeInfoUtil.getContributedImageDescriptor(element);
            if (contributedImageDescriptor == null) {
                return TypeNameMatchLabelProvider.getImage((TypeNameMatch)element, 16);
            }
            return this.fImageManager.createImage(contributedImageDescriptor);
        }

        public String getText(Object element) {
            if (!(element instanceof TypeNameMatch)) {
                return super.getText(element);
            }
            TypeNameMatch typeMatch = (TypeNameMatch)element;
            if (this.fContainerInfo && FilteredTypesSelectionDialog.this.isDuplicateElement(element)) {
                return BasicElementLabels.getJavaElementName(FilteredTypesSelectionDialog.this.fTypeInfoUtil.getFullyQualifiedText(typeMatch));
            }
            if (!this.fContainerInfo && FilteredTypesSelectionDialog.this.isDuplicateElement(element)) {
                return BasicElementLabels.getJavaElementName(FilteredTypesSelectionDialog.this.fTypeInfoUtil.getQualifiedText(typeMatch));
            }
            return BasicElementLabels.getJavaElementName(typeMatch.getSimpleTypeName());
        }

        public Image decorateImage(Image image, Object element) {
            return image;
        }

        public String decorateText(String text, Object element) {
            if (!(element instanceof TypeNameMatch)) {
                return null;
            }
            if (this.fContainerInfo && FilteredTypesSelectionDialog.this.isDuplicateElement(element)) {
                return BasicElementLabels.getJavaElementName(FilteredTypesSelectionDialog.this.fTypeInfoUtil.getFullyQualifiedText((TypeNameMatch)element));
            }
            return BasicElementLabels.getJavaElementName(FilteredTypesSelectionDialog.this.fTypeInfoUtil.getQualifiedText((TypeNameMatch)element));
        }

        public StyledString getStyledText(Object element) {
            String namePattern;
            String text = this.getText(element);
            StyledString string = new StyledString(text);
            int index = text.indexOf(JavaElementLabels.CONCAT_STRING);
            String string2 = namePattern = FilteredTypesSelectionDialog.this.fFilter != null ? FilteredTypesSelectionDialog.this.fFilter.getNamePattern() : null;
            if (namePattern != null && !"*".equals(namePattern)) {
                String typeName = index == -1 ? text : text.substring(0, index);
                int[] matchingRegions = org.eclipse.jdt.core.search.SearchPattern.getMatchingRegions((String)namePattern, (String)typeName, (int)FilteredTypesSelectionDialog.this.fFilter.getMatchRule());
                this.markMatchingRegions(string, 0, matchingRegions, this.fBoldStyler);
            }
            if (index != -1) {
                String packagePattern;
                string.setStyle(index, text.length() - index, StyledString.QUALIFIER_STYLER);
                String string3 = packagePattern = FilteredTypesSelectionDialog.this.fFilter != null ? FilteredTypesSelectionDialog.this.fFilter.getPackagePattern() : null;
                if (packagePattern != null && !"*".equals(packagePattern)) {
                    int endIndex = text.indexOf(JavaElementLabels.CONCAT_STRING, index += JavaElementLabels.CONCAT_STRING.length());
                    String packageName = endIndex == -1 ? text.substring(index) : text.substring(index, endIndex);
                    int[] matchingRegions = org.eclipse.jdt.core.search.SearchPattern.getMatchingRegions((String)packagePattern, (String)packageName, (int)FilteredTypesSelectionDialog.this.fFilter.getPackageFlags());
                    this.markMatchingRegions(string, index, matchingRegions, this.fBoldQualifierStyler);
                }
            }
            return string;
        }

        private void markMatchingRegions(StyledString string, int index, int[] matchingRegions, StyledString.Styler styler) {
            if (matchingRegions != null) {
                int offset = -1;
                int length = 0;
                int i = 0;
                while (i + 1 < matchingRegions.length) {
                    if (offset == -1) {
                        offset = index + matchingRegions[i];
                    }
                    if (i + 2 < matchingRegions.length && matchingRegions[i] + matchingRegions[i + 1] == matchingRegions[i + 2]) {
                        length += matchingRegions[i + 1];
                    } else {
                        string.setStyle(offset, length + matchingRegions[i + 1], styler);
                        offset = -1;
                        length = 0;
                    }
                    i += 2;
                }
            }
        }

        private Font getBoldFont() {
            if (this.fBoldFont == null) {
                Font font = FilteredTypesSelectionDialog.this.getDialogArea().getFont();
                FontData[] data = font.getFontData();
                int i = 0;
                while (i < data.length) {
                    data[i].setStyle(1);
                    ++i;
                }
                this.fBoldFont = new Font(font.getDevice(), data);
            }
            return this.fBoldFont;
        }

        private StyledString.Styler createBoldStyler() {
            return new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    textStyle.font = TypeItemLabelProvider.this.getBoldFont();
                }
            };
        }

        private StyledString.Styler createBoldQualifierStyler() {
            return new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    StyledString.QUALIFIER_STYLER.applyStyles(textStyle);
                    textStyle.font = TypeItemLabelProvider.this.getBoldFont();
                }
            };
        }
    }

    private static class TypeItemsComparator
    implements Comparator<TypeNameMatch> {
        private final Map<String, String> fLib2Name = new HashMap<String, String>();
        private final String[] fInstallLocations;
        private final String[] fVMNames;

        public TypeItemsComparator() {
            ArrayList<String> locations = new ArrayList<String>();
            ArrayList<String> labels = new ArrayList<String>();
            IVMInstallType[] installs = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < installs.length) {
                this.processVMInstallType(installs[i], locations, labels);
                ++i;
            }
            this.fInstallLocations = locations.toArray(new String[locations.size()]);
            this.fVMNames = labels.toArray(new String[labels.size()]);
        }

        private void processVMInstallType(IVMInstallType installType, List<String> locations, List<String> labels) {
            if (installType != null) {
                IVMInstall[] installs = installType.getVMInstalls();
                boolean isMac = "macosx".equals(Platform.getOS());
                int i = 0;
                while (i < installs.length) {
                    String label = this.getFormattedLabel(installs[i].getName());
                    LibraryLocation[] libLocations = installs[i].getLibraryLocations();
                    if (libLocations != null) {
                        this.processLibraryLocation(libLocations, label);
                    } else {
                        String filePath = installs[i].getInstallLocation().getAbsolutePath();
                        if (isMac && filePath.endsWith("/Home")) {
                            filePath = filePath.substring(0, filePath.length() - "/Home".length() + 1);
                        }
                        locations.add(filePath);
                        labels.add(label);
                    }
                    ++i;
                }
            }
        }

        private void processLibraryLocation(LibraryLocation[] libLocations, String label) {
            int l = 0;
            while (l < libLocations.length) {
                LibraryLocation location = libLocations[l];
                this.fLib2Name.put(location.getSystemLibraryPath().toString(), label);
                ++l;
            }
        }

        private String getFormattedLabel(String name) {
            return MessageFormat.format(JavaUIMessages.FilteredTypesSelectionDialog_library_name_format, name);
        }

        @Override
        public int compare(TypeNameMatch leftInfo, TypeNameMatch rightInfo) {
            int rightCategory;
            int result = this.compareName(leftInfo.getSimpleTypeName(), rightInfo.getSimpleTypeName());
            if (result != 0) {
                return result;
            }
            result = this.compareDeprecation(leftInfo.getModifiers(), rightInfo.getModifiers());
            if (result != 0) {
                return result;
            }
            result = this.compareTypeContainerName(leftInfo.getTypeContainerName(), rightInfo.getTypeContainerName());
            if (result != 0) {
                return result;
            }
            int leftCategory = this.getElementTypeCategory(leftInfo);
            if (leftCategory < (rightCategory = this.getElementTypeCategory(rightInfo))) {
                return -1;
            }
            if (leftCategory > rightCategory) {
                return 1;
            }
            return this.compareContainerName(leftInfo, rightInfo);
        }

        private int compareName(String leftString, String rightString) {
            int result = leftString.compareToIgnoreCase(rightString);
            if (result != 0 || rightString.length() == 0) {
                return result;
            }
            if (Strings.isLowerCase(leftString.charAt(0)) && !Strings.isLowerCase(rightString.charAt(0))) {
                return 1;
            }
            if (Strings.isLowerCase(rightString.charAt(0)) && !Strings.isLowerCase(leftString.charAt(0))) {
                return -1;
            }
            return leftString.compareTo(rightString);
        }

        private int compareDeprecation(int leftType, int rightType) {
            boolean rightIsDeprecated = Flags.isDeprecated((int)rightType);
            if (Flags.isDeprecated((int)leftType)) {
                return rightIsDeprecated ? 0 : 1;
            }
            return rightIsDeprecated ? -1 : 0;
        }

        private int compareTypeContainerName(String leftString, String rightString) {
            int leftLength = leftString.length();
            int rightLength = rightString.length();
            if (leftLength == 0 && rightLength > 0) {
                return -1;
            }
            if (leftLength == 0 && rightLength == 0) {
                return 0;
            }
            if (leftLength > 0 && rightLength == 0) {
                return 1;
            }
            return this.compareName(leftString, rightString);
        }

        private int compareContainerName(TypeNameMatch leftType, TypeNameMatch rightType) {
            return this.getContainerName(leftType).compareTo(this.getContainerName(rightType));
        }

        private String getContainerName(TypeNameMatch type) {
            IPackageFragmentRoot root = type.getPackageFragmentRoot();
            if (root.isExternal()) {
                String name = root.getPath().toOSString();
                int i = 0;
                while (i < this.fInstallLocations.length) {
                    if (name.startsWith(this.fInstallLocations[i])) {
                        return this.fVMNames[i];
                    }
                    ++i;
                }
                String lib = this.fLib2Name.get(name);
                if (lib != null) {
                    return lib;
                }
            }
            StringBuffer buf = new StringBuffer();
            JavaElementLabels.getPackageFragmentRootLabel(root, 0x30000000000L, buf);
            return buf.toString();
        }

        private int getElementTypeCategory(TypeNameMatch type) {
            try {
                if (type.getPackageFragmentRoot().getKind() == 1) {
                    return 0;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            return 1;
        }
    }

    private class TypeItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private boolean fMatchEverything;
        private final int fMyTypeFilterVersion;
        private final TypeInfoFilter fTypeInfoFilter;

        public TypeItemsFilter(IJavaSearchScope scope, int elementKind, ITypeInfoFilterExtension extension) {
            super((FilteredItemsSelectionDialog)FilteredTypesSelectionDialog.this, (SearchPattern)new TypeSearchPattern());
            this.fMatchEverything = false;
            this.fMyTypeFilterVersion = FilteredTypesSelectionDialog.this.fTypeFilterVersion;
            String pattern = this.patternMatcher.getPattern();
            this.fTypeInfoFilter = new TypeInfoFilter(pattern, scope, elementKind, extension);
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (!(filter instanceof TypeItemsFilter)) {
                return false;
            }
            TypeItemsFilter typeItemsFilter = (TypeItemsFilter)filter;
            if (this.fMyTypeFilterVersion != typeItemsFilter.getMyTypeFilterVersion()) {
                return false;
            }
            return typeItemsFilter.fTypeInfoFilter.isSubFilter(this.fTypeInfoFilter.getText());
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter iFilter) {
            if (!(iFilter instanceof TypeItemsFilter)) {
                return false;
            }
            TypeItemsFilter typeItemsFilter = (TypeItemsFilter)iFilter;
            if (!this.getPattern().equals(typeItemsFilter.getPattern())) {
                return false;
            }
            if (this.getSearchScope() != typeItemsFilter.getSearchScope()) {
                return false;
            }
            return this.fMyTypeFilterVersion == typeItemsFilter.getMyTypeFilterVersion();
        }

        public int getElementKind() {
            return this.fTypeInfoFilter.getElementKind();
        }

        public IJavaSearchScope getSearchScope() {
            return this.fTypeInfoFilter.getSearchScope();
        }

        public int getMyTypeFilterVersion() {
            return this.fMyTypeFilterVersion;
        }

        public String getNamePattern() {
            return this.fTypeInfoFilter.getNamePattern();
        }

        public String getPackagePattern() {
            return this.fTypeInfoFilter.getPackagePattern();
        }

        public int getPackageFlags() {
            return this.fTypeInfoFilter.getPackageFlags();
        }

        public boolean matchesRawNamePattern(TypeNameMatch type) {
            return this.fTypeInfoFilter.matchesRawNamePattern(type);
        }

        public boolean matchesFilterExtension(TypeNameMatch type) {
            return this.fTypeInfoFilter.matchesFilterExtension(type);
        }

        public void setMatchEverythingMode(boolean matchEverything) {
            this.fMatchEverything = matchEverything;
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            if (this.fMatchEverything) {
                return true;
            }
            TypeNameMatch type = (TypeNameMatch)item;
            return this.fTypeInfoFilter.matchesHistoryElement(type);
        }

        public boolean matchesRawNamePattern(Object item) {
            TypeNameMatch type = (TypeNameMatch)item;
            return this.matchesRawNamePattern(type);
        }

        public int getMatchRule() {
            return this.fTypeInfoFilter.getSearchFlags();
        }

        public String getPattern() {
            return this.fTypeInfoFilter.getText();
        }

        public boolean isCamelCasePattern() {
            return this.fTypeInfoFilter.isCamelCasePattern();
        }

        protected boolean matches(String text) {
            throw new UnsupportedOperationException();
        }
    }

    private static class TypeSearchPattern
    extends SearchPattern {
        private String fPattern;

        private TypeSearchPattern() {
        }

        public void setPattern(String stringPattern) {
            this.fPattern = stringPattern;
        }

        public String getPattern() {
            return this.fPattern;
        }
    }

    private static class TypeSearchRequestor
    extends TypeNameMatchRequestor {
        private volatile boolean fStop;
        private final FilteredItemsSelectionDialog.AbstractContentProvider fContentProvider;
        private final TypeItemsFilter fTypeItemsFilter;

        public TypeSearchRequestor(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, TypeItemsFilter typeItemsFilter) {
            this.fContentProvider = contentProvider;
            this.fTypeItemsFilter = typeItemsFilter;
        }

        public void acceptTypeNameMatch(TypeNameMatch match) {
            if (this.fStop) {
                return;
            }
            if (TypeFilter.isFiltered(match)) {
                return;
            }
            if (this.fTypeItemsFilter.matchesFilterExtension(match)) {
                this.fContentProvider.add((Object)match, (FilteredItemsSelectionDialog.ItemsFilter)this.fTypeItemsFilter);
            }
        }
    }

    protected class TypeSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        public synchronized void accessed(Object object) {
            super.accessed(object);
        }

        public synchronized boolean remove(Object element) {
            OpenTypeHistory.getInstance().remove((TypeNameMatch)element);
            return super.remove(element);
        }

        public void load(IMemento memento) {
            TypeNameMatch[] types = OpenTypeHistory.getInstance().getTypeInfos();
            int i = types.length - 1;
            while (i >= 0) {
                TypeNameMatch type = types[i];
                this.accessed(type);
                --i;
            }
        }

        public void save(IMemento memento) {
            this.persistHistory();
        }

        private synchronized void persistHistory() {
            if (FilteredTypesSelectionDialog.this.getReturnCode() == 0) {
                Object[] items = this.getHistoryItems();
                int i = 0;
                while (i < items.length) {
                    OpenTypeHistory.getInstance().accessed((TypeNameMatch)items[i]);
                    ++i;
                }
            }
        }

        protected Object restoreItemFromMemento(IMemento element) {
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento element) {
        }
    }
}

