/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.reorg.SourceReferenceUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ConstructorReferenceFinder;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.jdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.TypeVariableMaplet;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsModel;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsSolver;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeRefactoringProcessor;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.TextEditBasedChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEditGroup;

public abstract class HierarchyProcessor
extends SuperTypeRefactoringProcessor {
    protected IType fCachedDeclaringType;
    protected final Map<IMember, Object[]> fCachedMembersReferences = new HashMap<IMember, Object[]>(2);
    protected IType[] fCachedReferencedTypes;
    protected TextEditBasedChangeManager fChangeManager;
    protected final boolean fLayer;
    protected IMember[] fMembersToMove;

    protected static boolean areAllFragmentsDeleted(FieldDeclaration declaration, List<ASTNode> declarationNodes) {
        Iterator iterator = declaration.fragments().iterator();
        while (iterator.hasNext()) {
            if (declarationNodes.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    protected static RefactoringStatus checkProjectCompliance(CompilationUnitRewrite sourceRewriter, IType destination, IMember[] members) {
        RefactoringStatus status = new RefactoringStatus();
        if (!JavaModelUtil.is50OrHigher(destination.getJavaProject())) {
            int index = 0;
            while (index < members.length) {
                try {
                    BodyDeclaration decl = ASTNodeSearchUtil.getBodyDeclarationNode(members[index], sourceRewriter.getRoot());
                    if (decl != null) {
                        Iterator iterator = decl.modifiers().iterator();
                        while (iterator.hasNext()) {
                            boolean reported = false;
                            IExtendedModifier modifier = (IExtendedModifier)iterator.next();
                            if (reported || !modifier.isAnnotation()) continue;
                            status.merge(RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.PullUpRefactoring_incompatible_langauge_constructs, new String[]{JavaElementLabels.getTextLabel(members[index], JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getTextLabel(destination, JavaElementLabels.ALL_DEFAULT)}), (RefactoringStatusContext)JavaStatusContext.create(members[index])));
                            reported = true;
                        }
                    }
                }
                catch (JavaModelException exception) {
                    JavaPlugin.log(exception);
                }
                if (members[index] instanceof IMethod) {
                    IMethod method = (IMethod)members[index];
                    try {
                        if (Flags.isVarargs((int)method.getFlags())) {
                            status.merge(RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.PullUpRefactoring_incompatible_language_constructs1, new String[]{JavaElementLabels.getTextLabel(members[index], JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getTextLabel(destination, JavaElementLabels.ALL_DEFAULT)}), (RefactoringStatusContext)JavaStatusContext.create(members[index])));
                        }
                    }
                    catch (JavaModelException exception) {
                        JavaPlugin.log(exception);
                    }
                }
                ++index;
            }
        }
        return status;
    }

    protected static void copyAnnotations(FieldDeclaration oldField, FieldDeclaration newField) {
        AST ast = newField.getAST();
        int index = 0;
        int n = oldField.modifiers().size();
        while (index < n) {
            IExtendedModifier modifier = (IExtendedModifier)oldField.modifiers().get(index);
            List modifiers = newField.modifiers();
            if (modifier.isAnnotation() && !modifiers.contains(modifier)) {
                modifiers.add((IExtendedModifier)ASTNode.copySubtree((AST)ast, (ASTNode)((Annotation)modifier)));
            }
            ++index;
        }
    }

    protected static void copyAnnotations(MethodDeclaration oldMethod, MethodDeclaration newMethod) {
        AST ast = newMethod.getAST();
        int index = 0;
        int n = oldMethod.modifiers().size();
        while (index < n) {
            IExtendedModifier modifier = (IExtendedModifier)oldMethod.modifiers().get(index);
            List modifiers = newMethod.modifiers();
            if (modifier.isAnnotation() && !modifiers.contains(modifier)) {
                modifiers.add((IExtendedModifier)ASTNode.copySubtree((AST)ast, (ASTNode)((Annotation)modifier)));
            }
            ++index;
        }
    }

    protected static void copyJavadocNode(ASTRewrite rewrite, BodyDeclaration oldDeclaration, BodyDeclaration newDeclaration) throws JavaModelException {
        String newString;
        Javadoc predecessor = oldDeclaration.getJavadoc();
        if (predecessor != null && (newString = ASTNodes.getNodeSource((ASTNode)predecessor, false, true)) != null) {
            newDeclaration.setJavadoc((Javadoc)rewrite.createStringPlaceholder(newString, 29));
        }
    }

    protected static void copyThrownExceptions(MethodDeclaration oldMethod, MethodDeclaration newMethod) {
        AST ast = newMethod.getAST();
        int index = 0;
        int n = oldMethod.thrownExceptions().size();
        while (index < n) {
            newMethod.thrownExceptions().add(ASTNode.copySubtree((AST)ast, (ASTNode)((Name)oldMethod.thrownExceptions().get(index))));
            ++index;
        }
    }

    protected static void copyTypeParameters(MethodDeclaration oldMethod, MethodDeclaration newMethod) {
        AST ast = newMethod.getAST();
        int index = 0;
        int n = oldMethod.typeParameters().size();
        while (index < n) {
            newMethod.typeParameters().add(ASTNode.copySubtree((AST)ast, (ASTNode)((TypeParameter)oldMethod.typeParameters().get(index))));
            ++index;
        }
    }

    protected static String createLabel(IMember member) {
        if (member instanceof IType) {
            return JavaElementLabels.getTextLabel(member, JavaElementLabels.ALL_FULLY_QUALIFIED);
        }
        if (member instanceof IMethod) {
            return JavaElementLabels.getTextLabel(member, JavaElementLabels.ALL_FULLY_QUALIFIED);
        }
        if (member instanceof IField) {
            return JavaElementLabels.getTextLabel(member, JavaElementLabels.ALL_FULLY_QUALIFIED);
        }
        if (member instanceof IInitializer) {
            return RefactoringCoreMessages.HierarchyRefactoring_initializer;
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    protected static FieldDeclaration createNewFieldDeclarationNode(ASTRewrite rewrite, CompilationUnit unit, IField field, VariableDeclarationFragment oldFieldFragment, TypeVariableMaplet[] mapping, IProgressMonitor monitor, RefactoringStatus status, int modifiers) throws JavaModelException {
        VariableDeclarationFragment newFragment = rewrite.getAST().newVariableDeclarationFragment();
        newFragment.setExtraDimensions(oldFieldFragment.getExtraDimensions());
        if (oldFieldFragment.getInitializer() != null) {
            Expression newInitializer = null;
            newInitializer = mapping.length > 0 ? HierarchyProcessor.createPlaceholderForExpression(oldFieldFragment.getInitializer(), field.getCompilationUnit(), mapping, rewrite) : HierarchyProcessor.createPlaceholderForExpression(oldFieldFragment.getInitializer(), field.getCompilationUnit(), rewrite);
            newFragment.setInitializer(newInitializer);
        }
        newFragment.setName((SimpleName)ASTNode.copySubtree((AST)rewrite.getAST(), (ASTNode)oldFieldFragment.getName()));
        FieldDeclaration newField = rewrite.getAST().newFieldDeclaration(newFragment);
        FieldDeclaration oldField = ASTNodeSearchUtil.getFieldDeclarationNode(field, unit);
        HierarchyProcessor.copyJavadocNode(rewrite, (BodyDeclaration)oldField, (BodyDeclaration)newField);
        HierarchyProcessor.copyAnnotations(oldField, newField);
        newField.modifiers().addAll(ASTNodeFactory.newModifiers(rewrite.getAST(), modifiers));
        Type oldType = oldField.getType();
        Type newType = null;
        newType = mapping.length > 0 ? HierarchyProcessor.createPlaceholderForType(oldType, field.getCompilationUnit(), mapping, rewrite) : HierarchyProcessor.createPlaceholderForType(oldType, field.getCompilationUnit(), rewrite);
        newField.setType(newType);
        return newField;
    }

    protected static Expression createPlaceholderForExpression(Expression expression, ICompilationUnit declaringCu, ASTRewrite rewrite) throws JavaModelException {
        return (Expression)rewrite.createStringPlaceholder(declaringCu.getBuffer().getText(expression.getStartPosition(), expression.getLength()), 32);
    }

    protected static Expression createPlaceholderForExpression(Expression expression, ICompilationUnit declaringCu, TypeVariableMaplet[] mapping, ASTRewrite rewrite) throws JavaModelException {
        Expression result = null;
        try {
            Document document = new Document(declaringCu.getBuffer().getContents());
            ASTRewrite rewriter = ASTRewrite.create((AST)expression.getAST());
            ITrackedNodePosition position = rewriter.track((ASTNode)expression);
            expression.accept((ASTVisitor)new TypeVariableMapper(rewriter, mapping));
            rewriter.rewriteAST((IDocument)document, declaringCu.getJavaProject().getOptions(true)).apply((IDocument)document, 0);
            result = (Expression)rewrite.createStringPlaceholder(document.get(position.getStartPosition(), position.getLength()), 32);
        }
        catch (MalformedTreeException exception) {
            JavaPlugin.log(exception);
        }
        catch (BadLocationException exception) {
            JavaPlugin.log(exception);
        }
        return result;
    }

    protected static BodyDeclaration createPlaceholderForProtectedTypeDeclaration(BodyDeclaration bodyDeclaration, CompilationUnit declaringCuNode, ICompilationUnit declaringCu, ASTRewrite rewrite, boolean removeIndentation) throws JavaModelException {
        String text = null;
        try {
            ASTRewrite rewriter = ASTRewrite.create((AST)bodyDeclaration.getAST());
            ModifierRewrite.create(rewriter, (ASTNode)bodyDeclaration).setVisibility(4, null);
            ITrackedNodePosition position = rewriter.track((ASTNode)bodyDeclaration);
            Document document = new Document(declaringCu.getBuffer().getText(declaringCuNode.getStartPosition(), declaringCuNode.getLength()));
            rewriter.rewriteAST((IDocument)document, declaringCu.getJavaProject().getOptions(true)).apply((IDocument)document, 2);
            text = document.get(position.getStartPosition(), position.getLength());
        }
        catch (BadLocationException badLocationException) {
            text = HierarchyProcessor.getNewText((ASTNode)bodyDeclaration, declaringCu, removeIndentation);
        }
        return (BodyDeclaration)rewrite.createStringPlaceholder(text, 55);
    }

    protected static BodyDeclaration createPlaceholderForProtectedTypeDeclaration(final BodyDeclaration bodyDeclaration, CompilationUnit declaringCuNode, ICompilationUnit declaringCu, TypeVariableMaplet[] mapping, ASTRewrite rewrite, boolean removeIndentation) throws JavaModelException {
        BodyDeclaration result = null;
        try {
            Document document = new Document(declaringCu.getBuffer().getContents());
            ASTRewrite rewriter = ASTRewrite.create((AST)bodyDeclaration.getAST());
            ITrackedNodePosition position = rewriter.track((ASTNode)bodyDeclaration);
            bodyDeclaration.accept((ASTVisitor)new TypeVariableMapper(rewriter, mapping){

                public final boolean visit(AnnotationTypeDeclaration node) {
                    ModifierRewrite.create(this.fRewrite, (ASTNode)bodyDeclaration).setVisibility(4, null);
                    return true;
                }

                public final boolean visit(EnumDeclaration node) {
                    ModifierRewrite.create(this.fRewrite, (ASTNode)bodyDeclaration).setVisibility(4, null);
                    return true;
                }

                public final boolean visit(TypeDeclaration node) {
                    ModifierRewrite.create(this.fRewrite, (ASTNode)bodyDeclaration).setVisibility(4, null);
                    return true;
                }
            });
            rewriter.rewriteAST((IDocument)document, declaringCu.getJavaProject().getOptions(true)).apply((IDocument)document, 0);
            result = (BodyDeclaration)rewrite.createStringPlaceholder(document.get(position.getStartPosition(), position.getLength()), 55);
        }
        catch (MalformedTreeException exception) {
            JavaPlugin.log(exception);
        }
        catch (BadLocationException exception) {
            JavaPlugin.log(exception);
        }
        return result;
    }

    protected static SingleVariableDeclaration createPlaceholderForSingleVariableDeclaration(SingleVariableDeclaration declaration, ICompilationUnit declaringCu, ASTRewrite rewrite) throws JavaModelException {
        return (SingleVariableDeclaration)rewrite.createStringPlaceholder(declaringCu.getBuffer().getText(declaration.getStartPosition(), declaration.getLength()), 44);
    }

    protected static SingleVariableDeclaration createPlaceholderForSingleVariableDeclaration(SingleVariableDeclaration declaration, ICompilationUnit declaringCu, TypeVariableMaplet[] mapping, ASTRewrite rewrite) throws JavaModelException {
        SingleVariableDeclaration result = null;
        try {
            Document document = new Document(declaringCu.getBuffer().getContents());
            ASTRewrite rewriter = ASTRewrite.create((AST)declaration.getAST());
            ITrackedNodePosition position = rewriter.track((ASTNode)declaration);
            declaration.accept((ASTVisitor)new TypeVariableMapper(rewriter, mapping));
            rewriter.rewriteAST((IDocument)document, declaringCu.getJavaProject().getOptions(true)).apply((IDocument)document, 0);
            result = (SingleVariableDeclaration)rewrite.createStringPlaceholder(document.get(position.getStartPosition(), position.getLength()), 44);
        }
        catch (MalformedTreeException exception) {
            JavaPlugin.log(exception);
        }
        catch (BadLocationException exception) {
            JavaPlugin.log(exception);
        }
        return result;
    }

    protected static Type createPlaceholderForType(Type type, ICompilationUnit declaringCu, ASTRewrite rewrite) throws JavaModelException {
        return (Type)rewrite.createStringPlaceholder(declaringCu.getBuffer().getText(type.getStartPosition(), type.getLength()), 43);
    }

    protected static Type createPlaceholderForType(Type type, ICompilationUnit declaringCu, TypeVariableMaplet[] mapping, ASTRewrite rewrite) throws JavaModelException {
        Type result = null;
        try {
            Document document = new Document(declaringCu.getBuffer().getContents());
            ASTRewrite rewriter = ASTRewrite.create((AST)type.getAST());
            ITrackedNodePosition position = rewriter.track((ASTNode)type);
            type.accept((ASTVisitor)new TypeVariableMapper(rewriter, mapping));
            rewriter.rewriteAST((IDocument)document, declaringCu.getJavaProject().getOptions(true)).apply((IDocument)document, 0);
            result = (Type)rewrite.createStringPlaceholder(document.get(position.getStartPosition(), position.getLength()), 43);
        }
        catch (MalformedTreeException exception) {
            JavaPlugin.log(exception);
        }
        catch (BadLocationException exception) {
            JavaPlugin.log(exception);
        }
        return result;
    }

    protected static BodyDeclaration createPlaceholderForTypeDeclaration(BodyDeclaration bodyDeclaration, ICompilationUnit declaringCu, ASTRewrite rewrite, boolean removeIndentation) throws JavaModelException {
        return (BodyDeclaration)rewrite.createStringPlaceholder(HierarchyProcessor.getNewText((ASTNode)bodyDeclaration, declaringCu, removeIndentation), 55);
    }

    protected static BodyDeclaration createPlaceholderForTypeDeclaration(BodyDeclaration bodyDeclaration, ICompilationUnit declaringCu, TypeVariableMaplet[] mapping, ASTRewrite rewrite, boolean removeIndentation) throws JavaModelException {
        BodyDeclaration result = null;
        try {
            Document document = new Document(declaringCu.getBuffer().getContents());
            ASTRewrite rewriter = ASTRewrite.create((AST)bodyDeclaration.getAST());
            ITrackedNodePosition position = rewriter.track((ASTNode)bodyDeclaration);
            bodyDeclaration.accept((ASTVisitor)new TypeVariableMapper(rewriter, mapping));
            rewriter.rewriteAST((IDocument)document, declaringCu.getJavaProject().getOptions(true)).apply((IDocument)document, 0);
            result = (BodyDeclaration)rewrite.createStringPlaceholder(document.get(position.getStartPosition(), position.getLength()), 55);
        }
        catch (MalformedTreeException exception) {
            JavaPlugin.log(exception);
        }
        catch (BadLocationException exception) {
            JavaPlugin.log(exception);
        }
        return result;
    }

    protected static void deleteDeclarationNodes(CompilationUnitRewrite sourceRewriter, boolean sameCu, CompilationUnitRewrite unitRewriter, List<IMember> members, GroupCategorySet set) throws JavaModelException {
        List<ASTNode> declarationNodes = HierarchyProcessor.getDeclarationNodes(unitRewriter.getRoot(), members);
        for (ASTNode node : declarationNodes) {
            ASTRewrite rewriter = unitRewriter.getASTRewrite();
            ImportRemover remover = unitRewriter.getImportRemover();
            if (node instanceof VariableDeclarationFragment) {
                if (!(node.getParent() instanceof FieldDeclaration)) continue;
                FieldDeclaration declaration = (FieldDeclaration)node.getParent();
                if (HierarchyProcessor.areAllFragmentsDeleted(declaration, declarationNodes)) {
                    rewriter.remove((ASTNode)declaration, (TextEditGroup)unitRewriter.createCategorizedGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_remove_member, set));
                    if (sameCu) continue;
                    remover.registerRemovedNode((ASTNode)declaration);
                    continue;
                }
                rewriter.remove(node, (TextEditGroup)unitRewriter.createCategorizedGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_remove_member, set));
                if (sameCu) continue;
                remover.registerRemovedNode(node);
                continue;
            }
            rewriter.remove(node, (TextEditGroup)unitRewriter.createCategorizedGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_remove_member, set));
            if (sameCu) continue;
            remover.registerRemovedNode(node);
        }
    }

    protected static List<ASTNode> getDeclarationNodes(CompilationUnit cuNode, List<IMember> members) throws JavaModelException {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(members.size());
        for (IMember member : members) {
            Object node = null;
            if (member instanceof IField) {
                node = Flags.isEnum((int)member.getFlags()) ? ASTNodeSearchUtil.getEnumConstantDeclaration((IField)member, cuNode) : ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)member, cuNode);
            } else if (member instanceof IType) {
                node = ASTNodeSearchUtil.getAbstractTypeDeclarationNode((IType)member, cuNode);
            } else if (member instanceof IMethod) {
                node = ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)member, cuNode);
            }
            if (node == null) continue;
            result.add((ASTNode)node);
        }
        return result;
    }

    protected static String getNewText(ASTNode node, ICompilationUnit declaringCu, boolean removeIndentation) throws JavaModelException {
        String result = declaringCu.getBuffer().getText(node.getStartPosition(), node.getLength());
        if (removeIndentation) {
            return HierarchyProcessor.getUnindentedText(result, declaringCu);
        }
        return result;
    }

    protected static String getUnindentedText(String text, ICompilationUnit declaringCu) throws JavaModelException {
        String[] lines = Strings.convertIntoLines(text);
        Strings.trimIndentation(lines, declaringCu.getJavaProject(), false);
        return Strings.concatenate(lines, StubUtility.getLineDelimiterUsed((IJavaElement)declaringCu));
    }

    protected HierarchyProcessor(IMember[] members, CodeGenerationSettings settings, boolean layer) {
        super(settings);
        this.fLayer = layer;
        if (members != null) {
            ICompilationUnit original;
            this.fMembersToMove = (IMember[])SourceReferenceUtil.sortByOffset((ISourceReference[])members);
            if (layer && this.fMembersToMove.length > 0 && (original = this.fMembersToMove[0].getCompilationUnit()) != null) {
                try {
                    ICompilationUnit copy = this.getSharedWorkingCopy(original.getPrimary(), (IProgressMonitor)new NullProgressMonitor());
                    if (copy != null) {
                        int index = 0;
                        while (index < this.fMembersToMove.length) {
                            IJavaElement[] elements = copy.findElements((IJavaElement)this.fMembersToMove[index]);
                            if (elements != null && elements.length > 0 && elements[0] instanceof IMember) {
                                this.fMembersToMove[index] = (IMember)elements[0];
                            }
                            ++index;
                        }
                    }
                }
                catch (JavaModelException exception) {
                    JavaPlugin.log(exception);
                }
            }
        }
    }

    protected boolean canBeAccessedFrom(IMember member, IType target, ITypeHierarchy hierarchy) throws JavaModelException {
        Assert.isTrue((!(member instanceof IInitializer) ? 1 : 0) != 0);
        return member.exists();
    }

    protected RefactoringStatus checkConstructorCalls(IType type, IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, 2);
            RefactoringStatus result = new RefactoringStatus();
            SearchResultGroup[] groups = ConstructorReferenceFinder.getConstructorReferences(type, this.fOwner, (IProgressMonitor)new SubProgressMonitor(monitor, 1), result);
            String message = Messages.format(RefactoringCoreMessages.HierarchyRefactoring_gets_instantiated, new Object[]{JavaElementLabels.getTextLabel(type, JavaElementLabels.ALL_FULLY_QUALIFIED)});
            ICompilationUnit unit = null;
            int index = 0;
            while (index < groups.length) {
                unit = groups[index].getCompilationUnit();
                if (unit != null) {
                    CompilationUnit cuNode = RefactoringASTParser.parseWithASTProvider((ITypeRoot)unit, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    ASTNode[] references = ASTNodeSearchUtil.getAstNodes(groups[index].getSearchResults(), cuNode);
                    ASTNode node = null;
                    int offset = 0;
                    while (offset < references.length) {
                        node = references[offset];
                        if (node instanceof ClassInstanceCreation || ConstructorReferenceFinder.isImplicitConstructorReferenceNodeInClassCreations(node)) {
                            RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)unit, node);
                            result.addError(message, context);
                        }
                        ++offset;
                    }
                }
                ++index;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    protected RefactoringStatus checkDeclaringType(IProgressMonitor monitor) throws JavaModelException {
        try {
            IType type = this.getDeclaringType();
            if (type.isEnum()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.HierarchyRefactoring_enum_members);
                return refactoringStatus;
            }
            if (type.isAnnotation()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.HierarchyRefactoring_annotation_members);
                return refactoringStatus;
            }
            if (type.isInterface()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.HierarchyRefactoring_interface_members);
                return refactoringStatus;
            }
            if (type.isBinary()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.HierarchyRefactoring_members_of_binary);
                return refactoringStatus;
            }
            if (type.isReadOnly()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.HierarchyRefactoring_members_of_read_only);
                return refactoringStatus;
            }
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected RefactoringStatus checkIfMembersExist() {
        RefactoringStatus result = new RefactoringStatus();
        IMember member = null;
        int index = 0;
        while (index < this.fMembersToMove.length) {
            member = this.fMembersToMove[index];
            if (member == null || !member.exists()) {
                result.addFatalError(RefactoringCoreMessages.HierarchyRefactoring_does_not_exist);
            }
            ++index;
        }
        return result;
    }

    protected void clearCaches() {
        this.fCachedReferencedTypes = null;
    }

    protected void copyParameters(ASTRewrite rewrite, ICompilationUnit unit, MethodDeclaration oldMethod, MethodDeclaration newMethod, TypeVariableMaplet[] mapping) throws JavaModelException {
        SingleVariableDeclaration newDeclaration = null;
        int index = 0;
        int size = oldMethod.parameters().size();
        while (index < size) {
            SingleVariableDeclaration oldDeclaration = (SingleVariableDeclaration)oldMethod.parameters().get(index);
            newDeclaration = mapping.length > 0 ? HierarchyProcessor.createPlaceholderForSingleVariableDeclaration(oldDeclaration, unit, mapping, rewrite) : HierarchyProcessor.createPlaceholderForSingleVariableDeclaration(oldDeclaration, unit, rewrite);
            newMethod.parameters().add(newDeclaration);
            ++index;
        }
    }

    protected void copyReturnType(ASTRewrite rewrite, ICompilationUnit unit, MethodDeclaration oldMethod, MethodDeclaration newMethod, TypeVariableMaplet[] mapping) throws JavaModelException {
        Type newReturnType = null;
        newReturnType = mapping.length > 0 ? HierarchyProcessor.createPlaceholderForType(oldMethod.getReturnType2(), unit, mapping, rewrite) : HierarchyProcessor.createPlaceholderForType(oldMethod.getReturnType2(), unit, rewrite);
        newMethod.setReturnType2(newReturnType);
    }

    @Override
    protected SuperTypeConstraintsSolver createContraintSolver(SuperTypeConstraintsModel model) {
        return new SuperTypeConstraintsSolver(model);
    }

    public IType getDeclaringType() {
        if (this.fCachedDeclaringType != null) {
            return this.fCachedDeclaringType;
        }
        this.fCachedDeclaringType = RefactoringAvailabilityTester.getTopLevelType(this.fMembersToMove);
        if (this.fCachedDeclaringType == null) {
            this.fCachedDeclaringType = this.fMembersToMove[0].getDeclaringType();
        }
        return this.fCachedDeclaringType;
    }

    public IMember[] getMembersToMove() {
        return this.fMembersToMove;
    }

    protected IType[] getTypesReferencedInMovedMembers(IProgressMonitor monitor) throws JavaModelException {
        if (this.fCachedReferencedTypes == null) {
            IType[] types = ReferenceFinderUtil.getTypesReferencedIn((IJavaElement[])this.fMembersToMove, this.fOwner, monitor);
            ArrayList<IType> result = new ArrayList<IType>(types.length);
            List<IMember> members = Arrays.asList(this.fMembersToMove);
            int index = 0;
            while (index < types.length) {
                if (!members.contains(types[index]) && !types[index].equals(this.getDeclaringType())) {
                    result.add(types[index]);
                }
                ++index;
            }
            this.fCachedReferencedTypes = new IType[result.size()];
            result.toArray(this.fCachedReferencedTypes);
        }
        return this.fCachedReferencedTypes;
    }

    protected boolean hasNonMovedReferences(IMember member, IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        SearchResultGroup[] groups;
        if (!this.fCachedMembersReferences.containsKey(member)) {
            RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaElement)member, (int)2, (int)24));
            engine.setFiltering(true, true);
            engine.setStatus(status);
            engine.setOwner(this.fOwner);
            engine.setScope(RefactoringScopeFactory.create((IJavaElement)member));
            engine.searchPattern((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.fCachedMembersReferences.put(member, engine.getResults());
        }
        if ((groups = (SearchResultGroup[])this.fCachedMembersReferences.get(member)).length == 0) {
            return false;
        }
        if (groups.length > 1) {
            return true;
        }
        ICompilationUnit unit = groups[0].getCompilationUnit();
        if (!this.getDeclaringType().getCompilationUnit().equals(unit)) {
            return true;
        }
        SearchMatch[] matches = groups[0].getSearchResults();
        int index = 0;
        while (index < matches.length) {
            if (!this.isMovedReference(matches[index])) {
                return true;
            }
            ++index;
        }
        return false;
    }

    protected boolean isMovedReference(SearchMatch match) throws JavaModelException {
        ISourceRange range = null;
        int index = 0;
        while (index < this.fMembersToMove.length) {
            range = this.fMembersToMove[index].getSourceRange();
            if (range.getOffset() <= match.getOffset() && range.getOffset() + range.getLength() >= match.getOffset()) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return new RefactoringParticipant[0];
    }

    protected boolean needsVisibilityAdjustment(IMember member, boolean references, IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        if (JdtFlags.isPublic(member) || JdtFlags.isProtected(member)) {
            return false;
        }
        if (!references) {
            return true;
        }
        return this.hasNonMovedReferences(member, monitor, status);
    }

    public static class TypeVariableMapper
    extends ASTVisitor {
        protected final TypeVariableMaplet[] fMapping;
        protected final ASTRewrite fRewrite;

        public TypeVariableMapper(ASTRewrite rewrite, TypeVariableMaplet[] mapping) {
            Assert.isNotNull((Object)rewrite);
            Assert.isNotNull((Object)mapping);
            this.fRewrite = rewrite;
            this.fMapping = mapping;
        }

        public final boolean visit(SimpleName node) {
            ITypeBinding binding = node.resolveTypeBinding();
            if (binding != null && binding.isTypeVariable()) {
                String name = null;
                int index = 0;
                while (index < this.fMapping.length) {
                    name = binding.getName();
                    if (this.fMapping[index].getSourceName().equals(name) && node.getIdentifier().equals(name)) {
                        IMethodBinding method;
                        MethodDeclaration declaration = (MethodDeclaration)ASTNodes.getParent((ASTNode)node, MethodDeclaration.class);
                        if (declaration != null && (method = declaration.resolveBinding()) != null) {
                            ITypeBinding[] bindings = method.getTypeParameters();
                            int offset = 0;
                            while (offset < bindings.length) {
                                if (bindings[offset].isEqualTo((IBinding)binding)) {
                                    return true;
                                }
                                ++offset;
                            }
                        }
                        this.fRewrite.set((ASTNode)node, (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY, (Object)this.fMapping[index].getTargetName(), null);
                    }
                    ++index;
                }
            }
            return true;
        }
    }
}

