/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;

public class ASTNodeFactory {
    private static final String STATEMENT_HEADER = "class __X__ { void __x__() { ";
    private static final String STATEMENT_FOOTER = "}}";
    private static final String TYPE_HEADER = "class __X__ { abstract ";
    private static final String TYPE_FOOTER = " __f__(); }}";
    private static final String TYPEPARAM_HEADER = "class __X__ { abstract <";
    private static final String TYPEPARAM_FOOTER = "> void __f__(); }}";

    private ASTNodeFactory() {
    }

    public static ASTNode newStatement(AST ast, String content) {
        StringBuffer buffer = new StringBuffer(STATEMENT_HEADER);
        buffer.append(content);
        buffer.append(STATEMENT_FOOTER);
        ASTParser p = ASTParser.newParser((int)ast.apiLevel());
        p.setSource(buffer.toString().toCharArray());
        CompilationUnit root = (CompilationUnit)p.createAST(null);
        ASTNode result = ASTNode.copySubtree((AST)ast, (ASTNode)NodeFinder.perform((ASTNode)root, (int)STATEMENT_HEADER.length(), (int)content.length()));
        result.accept((ASTVisitor)new PositionClearer());
        return result;
    }

    public static Name newName(AST ast, String qualifiedName) {
        return ast.newName(qualifiedName);
    }

    public static TypeParameter newTypeParameter(AST ast, String content) {
        StringBuffer buffer = new StringBuffer(TYPEPARAM_HEADER);
        buffer.append(content);
        buffer.append(TYPEPARAM_FOOTER);
        ASTParser p = ASTParser.newParser((int)ast.apiLevel());
        p.setSource(buffer.toString().toCharArray());
        CompilationUnit root = (CompilationUnit)p.createAST(null);
        List list = root.types();
        TypeDeclaration typeDecl = (TypeDeclaration)list.get(0);
        MethodDeclaration methodDecl = typeDecl.getMethods()[0];
        TypeParameter tp = (TypeParameter)methodDecl.typeParameters().get(0);
        ASTNode result = ASTNode.copySubtree((AST)ast, (ASTNode)tp);
        result.accept((ASTVisitor)new PositionClearer());
        return (TypeParameter)result;
    }

    public static Type newType(AST ast, String content) {
        StringBuffer buffer = new StringBuffer(TYPE_HEADER);
        buffer.append(content);
        buffer.append(TYPE_FOOTER);
        ASTParser p = ASTParser.newParser((int)ast.apiLevel());
        p.setSource(buffer.toString().toCharArray());
        CompilationUnit root = (CompilationUnit)p.createAST(null);
        List list = root.types();
        TypeDeclaration typeDecl = (TypeDeclaration)list.get(0);
        MethodDeclaration methodDecl = typeDecl.getMethods()[0];
        Type type = methodDecl.getReturnType2();
        ASTNode result = ASTNode.copySubtree((AST)ast, (ASTNode)type);
        result.accept((ASTVisitor)new PositionClearer());
        return (Type)result;
    }

    public static Type newType(AST ast, VariableDeclaration declaration) {
        return ASTNodeFactory.newType(ast, declaration, null, null);
    }

    public static Type newType(AST ast, VariableDeclaration declaration, ImportRewrite importRewrite, ImportRewrite.ImportRewriteContext context) {
        Type type2;
        Type type = ASTNodes.getType(declaration);
        if (declaration instanceof SingleVariableDeclaration && (type2 = ((SingleVariableDeclaration)declaration).getType()) instanceof UnionType) {
            ITypeBinding typeBinding = type2.resolveBinding();
            if (typeBinding != null) {
                if (importRewrite != null) {
                    type = importRewrite.addImport(typeBinding, ast, context);
                    return type;
                }
                String qualifiedName = typeBinding.getQualifiedName();
                if (qualifiedName.length() > 0) {
                    type = ast.newSimpleType(ast.newName(qualifiedName));
                    return type;
                }
            }
            type = (Type)((UnionType)type2).types().get(0);
            return type;
        }
        int extraDim = declaration.getExtraDimensions();
        type = (Type)ASTNode.copySubtree((AST)ast, (ASTNode)type);
        int i = 0;
        while (i < extraDim) {
            type = ast.newArrayType(type);
            ++i;
        }
        return type;
    }

    public static Expression newDefaultExpression(AST ast, Type type, int extraDimensions) {
        if (extraDimensions == 0 && type.isPrimitiveType()) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            if (primitiveType.getPrimitiveTypeCode() == PrimitiveType.BOOLEAN) {
                return ast.newBooleanLiteral(false);
            }
            if (primitiveType.getPrimitiveTypeCode() == PrimitiveType.VOID) {
                return null;
            }
            return ast.newNumberLiteral("0");
        }
        return ast.newNullLiteral();
    }

    public static Expression newDefaultExpression(AST ast, ITypeBinding type) {
        if (type.isPrimitive()) {
            String name = type.getName();
            if ("boolean".equals(name)) {
                return ast.newBooleanLiteral(false);
            }
            if ("void".equals(name)) {
                return null;
            }
            return ast.newNumberLiteral("0");
        }
        return ast.newNullLiteral();
    }

    public static List<Modifier> newModifiers(AST ast, int modifiers) {
        return ast.newModifiers(modifiers);
    }

    public static List<Modifier> newModifiers(AST ast, List<? extends IExtendedModifier> modifierNodes) {
        ArrayList<Modifier> res = new ArrayList<Modifier>(modifierNodes.size());
        int i = 0;
        while (i < modifierNodes.size()) {
            IExtendedModifier curr = modifierNodes.get(i);
            if (curr instanceof Modifier) {
                res.add(ast.newModifier(((Modifier)curr).getKeyword()));
            }
            ++i;
        }
        return res;
    }

    public static Expression newInfixExpression(AST ast, InfixExpression.Operator operator, ArrayList<Expression> operands) {
        if (operands.size() == 1) {
            return operands.get(0);
        }
        InfixExpression result = ast.newInfixExpression();
        result.setOperator(operator);
        result.setLeftOperand(operands.get(0));
        result.setRightOperand(operands.get(1));
        result.extendedOperands().addAll(operands.subList(2, operands.size()));
        return result;
    }

    public static Annotation newAnnotation(AST ast, IAnnotationBinding annotation, ImportRewrite importRewrite, ImportRewrite.ImportRewriteContext context) {
        Name name;
        Type type = importRewrite.addImport(annotation.getAnnotationType(), ast, context);
        if (type instanceof SimpleType) {
            SimpleType simpleType = (SimpleType)type;
            name = simpleType.getName();
            simpleType.setName((Name)ast.newSimpleName("a"));
        } else {
            name = ast.newName(ASTNodes.asString((ASTNode)type));
        }
        IMemberValuePairBinding[] mvps = annotation.getDeclaredMemberValuePairs();
        if (mvps.length == 0) {
            MarkerAnnotation result = ast.newMarkerAnnotation();
            result.setTypeName(name);
            return result;
        }
        if (mvps.length == 1 && "value".equals(mvps[0].getName())) {
            SingleMemberAnnotation result = ast.newSingleMemberAnnotation();
            result.setTypeName(name);
            Object value = mvps[0].getValue();
            if (value != null) {
                result.setValue(ASTNodeFactory.newAnnotationValue(ast, value, importRewrite, context));
            }
            return result;
        }
        NormalAnnotation result = ast.newNormalAnnotation();
        result.setTypeName(name);
        List values = result.values();
        int i = 0;
        while (i < mvps.length) {
            IMemberValuePairBinding mvp = mvps[i];
            MemberValuePair mvpNode = ast.newMemberValuePair();
            mvpNode.setName(ast.newSimpleName(mvp.getName()));
            Object value = mvp.getValue();
            if (value != null) {
                mvpNode.setValue(ASTNodeFactory.newAnnotationValue(ast, value, importRewrite, context));
            }
            values.add(mvpNode);
            ++i;
        }
        return result;
    }

    public static Expression newAnnotationValue(AST ast, Object value, ImportRewrite importRewrite, ImportRewrite.ImportRewriteContext context) {
        if (value instanceof Boolean) {
            return ast.newBooleanLiteral(((Boolean)value).booleanValue());
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            return ast.newNumberLiteral(value.toString());
        }
        if (value instanceof Character) {
            CharacterLiteral result = ast.newCharacterLiteral();
            result.setCharValue(((Character)value).charValue());
            return result;
        }
        if (value instanceof ITypeBinding) {
            TypeLiteral result = ast.newTypeLiteral();
            result.setType(importRewrite.addImport((ITypeBinding)value, ast, context));
            return result;
        }
        if (value instanceof String) {
            StringLiteral result = ast.newStringLiteral();
            result.setLiteralValue((String)value);
            return result;
        }
        if (value instanceof IVariableBinding) {
            Name name;
            IVariableBinding variable = (IVariableBinding)value;
            FieldAccess result = ast.newFieldAccess();
            result.setName(ast.newSimpleName(variable.getName()));
            Type type = importRewrite.addImport(variable.getType(), ast, context);
            if (type instanceof SimpleType) {
                SimpleType simpleType = (SimpleType)type;
                name = simpleType.getName();
                simpleType.setName((Name)ast.newSimpleName("a"));
            } else {
                name = ast.newName(ASTNodes.asString((ASTNode)type));
            }
            result.setExpression((Expression)name);
            return result;
        }
        if (value instanceof IAnnotationBinding) {
            return ASTNodeFactory.newAnnotation(ast, (IAnnotationBinding)value, importRewrite, context);
        }
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            if (values.length == 1) {
                return ASTNodeFactory.newAnnotationValue(ast, values[0], importRewrite, context);
            }
            ArrayInitializer initializer = ast.newArrayInitializer();
            List expressions = initializer.expressions();
            Object[] objectArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object val = objectArray[n2];
                expressions.add(ASTNodeFactory.newAnnotationValue(ast, val, importRewrite, context));
                ++n2;
            }
            return initializer;
        }
        return null;
    }

    private static class PositionClearer
    extends GenericVisitor {
        public PositionClearer() {
            super(true);
        }

        @Override
        protected boolean visitNode(ASTNode node) {
            node.setSourceRange(-1, 0);
            return true;
        }
    }
}

