/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.util;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class PreferenceStoreUtil {
    private static Logger log = Logger.getLogger(PreferenceStoreUtil.class);
    private static IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();

    public static Color getTableNameColor() {
        String color = preferenceStore.getString("tableNameColor");
        return new Color((Device)Display.getCurrent(), PreferenceStoreUtil.decoderRGB(color == null ? "0,0,0" : color));
    }

    public static void setTableNameColor(RGB rgb) {
        preferenceStore.setValue("tableNameColor", PreferenceStoreUtil.encoderRGB(rgb));
    }

    public static Color getTableAliasColor() {
        String color = preferenceStore.getString("tableAliasColor");
        return new Color((Device)Display.getCurrent(), PreferenceStoreUtil.decoderRGB(color == null ? "0,0,0" : color));
    }

    public static void setTableAliasColor(RGB rgb) {
        preferenceStore.setValue("tableAliasColor", PreferenceStoreUtil.encoderRGB(rgb));
    }

    public static Color getTableFieldColor() {
        String color = preferenceStore.getString("tableFieldColor");
        return new Color((Device)Display.getCurrent(), PreferenceStoreUtil.decoderRGB(color == null ? "0,0,0" : color));
    }

    public static void setTableFieldColor(RGB rgb) {
        preferenceStore.setValue("tableFieldColor", PreferenceStoreUtil.encoderRGB(rgb));
    }

    public static void setTablePath(String path) {
        preferenceStore.setValue("tables", path);
    }

    public static void setDataTypePath(String path) {
        preferenceStore.setValue("datatypes", path);
    }

    public static boolean isDynamicCheck() {
        return preferenceStore.getBoolean("dynamic");
    }

    public static void setDynamicCheck(boolean check) {
        preferenceStore.setValue("dynamic", check);
    }

    public static boolean isHQLHighlighting() {
        return preferenceStore.getBoolean("highlighting");
    }

    public static void setHQLHighlighting(boolean highlight) {
        preferenceStore.setValue("highlighting", highlight);
    }

    public static void setMergeDatabaseConfig(Element config) {
        preferenceStore.setValue("MergeDatabase", config.asXML());
    }

    public static Element getMergeDatabaseConfig() {
        try {
            String mergeDatabaseConfig = preferenceStore.getString("MergeDatabase");
            if (StringUtils.isBlank((String)mergeDatabaseConfig)) {
                return DocumentHelper.createElement((String)"MergeDatabase");
            }
            return DocumentHelper.parseText((String)mergeDatabaseConfig).getRootElement();
        }
        catch (Exception exception) {
            return DocumentHelper.createElement((String)"MergeDatabase");
        }
    }

    private static RGB decoderRGB(String value) {
        try {
            if (value == null || "".equals(value.trim())) {
                return new RGB(0, 0, 0);
            }
            String[] values = value.split(",");
            return new RGB(Integer.parseInt(values[0]), Integer.parseInt(values[1]), Integer.parseInt(values[2]));
        }
        catch (Exception e) {
            log.error((Object)("\u89e3\u7801\u989c\u8272\u5931\u8d25\uff1a\u3010" + value + "\u3011"), (Throwable)e);
            return new RGB(0, 0, 0);
        }
    }

    private static String encoderRGB(RGB rgb) {
        try {
            return String.valueOf(String.valueOf(rgb.red)) + "," + String.valueOf(rgb.green) + "," + String.valueOf(rgb.blue);
        }
        catch (Exception e) {
            log.error((Object)"\u7f16\u7801\u989c\u8272\u5931\u8d25", (Throwable)e);
            return "0,0,0";
        }
    }
}

