/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.util;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public abstract class MarkUtil {
    private static Logger log = Logger.getLogger(MarkUtil.class);
    public static final String MARK_TYPE_LAYER = String.valueOf(JavaPlugin.getPluginId()) + ".layersMark";

    public static boolean createMark(IResource resource, String markType, int severity, int start, int end, int lineNumber, String message) {
        try {
            IMarker marker = resource.createMarker(markType);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("charStart", start);
            marker.setAttribute("charEnd", end);
            marker.setAttribute("severity", severity);
            if (lineNumber > 0) {
                marker.setAttribute("lineNumber", lineNumber);
            }
            return true;
        }
        catch (CoreException e) {
            log.error((Object)"\u521b\u5efa\u6807\u8bb0\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public static boolean createLayerMark(IResource resource, int start, int length, int lineNumber, String message) {
        return MarkUtil.createMark(resource, MARK_TYPE_LAYER, 2, start, start + length, lineNumber, message);
    }
}

