/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.util;

import com.ximpleware.VTDNav;
import gongqi.erp.framework.core.LayerDefination;
import gongqi.erp.framework.core.LayerDefinationManager;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.extension.SolutionExtensionDefinition;
import gongqi.erp.framework.core.extension.SolutionExtensionDefinitionManager;
import gongqi.erp.framework.core.solution.SolutionDefinition;
import gongqi.erp.framework.core.solution.SolutionDefinitionManager;
import gongqi.erp.framework.tools.StringHelper;
import gongqi.erp.framework.tools.io.FileIOXML;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.erp.gotmodel.core.GOTLocator;
import info.gongqi.util.FileIO;
import info.gongqi.util.PluginUtil;
import info.gongqi.utils.VTDUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;

public class LayerUtil {
    public static final String BASEPACKAGE = "gongqi.erp.layers.";
    public static final String METHOD_NEWINSTANCE = "newInstance";
    public static final String METHOD_UTIL = "util";

    public static boolean isLayerPackage(String packageName) {
        block5: {
            block7: {
                block6: {
                    if (!StringHelper.isNotBlank((String)packageName)) break block5;
                    if (!packageName.startsWith(BASEPACKAGE)) break block6;
                    LayerDefinationManager layerDefinationManager = (LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class);
                    LayerDefination layerDefination = layerDefinationManager.getCurrentLayer();
                    while (layerDefination != null) {
                        String layerPackagePrefix = BASEPACKAGE + layerDefination.getLayerName();
                        if ((String.valueOf(layerPackagePrefix) + ".classes").equals(packageName) || (String.valueOf(layerPackagePrefix) + ".datatypes").equals(packageName) || (String.valueOf(layerPackagePrefix) + ".enums").equals(packageName) || packageName.matches(String.valueOf(layerPackagePrefix.replace(".", "\\.")) + "\\.forms\\.[A-Za-z0-9_$]*$") || packageName.matches(String.valueOf(layerPackagePrefix.replace(".", "\\.")) + "\\.forms\\.[A-Za-z0-9_$]*\\.datasource") || (String.valueOf(layerPackagePrefix) + ".maps").equals(packageName) || (String.valueOf(layerPackagePrefix) + ".reports").equals(packageName) || (String.valueOf(layerPackagePrefix) + ".tables").equals(packageName)) {
                            return true;
                        }
                        String lowerLayer = layerDefination.getLowerLayer();
                        if (!"Gongqi_ERP_No_More_Layer".equals(lowerLayer)) {
                            layerDefination = layerDefinationManager.getLayer(lowerLayer);
                            continue;
                        }
                        break block5;
                    }
                    break block5;
                }
                if (!packageName.contains(String.format(".layers.%s.", "app"))) break block7;
                SolutionDefinitionManager solutionDefinitionManager = (SolutionDefinitionManager)ObjectContainer.getInstance(SolutionDefinitionManager.class);
                List solutions = solutionDefinitionManager.getSolutions();
                for (SolutionDefinition solutionDefinition : solutions) {
                    String packagePrefix = String.format("%s.layers.%s", solutionDefinition.getSolutionName(), "app");
                    if (!(String.valueOf(packagePrefix) + ".classes").equals(packageName) && !(String.valueOf(packagePrefix) + ".datatypes").equals(packageName) && !(String.valueOf(packagePrefix) + ".enums").equals(packageName) && !packageName.matches(String.valueOf(packagePrefix.replace(".", "\\.")) + "\\.forms\\.[A-Za-z0-9_$]*$") && !packageName.matches(String.valueOf(packagePrefix.replace(".", "\\.")) + "\\.forms\\.[A-Za-z0-9_$]*\\.datasource") && !(String.valueOf(packagePrefix) + ".maps").equals(packageName) && !(String.valueOf(packagePrefix) + ".reports").equals(packageName) && !(String.valueOf(packagePrefix) + ".tables").equals(packageName)) continue;
                    return true;
                }
                break block5;
            }
            if (!packageName.contains(String.format(".layers.%s.", "ext"))) break block5;
            SolutionExtensionDefinitionManager solutionExtensionDefinitionManager = (SolutionExtensionDefinitionManager)ObjectContainer.getInstance(SolutionExtensionDefinitionManager.class);
            List solutionExtensions = solutionExtensionDefinitionManager.getSolutionExtensions();
            for (SolutionExtensionDefinition solutionExtensionDefinition : solutionExtensions) {
                String packagePrefix = String.format("%s.layers.%s", solutionExtensionDefinition.getSolutionDefinition().getSolutionName(), "ext");
                if (!(String.valueOf(packagePrefix) + ".classes").equals(packageName) && !(String.valueOf(packagePrefix) + ".datatypes").equals(packageName) && !(String.valueOf(packagePrefix) + ".enums").equals(packageName) && !packageName.matches(String.valueOf(packagePrefix.replace(".", "\\.")) + "\\.forms\\.[A-Za-z0-9_$]*$") && !packageName.matches(String.valueOf(packagePrefix.replace(".", "\\.")) + "\\.forms\\.[A-Za-z0-9_$]*\\.datasource") && !(String.valueOf(packagePrefix) + ".maps").equals(packageName) && !(String.valueOf(packagePrefix) + ".reports").equals(packageName) && !(String.valueOf(packagePrefix) + ".tables").equals(packageName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBasePackage(String packageName) {
        block3: {
            block5: {
                block4: {
                    if (!StringHelper.isNotBlank((String)packageName)) break block3;
                    if (!packageName.startsWith(BASEPACKAGE)) break block4;
                    String packageSegment = packageName.substring(packageName.indexOf(".layers.") + ".layers.xxx.".length());
                    if (packageSegment.matches("forms\\.[A-Za-z0-9_$]*\\.base") || packageSegment.matches("forms\\.[A-Za-z0-9_$]*\\.datasource\\.base") || packageSegment.matches("maps\\.[A-Za-z0-9_$]*\\.base") || packageSegment.startsWith("reports") || packageSegment.startsWith("classes.base") || packageSegment.startsWith("tables.base")) {
                        return true;
                    }
                    break block3;
                }
                if (!packageName.contains(String.format(".layers.%s.", "app"))) break block5;
                SolutionDefinitionManager solutionDefinitionManager = (SolutionDefinitionManager)ObjectContainer.getInstance(SolutionDefinitionManager.class);
                List solutions = solutionDefinitionManager.getSolutions();
                for (SolutionDefinition solutionDefinition : solutions) {
                    String packageSegment;
                    if (!packageName.startsWith(String.format("%s.layers.%s", solutionDefinition.getSolutionName(), "app")) || !(packageSegment = packageName.substring(packageName.indexOf(".layers.") + ".layers.xxx.".length())).matches("forms\\.[A-Za-z0-9_$]*\\.base") && !packageSegment.matches("forms\\.[A-Za-z0-9_$]*\\.datasource\\.base") && !packageSegment.matches("maps\\.[A-Za-z0-9_$]*\\.base") && !packageSegment.startsWith("reports") && !packageSegment.startsWith("classes.base") && !packageSegment.startsWith("tables.base")) continue;
                    return true;
                }
                break block3;
            }
            if (!packageName.contains(String.format(".layers.%s.", "ext"))) break block3;
            SolutionExtensionDefinitionManager solutionExtensionDefinitionManager = (SolutionExtensionDefinitionManager)ObjectContainer.getInstance(SolutionExtensionDefinitionManager.class);
            List solutionExtensions = solutionExtensionDefinitionManager.getSolutionExtensions();
            for (SolutionExtensionDefinition solutionExtensionDefinition : solutionExtensions) {
                String packageSegment;
                if (!packageName.startsWith(String.format("%s.layers.%s", solutionExtensionDefinition.getSolutionDefinition().getSolutionName(), "ext")) || !(packageSegment = packageName.substring(packageName.indexOf(".layers.") + ".layers.xxx.".length())).matches("forms\\.[A-Za-z0-9_$]*\\.base") && !packageSegment.matches("forms\\.[A-Za-z0-9_$]*\\.datasource\\.base") && !packageSegment.matches("maps\\.[A-Za-z0-9_$]*\\.base") && !packageSegment.startsWith("reports") && !packageSegment.startsWith("classes.base") && !packageSegment.startsWith("tables.base")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDataTypePackage(String packageName) {
        String packageSegment;
        return LayerUtil.isLayerPackage(packageName) && "datatypes".equals(packageSegment = packageName.substring(packageName.indexOf(".layers.") + ".layers.xxx.".length()));
    }

    public static boolean isTablePackage(String packageName) {
        String packageSegment;
        return LayerUtil.isLayerPackage(packageName) && "tables".equals(packageSegment = packageName.substring(packageName.indexOf(".layers.") + ".layers.xxx.".length()));
    }

    public static boolean isFormPackage(String packageName) {
        String packageSegment;
        return LayerUtil.isLayerPackage(packageName) && (packageSegment = packageName.substring(packageName.indexOf(".layers.") + ".layers.xxx.".length())).matches("forms\\.[A-Za-z0-9_$]+$");
    }

    public static boolean isFormDataSourcePackage(String packageName) {
        String packageSegment;
        return LayerUtil.isLayerPackage(packageName) && (packageSegment = packageName.substring(packageName.indexOf(".layers.") + ".layers.xxx.".length())).matches("forms\\.[A-Za-z0-9_$]+\\.datasource$");
    }

    public static boolean isBaseTablePackage(String packageName) {
        String packageSegment;
        return LayerUtil.isBasePackage(packageName) && "tables.base".equals(packageSegment = packageName.substring(packageName.indexOf(".layers.") + ".layers.xxx.".length()));
    }

    public static boolean isEnumsPackage(String packageName) {
        String packageSegment;
        return LayerUtil.isLayerPackage(packageName) && "enums".equals(packageSegment = packageName.substring(packageName.indexOf(".layers.") + ".layers.xxx.".length()));
    }

    public static boolean isFormBase(String packageName) {
        if (LayerUtil.isLayerPackage(packageName)) {
            packageName.substring(packageName.indexOf(".layers.") + ".layers.xxx.".length());
            if (packageName.matches("forms\\.[A-Za-z0-9_$]*\\.base")) {
                return true;
            }
        }
        return false;
    }

    public static boolean isHostingHighestLayer(String className) {
        if (StringUtils.isBlank((String)className) || !LayerUtil.isLayerPackage(className.substring(0, className.lastIndexOf(".")))) {
            return false;
        }
        LayerDefination layerDefination = LayerUtil.getLayerDefination(className);
        String hostingLayer = LayerUtil.getEntityHostingLayerDefination(className).getLayerName();
        return layerDefination.getLayerName().equals(hostingLayer);
    }

    public static boolean isDataArea() {
        try {
            File file = new File(PluginUtil.getBasePath(), "Eclipse/dataarea.cfg");
            if (file.exists()) {
                return "true".equals(FileIO.load(file.getAbsolutePath()).trim());
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public static LayerDefination getLayerDefination(String name) {
        int index = name.indexOf(".layers.") + ".layers.".length();
        String layerName = name.substring(index, name.indexOf(".", index));
        return ((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).getLayer(layerName);
    }

    public static EntityType getEntityType(String name) {
        EntityType entityType;
        String type = name.substring(name.indexOf(".layers.") + 12, name.indexOf(".", name.indexOf(".layers.") + 12));
        if ("classes".equals(type)) {
            entityType = EntityType.Class;
        } else if ("datatypes".equals(type)) {
            entityType = EntityType.DataType;
        } else if ("enums".equals(type)) {
            entityType = EntityType.Enum;
        } else if ("forms".equals(type)) {
            entityType = EntityType.Form;
        } else if ("menuitems".equals(type)) {
            entityType = EntityType.MenuItem;
        } else if ("reports".equals(type)) {
            entityType = EntityType.Report;
        } else if ("tables".equals(type)) {
            entityType = EntityType.Table;
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684GOT\u5b9e\u4f53\u7c7b\u578b\uff1a" + name);
        }
        return entityType;
    }

    public static String getEntityName(String className) {
        String entityName = null;
        EntityType entityType = LayerUtil.getEntityType(className);
        entityName = className.substring(className.indexOf(".layers.") + ".layers.xxx.".length());
        entityName = entityName.substring(entityName.indexOf(".") + 1);
        switch (entityType) {
            case Class: {
                if (!entityName.startsWith(".base.")) break;
                entityName = entityName.substring("base.Base".length());
                break;
            }
            case DataType: {
                entityName = entityName.substring("DataType_".length());
                break;
            }
            case Form: {
                entityName = entityName.substring(0, entityName.indexOf("."));
                break;
            }
            case MenuItem: {
                entityName = entityName.substring("MenuItem_".length());
                break;
            }
            case Report: {
                entityName = entityName.substring(0, entityName.indexOf("."));
                break;
            }
            case Table: {
                if (!entityName.startsWith("base.")) break;
                entityName = entityName.substring("base.Base".length());
            }
        }
        if (!className.startsWith(BASEPACKAGE)) {
            String solutionName = className.substring(0, className.indexOf(".layers."));
            entityName = String.valueOf(solutionName) + "." + entityName;
        }
        return entityName;
    }

    public static LayerDefination getEntityHostingLayerDefination(String typeFullyQualifiedName) {
        LayerDefinationManager layerDefinationManager = (LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class);
        EntityType entityType = LayerUtil.getEntityType(typeFullyQualifiedName);
        String entityName = LayerUtil.getEntityName(typeFullyQualifiedName);
        File entityXmlFile = LayerUtil.getEntityXmlFile(entityType, entityName);
        Document entityDocument = FileIOXML.loadDocument((String)entityXmlFile.getAbsolutePath());
        String hostingLayer = entityDocument.getRootElement().attributeValue("modifiedLayer");
        return layerDefinationManager.getLayer(hostingLayer);
    }

    public static String getHostingLayerFullyQualifiedName(String typeFullyQualifiedName) {
        String prefix = typeFullyQualifiedName.substring(0, typeFullyQualifiedName.indexOf(".layers.") + ".layers.".length());
        String suffix = typeFullyQualifiedName.substring(typeFullyQualifiedName.indexOf(".layers.") + ".layers.xxx".length());
        String hostingLayer = LayerUtil.getEntityHostingLayerDefination(typeFullyQualifiedName).getLayerName();
        return String.valueOf(prefix) + hostingLayer + suffix;
    }

    public static LayerDefination getEntityCreateLayerDefination(EntityType entityType, String entityName) {
        File entityFile = LayerUtil.getEntityXmlFile(entityType, entityName);
        if (entityFile.exists()) {
            VTDNav nav = VTDUtil.parse((File)entityFile);
            String createdLayer = VTDUtil.getAttributeValue((VTDNav)nav, (String)"createdLayer");
            return ((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).getLayer(createdLayer);
        }
        return null;
    }

    private static File getEntityXmlFile(EntityType entityType, String entityName) {
        GOTLocator gotLocator = (GOTLocator)ObjectContainer.getInstance(GOTLocator.class);
        File entityFile = gotLocator.getEntityFile(entityType, entityName);
        return entityFile;
    }

    public static String getInstanceMthodName() {
        return METHOD_NEWINSTANCE;
    }

    public static String getUtilsMethodName() {
        return METHOD_UTIL;
    }

    public static String getUtilAnnotationName() {
        return "Util";
    }

    public static boolean isUtilMethod(IMethod method) throws JavaModelException {
        IAnnotation[] iAnnotationArray = method.getAnnotations();
        int n = iAnnotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            if ("gongqi.erp.framework.core.Util".equals(annotation.getElementName()) || annotation.getElementName().equals(LayerUtil.getUtilAnnotationName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isUtilMethod(IMethodBinding methodBinding) {
        if (methodBinding != null && methodBinding.getAnnotations() != null) {
            IAnnotationBinding[] iAnnotationBindingArray = methodBinding.getAnnotations();
            int n = iAnnotationBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotationBinding annotationBinding = iAnnotationBindingArray[n2];
                if ("gongqi.erp.framework.core.Util".equals(annotationBinding.getAnnotationType().getQualifiedName())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static int getLayerLevel(String layerName) {
        ArrayList<String> layers = new ArrayList<String>();
        LayerDefinationManager definationManager = (LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class);
        LayerDefination layer = definationManager.getRootLayer();
        while (true) {
            layers.add(layer.getLayerName());
            String upperLayer = layer.getUpperLayer();
            if (upperLayer.equals("Gongqi_ERP_No_More_Layer")) break;
            layer = definationManager.getLayer(upperLayer);
        }
        return layers.indexOf(layerName);
    }
}

