/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.util;

import gongqi.erp.framework.core.GongqiEnvironment;
import gongqi.erp.framework.core.LayerDefination;
import gongqi.erp.framework.core.LayerDefinationManager;
import gongqi.erp.framework.core.ObjectContainer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;

public class JarUtil {
    public static void packClass() throws IOException {
        LayerDefination currentLayer = ((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).getCurrentLayer();
        File jarFile = new File(((GongqiEnvironment)ObjectContainer.getInstance(GongqiEnvironment.class)).getGongqiDir(), "BakProject/layer-" + currentLayer.getLayerName() + ".jar");
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.put(new Attributes.Name("Manifest-Version"), "1.0");
        mainAttributes.put(new Attributes.Name("Sealed"), "true");
        JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(jarFile), manifest);
        File classes = new File(((GongqiEnvironment)ObjectContainer.getInstance(GongqiEnvironment.class)).getBaseDir(), "classes");
        Collection files = FileUtils.listFiles((File)new File(classes, "gongqi/erp/layers/" + currentLayer.getLayerName()), null, (boolean)true);
        for (File file : files) {
            JarEntry jarEntry = new JarEntry(file.getAbsolutePath().substring(classes.getAbsolutePath().length() + 1).replace(File.separatorChar, '/'));
            jarEntry.setMethod(8);
            jarEntry.setTime(file.lastModified());
            jarOutputStream.putNextEntry(jarEntry);
            byte[] readBuffer = new byte[4096];
            try (FileInputStream inputStream = null;){
                int count;
                inputStream = new FileInputStream(file);
                while ((count = ((InputStream)inputStream).read(readBuffer, 0, readBuffer.length)) != -1) {
                    jarOutputStream.write(readBuffer, 0, count);
                }
            }
        }
        jarOutputStream.close();
    }

    public static void packSource() throws IOException {
        LayerDefination currentLayer = ((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).getCurrentLayer();
        File jarFile = new File(((GongqiEnvironment)ObjectContainer.getInstance(GongqiEnvironment.class)).getGongqiDir(), "BakProject/layer-" + currentLayer.getLayerName() + "-source.jar");
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.put(new Attributes.Name("Manifest-Version"), "1.0");
        mainAttributes.put(new Attributes.Name("Sealed"), "true");
        JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(jarFile), manifest);
        File source = new File(((GongqiEnvironment)ObjectContainer.getInstance(GongqiEnvironment.class)).getGongqiDir(), "Project/Server/LayerProject/src");
        Collection files = FileUtils.listFiles((File)new File(source, "gongqi/erp/layers/" + currentLayer.getLayerName()), null, (boolean)true);
        for (File file : files) {
            JarEntry jarEntry = new JarEntry(file.getAbsolutePath().substring(source.getAbsolutePath().length() + 1).replace(File.separatorChar, '/'));
            jarEntry.setMethod(8);
            jarEntry.setTime(file.lastModified());
            jarOutputStream.putNextEntry(jarEntry);
            byte[] readBuffer = new byte[4096];
            try (FileInputStream inputStream = null;){
                int count;
                inputStream = new FileInputStream(file);
                while ((count = ((InputStream)inputStream).read(readBuffer, 0, readBuffer.length)) != -1) {
                    jarOutputStream.write(readBuffer, 0, count);
                }
            }
        }
        jarOutputStream.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void packDoc() throws Exception {
        LayerDefination currentLayer = ((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).getCurrentLayer();
        File jarFile = new File(((GongqiEnvironment)ObjectContainer.getInstance(GongqiEnvironment.class)).getGongqiDir(), "BakProject/layer-" + currentLayer.getLayerName() + "-javadoc.jar");
        File docs = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString());
        File argFile = File.createTempFile("javadoc-arguments", ".tmp");
        ArrayList<String> args = new ArrayList<String>();
        args.add("-d");
        args.add(docs.getAbsolutePath());
        args.add("-sourcepath");
        args.add(new File(((GongqiEnvironment)ObjectContainer.getInstance(GongqiEnvironment.class)).getGongqiDir(), "Project/Server/LayerProject/src").getAbsolutePath());
        args.add("-classpath");
        Collection classpaths = FileUtils.listFiles((File)new File(((GongqiEnvironment)ObjectContainer.getInstance(GongqiEnvironment.class)).getBaseDir(), "lib"), (String[])new String[]{"jar"}, (boolean)true);
        classpaths.add(new File(((GongqiEnvironment)ObjectContainer.getInstance(GongqiEnvironment.class)).getBaseDir(), "classes"));
        classpaths.addAll(FileUtils.listFiles((File)new File(((GongqiEnvironment)ObjectContainer.getInstance(GongqiEnvironment.class)).getLibDir(), "framework"), (String[])new String[]{"jar"}, (boolean)false));
        classpaths.addAll(FileUtils.listFiles((File)new File(((GongqiEnvironment)ObjectContainer.getInstance(GongqiEnvironment.class)).getLibDir(), "tomcat"), (String[])new String[]{"jar"}, (boolean)false));
        LayerDefination layerDefination = currentLayer;
        while (layerDefination != null) {
            classpaths.addAll(FileUtils.listFiles((File)new File(((GongqiEnvironment)ObjectContainer.getInstance(GongqiEnvironment.class)).getLibDir(), "erp/layer_" + layerDefination.getLayerName()), (String[])new String[]{"jar"}, (boolean)true));
            String lowerLayer = layerDefination.getLowerLayer();
            if ("Gongqi_ERP_No_More_Layer".equals(lowerLayer)) break;
            layerDefination = ((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).getLayer(lowerLayer);
        }
        StringBuffer buf_classpath = new StringBuffer();
        Iterator iterator = classpaths.iterator();
        while (iterator.hasNext()) {
            buf_classpath.append(File.pathSeparatorChar).append(((File)iterator.next()).getAbsolutePath());
        }
        args.add(buf_classpath.length() > 0 ? buf_classpath.substring(1) : "");
        args.add("-protected");
        args.add("-source 1.7");
        args.add("-encoding UTF-8");
        args.add("-docencoding UTF-8");
        args.add("-doctitle '" + currentLayer.getLayerName() + " API'");
        args.add("-windowtitle '" + currentLayer.getLayerName() + " API'");
        args.add("-use");
        args.add("-version");
        args.add("-author");
        args.add("-splitindex");
        File source = new File(((GongqiEnvironment)ObjectContainer.getInstance(GongqiEnvironment.class)).getGongqiDir(), "Project/Server/LayerProject/src");
        File layerPackage = new File(source, "gongqi/erp/layers/" + currentLayer.getLayerName());
        Collection listFiles = FileUtils.listFilesAndDirs((File)layerPackage, (IOFileFilter)new IOFileFilter(){

            public boolean accept(File dir, String name) {
                return false;
            }

            public boolean accept(File file) {
                return false;
            }
        }, (IOFileFilter)new IOFileFilter(){

            public boolean accept(File dir, String name) {
                return false;
            }

            public boolean accept(File file) {
                if (file.isDirectory() && file.listFiles() != null) {
                    File[] fileArray = file.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File _file = fileArray[n2];
                        if (_file.isFile() && FilenameUtils.isExtension((String)_file.getName(), (String)"java")) {
                            return true;
                        }
                        ++n2;
                    }
                }
                return false;
            }
        });
        for (File file : listFiles) {
            String _package;
            if (layerPackage.getAbsolutePath().equals(file.getAbsolutePath())) {
                if (FileUtils.listFiles((File)file, (String[])new String[]{"java"}, (boolean)false).size() <= 0) continue;
                _package = file.getAbsolutePath().substring(source.getAbsolutePath().length() + 1).replace(File.separatorChar, '.');
                args.add(_package);
                continue;
            }
            _package = file.getAbsolutePath().substring(source.getAbsolutePath().length() + 1).replace(File.separatorChar, '.');
            args.add(_package);
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(argFile), "UTF-8"));){
            int i = 0;
            while (i < args.size()) {
                String curr = (String)args.get(i);
                writer.write(curr);
                writer.write(32);
                ++i;
            }
        }
        Process process = Runtime.getRuntime().exec(String.valueOf(new File(((GongqiEnvironment)ObjectContainer.getInstance(GongqiEnvironment.class)).getGongqiDir(), "Java/jdk/bin/javadoc.exe").getAbsolutePath()) + " @" + argFile.getAbsolutePath());
        InputStream is = process.getInputStream();
        byte[] bytes = new byte[2048];
        while (is.read(bytes) != -1) {
        }
        is.close();
        if (process.waitFor() != 0) throw new Exception("\u5bfc\u51fajavadoc\u5931\u8d25");
        InputStream errorStream = process.getErrorStream();
        if (errorStream.available() != 0) throw new Exception("\u5bfc\u51fajavadoc\u5931\u8d25");
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.put(new Attributes.Name("Manifest-Version"), "1.0");
        JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(jarFile), manifest);
        Collection files = FileUtils.listFiles((File)docs, null, (boolean)true);
        for (File file : files) {
            JarEntry jarEntry = new JarEntry(file.getAbsolutePath().substring(docs.getAbsolutePath().length() + 1).replace(File.separatorChar, '/'));
            jarEntry.setMethod(8);
            jarEntry.setTime(file.lastModified());
            jarOutputStream.putNextEntry(jarEntry);
            byte[] readBuffer = new byte[4096];
            try (FileInputStream inputStream = null;){
                int count;
                inputStream = new FileInputStream(file);
                while ((count = ((InputStream)inputStream).read(readBuffer, 0, readBuffer.length)) != -1) {
                    jarOutputStream.write(readBuffer, 0, count);
                }
            }
        }
        jarOutputStream.close();
        FileUtils.deleteDirectory((File)docs);
        argFile.delete();
    }
}

