/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;

public class FileIO {
    public static final String UTF8 = "UTF-8";
    public static final String endLine = System.getProperty("line.separator");

    public static boolean exists(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static boolean save(String path, String content) {
        try {
            File file = new File(path);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.createNewFile()) {
                if (FileIO.delete(file)) {
                    file.createNewFile();
                } else {
                    throw new RuntimeException("\u6587\u4ef6\u4fdd\u5b58\u524d\u5220\u9664\u5931\u8d25" + path);
                }
            }
            OutputStreamWriter outputStream = new OutputStreamWriter((OutputStream)new FileOutputStream(file), UTF8);
            outputStream.write(content);
            outputStream.flush();
            outputStream.close();
            return true;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean delete(File file) {
        if (file.exists()) {
            return file.delete();
        }
        return true;
    }

    public static void xLoad(String path, String suffix, HashMap<String, String> map) {
        File dir = new File(path);
        if (dir != null && dir.exists()) {
            if (dir.isDirectory()) {
                String[] children = dir.list();
                int i = 0;
                while (i < children.length) {
                    FileIO.xLoad(String.valueOf(path) + "/" + children[i], suffix, map);
                    ++i;
                }
            } else if (path.endsWith(suffix)) {
                map.put(path, FileIO.load(path));
            }
        }
    }

    public static String load(String path) {
        try {
            String tmp;
            InputStreamReader inputStream = new InputStreamReader((InputStream)new FileInputStream(path), UTF8);
            BufferedReader bufferedReader = new BufferedReader(inputStream);
            StringBuffer stringBuffer = new StringBuffer();
            while ((tmp = bufferedReader.readLine()) != null) {
                stringBuffer.append(String.valueOf(tmp) + System.getProperty("line.separator"));
            }
            bufferedReader.close();
            inputStream.close();
            return stringBuffer.toString();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean rename(String pathFrom, String pathTo) {
        try {
            File fileFrom = new File(pathFrom);
            File fileTo = new File(pathTo);
            return fileFrom.renameTo(fileTo);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean copy(String pathFrom, String pathTo) {
        File fileTo;
        File fileFrom;
        block6: {
            fileFrom = new File(pathFrom);
            fileTo = new File(pathTo);
            if (fileFrom.exists()) break block6;
            System.err.println(String.valueOf(fileFrom.getAbsolutePath()) + "\u4e0d\u5b58\u5728");
            return false;
        }
        try {
            int bytesRead;
            if (fileTo.exists()) {
                fileTo.delete();
            }
            FileInputStream fis = null;
            FileOutputStream fos = null;
            if (!new File(fileTo.getParent()).exists()) {
                new File(fileTo.getParent()).mkdirs();
            }
            fileTo.createNewFile();
            fis = new FileInputStream(fileFrom);
            fos = new FileOutputStream(fileTo);
            byte[] buf = new byte[4096];
            while ((bytesRead = fis.read(buf)) != -1) {
                fos.write(buf, 0, bytesRead);
            }
            fos.flush();
            fos.close();
            fis.close();
            fileTo.setLastModified(fileFrom.lastModified());
            fileTo.getParentFile().setLastModified(fileFrom.lastModified());
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean findOrCreateFolder(String path) {
        File formFolder = new File(path);
        if (!formFolder.exists()) {
            return formFolder.mkdirs();
        }
        return true;
    }

    public static void CreateFolder(String[] paths) {
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            FileIO.findOrCreateFolder(path);
            ++n2;
        }
    }

    public static boolean CreateFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            try {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                return file.createNewFile();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    public static boolean xDeleteFolder(String path) {
        File dir = new File(path);
        if (dir != null && dir.exists()) {
            if (dir.isDirectory()) {
                String[] children = dir.list();
                int i = 0;
                while (i < children.length) {
                    boolean success = FileIO.xDeleteFolder(String.valueOf(path) + "/" + children[i]);
                    if (!success) {
                        return false;
                    }
                    ++i;
                }
            }
            return dir.delete();
        }
        return true;
    }
}

