/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.preferences;

import info.gongqi.util.PreferenceStoreUtil;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MergeConfig
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Table ignoredTable;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FormLayout());
        Label label = new Label(composite, 0);
        label.setText("\u8868\u5ffd\u7565\u89c4\u5219");
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment(0, 5);
        label.setLayoutData((Object)formData);
        this.ignoredTable = new Table(composite, 67620);
        this.ignoredTable.setHeaderVisible(true);
        this.ignoredTable.setLinesVisible(true);
        formData = new FormData();
        formData.left = new FormAttachment((Control)label, 5, 16384);
        formData.right = new FormAttachment(100, -90);
        formData.top = new FormAttachment((Control)label, 5);
        formData.bottom = new FormAttachment(95);
        this.ignoredTable.setLayoutData((Object)formData);
        TableColumn c_active = new TableColumn(this.ignoredTable, 0x1000000);
        c_active.setText("\u542f\u7528");
        c_active.setWidth(45);
        TableColumn c_tablePatterns = new TableColumn(this.ignoredTable, 16384);
        c_tablePatterns.setText("\u5ffd\u7565\u89c4\u5219");
        c_tablePatterns.setWidth(300);
        Element databaseConfig = PreferenceStoreUtil.getMergeDatabaseConfig();
        Element ignoretables = databaseConfig.element("ignoretables");
        if (ignoretables != null) {
            List elements = ignoretables.elements("ignoretable");
            for (Element element : elements) {
                TableItem item = new TableItem(this.ignoredTable, 0);
                item.setText(new String[]{"", element.attributeValue("pattern", "")});
                item.setChecked(Boolean.parseBoolean(item.getText(0)));
            }
        }
        Button addPattern = new Button(composite, 8);
        addPattern.setText("Add");
        formData = new FormData(60, 30);
        formData.left = new FormAttachment((Control)this.ignoredTable, 5);
        formData.top = new FormAttachment((Control)this.ignoredTable, 0, 128);
        addPattern.setLayoutData((Object)formData);
        addPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeConfig.this.addIgnorePattern();
            }
        });
        Button editorPattern = new Button(composite, 8);
        editorPattern.setText("Editor");
        formData = new FormData();
        formData.top = new FormAttachment((Control)addPattern, 5);
        formData.left = new FormAttachment((Control)addPattern, 0, 16384);
        formData.right = new FormAttachment((Control)addPattern, 0, 131072);
        editorPattern.setLayoutData((Object)formData);
        editorPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeConfig.this.editorIgnorePattern();
            }
        });
        Button removePattern = new Button(composite, 8);
        removePattern.setText("Remove");
        formData = new FormData();
        formData.top = new FormAttachment((Control)editorPattern, 5);
        formData.left = new FormAttachment((Control)editorPattern, 0, 16384);
        formData.right = new FormAttachment((Control)editorPattern, 0, 131072);
        removePattern.setLayoutData((Object)formData);
        removePattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeConfig.this.remoteIgnorePattern();
            }
        });
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        this.performOk();
    }

    public boolean performOk() {
        TableItem[] tableItems;
        Element config = PreferenceStoreUtil.getMergeDatabaseConfig();
        Element ignoretables = config.element("ignoretables");
        if (ignoretables == null) {
            ignoretables = config.addElement("ignoretables");
        }
        List elements = ignoretables.elements("ignoretable");
        for (Element element : elements) {
            ignoretables.remove(element);
        }
        TableItem[] tableItemArray = tableItems = this.ignoredTable.getItems();
        int n = tableItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            Element element = ignoretables.addElement("ignoretable");
            element.addAttribute("enable", Boolean.toString(tableItem.getChecked()));
            element.addAttribute("pattern", tableItem.getText(1));
            ++n2;
        }
        PreferenceStoreUtil.setMergeDatabaseConfig(config);
        return true;
    }

    private void addIgnorePattern() {
        InputDialog dialog = new InputDialog(this.getShell(), "\u6dfb\u52a0\u89c4\u5219", "\u8868\u5ffd\u7565\u89c4\u5219(\u6b63\u5219\u8868\u8fbe\u5f0f)", null, new IInputValidator(){

            public String isValid(String newText) {
                TableItem[] items;
                if (StringUtils.isBlank((String)newText)) {
                    return "\u5ffd\u7565\u89c4\u5219\u4e0d\u5141\u8bb8\u4e3a\u7a7a!";
                }
                TableItem[] tableItemArray = items = MergeConfig.this.ignoredTable.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    if (newText.trim().equals(tableItem.getText(1))) {
                        return "\u5ffd\u7565\u89c4\u5219\u91cd\u590d";
                    }
                    ++n2;
                }
                return null;
            }
        });
        if (dialog.open() == 0) {
            String pattern = dialog.getValue().trim();
            TableItem item = new TableItem(this.ignoredTable, 0);
            item.setText(new String[]{"", pattern});
            item.setChecked(true);
        }
    }

    private void editorIgnorePattern() {
        int index = this.ignoredTable.getSelectionIndex();
        if (index == -1) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"\u63d0\u793a", (String)"\u8bf7\u9009\u62e9\u9700\u8981\u7f16\u8f91\u7684\u89c4\u5219!");
            return;
        }
        TableItem tableItem = this.ignoredTable.getItem(index);
        String text = tableItem.getText(1);
        InputDialog dialog = new InputDialog(this.getShell(), "\u6dfb\u52a0\u89c4\u5219", "\u8868\u5ffd\u7565\u89c4\u5219", text, new IInputValidator(){

            public String isValid(String newText) {
                TableItem[] items;
                if (StringUtils.isBlank((String)newText)) {
                    return "\u5ffd\u7565\u89c4\u5219\u4e0d\u5141\u8bb8\u4e3a\u7a7a!";
                }
                TableItem[] tableItemArray = items = MergeConfig.this.ignoredTable.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    if (newText.trim().equals(tableItem.getText(1))) {
                        return "\u5ffd\u7565\u89c4\u5219\u91cd\u590d";
                    }
                    ++n2;
                }
                return null;
            }
        });
        if (dialog.open() == 0) {
            String pattern = dialog.getValue().trim();
            tableItem.setText(new String[]{"", pattern});
        }
    }

    private void remoteIgnorePattern() {
        int index = this.ignoredTable.getSelectionIndex();
        if (index == -1) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"\u63d0\u793a", (String)"\u8bf7\u9009\u62e9\u9700\u8981\u79fb\u9664\u7684\u89c4\u5219!");
            return;
        }
        this.ignoredTable.remove(index);
    }
}

