/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.layer;

import info.gongqi.layer.InvokeType;
import info.gongqi.util.Images;
import info.gongqi.util.LayerUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.codeassist.InternalCompletionContext;
import org.eclipse.jdt.internal.codeassist.InternalExtendedCompletionContext;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.text.correction.proposals.AddImportCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.MethodProposalInfo;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class JavaCompletionProposalHnadler {
    private static Logger log = Logger.getLogger(JavaCompletionProposalHnadler.class);
    private static JavaCompletionProposalHnadler defaultHandler;

    public static JavaCompletionProposalHnadler getDefaultHandler() {
        if (defaultHandler == null) {
            defaultHandler = new JavaCompletionProposalHnadler();
        }
        return defaultHandler;
    }

    public List<ICompletionProposal> handlerJavaContentAssist(JavaContentAssistInvocationContext javaContext, List<ICompletionProposal> completionProposals) {
        try {
            completionProposals = this.handlerLayerClass(completionProposals);
            InvokeType invokeType = this.getInvokeType(javaContext);
            if (invokeType == InvokeType.Instance) {
                return this.handlerInstanceCompletionProposals(completionProposals);
            }
            if (invokeType == InvokeType.Util) {
                return this.handlerUtilCompletionProposals(completionProposals);
            }
            this.filterCompletionProposal(completionProposals);
            this.sortCompletionProposal(completionProposals);
        }
        catch (Exception e) {
            log.error((Object)"\u5904\u7406ICompletionProposal\u5f02\u5e38", (Throwable)e);
        }
        return completionProposals;
    }

    private List<ICompletionProposal> handlerInstanceCompletionProposals(List<ICompletionProposal> completionProposals) throws JavaModelException {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (ICompletionProposal proposal : completionProposals) {
            if (proposal instanceof JavaMethodCompletionProposal) {
                JavaMethodCompletionProposal methodProposal = (JavaMethodCompletionProposal)proposal;
                IMethod method = (IMethod)methodProposal.getJavaElement();
                if (Flags.isStatic((int)method.getFlags()) || LayerUtil.isUtilMethod(method)) continue;
                proposals.add(proposal);
                continue;
            }
            proposals.add(proposal);
        }
        return proposals;
    }

    private List<ICompletionProposal> handlerUtilCompletionProposals(List<ICompletionProposal> completionProposals) throws JavaModelException {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (ICompletionProposal completionProposal : completionProposals) {
            JavaMethodCompletionProposal methodProposal;
            IMethod method;
            if (!(completionProposal instanceof JavaMethodCompletionProposal) || Flags.isStatic((int)(method = (IMethod)(methodProposal = (JavaMethodCompletionProposal)completionProposal).getJavaElement()).getFlags()) || !LayerUtil.isUtilMethod(method)) continue;
            methodProposal.setImage(Images.getIcon(method));
            proposals.add(completionProposal);
        }
        return proposals;
    }

    private List<ICompletionProposal> handlerLayerClass(List<ICompletionProposal> completionProposals) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        try {
            for (ICompletionProposal proposal : completionProposals) {
                if (proposal instanceof JavaTypeCompletionProposal || proposal instanceof LazyJavaTypeCompletionProposal) {
                    IType type;
                    AbstractJavaCompletionProposal typeProposal = (AbstractJavaCompletionProposal)proposal;
                    IJavaElement javaElement = typeProposal.getJavaElement();
                    if (!(javaElement instanceof IType) || (type = (IType)javaElement).getPackageFragment() != null && LayerUtil.isLayerPackage(type.getPackageFragment().getElementName()) && !LayerUtil.isHostingHighestLayer(type.getFullyQualifiedName())) continue;
                    proposals.add(proposal);
                    continue;
                }
                if (proposal instanceof JavaMethodCompletionProposal) {
                    JavaMethodCompletionProposal methodProposal = (JavaMethodCompletionProposal)proposal;
                    MethodProposalInfo proposalInfo = (MethodProposalInfo)methodProposal.getProposalInfo();
                    CompletionProposal completionProposal = proposalInfo.getCompletionProposal();
                    if (completionProposal.isConstructor()) {
                        methodProposal.toString();
                        char[] declaringTypeSignature = completionProposal.getDeclarationSignature();
                        String declaringType = declaringTypeSignature == null ? "java.lang.Object" : SignatureUtil.stripSignatureToFQN(String.valueOf(declaringTypeSignature));
                        String qualifier = Signature.getQualifier((String)declaringType);
                        if (LayerUtil.isLayerPackage(qualifier)) {
                            if (!LayerUtil.isHostingHighestLayer(declaringType)) continue;
                            proposals.add(proposal);
                            continue;
                        }
                        proposals.add(proposal);
                        continue;
                    }
                    proposals.add(proposal);
                    continue;
                }
                proposals.add(proposal);
            }
            return proposals;
        }
        catch (Exception e) {
            log.error((Object)"\u5904\u7406ICompletionProposal\u9519\u8bef", (Throwable)e);
            return completionProposals;
        }
    }

    public IJavaCompletionProposal[] handlerQuickFixProcessor(IJavaCompletionProposal[] javaCompletionProposals) {
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        IJavaCompletionProposal[] iJavaCompletionProposalArray = javaCompletionProposals;
        int n = javaCompletionProposals.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaCompletionProposal javaCompletionProposal = iJavaCompletionProposalArray[n2];
            if (javaCompletionProposal instanceof AddImportCorrectionProposal) {
                AddImportCorrectionProposal importCorrectionProposal = (AddImportCorrectionProposal)javaCompletionProposal;
                String qualifiedTypeName = importCorrectionProposal.getQualifiedTypeName();
                if (qualifiedTypeName.lastIndexOf(46) != -1 && LayerUtil.isLayerPackage(qualifiedTypeName.substring(0, qualifiedTypeName.lastIndexOf(46)))) {
                    if (LayerUtil.isHostingHighestLayer(qualifiedTypeName)) {
                        proposals.add(importCorrectionProposal);
                    }
                } else {
                    proposals.add(importCorrectionProposal);
                }
            } else {
                proposals.add(javaCompletionProposal);
            }
            ++n2;
        }
        ListIterator iterator = proposals.listIterator();
        while (iterator.hasNext()) {
            IJavaCompletionProposal javaCompletionProposal = (IJavaCompletionProposal)iterator.next();
            if (!this.upLayerPackage(javaCompletionProposal) && !this.acrossSolutionRef(javaCompletionProposal)) continue;
            iterator.remove();
        }
        return proposals.toArray(new IJavaCompletionProposal[proposals.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InvokeType getInvokeType(JavaContentAssistInvocationContext javaContext) {
        CompletionContext coreContext = javaContext.getCoreContext();
        if (!(coreContext instanceof InternalCompletionContext)) return InvokeType.Other;
        try {
            MethodBinding singletonMethod;
            Expression expression = null;
            Object obj = this.getAssistNode((InternalCompletionContext)coreContext);
            if (obj instanceof FieldReference) {
                FieldReference fieldReference = (FieldReference)obj;
                expression = fieldReference.receiver;
            } else if (obj instanceof NameReference) {
                NameReference nameReference = (NameReference)obj;
                Binding binding = nameReference.binding;
                if (!(binding instanceof VariableBinding)) return InvokeType.Other;
                VariableBinding variableBinding = (VariableBinding)binding;
                TypeBinding typeBinding = variableBinding.type;
                if (!(typeBinding instanceof ReferenceBinding)) return InvokeType.Other;
                if (!LayerUtil.isLayerPackage(String.valueOf(typeBinding.getPackage().readableName()))) return InvokeType.Other;
                return InvokeType.Instance;
            }
            while (true) {
                if (!(expression instanceof CastExpression)) {
                    if (!(expression instanceof MessageSend)) return InvokeType.Other;
                    MessageSend messageSend = (MessageSend)expression;
                    SingleNameReference singleName = (SingleNameReference)messageSend.receiver;
                    singletonMethod = messageSend.binding;
                    if (!LayerUtil.isLayerPackage(String.valueOf(singleName.resolvedType.getPackage().readableName()))) return InvokeType.Other;
                    if (!singleName.resolvedType.debugName().equals(singletonMethod.returnType.debugName())) return InvokeType.Other;
                    if (singletonMethod.parameters.length != 0) return InvokeType.Other;
                    if (!LayerUtil.getUtilsMethodName().equals(new String(singletonMethod.constantPoolName()))) break;
                    return InvokeType.Util;
                }
                CastExpression castExpression = (CastExpression)expression;
                expression = castExpression.expression;
            }
            if (!LayerUtil.getInstanceMthodName().equals(new String(singletonMethod.constantPoolName()))) return InvokeType.Other;
            return InvokeType.Instance;
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return InvokeType.Other;
    }

    private Object getAssistNode(InternalCompletionContext internalCompletionContext) throws Exception {
        InternalExtendedCompletionContext extendedContext = (InternalExtendedCompletionContext)JavaCompletionProposalHnadler.reflectFieldValue(internalCompletionContext, InternalCompletionContext.class, "extendedContext");
        return JavaCompletionProposalHnadler.reflectFieldValue(extendedContext, InternalExtendedCompletionContext.class, "assistNode");
    }

    private static Object reflectFieldValue(Object obj, Class clazz, String name) throws Exception {
        Field field = clazz.getDeclaredField(name);
        field.setAccessible(true);
        return field.get(obj);
    }

    private List<ICompletionProposal> sortCompletionProposal(List<ICompletionProposal> completionProposals) {
        Comparator<ICompletionProposal> comparator = new Comparator<ICompletionProposal>(){

            @Override
            public int compare(ICompletionProposal o1, ICompletionProposal o2) {
                return o1.getDisplayString().compareTo(o2.getDisplayString());
            }
        };
        Collections.sort(completionProposals, comparator);
        return completionProposals;
    }

    private List<ICompletionProposal> filterCompletionProposal(List<ICompletionProposal> completionProposals) {
        ListIterator<ICompletionProposal> iterator = completionProposals.listIterator();
        while (iterator.hasNext()) {
            IJavaCompletionProposal javaCompletionProposal;
            ICompletionProposal completionProposal = iterator.next();
            if (!(completionProposal instanceof IJavaCompletionProposal) || !this.upLayerPackage(javaCompletionProposal = (IJavaCompletionProposal)completionProposal) && !this.acrossSolutionRef(javaCompletionProposal)) continue;
            iterator.remove();
        }
        return completionProposals;
    }

    private boolean upLayerPackage(IJavaCompletionProposal completionProposal) {
        ASTRewriteCorrectionProposal rewriteCorrectionProposal;
        ImportRewrite importRewrite;
        if (completionProposal instanceof LazyJavaTypeCompletionProposal) {
            LazyJavaTypeCompletionProposal lazyJavaTypeCompletionProposal = (LazyJavaTypeCompletionProposal)completionProposal;
            String qualifiedTypeName = lazyJavaTypeCompletionProposal.getQualifiedTypeName();
            return this.upLayerPackage(qualifiedTypeName);
        }
        if (completionProposal instanceof AddImportCorrectionProposal) {
            AddImportCorrectionProposal addImportCorrectionProposal = (AddImportCorrectionProposal)completionProposal;
            String qualifiedTypeName = addImportCorrectionProposal.getQualifiedTypeName();
            return this.upLayerPackage(qualifiedTypeName);
        }
        if (completionProposal instanceof ASTRewriteCorrectionProposal && (importRewrite = (rewriteCorrectionProposal = (ASTRewriteCorrectionProposal)completionProposal).getImportRewrite()) != null) {
            String[] addedImports;
            String[] stringArray = addedImports = importRewrite.getAddedImports();
            if (addedImports.length != 0) {
                String addImport = stringArray[0];
                return this.upLayerPackage(addImport);
            }
        }
        return false;
    }

    private boolean upLayerPackage(String typeBindingPackageName) {
        try {
            IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            ICompilationUnit unit = (ICompilationUnit)EditorUtility.getEditorInputJavaElement(activeEditor, false);
            String packageName = unit.getPackageDeclarations()[0].getElementName();
            if (packageName.contains(".layers.") && typeBindingPackageName.contains(".layers.")) {
                int typeBindingLevel;
                int level = LayerUtil.getLayerLevel(this.extractLayerName(packageName));
                return level < (typeBindingLevel = LayerUtil.getLayerLevel(this.extractLayerName(typeBindingPackageName)));
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    private String extractLayerName(String packageName) {
        String temp = packageName.substring(packageName.indexOf(".layers.") + ".layers.".length());
        return temp.substring(0, temp.indexOf("."));
    }

    private boolean acrossSolutionRef(IJavaCompletionProposal completionProposal) {
        if (completionProposal instanceof LazyJavaTypeCompletionProposal) {
            LazyJavaTypeCompletionProposal lazyJavaTypeCompletionProposal = (LazyJavaTypeCompletionProposal)completionProposal;
            String qualifiedTypeName = lazyJavaTypeCompletionProposal.getQualifiedTypeName();
            return JavaCompletionProposalHnadler.acrossSolutionRef(qualifiedTypeName);
        }
        if (completionProposal instanceof AddImportCorrectionProposal) {
            AddImportCorrectionProposal addImportCorrectionProposal = (AddImportCorrectionProposal)completionProposal;
            String qualifiedTypeName = addImportCorrectionProposal.getQualifiedTypeName();
            return JavaCompletionProposalHnadler.acrossSolutionRef(qualifiedTypeName);
        }
        return false;
    }

    private static boolean acrossSolutionRef(String typeBindingPackageName) {
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        ICompilationUnit unit = (ICompilationUnit)EditorUtility.getEditorInputJavaElement(activeEditor, false);
        try {
            String packageName = unit.getPackageDeclarations()[0].getElementName();
            if (packageName.contains(".layers.") && typeBindingPackageName.contains(".layers.") && !packageName.startsWith("gongqi.erp.layers.") && !typeBindingPackageName.startsWith("gongqi.erp.layers.") && !packageName.substring(0, packageName.indexOf(".layers.")).equals(typeBindingPackageName.substring(0, typeBindingPackageName.indexOf(".layers.")))) {
                return true;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }
}

