/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.file.monitor;

import gongqi.erp.framework.core.GongqiEnvironment;
import gongqi.erp.framework.core.ObjectContainer;
import info.gongqi.file.monitor.CommandsListener;
import info.gongqi.file.monitor.LayersAlterationListener;
import info.gongqi.file.monitor.OprCommandChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;

public class MonitorController {
    private static ArrayList<MonitorController> array;
    private static boolean isStarted;
    private long interval = TimeUnit.SECONDS.toMillis(2L);
    private FileAlterationMonitor monitor = new FileAlterationMonitor(this.interval);
    public static String monitorPath;

    public static boolean getIsStarted() {
        return isStarted;
    }

    public static boolean startMf() {
        if (isStarted) {
            return true;
        }
        array = new ArrayList();
        MonitorController mc = new MonitorController();
        array.add(mc);
        try {
            mc.init();
            mc.start();
            isStarted = true;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean stopMf() {
        if (!isStarted) {
            return true;
        }
        for (MonitorController mc : array) {
            try {
                mc.stop();
                mc = null;
            }
            catch (Exception exception) {
                return false;
            }
        }
        array = null;
        isStarted = false;
        return true;
    }

    public void init() {
        GongqiEnvironment environment = (GongqiEnvironment)ObjectContainer.getInstance(GongqiEnvironment.class);
        File codeListenerPath = new File(environment.getGongqiDir(), "Project/Server/GongqiERP/designer/tmp/codelistener");
        FileAlterationObserver observer = new FileAlterationObserver(codeListenerPath.getAbsolutePath(), new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return "OprCommand.txt".equals(pathname.getName());
            }
        }, null);
        observer.addListener((FileAlterationListener)new OprCommandChangeListener());
        this.monitor.addObserver(observer);
        observer = new FileAlterationObserver(codeListenerPath.getAbsolutePath(), new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return "PluginListener.xml".equals(pathname.getName());
            }
        }, null);
        observer.addListener((FileAlterationListener)new CommandsListener());
        this.monitor.addObserver(observer);
        File layersDir = new File(environment.getGongqiDir(), "Project/Server/LayerProject/layers");
        observer = new FileAlterationObserver(layersDir);
        observer.addListener((FileAlterationListener)new LayersAlterationListener());
        this.monitor.addObserver(observer);
    }

    public void start() {
        try {
            this.monitor.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            this.monitor.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

