/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.command.impl;

import info.gongqi.command.Command;
import info.gongqi.command.impl.AbstractCommandHandler;
import info.gongqi.util.JavaElementHelp;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.UserLibrary;
import org.eclipse.jdt.internal.core.UserLibraryManager;

public class CreateLayerCommandHandlerImpl
extends AbstractCommandHandler {
    @Override
    protected boolean handleInternal(Command command) throws Exception {
        this.aggregateLayers();
        this.updateUserLibrary(command.getLayerName());
        return true;
    }

    private void updateUserLibrary(String layerName) {
        log.debug((Object)("update layer UserLibrary:" + layerName));
        String libraryName = "layer_" + layerName;
        UserLibraryManager manager = JavaModelManager.getUserLibraryManager();
        UserLibrary userLibrary = manager.getUserLibrary(libraryName);
        if (userLibrary != null) {
            manager.removeUserLibrary(libraryName);
        }
        manager.setUserLibrary(libraryName, new IClasspathEntry[0], false);
        JavaProject project = JavaElementHelp.getLayerProject();
        try {
            IClasspathEntry[] rawClasspath;
            boolean quote = false;
            IClasspathEntry[] iClasspathEntryArray = rawClasspath = project.getRawClasspath();
            int n = rawClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                if (classpathEntry.getEntryKind() == 5 && classpathEntry.getPath().toOSString().equals("org.eclipse.jdt.USER_LIBRARY/" + libraryName)) {
                    quote = true;
                    break;
                }
                ++n2;
            }
            if (!quote) {
                IClasspathEntry[] newRawClasspath = new IClasspathEntry[rawClasspath.length + 1];
                System.arraycopy(rawClasspath, 0, newRawClasspath, 0, rawClasspath.length);
                newRawClasspath[rawClasspath.length] = JavaCore.newContainerEntry((IPath)Path.fromOSString((String)("org.eclipse.jdt.USER_LIBRARY/" + libraryName)));
                JavaModelManager.PerProjectInfo perProjectInfo = project.getPerProjectInfo();
                perProjectInfo.writeAndCacheClasspath(project, newRawClasspath, perProjectInfo.outputLocation);
            }
        }
        catch (JavaModelException e) {
            log.error((Object)("\u521b\u5efa\u5c42" + layerName + "\u66f4\u65b0\u7528\u6237\u5e93\u5f02\u5e38"), (Throwable)e);
        }
    }
}

