/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.command.impl;

import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.gotmodel.core.GOTLocator;
import info.gongqi.command.Command;
import info.gongqi.command.CommandHandler;
import info.gongqi.util.ASTUtil;
import info.gongqi.util.JavaElementHelp;
import info.gongqi.util.LayerUtil;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public abstract class AbstractCommandHandler
implements CommandHandler {
    protected static Logger log = Logger.getLogger(AbstractCommandHandler.class);

    @Override
    public final boolean handle(Command command) {
        try {
            this.refreshProject();
            return this.handleInternal(command);
        }
        catch (Exception e) {
            log.error((Object)("Command\u5904\u7406\u5f02\u5e38\uff1a\u3010" + command + "\u3011"), (Throwable)e);
            return false;
        }
    }

    protected abstract boolean handleInternal(Command var1) throws Exception;

    protected void aggregateLayers() {
        log.debug((Object)"aggregateLayers");
        GOTLocator cfr_ignored_0 = (GOTLocator)ObjectContainer.getInstance(GOTLocator.class);
    }

    protected void correctLayerReference() {
        try {
            JavaProject project = JavaElementHelp.getLayerProject();
            if (project != null) {
                List<ICompilationUnit> compilationUnits = JavaElementHelp.getCompilationUnits((IJavaProject)project);
                ASTVisitor astVisitor = new ASTVisitor(){

                    public boolean visit(ImportDeclaration importDeclaration) {
                        ITypeBinding typeBinding = importDeclaration.getName().resolveTypeBinding();
                        if (typeBinding != null && LayerUtil.isLayerPackage(typeBinding.getPackage().getName()) && !LayerUtil.isHostingHighestLayer(typeBinding.getQualifiedName())) {
                            String fullyQualifiedName = LayerUtil.getHostingLayerFullyQualifiedName(typeBinding.getQualifiedName());
                            Name name = importDeclaration.getAST().newName(fullyQualifiedName);
                            importDeclaration.setName(name);
                        }
                        return false;
                    }

                    public boolean visit(TypeDeclaration node) {
                        List bodyDeclarations = node.bodyDeclarations();
                        for (ASTNode astNode : bodyDeclarations) {
                            astNode.accept((ASTVisitor)this);
                        }
                        return false;
                    }

                    public boolean visit(SimpleType simpleType) {
                        CompilationUnit unit;
                        String packageName;
                        ITypeBinding typeBinding = simpleType.getName().resolveTypeBinding();
                        if (typeBinding != null && typeBinding.getPackage() != null && simpleType.getName() instanceof QualifiedName && LayerUtil.isLayerPackage(typeBinding.getPackage().getName()) && !LayerUtil.isHostingHighestLayer(typeBinding.getQualifiedName()) && !LayerUtil.isDataTypePackage(packageName = (unit = (CompilationUnit)simpleType.getRoot()).getPackage().getName().getFullyQualifiedName())) {
                            String fullyQualifiedName = LayerUtil.getHostingLayerFullyQualifiedName(typeBinding.getQualifiedName());
                            Name name = simpleType.getAST().newName(fullyQualifiedName);
                            simpleType.setName(name);
                            return false;
                        }
                        return super.visit(simpleType);
                    }
                };
                for (ICompilationUnit compilationUnit : compilationUnits) {
                    ICompilationUnit workingCopy = compilationUnit.getWorkingCopy(null);
                    CompilationUnit unit = ASTUtil.parser(compilationUnit);
                    if (unit.getPackage() == null || LayerUtil.isBasePackage(unit.getPackage().getName().getFullyQualifiedName())) continue;
                    Document document = new Document(compilationUnit.getBuffer().getContents());
                    unit.recordModifications();
                    unit.accept(astVisitor);
                    TextEdit textEdit = unit.rewrite((IDocument)document, compilationUnit.getJavaProject().getOptions(true));
                    textEdit.apply((IDocument)document);
                    if (!textEdit.hasChildren()) continue;
                    workingCopy.getBuffer().setContents(document.get());
                    workingCopy.reconcile(0, false, null, null);
                    workingCopy.commitWorkingCopy(true, null);
                    workingCopy.discardWorkingCopy();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"\u4fee\u6b63\u5c42\u5f15\u7528\u4ee3\u7801\u5f02\u5e38", (Throwable)e);
        }
    }

    protected void refreshProject() throws CoreException {
        JavaProject project = JavaElementHelp.getLayerProject();
        project.getProject().refreshLocal(2, null);
    }
}

