/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.command;

import info.gongqi.command.Command;
import info.gongqi.command.CommandHandler;
import info.gongqi.command.CommandType;
import info.gongqi.command.impl.CreateLayerCommandHandlerImpl;
import info.gongqi.command.impl.DeleteEntityCommandHandlerImpl;
import info.gongqi.command.impl.DestroyLayerCommandHandlerImpl;
import info.gongqi.command.impl.OverrideMethodCommandHandlerImpl;
import info.gongqi.command.impl.PromoteEntityCommandHandlerImpl;
import info.gongqi.command.impl.ReverEntityCommandHandlerImpl;
import info.gongqi.command.impl.SaveEntityCommandHandlerImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CommandDispatcher {
    private static Logger log = Logger.getLogger(CommandDispatcher.class);
    private static Map<String, CommandHandler> handlers;
    private static CommandDispatcher defaultCommand;

    static {
        try {
            CommandDispatcher.registerHandler();
        }
        catch (Exception e) {
            log.error((Object)"\u6ce8\u518cCommandHandler\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u6ce8\u518cCommanHandler\u5f02\u5e38");
        }
    }

    public static CommandDispatcher getDefault() {
        if (defaultCommand == null) {
            defaultCommand = new CommandDispatcher();
        }
        return defaultCommand;
    }

    public boolean dispatcher(Command command) {
        log.debug((Object)("handler Command:" + command.toString()));
        CommandHandler handler = this.getHandler(command);
        if (handler == null) {
            log.error((Object)("\u672a\u6ce8\u518c\u5904\u7406\u5668\uff1a" + command));
            return false;
        }
        return handler.handle(command);
    }

    private static void registerHandler() {
        handlers = new HashMap<String, CommandHandler>();
        handlers.put(CommandType.CreateLayer.name(), new CreateLayerCommandHandlerImpl());
        handlers.put(CommandType.DeleteEntity.name(), new DeleteEntityCommandHandlerImpl());
        handlers.put(CommandType.DestroyLayer.name(), new DestroyLayerCommandHandlerImpl());
        handlers.put(CommandType.PromoteEntity.name(), new PromoteEntityCommandHandlerImpl());
        handlers.put(CommandType.ReverEntity.name(), new ReverEntityCommandHandlerImpl());
        handlers.put(CommandType.SaveEntity.name(), new SaveEntityCommandHandlerImpl());
        handlers.put(CommandType.OverrideMethod.name(), new OverrideMethodCommandHandlerImpl());
    }

    private CommandHandler getHandler(Command command) {
        return handlers.get(command.getCommandType().name());
    }
}

