/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.action;

import com.ximpleware.VTDNav;
import gongqi.erp.framework.core.GongqiEnvironment;
import gongqi.erp.framework.core.LayerDefination;
import gongqi.erp.framework.core.LayerDefinationManager;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.tools.StringHelper;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.erp.gotmodel.core.GOTLocator;
import gongqi.erp.gotmodel.core.LayeredGOTEntityManager;
import info.gongqi.util.JavaElementHelp;
import info.gongqi.utils.VTDUtil;
import info.gongqi.widgets.StringEditor;
import info.gongqi.widgets.Table;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class ImportTableView
implements IWorkbenchWindowActionDelegate,
SelectionListener {
    private static final String[] DATATYPE = new String[]{"String", "Long", "Boolean", "Date", "Decimal", "Enum", "Time"};
    private static Logger log = Logger.getLogger(ImportTableView.class);
    private Shell shell;
    private StringEditor importId;
    private StringEditor importLabel;
    private Combo c_FileType;
    private StringEditor sheetName;
    private StringEditor seperator;
    private Button bt_isGongqiReord;
    private StringEditor tableClass;
    private Button bt_active;
    private Button bt_visible;
    private Button bt_hasHeader;
    private Button bt_hasVars;
    private Button bt_simpleInsert;
    private Button bt_saveImported;
    private Button bt_saveUnImported;
    private VarTable var;
    private FieldTable fields;
    private Button confirm;
    private Button cancel;

    public void run(IAction action) {
        if (this.shell == null || this.shell.isDisposed()) {
            this.createContent();
        } else {
            this.shell.setActive();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    public void init(IWorkbenchWindow window) {
    }

    private void createContent() {
        Display display = Display.getCurrent();
        this.shell = new Shell(display.getActiveShell(), 65600);
        this.shell.setText("\u65b0\u5efa\u6570\u636e\u5bfc\u5165");
        this.shell.setImage(new Image((Device)this.shell.getDisplay(), ImportTableView.class.getClassLoader().getResourceAsStream("info/gongqi/icon/import.png")));
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(780, 430);
        this.importId = new StringEditor((Composite)this.shell, "\u5bfc\u5165ID");
        FormData layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 15);
        layoutData.top = new FormAttachment(0, 15);
        this.importId.setLayoutData(layoutData);
        this.importLabel = new StringEditor((Composite)this.shell, "\u5bfc\u5165\u540d\u79f0");
        layoutData = new FormData();
        layoutData.left = new FormAttachment((Control)this.importId, 15);
        layoutData.top = new FormAttachment((Control)this.importId, 0, 128);
        this.importLabel.setLayoutData(layoutData);
        Label l_FileType = new Label((Composite)this.shell, 16384);
        l_FileType.setText("\u6587\u4ef6\u7c7b\u578b");
        layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 15);
        layoutData.top = new FormAttachment((Control)this.importId, 20);
        l_FileType.setLayoutData((Object)layoutData);
        this.c_FileType = new Combo((Composite)this.shell, 8);
        this.c_FileType.setItems(new String[]{"XLS", "CSV"});
        this.c_FileType.select(0);
        this.c_FileType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ImportTableView.this.c_FileType.getText();
                if ("XLS".equals(text)) {
                    ImportTableView.this.sheetName.setEditable(true);
                    ImportTableView.this.seperator.setText("");
                    ImportTableView.this.seperator.setEditable(false);
                } else if ("CSV".equals(text)) {
                    ImportTableView.this.sheetName.setText("");
                    ImportTableView.this.sheetName.setEditable(false);
                    ImportTableView.this.seperator.setEditable(true);
                }
            }
        });
        layoutData = new FormData(20, 15);
        layoutData.left = new FormAttachment((Control)l_FileType, 5);
        layoutData.top = new FormAttachment((Control)this.importId, 17);
        this.c_FileType.setLayoutData((Object)layoutData);
        this.sheetName = new StringEditor((Composite)this.shell, "Sheet\u540d\u79f0");
        this.sheetName.setWidth(60);
        layoutData = new FormData();
        layoutData.left = new FormAttachment((Control)this.c_FileType, 10);
        layoutData.top = new FormAttachment((Control)this.importId, 20);
        this.sheetName.setLayoutData(layoutData);
        this.seperator = new StringEditor((Composite)this.shell, "\u5206\u9694\u7b26");
        this.seperator.setWidth(15);
        this.seperator.setEditable(false);
        layoutData = new FormData();
        layoutData.left = new FormAttachment((Control)this.sheetName, 10);
        layoutData.top = new FormAttachment((Control)this.importId, 20);
        this.seperator.setLayoutData(layoutData);
        this.bt_isGongqiReord = new Button((Composite)this.shell, 32);
        this.bt_isGongqiReord.setText("GongqiReord");
        this.bt_isGongqiReord.setSelection(true);
        this.bt_isGongqiReord.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTableView.this.fields.table.setEnabled(ImportTableView.this.bt_isGongqiReord.getSelection());
            }
        });
        layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 15);
        layoutData.top = new FormAttachment((Control)l_FileType, 20);
        this.bt_isGongqiReord.setLayoutData((Object)layoutData);
        this.tableClass = new StringEditor((Composite)this.shell, "TableClass");
        this.tableClass.setWidth(129);
        layoutData = new FormData();
        layoutData.left = new FormAttachment((Control)this.bt_isGongqiReord, 15);
        layoutData.top = new FormAttachment((Control)l_FileType, 20);
        this.tableClass.setLayoutData(layoutData);
        this.tableClass.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                ImportTableView.this.updateImportFields();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.bt_active = new Button((Composite)this.shell, 32);
        this.bt_active.setText("\u6709\u6548\u7684");
        this.bt_active.setSelection(true);
        layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 15);
        layoutData.top = new FormAttachment((Control)this.bt_isGongqiReord, 15);
        this.bt_active.setLayoutData((Object)layoutData);
        this.bt_visible = new Button((Composite)this.shell, 32);
        this.bt_visible.setText("\u53ef\u89c1\u6027");
        this.bt_visible.setSelection(true);
        layoutData = new FormData();
        layoutData.left = new FormAttachment((Control)this.bt_active, 15);
        layoutData.top = new FormAttachment((Control)this.bt_isGongqiReord, 15);
        this.bt_visible.setLayoutData((Object)layoutData);
        this.bt_hasHeader = new Button((Composite)this.shell, 32);
        this.bt_hasHeader.setText("\u6807\u9898\u884c");
        layoutData = new FormData();
        layoutData.left = new FormAttachment((Control)this.bt_visible, 15);
        layoutData.top = new FormAttachment((Control)this.bt_isGongqiReord, 15);
        this.bt_hasHeader.setLayoutData((Object)layoutData);
        this.bt_hasVars = new Button((Composite)this.shell, 32);
        this.bt_hasVars.setText("\u5168\u5c40\u53d8\u91cf");
        this.bt_hasVars.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTableView.this.var.setActive(ImportTableView.this.bt_hasVars.getSelection());
            }
        });
        layoutData = new FormData();
        layoutData.left = new FormAttachment((Control)this.bt_hasHeader, 15);
        layoutData.top = new FormAttachment((Control)this.bt_isGongqiReord, 15);
        this.bt_hasVars.setLayoutData((Object)layoutData);
        this.bt_simpleInsert = new Button((Composite)this.shell, 32);
        this.bt_simpleInsert.setText("SimpleInsert");
        layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 15);
        layoutData.top = new FormAttachment((Control)this.bt_visible, 13);
        this.bt_simpleInsert.setLayoutData((Object)layoutData);
        this.bt_saveImported = new Button((Composite)this.shell, 32);
        this.bt_saveImported.setText("\u5bfc\u5165\u6210\u529f\u65e5\u5fd7");
        layoutData = new FormData();
        layoutData.left = new FormAttachment((Control)this.bt_simpleInsert, 15);
        layoutData.top = new FormAttachment((Control)this.bt_visible, 13);
        this.bt_saveImported.setLayoutData((Object)layoutData);
        this.bt_saveUnImported = new Button((Composite)this.shell, 32);
        this.bt_saveUnImported.setText("\u5bfc\u5165\u5931\u8d25\u65e5\u5fd7");
        this.bt_saveUnImported.setSelection(true);
        layoutData = new FormData();
        layoutData.left = new FormAttachment((Control)this.bt_saveImported, 15);
        layoutData.top = new FormAttachment((Control)this.bt_visible, 13);
        this.bt_saveUnImported.setLayoutData((Object)layoutData);
        this.var = new VarTable((Composite)this.shell);
        layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 15);
        layoutData.top = new FormAttachment((Control)this.bt_saveImported, 15);
        layoutData.bottom = new FormAttachment(100, -45);
        this.var.setLayoutData(layoutData);
        this.fields = new FieldTable((Composite)this.shell);
        this.fields.setActive(true);
        layoutData = new FormData();
        layoutData.left = new FormAttachment((Control)this.importLabel, 15);
        layoutData.top = new FormAttachment(0, 15);
        layoutData.bottom = new FormAttachment(100, -45);
        this.fields.setLayoutData(layoutData);
        this.confirm = new Button((Composite)this.shell, 8);
        this.confirm.setText("\u786e\u5b9a");
        this.confirm.setData("flag", (Object)"confirm");
        layoutData = new FormData(100, 30);
        layoutData.left = new FormAttachment(35, 0);
        layoutData.bottom = new FormAttachment(100, -5);
        this.confirm.setLayoutData((Object)layoutData);
        this.confirm.addSelectionListener((SelectionListener)this);
        this.cancel = new Button((Composite)this.shell, 8);
        this.cancel.setText("\u53d6\u6d88");
        this.cancel.setData("flag", (Object)"cancel");
        layoutData = new FormData(100, 30);
        layoutData.left = new FormAttachment((Control)this.confirm, 30);
        layoutData.bottom = new FormAttachment(100, -5);
        this.cancel.setLayoutData((Object)layoutData);
        this.cancel.addSelectionListener((SelectionListener)this);
        this.shell.open();
    }

    public void widgetSelected(SelectionEvent e) {
        Object flag = e.widget.getData("flag");
        if ("confirm".equals(flag)) {
            this.createImport();
        } else if ("cancel".equals(flag)) {
            this.closeForm();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private String[] getGongqiDataType() {
        return new String[]{"String", "Long", "Boolean", "Date", "Decimal", "Enum", "Time"};
    }

    private void createImport() {
        try {
            LayerDefination instance = ((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).getCurrentLayer();
            File target = new File(((GongqiEnvironment)ObjectContainer.getInstance(GongqiEnvironment.class)).getGongqiDir(), "Project/Server/LayerProject/src/gongqi/erp/layers/" + instance.getLayerName() + "/imports/ImportTable_" + this.importId.getText() + ".java");
            JavaProject project = JavaElementHelp.getLayerProject();
            if (project == null) {
                return;
            }
            if (target.exists()) {
                MessageDialog.openError((Shell)this.shell, (String)"\u9519\u8bef", (String)(String.valueOf(this.importId.getText()) + "\u5bfc\u5165\u5df2\u7ecf\u5b58\u5728"));
                return;
            }
            VelocityContext context = new VelocityContext();
            context.put("layerName", (Object)instance.getLayerName());
            String hostingLayer = ((LayeredGOTEntityManager)ObjectContainer.getInstance(LayeredGOTEntityManager.class)).getEntityHostingLayer(EntityType.Table, this.tableClass.getText());
            context.put("hostingLayer", (Object)hostingLayer);
            context.put("tableName", (Object)this.tableClass.getText());
            context.put("importId", (Object)this.importId.getText());
            context.put("label", (Object)this.importLabel.getText());
            context.put("active", (Object)this.bt_active.getSelection());
            context.put("visible", (Object)this.bt_visible.getSelection());
            context.put("fileType", (Object)("ImportFileType." + this.c_FileType.getText()));
            context.put("sheetName", (Object)this.sheetName.getText());
            context.put("seperator", (Object)this.seperator.getText());
            context.put("hasVars", (Object)this.bt_hasVars.getSelection());
            context.put("vars", this.var.getVars());
            context.put("hasHeader", (Object)this.bt_hasHeader.getSelection());
            context.put("saveImported", (Object)this.bt_saveImported.getSelection());
            context.put("saveUnImported", (Object)this.bt_saveUnImported.getSelection());
            context.put("isGongqiReord", (Object)this.bt_isGongqiReord.getSelection());
            context.put("simpleInsert", (Object)this.bt_simpleInsert.getSelection());
            context.put("fields", this.fields.table.getRecords());
            Template template = Velocity.getTemplate((String)"/info/gongqi/action/ImportTable.vm");
            StringWriter writer = new StringWriter();
            template.merge((Context)context, (Writer)writer);
            FileUtils.write((File)target, (CharSequence)writer.toString(), (String)"UTF-8");
            IOUtils.closeQuietly((Writer)writer);
            writer.close();
            this.shell.close();
            IFolder floder = project.getProject().getFolder(String.format("src/gongqi/erp/layers/%s/imports", instance.getLayerName()));
            if (floder.exists()) {
                floder.refreshLocal(2, null);
            }
        }
        catch (Exception e) {
            log.error((Object)"\u65b0\u5efa\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            MessageDialog.openError((Shell)this.shell, (String)"\u9519\u8bef\u63d0\u793a", (String)("\u65b0\u5efa\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    private void closeForm() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    private void updateImportFields() {
        List<String> recordCMFields = Arrays.asList("CreatedDate", "CreatedTime", "CreatedBy", "ModifiedDate", "ModifiedTime", "ModifiedBy", "RecVersion", "RecId");
        File tableXML = ((GOTLocator)ObjectContainer.getInstance(GOTLocator.class)).getEntityFile(EntityType.Table, this.tableClass.getText());
        this.fields.table.cleanRecords();
        if (!tableXML.exists()) {
            ArrayList tables = new ArrayList(((GOTLocator)ObjectContainer.getInstance(GOTLocator.class)).getEntityFiles(EntityType.Table).values());
            for (File table : tables) {
                if (!this.tableClass.getText().toLowerCase().equals(table.getName().toLowerCase())) continue;
                tableXML = table;
                break;
            }
        }
        if (tableXML.exists() && tableXML.isFile()) {
            VTDNav nav = VTDUtil.parse((File)tableXML);
            if (!this.tableClass.getText().equals(VTDUtil.getAttributeValue((VTDNav)nav, (String)"name"))) {
                this.tableClass.setText(VTDUtil.getAttributeValue((VTDNav)nav, (String)"name"));
            }
            if (VTDUtil.toFirstChildElement((VTDNav)nav, (String)"TableFields") && VTDUtil.toFirstChildElement((VTDNav)nav, (String)"TableField")) {
                do {
                    String entityId;
                    if (recordCMFields.contains(VTDUtil.getAttributeValue((VTDNav)nav, (String)"name"))) continue;
                    if ("Component".equals(VTDUtil.getAttributeValue((VTDNav)nav, (String)"type"))) {
                        VTDUtil.iterateProperty((VTDNav)nav.cloneNav(), (VTDUtil.IteratePropertyCallBack)new VTDUtil.IteratePropertyCallBack(){

                            public void callBack(String propertyName, String propertyValue, VTDNav property) {
                                File dataTypeXML;
                                VTDNav dataTypeNav;
                                if ("Extends".equals(propertyName) && StringHelper.isNotBlank((String)propertyValue) && VTDUtil.toFirstChildElement((VTDNav)(dataTypeNav = VTDUtil.parse((File)(dataTypeXML = ((GOTLocator)ObjectContainer.getInstance(GOTLocator.class)).getEntityFile(EntityType.DataType, propertyValue)))), (String)"DataTypeArray") && VTDUtil.toFirstChildElement((VTDNav)dataTypeNav, (String)"DataTypeArrayItem")) {
                                    do {
                                        String label = ImportTableView.this.getExtendLabel(VTDUtil.getPropertyAttributeValue((VTDNav)dataTypeNav, (String)"RefDataType", (String)"refentityid"), VTDUtil.getPropertyValue((VTDNav)dataTypeNav, (String)"RefDataType"));
                                        ImportTableView.this.fields.table.addRecord(new String[]{String.valueOf(VTDUtil.getAttributeValue((VTDNav)VTDUtil.toParentElement((VTDNav)property.cloneNav(), (int)2), (String)"name")) + "_" + VTDUtil.getAttributeValue((VTDNav)dataTypeNav, (String)"name"), label == null ? "" : label, "String", "true"});
                                    } while (VTDUtil.toNextSiblingElement((VTDNav)dataTypeNav, (String)"DataTypeArrayItem"));
                                }
                            }
                        });
                        continue;
                    }
                    String label = VTDUtil.getPropertyValue((VTDNav)nav, (String)"Label");
                    if (StringUtils.isBlank((String)label) && StringUtils.isNotBlank((String)(entityId = VTDUtil.getPropertyAttributeValue((VTDNav)nav, (String)"Extends", (String)"refentityid")))) {
                        label = this.getExtendLabel(entityId, VTDUtil.getPropertyValue((VTDNav)nav, (String)"Extends"));
                    }
                    this.fields.table.addRecord(new String[]{VTDUtil.getAttributeValue((VTDNav)nav, (String)"name"), label == null ? "" : label, VTDUtil.getAttributeValue((VTDNav)nav, (String)"type"), "true"});
                } while (VTDUtil.toNextSiblingElement((VTDNav)nav, (String)"TableField"));
            }
        }
    }

    private String getExtendLabel(String entityId, String entityName) {
        String label = null;
        if (entityId.startsWith("20")) {
            File tableXML = ((GOTLocator)ObjectContainer.getInstance(GOTLocator.class)).getEntityFile(EntityType.Table, entityName);
            VTDNav nav = VTDUtil.parse((File)tableXML);
            label = VTDUtil.getPropertyValue((VTDNav)nav, (String)"Label");
            while (label == null && StringUtils.isNotBlank((String)VTDUtil.getPropertyAttributeValue((VTDNav)nav, (String)"Extends", (String)"refentityid"))) {
                tableXML = ((GOTLocator)ObjectContainer.getInstance(GOTLocator.class)).getEntityFile(EntityType.DataType, VTDUtil.getPropertyValue((VTDNav)nav, (String)"Extends"));
                nav = VTDUtil.parse((File)tableXML);
                label = VTDUtil.getPropertyValue((VTDNav)nav, (String)"Label");
            }
        } else if (entityId.startsWith("10")) {
            File tableXML = ((GOTLocator)ObjectContainer.getInstance(GOTLocator.class)).getEntityFile(EntityType.Enum, entityName);
            VTDNav nav = VTDUtil.parse((File)tableXML);
            label = VTDUtil.getPropertyValue((VTDNav)nav, (String)"Label");
        }
        return label;
    }

    private class FieldTable
    extends Composite
    implements SelectionListener {
        private Table table;
        private boolean active;
        private static final String DATA_KEY_ADD = "add";
        private static final String DATA_KEY_REMOVE = "remove";
        private static final String DATA_KEY_UP = "up";
        private static final String DATA_KEY_DOWN = "down";

        public FieldTable(Composite parent) {
            super(parent, 0);
            this.setLayout((Layout)new FormLayout());
            this.createTable();
            this.createToolBar();
        }

        private void createTable() {
            this.table = new Table(this, new String[]{"\u5b57\u6bb5Id", "\u5b57\u6bb5\u540d\u79f0", "\u5b57\u6bb5\u7c7b\u578b", "\u6709\u6548\u6027"}){

                @Override
                protected Control cellBindEditor(final TableItem tableItem, final int columnIndex, String columnLabel) {
                    if ("\u6709\u6548\u6027".equals(columnLabel)) {
                        final Combo active = new Combo((Composite)FieldTable.this.table, 8);
                        active.setItems(new String[]{"true", "false"});
                        active.setText(tableItem.getText(columnIndex));
                        active.addModifyListener(new ModifyListener(){

                            public void modifyText(ModifyEvent e) {
                                tableItem.setText(columnIndex, active.getText());
                            }
                        });
                        return active;
                    }
                    return super.cellBindEditor(tableItem, columnIndex, columnLabel);
                }

                @Override
                protected void configureColumn(TableColumn[] columns) {
                    columns[0].setWidth(100);
                    columns[1].setWidth(100);
                    columns[2].setWidth(100);
                    columns[3].setWidth(50);
                }
            };
            this.table.setEnabled(this.active);
            FormData formData = new FormData();
            formData.top = new FormAttachment(0);
            formData.left = new FormAttachment(0);
            formData.bottom = new FormAttachment(100);
            this.table.setLayoutData(formData);
        }

        private void createToolBar() {
            ToolBar toolBar = new ToolBar((Composite)this, 512);
            FormData formData = new FormData();
            formData.left = new FormAttachment((Control)this.table, 10);
            formData.top = new FormAttachment((Control)this.table, 0, 128);
            toolBar.setLayoutData((Object)formData);
            ToolItem add = new ToolItem(toolBar, 8);
            add.setImage(new Image((Device)ImportTableView.this.shell.getDisplay(), ImportTableView.class.getClassLoader().getResourceAsStream("info/gongqi/icon/add.png")));
            add.setData((Object)DATA_KEY_ADD);
            add.addSelectionListener((SelectionListener)this);
            ToolItem remove = new ToolItem(toolBar, 8);
            remove.setImage(new Image((Device)ImportTableView.this.shell.getDisplay(), ImportTableView.class.getClassLoader().getResourceAsStream("info/gongqi/icon/remove.png")));
            remove.setData((Object)DATA_KEY_REMOVE);
            remove.addSelectionListener((SelectionListener)this);
            ToolItem up = new ToolItem(toolBar, 8);
            up.setImage(new Image((Device)ImportTableView.this.shell.getDisplay(), ImportTableView.class.getClassLoader().getResourceAsStream("info/gongqi/icon/up.png")));
            up.setData((Object)DATA_KEY_UP);
            up.addSelectionListener((SelectionListener)this);
            ToolItem down = new ToolItem(toolBar, 8);
            down.setImage(new Image((Device)ImportTableView.this.shell.getDisplay(), ImportTableView.class.getClassLoader().getResourceAsStream("info/gongqi/icon/down.png")));
            down.setData((Object)DATA_KEY_DOWN);
            down.addSelectionListener((SelectionListener)this);
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.active) {
                if (DATA_KEY_ADD.equals(e.widget.getData())) {
                    this.addPressed();
                } else if (DATA_KEY_REMOVE.equals(e.widget.getData())) {
                    this.removePressed();
                } else if (DATA_KEY_UP.equals(e.widget.getData())) {
                    this.upPressed();
                } else if (DATA_KEY_DOWN.equals(e.widget.getData())) {
                    this.downPressed();
                }
            }
        }

        private void addPressed() {
            this.table.addRecord(new String[]{"", "", DATATYPE[0], Boolean.TRUE.toString()});
        }

        private void removePressed() {
            this.table.remove(this.table.getSelectionIndices());
        }

        private void upPressed() {
            TableItem[] selection = this.table.getSelection();
            if (selection != null && selection.length > 0) {
                TableItem[] tableItemArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    int index = this.table.indexOf(tableItem);
                    if (index > 0) {
                        TableItem firstItem = this.table.getItem(index - 1);
                        int i = 0;
                        while (i < this.table.getColumnCount()) {
                            String text = firstItem.getText(i);
                            firstItem.setText(i, tableItem.getText(i));
                            tableItem.setText(i, text);
                            ++i;
                        }
                    }
                    ++n2;
                }
                this.table.deselect(this.table.indexOf(selection[0]) + selection.length - 1);
                this.table.select(this.table.indexOf(selection[0]) - 1);
            }
        }

        private void downPressed() {
            TableItem[] selection = this.table.getSelection();
            if (selection != null && selection.length > 0) {
                TableItem[] tableItemArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    int index = this.table.indexOf(tableItem);
                    if (index < this.table.getItemCount() - 1) {
                        TableItem nextItem = this.table.getItem(index + 1);
                        int i = 0;
                        while (i < this.table.getColumnCount()) {
                            String text = nextItem.getText(i);
                            nextItem.setText(i, tableItem.getText(i));
                            tableItem.setText(i, text);
                            ++i;
                        }
                    }
                    ++n2;
                }
                this.table.deselect(this.table.indexOf(selection[0]));
                this.table.select(this.table.indexOf(selection[selection.length - 1]) + 1);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        protected void checkSubclass() {
        }

        public void setActive(boolean active) {
            this.active = active;
            this.table.setEnabled(active);
        }
    }

    private class VarTable
    extends Composite
    implements SelectionListener {
        private static final String DATA_KEY_ADD = "add";
        private static final String DATA_KEY_REMOVE = "remove";
        private Table table;
        private boolean active;

        public VarTable(Composite parent) {
            super(parent, 0);
            this.active = false;
            this.setLayout((Layout)new FormLayout());
            this.createTable();
            this.createToolBar();
        }

        private void createTable() {
            this.table = new Table(this, new String[]{"\u5e8f\u53f7", "\u53d8\u91cfId", "\u53d8\u91cf\u540d\u79f0", "\u6570\u636e\u7c7b\u578b"}){

                @Override
                protected Control cellBindEditor(final TableItem tableItem, final int columnIndex, String columnLabel) {
                    if ("\u6570\u636e\u7c7b\u578b".equals(columnLabel)) {
                        final Combo type = new Combo((Composite)VarTable.this.table, 8);
                        type.setItems(ImportTableView.this.getGongqiDataType());
                        type.setText(tableItem.getText(columnIndex));
                        type.addModifyListener(new ModifyListener(){

                            public void modifyText(ModifyEvent e) {
                                tableItem.setText(columnIndex, type.getText());
                            }
                        });
                        return type;
                    }
                    return super.cellBindEditor(tableItem, columnIndex, columnLabel);
                }

                @Override
                protected void configureColumn(TableColumn[] columns) {
                    columns[0].setWidth(40);
                    columns[1].setWidth(80);
                    columns[2].setWidth(80);
                    columns[3].setWidth(60);
                }
            };
            this.table.setEnabled(this.active);
            FormData formData = new FormData();
            formData.top = new FormAttachment(0);
            formData.left = new FormAttachment(0);
            formData.bottom = new FormAttachment(100);
            this.table.setLayoutData(formData);
        }

        private void createToolBar() {
            ToolBar toolBar = new ToolBar((Composite)this, 512);
            FormData formData = new FormData();
            formData.left = new FormAttachment((Control)this.table, 10);
            formData.top = new FormAttachment((Control)this.table, 0, 128);
            toolBar.setLayoutData((Object)formData);
            ToolItem add = new ToolItem(toolBar, 8);
            add.setImage(new Image((Device)ImportTableView.this.shell.getDisplay(), ImportTableView.class.getClassLoader().getResourceAsStream("info/gongqi/icon/add.png")));
            add.setData((Object)DATA_KEY_ADD);
            add.addSelectionListener((SelectionListener)this);
            ToolItem remove = new ToolItem(toolBar, 8);
            remove.setImage(new Image((Device)ImportTableView.this.shell.getDisplay(), ImportTableView.class.getClassLoader().getResourceAsStream("info/gongqi/icon/remove.png")));
            remove.setData((Object)DATA_KEY_REMOVE);
            remove.addSelectionListener((SelectionListener)this);
        }

        protected void checkSubclass() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.active) {
                if (DATA_KEY_ADD.equals(e.widget.getData())) {
                    this.addPressed();
                } else if (DATA_KEY_REMOVE.equals(e.widget.getData())) {
                    this.removePressed();
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        private void addPressed() {
            this.table.addRecord(new String[]{String.valueOf(this.table.getItemCount()), "", "", DATATYPE[0]});
        }

        private void removePressed() {
            this.table.remove(this.table.getSelectionIndices());
        }

        public void setActive(boolean active) {
            this.active = active;
            this.table.setEnabled(active);
        }

        public List<Object[]> getVars() {
            return this.table.getRecords();
        }
    }
}

