/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.action;

import gongqi.erp.framework.core.GongqiEnvironment;
import gongqi.erp.framework.core.ObjectContainer;
import info.gongqi.util.JavaElementHelp;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class ImportProject
implements IWorkbenchWindowActionDelegate {
    private static Logger log = Logger.getLogger(ImportProject.class);

    public void run(IAction action) {
        File projectDir = new File(((GongqiEnvironment)ObjectContainer.getInstance(GongqiEnvironment.class)).getGongqiDir(), "Project");
        File projectPath = new File(projectDir, "Client");
        if (projectPath.exists()) {
            this.importProject(projectPath, "Client");
        }
        if ((projectPath = new File(projectDir, "Server\\GongqiERP")).exists()) {
            this.importProject(projectPath, "GongqiERP");
        }
        if ((projectPath = new File(projectDir, "Server\\LayerProject")).exists()) {
            this.importProject(projectPath, "LayerProject");
        }
        if ((projectPath = new File(projectDir, "Server\\lib")).exists()) {
            this.importProject(projectPath, "lib");
        }
        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"\u63d0\u793a", (String)"\u5bfc\u5165\u6210\u529f");
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    private void importProject(File projectPath, String projectName) {
        try {
            File projectDescription;
            if (JavaElementHelp.existProject(projectName)) {
                return;
            }
            if (!projectPath.exists()) {
                projectPath.mkdirs();
            }
            if (!(projectDescription = new File(projectPath, ".project")).exists()) {
                Document document = DocumentHelper.createDocument();
                Element projectDescriptionElement = document.addElement("projectDescription");
                projectDescriptionElement.addElement("name").setText(projectName);
                projectDescriptionElement.addElement("comment");
                projectDescriptionElement.addElement("projects");
                projectDescriptionElement.addElement("buildSpec");
                projectDescriptionElement.addElement("natures");
                FileUtils.write((File)projectDescription, (CharSequence)document.asXML(), (String)"UTF-8");
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject project = workspace.getRoot().getProject(projectName);
            IProjectDescription description = workspace.newProjectDescription(projectName);
            description.setLocation(Path.fromOSString((String)projectPath.getAbsolutePath()));
            project.create(description, null);
            project.open(128, null);
        }
        catch (Exception e) {
            log.error((Object)("\u5bfc\u5165\u5931\u8d25:" + projectPath.getAbsolutePath()), (Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"\u9519\u8bef\u63d0\u793a", (String)("\u5bfc\u5165\u5931\u8d25\uff1a" + projectPath.getName()));
        }
    }
}

