/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi;

import gongqi.erp.framework.util.ExecutorServiceUtils;
import gongqi.gdt.actions.HqlCheckAction;
import gongqi.gdt.hql.HQLStatement;
import gongqi.gdt.hql.statement.unit.BaseUnitdStatement;
import info.gongqi.hql.util.ASTHelper;
import info.gongqi.layer.CodeVerify;
import info.gongqi.util.Gongqi;
import info.gongqi.util.PreferenceStoreUtil;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;

public class CompilationUnitEditor
extends org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor {
    @Override
    public void doSave(IProgressMonitor progressMonitor) {
        try {
            HqlCheckAction.compilationUnitSyntaxCheck(JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.getEditorInput()));
        }
        catch (Exception e) {
            JavaPlugin.logErrorMessage("\u4fdd\u5b58\u524d\u68c0\u67e5\u5931\u8d25\uff1a" + e.getMessage());
        }
        super.doSave(progressMonitor);
    }

    @Override
    public void reconciled(CompilationUnit ast, boolean forced, IProgressMonitor progressMonitor) {
        super.reconciled(ast, forced, progressMonitor);
        if (PreferenceStoreUtil.isDynamicCheck()) {
            ExecutorServiceUtils.submit((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        HqlCheckAction.compilationUnitSyntaxCheck(CompilationUnitEditor.this.getCompilationUnit());
                    }
                    catch (Throwable throwable) {}
                }
            });
        }
        if (ast != null) {
            CodeVerify.verify(ast);
        }
    }

    public ICompilationUnit getCompilationUnit() {
        return (ICompilationUnit)EditorUtility.getEditorInputJavaElement((IEditorPart)this, false);
    }

    private void hqlHighlightingSynchronizer() {
        ICompilationUnit unit = null;
        List<ASTNode> nodes = null;
        try {
            unit = this.getCompilationUnit();
            nodes = ASTHelper.findCheckHqlNode(unit);
            if (nodes.isEmpty()) {
                return;
            }
            for (ASTNode _node : nodes) {
                ASTNode node = ASTHelper.findHqlNode(_node);
                if (node == null || "".equals(ASTHelper.getHql(node).trim())) continue;
                try {
                    HQLStatement hqlObject = new HQLStatement(unit, node);
                    List<BaseUnitdStatement> list = hqlObject.getBaseUnitdStatements();
                    for (BaseUnitdStatement baseUnitdStatement : list) {
                        StyleRange styleRange;
                        if (baseUnitdStatement.getTableName() != null && baseUnitdStatement.getTableName().isTableName()) {
                            styleRange = new StyleRange();
                            styleRange.start = hqlObject.getRoot().getDocIndex() + baseUnitdStatement.getTableName().getStart() + 1;
                            styleRange.length = baseUnitdStatement.getTableName().length();
                            styleRange.foreground = PreferenceStoreUtil.getTableNameColor();
                            styleRange.fontStyle = 3;
                            this.setStyleRange(styleRange);
                        }
                        if (baseUnitdStatement.getTableAlias() != null && baseUnitdStatement.getTableAlias().isTableAlias()) {
                            styleRange = new StyleRange();
                            styleRange.start = hqlObject.getRoot().getDocIndex() + baseUnitdStatement.getTableAlias().getStart() + 1;
                            styleRange.length = baseUnitdStatement.getTableAlias().length();
                            styleRange.foreground = PreferenceStoreUtil.getTableAliasColor();
                            styleRange.fontStyle = 3;
                            this.setStyleRange(styleRange);
                        }
                        if (baseUnitdStatement.getFieldName() == null || !baseUnitdStatement.getFieldName().isTableField()) continue;
                        styleRange = new StyleRange();
                        styleRange.start = hqlObject.getRoot().getDocIndex() + baseUnitdStatement.getFieldName().getStart() + 1;
                        styleRange.length = baseUnitdStatement.getFieldName().length();
                        styleRange.foreground = PreferenceStoreUtil.getTableFieldColor();
                        styleRange.fontStyle = 3;
                        this.setStyleRange(styleRange);
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
        }
        catch (Exception e) {
            JavaPlugin.log(e);
        }
    }

    @Override
    protected void handleTextChanged() {
        try {
            if (PreferenceStoreUtil.isHQLHighlighting()) {
                this.hqlHighlightingSynchronizer();
            }
        }
        catch (Exception exception) {}
    }

    public StyledText getActiveEditorStyledText() {
        try {
            Object obj = this.getAdapter(Control.class);
            if (obj instanceof StyledText) {
                return (StyledText)obj;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private void setStyleRange(StyleRange styleRange) {
        IRegion region;
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = this.getCompilationUnit().getResource().findMarkers(Gongqi.HQL_MARKER_ID, false, 2);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                int start = (Integer)marker.getAttribute("charStart");
                int end = (Integer)marker.getAttribute("charEnd");
                if (styleRange.start >= start && styleRange.start + styleRange.length <= end) {
                    return;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            return;
        }
        JavaSourceViewer jsv = this.getJavaSourceViewer();
        if (jsv != null && (region = jsv.modelRange2WidgetRange((IRegion)new Region(styleRange.start, styleRange.length))) != null) {
            styleRange = (StyleRange)styleRange.clone();
            styleRange.start = region.getOffset();
            styleRange.length = region.getLength();
            jsv.getTextWidget().setStyleRange(styleRange);
        }
    }

    public JavaSourceViewer getJavaSourceViewer() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof JavaSourceViewer) {
            return (JavaSourceViewer)sourceViewer;
        }
        return null;
    }
}

