/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.layer.upgrade;

import com.ximpleware.NavException;
import com.ximpleware.VTDException;
import gongqi.erp.framework.core.LayerDefination;
import gongqi.erp.framework.core.LayerDeploymentMode;
import gongqi.erp.framework.core.LayerLocator;
import gongqi.erp.framework.core.LayerResolver;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.extension.SolutionExtensionDefinition;
import gongqi.erp.framework.core.extension.SolutionExtensionDefinitionManager;
import gongqi.erp.framework.core.extension.SolutionExtensionDeploymentMode;
import gongqi.erp.framework.core.extension.SolutionExtensionLocator;
import gongqi.erp.framework.core.solution.SolutionDefinition;
import gongqi.erp.framework.core.solution.SolutionDefinitionManager;
import gongqi.erp.framework.core.solution.SolutionDeploymentMode;
import gongqi.erp.framework.core.solution.SolutionLocator;
import gongqi.erp.framework.exception.ERPException;
import gongqi.erp.framework.tools.ZipUtil;
import gongqi.erp.framework.tools.io.FileIOXML;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.layer.upgrade.ProgressMonitor;
import gongqi.gdt.layer.upgrade.analysis.ClassAnalysis;
import gongqi.gdt.layer.upgrade.analysis.DataTypeAnalysis;
import gongqi.gdt.layer.upgrade.analysis.EnumAnalysis;
import gongqi.gdt.layer.upgrade.analysis.FormAnalysis;
import gongqi.gdt.layer.upgrade.analysis.MenuAnalysis;
import gongqi.gdt.layer.upgrade.analysis.MenuItemAnalysis;
import gongqi.gdt.layer.upgrade.analysis.TableAnalysis;
import gongqi.gdt.layer.upgrade.modify.ClassModify;
import gongqi.gdt.layer.upgrade.modify.DataTypeModify;
import gongqi.gdt.layer.upgrade.modify.EnumModify;
import gongqi.gdt.layer.upgrade.modify.FormModify;
import gongqi.gdt.layer.upgrade.modify.MenuItemModify;
import gongqi.gdt.layer.upgrade.modify.MenuModify;
import gongqi.gdt.layer.upgrade.modify.ModifyLevel;
import gongqi.gdt.layer.upgrade.modify.TableModify;
import gongqi.gdt.layer.upgrade.node.GOTEntity;
import gongqi.gdt.layer.upgrade.node.GOTModel;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class LayerUpgradeService {
    private static Logger log = Logger.getLogger(LayerUpgradeService.class);
    private GOTModel sourceGOT;
    private GOTModel targetGOT;
    private GOTModel originalGOT;
    private Path upgradePackage;

    public void initGOTModel(File updatePackageFile) {
        try {
            this.upgradePackage = updatePackageFile.toPath();
            log.debug((Object)"\u52a0\u8f7d\u5f53\u524d\u5c42\u6a21\u578b");
            this.initSourceGOTModel();
            this.sourceGOT.catchRefInnerId();
            log.debug((Object)"\u52a0\u8f7d\u5347\u7ea7\u5c42\u6a21\u578b");
            this.initTargetGOTModel();
            log.debug((Object)"\u52a0\u8f7d\u8fc7\u6e21\u5c42\u6a21\u578b");
            this.initOriginalTargetGOTModel();
        }
        catch (VTDException | IOException e) {
            throw new RuntimeException("\u89e3\u6790\u5c42\u6a21\u578b\u9519\u8bef", e);
        }
    }

    public void analysis(ProgressMonitor monitor) throws VTDException, IOException {
        int totalWork = 100;
        monitor.beginTask(totalWork);
        Throwable throwable = null;
        try {
            new EnumAnalysis(this.sourceGOT, this.targetGOT, this.originalGOT).analysis(monitor);
            new DataTypeAnalysis(this.sourceGOT, this.targetGOT, this.originalGOT).analysis(monitor);
            new TableAnalysis(this.sourceGOT, this.targetGOT, this.originalGOT).analysis(monitor);
            new FormAnalysis(this.sourceGOT, this.targetGOT, this.originalGOT).analysis(monitor);
            new MenuItemAnalysis(this.sourceGOT, this.targetGOT, this.originalGOT).analysis(monitor);
            new MenuAnalysis(this.sourceGOT, this.targetGOT, this.originalGOT).analysis(monitor);
            new ClassAnalysis(this.sourceGOT, this.targetGOT, this.originalGOT).analysis(monitor);
        }
        catch (Throwable e) {
            throwable = e;
        }
        monitor.done(throwable);
        this.sourceGOT.clearCatchRefInnerId();
    }

    public void applyModifys(Element modifyElements, ProgressMonitor monitor) throws Exception {
        if (this.sourceGOT.getTopLayerDefination().getDeploymentMode() != LayerDeploymentMode.Source) {
            throw new ERPException("\u5f53\u524d\u5c42\u6e90\u7801\u5c42\uff0c\u65e0\u6cd5\u5347\u7ea7");
        }
        List cannotModifyItems = modifyElements.selectNodes(String.format("//ModifyItem[@modifyLevel='%s']", ModifyLevel.Cannot.name()));
        if (cannotModifyItems.size() > 0) {
            throw new ERPException("\u5b58\u5728\u4e0d\u80fd\u5347\u7ea7\u7684\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7");
        }
        monitor.beginTask(0);
        Throwable throwable = null;
        try {
            Element enumModifys = (Element)modifyElements.selectSingleNode("./DataDictionary/Enums");
            new EnumModify(this.sourceGOT, this.targetGOT, this.originalGOT).modify(enumModifys, monitor);
            Element dataTypeModifys = (Element)modifyElements.selectSingleNode("./DataDictionary/DataTypes");
            new DataTypeModify(this.sourceGOT, this.targetGOT, this.originalGOT).modify(dataTypeModifys, monitor);
            Element tableModifys = (Element)modifyElements.selectSingleNode("./DataDictionary/Tables");
            new TableModify(this.sourceGOT, this.targetGOT, this.originalGOT).modify(tableModifys, monitor);
            Element formModifys = (Element)modifyElements.selectSingleNode("./Forms");
            new FormModify(this.sourceGOT, this.targetGOT, this.originalGOT).modify(formModifys, monitor);
            Element menuItemModifys = (Element)modifyElements.selectSingleNode("./MenuItems");
            new MenuItemModify(this.sourceGOT, this.targetGOT, this.originalGOT).modify(menuItemModifys, monitor);
            Element menuModifys = (Element)modifyElements.selectSingleNode("./Menus");
            new MenuModify(this.sourceGOT, this.targetGOT, this.originalGOT).modify(menuModifys, monitor);
            Element classModifys = (Element)modifyElements.selectSingleNode("./Classes");
            new ClassModify(this.sourceGOT, this.targetGOT, this.originalGOT).modify(classModifys, monitor);
        }
        catch (Throwable e) {
            throwable = e;
        }
        this.saveGOT();
        monitor.done(throwable);
    }

    private void saveGOT() throws VTDException, IOException, DocumentException {
        this.writeEntityFile(this.sourceGOT.getEntitys(EntityType.Enum));
        this.writeEntityFile(this.sourceGOT.getEntitys(EntityType.DataType));
        this.writeEntityFile(this.sourceGOT.getEntitys(EntityType.Table));
        this.writeEntityFile(this.sourceGOT.getEntitys(EntityType.Form));
        this.writeEntityFile(this.sourceGOT.getEntitys(EntityType.MenuItem));
        this.writeEntityFile(this.sourceGOT.getEntitys(EntityType.Menu));
        for (GOTEntity entity : this.sourceGOT.getRemoveEntitys()) {
            File layerJavaPath;
            File layerGOTPath;
            String solutionName;
            LayerDefination layerDefination = this.sourceGOT.getLayerDefination(entity.getModifiedLayer());
            if (layerDefination.getLayerName().equals("app")) {
                solutionName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
                SolutionDefinition solutionDefinition = ((SolutionDefinitionManager)ObjectContainer.getInstance(SolutionDefinitionManager.class)).getSolution(solutionName);
                if (solutionDefinition.getDeploymentMode() != SolutionDeploymentMode.Source) continue;
                layerGOTPath = new File(solutionDefinition.getSolutionModelDir(), "got");
                layerJavaPath = ((SolutionLocator)ObjectContainer.getInstance(SolutionLocator.class)).getSolutionSourceDir(solutionName);
            } else if (layerDefination.getLayerName().equals("ext")) {
                solutionName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
                SolutionExtensionDefinition solutionExtensionDefinition = ((SolutionExtensionDefinitionManager)ObjectContainer.getInstance(SolutionExtensionDefinitionManager.class)).getSolutionExtension(solutionName);
                if (solutionExtensionDefinition.getDeploymentMode() != SolutionExtensionDeploymentMode.Source) continue;
                layerGOTPath = new File(solutionExtensionDefinition.getExtensionModelDir(), "got");
                layerJavaPath = ((SolutionExtensionLocator)ObjectContainer.getInstance(SolutionExtensionLocator.class)).getSolutionExtensionSourceDir(solutionName);
            } else {
                if (layerDefination.getDeploymentMode() != LayerDeploymentMode.Source) continue;
                layerGOTPath = new File(layerDefination.getLayerModelDir(), "got");
                layerJavaPath = ((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayerSourceDir(layerDefination.getLayerName());
            }
            switch (entity.getEntityType()) {
                case Enum: {
                    FileUtils.deleteQuietly((File)new File(layerJavaPath, "enums/" + entity.getName() + ".java"));
                    FileUtils.deleteQuietly((File)new File(layerGOTPath, "datadictionary/enums/" + entity.getName() + ".xml"));
                    break;
                }
                case DataType: {
                    FileUtils.deleteQuietly((File)new File(layerJavaPath, "datatypes/DataType_" + entity.getName() + ".java"));
                    FileUtils.deleteQuietly((File)new File(layerGOTPath, "datadictionary/datatypes/" + entity.getName() + ".xml"));
                    break;
                }
                case Table: {
                    FileUtils.deleteQuietly((File)new File(layerJavaPath, "tables/base/Base" + entity.getName() + ".java"));
                    FileUtils.deleteQuietly((File)new File(layerJavaPath, "tables/" + entity.getName() + ".java"));
                    FileUtils.deleteQuietly((File)new File(layerGOTPath, "datadictionary/tables/" + entity.getName() + ".xml"));
                    break;
                }
                case Form: {
                    FileUtils.deleteQuietly((File)new File(layerJavaPath, "forms/" + entity.getName()));
                    FileUtils.deleteQuietly((File)new File(layerGOTPath, "forms/" + entity.getName() + ".xml"));
                    break;
                }
                case MenuItem: {
                    FileUtils.deleteQuietly((File)new File(layerJavaPath, "menuitems/MenuItem_" + entity.getName()));
                    FileUtils.deleteQuietly((File)new File(layerGOTPath, "menuitems/" + entity.getName() + ".xml"));
                    break;
                }
                case Menu: {
                    FileUtils.deleteQuietly((File)new File(layerGOTPath, "menus/" + entity.getName() + ".xml"));
                    break;
                }
                default: {
                    throw new ERPException("\u5b9e\u4f53\u8282\u70b9\u79fb\u9664\u672a\u5904\u7406");
                }
            }
        }
    }

    private void writeEntityFile(Collection<GOTEntity> entitys) throws NavException, IOException, DocumentException {
        for (GOTEntity entity : entitys) {
            Path entityPath;
            Path gotPath;
            String solutionName;
            LayerDefination layerDefination = this.sourceGOT.getLayerDefination(entity.getModifiedLayer());
            if (layerDefination.getLayerName().equals("app")) {
                solutionName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
                SolutionDefinition solutionDefinition = ((SolutionDefinitionManager)ObjectContainer.getInstance(SolutionDefinitionManager.class)).getSolution(solutionName);
                if (solutionDefinition.getDeploymentMode() != SolutionDeploymentMode.Source) continue;
                gotPath = Paths.get(solutionDefinition.getSolutionModelDir(), "got");
            } else if (layerDefination.getLayerName().equals("ext")) {
                solutionName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
                SolutionExtensionDefinition solutionExtensionDefinition = ((SolutionExtensionDefinitionManager)ObjectContainer.getInstance(SolutionExtensionDefinitionManager.class)).getSolutionExtension(solutionName);
                if (solutionExtensionDefinition.getDeploymentMode() != SolutionExtensionDeploymentMode.Source) continue;
                gotPath = Paths.get(solutionExtensionDefinition.getExtensionModelDir(), "got");
            } else {
                if (layerDefination.getDeploymentMode() != LayerDeploymentMode.Source) continue;
                gotPath = Paths.get(layerDefination.getLayerModelDir(), "got");
            }
            if (entity.getEntityType() == EntityType.Enum) {
                entityPath = gotPath.resolve("datadictionary/enums/" + entity.getName() + ".xml");
            } else if (entity.getEntityType() == EntityType.DataType) {
                entityPath = gotPath.resolve("datadictionary/datatypes/" + entity.getName() + ".xml");
            } else if (entity.getEntityType() == EntityType.Table) {
                entityPath = gotPath.resolve("datadictionary/tables/" + entity.getName() + ".xml");
            } else if (entity.getEntityType() == EntityType.Menu) {
                entityPath = gotPath.resolve("menus/" + entity.getName() + ".xml");
            } else if (entity.getEntityType() == EntityType.MenuItem) {
                entityPath = gotPath.resolve("menuitems/" + entity.getName() + ".xml");
            } else if (entity.getEntityType() == EntityType.Form) {
                entityPath = gotPath.resolve("forms/" + entity.getName() + ".xml");
            } else if (entity.getEntityType() == EntityType.Class) {
                entityPath = gotPath.resolve("classes/" + entity.getName() + ".xml");
            } else {
                throw new ERPException(String.format("\u6682\u4e0d\u652f\u6301\u4fdd\u5b58\u3010%s\u3011\u7c7b\u578b\u8282\u70b9", entity.getEntityType().name()));
            }
            FileIOXML.saveDocument((String)entityPath.toString(), (Document)DocumentHelper.parseText((String)entity.asXML()));
            if (!entity.isRename() || !Files.exists(entityPath = entityPath.getParent().resolve(String.valueOf(entity.getOrigName()) + ".xml"), new LinkOption[0])) continue;
            Files.delete(entityPath);
        }
    }

    private void initSourceGOTModel() throws IOException {
        File layersPath = ((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayersRoot();
        List layerDefinations = ((LayerResolver)ObjectContainer.getInstance(LayerResolver.class)).resolveLayers(layersPath.getAbsolutePath());
        this.sourceGOT = new GOTModel(layerDefinations);
        this.sourceGOT.initModelEntitys();
    }

    private void initTargetGOTModel() throws IOException {
        File targetLayersRootDir = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString());
        targetLayersRootDir.mkdirs();
        if (this.upgradePackage.getFileName().toString().endsWith(".lyr")) {
            this.extractLayer(this.upgradePackage.toFile(), targetLayersRootDir);
        } else if (this.upgradePackage.getFileName().toString().endsWith(".lyrs")) {
            File[] lyrFiles;
            ZipUtil.unZipFiles((String)this.upgradePackage.toString(), (String)targetLayersRootDir.getAbsolutePath());
            File[] fileArray = lyrFiles = targetLayersRootDir.listFiles();
            int n = lyrFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File lyrFile = fileArray[n2];
                if (!lyrFile.isFile() || !lyrFile.getName().endsWith(".lyr")) {
                    throw new RuntimeException("\u5347\u7ea7\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0c\u5305\u542b\u65e0\u6548\u7684\u5c42\u6253\u5305\u6587\u4ef6");
                }
                this.extractLayer(lyrFile, targetLayersRootDir);
                lyrFile.delete();
                ++n2;
            }
        } else if (this.upgradePackage.getFileName().toString().endsWith(".app")) {
            File layersPath = ((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayersRoot();
            FileUtils.copyDirectory((File)new File(layersPath, "sys"), (File)new File(targetLayersRootDir, "sys"));
            FileUtils.copyDirectory((File)new File(layersPath, "obj"), (File)new File(targetLayersRootDir, "obj"));
            FileUtils.copyDirectory((File)new File(layersPath, "iny"), (File)new File(targetLayersRootDir, "iny"));
            FileUtils.copyDirectory((File)new File(layersPath, "ent"), (File)new File(targetLayersRootDir, "ent"));
            FileUtils.copyDirectory((File)new File(layersPath, "art"), (File)new File(targetLayersRootDir, "art"));
            FileUtils.copyFileToDirectory((File)this.upgradePackage.toFile(), (File)new File(targetLayersRootDir, "app"));
        } else {
            throw new ERPException("\u65e0\u6548\u7684\u5c42\u5347\u7ea7\u6587\u4ef6:" + this.upgradePackage.toFile().getAbsolutePath());
        }
        List layerDefinations = ((LayerResolver)ObjectContainer.getInstance(LayerResolver.class)).resolveLayers(targetLayersRootDir.getAbsolutePath());
        if (layerDefinations.isEmpty()) {
            throw new RuntimeException("\u5c42\u5347\u7ea7\u6587\u4ef6\u4e2d\u672a\u53d1\u73b0\u6709\u6548\u5c42\u4fe1\u606f\u3002");
        }
        if (this.sourceGOT.getLayerLevel(((LayerDefination)layerDefinations.get(0)).getLayerName()) != layerDefinations.size()) {
            throw new RuntimeException(String.format("\u5c42\u5347\u7ea7\u6587\u4ef6\u4e2d%s\u5c42\u4e0e\u5f53\u524d\u73af\u5883\u5c42\u94fe\u7684\u5c42\u7ea7\u4e0d\u4e00\u81f4\u3010%s  %s\u3011", ((LayerDefination)layerDefinations.get(0)).getLayerName(), this.sourceGOT.getLayerLevel(((LayerDefination)layerDefinations.get(0)).getLayerName()), layerDefinations.size()));
        }
        this.targetGOT = new GOTModel(layerDefinations);
        this.targetGOT.initModelEntitys();
    }

    private void extractLayer(File lyrFile, File descDir) {
        String layerName;
        File layerTempDir = new File(descDir, UUID.randomUUID().toString());
        try {
            ZipUtil.unZipFiles((String)lyrFile.getAbsolutePath(), (String)layerTempDir.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException("\u65e0\u6548\u7684\u5347\u7ea7\u6587\u4ef6\uff0c\u89e3\u6790\u9519\u8bef", e);
        }
        File gotPackageFile = new File(layerTempDir, "model").listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".got");
            }
        })[0];
        try {
            Throwable throwable = null;
            Object var7_10 = null;
            try (ZipFile gotZipFile = new ZipFile(gotPackageFile);){
                ZipEntry entry = gotZipFile.getEntry("Layer.xml");
                if (entry == null) {
                    throw new RuntimeException("\u65e0\u6548\u7684\u5347\u7ea7\u6587\u4ef6\uff0cgot\u538b\u7f29\u5305\u7f3a\u5c11\u5c42\u5b9a\u4e49\u6587\u4ef6");
                }
                SAXReader reader = new SAXReader();
                Document document = reader.read(gotZipFile.getInputStream(entry));
                layerName = document.getRootElement().elementText("name");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | DocumentException e) {
            throw new RuntimeException("\u65e0\u6548\u7684\u5347\u7ea7\u6587\u4ef6\uff0cgot\u538b\u7f29\u5305\u89e3\u6790\u9519\u8bef", e);
        }
        File descLayerDir = new File(descDir, layerName);
        if (descLayerDir.exists()) {
            throw new RuntimeException(String.format("\u5347\u7ea7\u6587\u4ef6\u9519\u8bef\uff0c\u5b58\u5728\u91cd\u590d\u7684%s\u5c42", layerName));
        }
        if (!layerTempDir.renameTo(descLayerDir)) {
            throw new RuntimeException(String.format("%s\u5c42\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u6587\u4ef6\u5939\u91cd\u547d\u540d\u5931\u8d25", layerName));
        }
    }

    private void initOriginalTargetGOTModel() throws IOException {
        ArrayList<LayerDefination> layerDefinations = new ArrayList<LayerDefination>();
        String targetTopLayerName = this.targetGOT.getTopLayerDefination().getLayerName();
        if (this.sourceGOT.getLayerDefination(targetTopLayerName) == null) {
            throw new RuntimeException(String.format("\u5347\u7ea7\u6587\u4ef6\u6700\u9ad8\u5c42%s\u5728\u5f53\u524d\u73af\u5883\u5c42\u94fe\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5347\u7ea7", targetTopLayerName));
        }
        if (targetTopLayerName.equals(this.sourceGOT.getTopLayerDefination().getLayerName())) {
            throw new RuntimeException(String.format("\u5347\u7ea7\u6587\u4ef6\u6700\u9ad8\u5c42%s\u5728\u5f53\u524d\u73af\u5883\u5c42\u94fe\u4f4d\u4e8e\u6700\u9ad8\u5c42\uff0c\u65e0\u6cd5\u5347\u7ea7", targetTopLayerName));
        }
        List<LayerDefination> sourceLayerDefinations = this.sourceGOT.getLayerDefinations();
        int i = sourceLayerDefinations.size();
        while (i > 0) {
            LayerDefination layerDefination = sourceLayerDefinations.get(i - 1);
            layerDefinations.add(layerDefination);
            if (layerDefination.getLayerName().equals(targetTopLayerName)) break;
            --i;
        }
        this.originalGOT = new GOTModel(layerDefinations);
        this.originalGOT.initModelEntitys();
    }
}

