/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.hql.statement;

import gongqi.gdt.hql.HQLStatement;
import gongqi.gdt.hql.statement.BaseStatement;
import gongqi.gdt.hql.statement.unit.BaseUnit;
import gongqi.gdt.hql.statement.unit.UpdateUnitStatement;
import info.gongqi.hql.util.TableHelper;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;

public class UpdateStatement
extends BaseStatement {
    private List<UpdateUnitStatement> updateFieldList = new ArrayList<UpdateUnitStatement>();

    public UpdateStatement(CommonTree tree, int endIndex, HQLStatement hqlStatement) {
        super(tree, "UPDATE", endIndex, hqlStatement);
    }

    @Override
    public boolean checkCondition(int index) {
        if (index < this.getStart() + this.getFlag().length()) {
            return false;
        }
        UpdateUnitStatement field = this.getUpdateField(index);
        if (field != null) {
            return field.getStart() + field.getTableName().getContent().length() > index;
        }
        return true;
    }

    @Override
    public void parser() {
        List list = this.getTree().getChildren();
        int i = 0;
        while (i < list.size()) {
            if (((CommonTree)list.get(i)).getType() == 26) {
                this.updateFieldList.add(new UpdateUnitStatement((CommonTree)list.get(i), this.getHqlStatement()));
            }
            ++i;
        }
    }

    public String getTableName(String tableAlias) {
        if (tableAlias == null || "".equals(tableAlias)) {
            return null;
        }
        int i = 0;
        while (i < this.getUpdateFieldList().size()) {
            UpdateUnitStatement updateField = this.getUpdateFieldList().get(i);
            BaseUnit tableAliasUnit = updateField.getTableAlias();
            if (tableAlias != null && tableAliasUnit != null && tableAliasUnit.getContent().equals(tableAlias)) {
                return updateField.getTableName().getContent();
            }
            ++i;
        }
        return "";
    }

    public List<String> findTableAlias(String prefix) {
        ArrayList<String> tableAliasList = new ArrayList<String>();
        int i = 0;
        while (i < this.getUpdateFieldList().size()) {
            UpdateUnitStatement updateField = this.getUpdateFieldList().get(i);
            if (prefix == null || "".equals(prefix)) {
                tableAliasList.add(updateField.getTableAlias().getContent());
            } else if (updateField.getTableAlias().getContent().toLowerCase().startsWith(prefix.toLowerCase())) {
                tableAliasList.add(updateField.getTableAlias().getContent());
            }
            ++i;
        }
        return tableAliasList;
    }

    public List<String> getTableFields(String tableAlias) {
        List<String> fields = new ArrayList<String>();
        String tableName = this.getTableName(tableAlias);
        if (!"".equals(tableName)) {
            fields = TableHelper.getFields(tableName);
        }
        return fields;
    }

    public List<String> getUpdateAllFields() {
        ArrayList<String> fields = new ArrayList<String>();
        for (UpdateUnitStatement fieldObject : this.getUpdateFieldList()) {
            fields.addAll(TableHelper.getFields(fieldObject.getTableName().getContent()));
        }
        return fields;
    }

    public List<String> getTableAlias() {
        ArrayList<String> tablealias = new ArrayList<String>();
        for (UpdateUnitStatement fromfield : this.getUpdateFieldList()) {
            tablealias.add(fromfield.getTableAlias().getContent());
        }
        return tablealias;
    }

    public List<UpdateUnitStatement> getUpdateFieldList() {
        this.instialize();
        return this.updateFieldList;
    }

    public UpdateUnitStatement getUpdateField(int index) {
        int i = 0;
        while (i < this.getUpdateFieldList().size()) {
            UpdateUnitStatement updateField = this.getUpdateFieldList().get(i);
            if (updateField.getStart() <= index && updateField.getEnd() > index) {
                return updateField;
            }
            ++i;
        }
        return null;
    }
}

