/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.core;

import gongqi.erp.framework.core.LayerDefinationManager;
import gongqi.erp.framework.core.LayerLocator;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.extension.SolutionExtensionLocator;
import gongqi.erp.framework.core.solution.SolutionLocator;
import gongqi.erp.framework.util.FileUtils;
import gongqi.erp.gotmodel.core.GOTLocator;
import gongqi.gdt.core.IDEProjectManager;
import java.io.File;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.UserLibraryManager;

public class EclipseProjectManagerImpl
implements IDEProjectManager {
    @Override
    public void createLayer(String layerName) {
        Element linkElement;
        ((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).resolveLayers();
        File layersSourceRoot = ((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayersSourceRoot();
        String layerUserLibraryName = String.format("layer_%s", layerName);
        UserLibraryManager manager = JavaModelManager.getUserLibraryManager();
        manager.setUserLibrary(layerUserLibraryName, new IClasspathEntry[0], false);
        String linkName = String.format("layer_%s_classes", layerName);
        File _projectFile = new File(layersSourceRoot, ".project");
        Document document = FileUtils.readFileToDocument((File)_projectFile);
        Element linkedResources = document.getRootElement().element("linkedResources");
        if (linkedResources == null) {
            linkedResources = document.getRootElement().addElement("linkedResources");
        }
        if ((linkElement = (Element)linkedResources.selectSingleNode(String.format("./link/name[text()='%s']/..", linkName))) != null) {
            linkedResources.remove(linkElement);
        }
        linkElement = linkedResources.addElement("link");
        linkElement.addElement("name").setText(linkName);
        linkElement.addElement("type").setText("2");
        linkElement.addElement("locationURI").setText(String.format("GongqiDir/Project/Server/GongqiERP/WEB-INF/layers/%s/binary/classes", layerName));
        FileUtils.writeDocumentToFile((File)_projectFile, (Document)document);
        File _classpathFile = new File(layersSourceRoot, ".classpath");
        File layerSourceRootDir = ((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayerSourceRootDir(layerName);
        String srcRelativePath = layerSourceRootDir.getAbsolutePath().substring(_classpathFile.getParentFile().getAbsolutePath().length() + 1);
        document = FileUtils.readFileToDocument((File)_classpathFile);
        List srcClasspathentrys = document.getRootElement().selectNodes("./classpathentry[@kind='src']");
        ListIterator iterator = srcClasspathentrys.listIterator();
        while (iterator.hasNext()) {
            Element srcClasspathentry = (Element)iterator.next();
            if (!srcRelativePath.equals(srcClasspathentry.attributeValue("path"))) continue;
            iterator.remove();
        }
        Element classpathentry = DocumentHelper.createElement((String)"classpathentry");
        classpathentry.addAttribute("kind", "src");
        classpathentry.addAttribute("path", srcRelativePath);
        classpathentry.addAttribute("output", linkName);
        document.getRootElement().elements().add(0, classpathentry);
        String path = String.format("./classpathentry[@kind='con' and path='org.eclipse.jdt.USER_LIBRARY/%s']", layerUserLibraryName);
        Element layerUserLibraryRef = (Element)document.getRootElement().selectSingleNode(path);
        if (layerUserLibraryRef != null) {
            document.getRootElement().remove(layerUserLibraryRef);
        }
        layerUserLibraryRef = document.getRootElement().addElement("classpathentry");
        layerUserLibraryRef.addAttribute("kind", "con");
        layerUserLibraryRef.addAttribute("path", "org.eclipse.jdt.USER_LIBRARY/" + layerUserLibraryName);
        FileUtils.writeDocumentToFile((File)_classpathFile, (Document)document);
        ((GOTLocator)ObjectContainer.getInstance(GOTLocator.class)).aggregateModels();
        this.refreshLayerProject("LayerProject");
        this.refreshLayerProject("GongqiERP");
    }

    @Override
    public void createSolution(String solutionName) {
        Element linkElement;
        ((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).resolveLayers();
        File layersSourceRoot = ((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayersSourceRoot();
        String solutionUserLibraryName = String.format("app_%s", solutionName);
        UserLibraryManager manager = JavaModelManager.getUserLibraryManager();
        manager.setUserLibrary(solutionUserLibraryName, new IClasspathEntry[0], false);
        String linkName = String.format("app_%s_classes", solutionName);
        File _projectFile = new File(layersSourceRoot, ".project");
        Document document = FileUtils.readFileToDocument((File)_projectFile);
        Element linkedResources = document.getRootElement().element("linkedResources");
        if (linkedResources == null) {
            linkedResources = document.getRootElement().addElement("linkedResources");
        }
        if ((linkElement = (Element)linkedResources.selectSingleNode(String.format("./link/name[text()='%s']/..", linkName))) != null) {
            linkedResources.remove(linkElement);
        }
        linkElement = linkedResources.addElement("link");
        linkElement.addElement("name").setText(linkName);
        linkElement.addElement("type").setText("2");
        linkElement.addElement("locationURI").setText(String.format("GongqiDir/Project/Server/GongqiERP/WEB-INF/layers/%s/%s/binary/classes", "app", solutionName));
        FileUtils.writeDocumentToFile((File)_projectFile, (Document)document);
        File _classpathFile = new File(layersSourceRoot, ".classpath");
        File solutionSourceRootDir = ((SolutionLocator)ObjectContainer.getInstance(SolutionLocator.class)).getSolutionSourceRootDir(solutionName);
        String srcRelativePath = solutionSourceRootDir.getAbsolutePath().substring(_classpathFile.getParentFile().getAbsolutePath().length() + 1);
        document = FileUtils.readFileToDocument((File)_classpathFile);
        List srcClasspathentrys = document.getRootElement().selectNodes("./classpathentry[@kind='src']");
        ListIterator iterator = srcClasspathentrys.listIterator();
        while (iterator.hasNext()) {
            Element srcClasspathentry = (Element)iterator.next();
            if (!srcRelativePath.equals(srcClasspathentry.attributeValue("path"))) continue;
            iterator.remove();
        }
        Element classpathentry = DocumentHelper.createElement((String)"classpathentry");
        classpathentry.addAttribute("kind", "src");
        classpathentry.addAttribute("path", srcRelativePath);
        classpathentry.addAttribute("output", linkName);
        document.getRootElement().elements().add(0, classpathentry);
        String path = String.format("./classpathentry[@kind='con' and path='org.eclipse.jdt.USER_LIBRARY/%s']", solutionUserLibraryName);
        Element layerUserLibraryRef = (Element)document.getRootElement().selectSingleNode(path);
        if (layerUserLibraryRef != null) {
            document.getRootElement().remove(layerUserLibraryRef);
        }
        layerUserLibraryRef = document.getRootElement().addElement("classpathentry");
        layerUserLibraryRef.addAttribute("kind", "con");
        layerUserLibraryRef.addAttribute("path", "org.eclipse.jdt.USER_LIBRARY/" + solutionUserLibraryName);
        FileUtils.writeDocumentToFile((File)_classpathFile, (Document)document);
        ((GOTLocator)ObjectContainer.getInstance(GOTLocator.class)).aggregateModels();
        this.refreshLayerProject("LayerProject");
        this.refreshLayerProject("GongqiERP");
    }

    @Override
    public void createExtension(String solutionName) {
        Element linkElement;
        ((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).resolveLayers();
        File layersSourceRoot = ((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayersSourceRoot();
        String solutionUserLibraryName = String.format("ext_%s", solutionName);
        UserLibraryManager manager = JavaModelManager.getUserLibraryManager();
        manager.setUserLibrary(solutionUserLibraryName, new IClasspathEntry[0], false);
        String linkName = String.format("ext_%s_classes", solutionName);
        File _projectFile = new File(layersSourceRoot, ".project");
        Document document = FileUtils.readFileToDocument((File)_projectFile);
        Element linkedResources = document.getRootElement().element("linkedResources");
        if (linkedResources == null) {
            linkedResources = document.getRootElement().addElement("linkedResources");
        }
        if ((linkElement = (Element)linkedResources.selectSingleNode(String.format("./link/name[text()='%s']/..", linkName))) != null) {
            linkedResources.remove(linkElement);
        }
        linkElement = linkedResources.addElement("link");
        linkElement.addElement("name").setText(linkName);
        linkElement.addElement("type").setText("2");
        linkElement.addElement("locationURI").setText(String.format("GongqiDir/Project/Server/GongqiERP/WEB-INF/layers/%s/%s/binary/classes", "ext", solutionName));
        FileUtils.writeDocumentToFile((File)_projectFile, (Document)document);
        File _classpathFile = new File(layersSourceRoot, ".classpath");
        File solutionSourceRootDir = ((SolutionExtensionLocator)ObjectContainer.getInstance(SolutionExtensionLocator.class)).getSolutionExtensionSourceRootDir(solutionName);
        String srcRelativePath = solutionSourceRootDir.getAbsolutePath().substring(_classpathFile.getParentFile().getAbsolutePath().length() + 1);
        document = FileUtils.readFileToDocument((File)_classpathFile);
        List srcClasspathentrys = document.getRootElement().selectNodes("./classpathentry[@kind='src']");
        ListIterator iterator = srcClasspathentrys.listIterator();
        while (iterator.hasNext()) {
            Element srcClasspathentry = (Element)iterator.next();
            if (!srcRelativePath.equals(srcClasspathentry.attributeValue("path"))) continue;
            iterator.remove();
        }
        Element classpathentry = DocumentHelper.createElement((String)"classpathentry");
        classpathentry.addAttribute("kind", "src");
        classpathentry.addAttribute("path", srcRelativePath);
        classpathentry.addAttribute("output", linkName);
        document.getRootElement().elements().add(0, classpathentry);
        String path = String.format("./classpathentry[@kind='con' and path='org.eclipse.jdt.USER_LIBRARY/%s']", solutionUserLibraryName);
        Element layerUserLibraryRef = (Element)document.getRootElement().selectSingleNode(path);
        if (layerUserLibraryRef != null) {
            document.getRootElement().remove(layerUserLibraryRef);
        }
        layerUserLibraryRef = document.getRootElement().addElement("classpathentry");
        layerUserLibraryRef.addAttribute("kind", "con");
        layerUserLibraryRef.addAttribute("path", "org.eclipse.jdt.USER_LIBRARY/" + solutionUserLibraryName);
        FileUtils.writeDocumentToFile((File)_classpathFile, (Document)document);
        ((GOTLocator)ObjectContainer.getInstance(GOTLocator.class)).aggregateModels();
        this.refreshLayerProject("LayerProject");
        this.refreshLayerProject("GongqiERP");
    }

    private void refreshLayerProject(String projectName) {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject project = root.getProject(projectName);
            project.refreshLocal(2, null);
        }
        catch (Throwable throwable) {}
    }
}

