/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.actions.layer;

import com.ibm.icu.text.SimpleDateFormat;
import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.LayerDefination;
import gongqi.erp.framework.core.LayerDefinationManager;
import gongqi.erp.framework.core.LayerDeploymentMode;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.gdt.actions.WorkbenchWindowActionDelegateAdapter;
import gongqi.gdt.util.SWTUtils;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PackLayerAction
extends WorkbenchWindowActionDelegateAdapter {
    private Shell shell;
    private Combo layerNameInput;
    private Text versionInput;
    private Button multiLayerInput;
    private Button button_Confirm;

    public void run(IAction action) {
        Display display = Display.getCurrent();
        this.shell = new Shell(display.getActiveShell(), 65600);
        this.shell.setText("\u5c42\u6253\u5305");
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(SWTUtils.zoom(200), SWTUtils.zoom(200));
        Label layerNameLabel = new Label((Composite)this.shell, 32);
        layerNameLabel.setText("\u5c42\u540d\u79f0");
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, SWTUtils.zoom(15));
        formData.left = new FormAttachment(0, SWTUtils.zoom(20));
        layerNameLabel.setLayoutData((Object)formData);
        this.layerNameInput = new Combo((Composite)this.shell, 8);
        this.layerNameInput.setItems(this.getSourceLayers());
        if (this.layerNameInput.getItemCount() > 0) {
            this.layerNameInput.select(0);
        }
        formData = new FormData();
        formData.height = SWTUtils.zoom(18);
        formData.top = new FormAttachment((Control)layerNameLabel, SWTUtils.zoom(-5), 128);
        formData.left = new FormAttachment((Control)layerNameLabel, SWTUtils.zoom(8), 131072);
        formData.right = new FormAttachment(100, SWTUtils.zoom(-10));
        this.layerNameInput.setLayoutData((Object)formData);
        Label versionLabel = new Label((Composite)this.shell, 32);
        versionLabel.setText("\u7248\u672c\u53f7");
        formData = new FormData();
        formData.top = new FormAttachment((Control)layerNameLabel, SWTUtils.zoom(20), 1024);
        formData.right = new FormAttachment((Control)layerNameLabel, 0, 131072);
        versionLabel.setLayoutData((Object)formData);
        this.versionInput = new Text((Composite)this.shell, 2052);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        this.versionInput.setText(dateFormat.format(new Date()));
        formData = new FormData();
        formData.height = SWTUtils.zoom(18);
        formData.top = new FormAttachment((Control)versionLabel, SWTUtils.zoom(-3), 128);
        formData.left = new FormAttachment((Control)this.layerNameInput, 0, 16384);
        formData.right = new FormAttachment((Control)this.layerNameInput, 0, 131072);
        this.versionInput.setLayoutData((Object)formData);
        Label multiLayerLabel = new Label((Composite)this.shell, 32);
        multiLayerLabel.setText("\u591a\u5c42\u6253\u5305");
        formData = new FormData();
        formData.top = new FormAttachment((Control)versionLabel, SWTUtils.zoom(15), 1024);
        formData.right = new FormAttachment((Control)versionLabel, 0, 131072);
        multiLayerLabel.setLayoutData((Object)formData);
        this.multiLayerInput = new Button((Composite)this.shell, 32);
        formData = new FormData();
        formData.height = SWTUtils.zoom(18);
        formData.top = new FormAttachment((Control)multiLayerLabel, 0, 128);
        formData.left = new FormAttachment((Control)this.versionInput, 0, 16384);
        this.multiLayerInput.setLayoutData((Object)formData);
        this.button_Confirm = new Button((Composite)this.shell, 8);
        this.button_Confirm.setText("\u786e\u5b9a");
        formData = new FormData(SWTUtils.zoom(70), SWTUtils.zoom(28));
        formData.left = new FormAttachment(0, SWTUtils.zoom(15));
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-10));
        this.button_Confirm.setLayoutData((Object)formData);
        this.button_Confirm.addSelectionListener((SelectionListener)this);
        Button button_Cancel = new Button((Composite)this.shell, 8);
        button_Cancel.setText("\u53d6\u6d88");
        formData = new FormData(SWTUtils.zoom(70), SWTUtils.zoom(28));
        formData.right = new FormAttachment(100, SWTUtils.zoom(-15));
        formData.bottom = new FormAttachment((Control)this.button_Confirm, 0, 1024);
        button_Cancel.setLayoutData((Object)formData);
        button_Cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackLayerAction.this.shell.close();
            }
        });
        this.showInScreenCenter(this.shell);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (this.button_Confirm == e.widget) {
            if (this.layerNameInput.getSelectionIndex() == -1) {
                MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)"\u8bf7\u9009\u62e9\u9700\u8981\u6253\u5305\u7684\u5c42");
                return;
            }
            String layerName = this.layerNameInput.getItem(this.layerNameInput.getSelectionIndex());
            if (StringUtils.isBlank((String)layerName)) {
                MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)"\u8bf7\u9009\u62e9\u9700\u8981\u6253\u5305\u7684\u5c42");
                return;
            }
            String version = this.versionInput.getText();
            if (StringUtils.isBlank((String)version)) {
                MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)"\u7248\u672c\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
                return;
            }
            boolean multiLayer = this.multiLayerInput.getSelection();
            try {
                ((LayerService)ObjectContainer.getInstance(LayerService.class)).packLayer(layerName, version, multiLayer);
                MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)String.format("%s\u5c42\u6253\u5305\u6210\u529f", layerName));
                this.shell.close();
            }
            catch (Throwable ex) {
                this.log.error((Object)String.format("%s\u5c42\u6253\u5305\u9519\u8bef", layerName), ex);
                MessageDialog.openError((Shell)this.shell, (String)"\u63d0\u793a", (String)ex.getMessage());
            }
        }
    }

    private String[] getSourceLayers() {
        ArrayList<String> sourceLayers = new ArrayList<String>();
        LayerDefination layer = ((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).getCurrentLayer();
        while (layer != null) {
            if (layer.getDeploymentMode() == LayerDeploymentMode.Source && !"app".equals(layer.getLayerName()) && !"ext".equals(layer.getLayerName())) {
                sourceLayers.add(layer.getLayerName());
            }
            if ("Gongqi_ERP_No_More_Layer".equals(layer.getLowerLayer())) break;
            layer = ((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).getLayer(layer.getLowerLayer());
        }
        if (sourceLayers.isEmpty()) {
            return new String[0];
        }
        return sourceLayers.toArray(new String[sourceLayers.size()]);
    }
}

