/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.actions.layer;

import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.gdt.actions.WorkbenchWindowActionDelegateAdapter;
import gongqi.gdt.core.IDEProjectManager;
import gongqi.gdt.util.SWTUtils;
import info.gongqi.widgets.StringEditor;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CreateLayerAction
extends WorkbenchWindowActionDelegateAdapter {
    private Shell shell;
    private StringEditor layerNameEditor;
    private Button button_Confirm;

    public void run(IAction action) {
        Display display = Display.getCurrent();
        this.shell = new Shell(display.getActiveShell(), 65600);
        this.shell.setText("\u521b\u5efa\u5c42");
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(SWTUtils.zoom(240), SWTUtils.zoom(120));
        this.layerNameEditor = new StringEditor((Composite)this.shell, "\u5c42\u540d\u79f0");
        this.layerNameEditor.setWidth(SWTUtils.zoom(135));
        this.layerNameEditor.setEditable(true);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, SWTUtils.zoom(15));
        formData.left = new FormAttachment(0, SWTUtils.zoom(10));
        formData.right = new FormAttachment(100, SWTUtils.zoom(-10));
        this.layerNameEditor.setLayoutData(formData);
        this.button_Confirm = new Button((Composite)this.shell, 8);
        this.button_Confirm.setText("\u786e\u5b9a");
        formData = new FormData(SWTUtils.zoom(70), SWTUtils.zoom(28));
        formData.left = new FormAttachment(0, SWTUtils.zoom(25));
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-10));
        this.button_Confirm.setLayoutData((Object)formData);
        this.button_Confirm.addSelectionListener((SelectionListener)this);
        Button button_Cancel = new Button((Composite)this.shell, 8);
        button_Cancel.setText("\u53d6\u6d88");
        formData = new FormData(SWTUtils.zoom(70), SWTUtils.zoom(28));
        formData.right = new FormAttachment(100, SWTUtils.zoom(-25));
        formData.bottom = new FormAttachment((Control)this.button_Confirm, 0, 1024);
        button_Cancel.setLayoutData((Object)formData);
        button_Cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateLayerAction.this.shell.close();
            }
        });
        this.showInScreenCenter(this.shell);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (this.button_Confirm == e.widget) {
            String layerName = this.layerNameEditor.getText();
            if (StringUtils.isBlank((String)layerName)) {
                MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)"\u5c42\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
                return;
            }
            if (!layerName.matches("^[a-z]{3}$")) {
                MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)"\u5c42\u540d\u79f0\u4e0d\u7b26\u5408\u89c4\u8303\uff1a^[a-z]{3}$");
                return;
            }
            try {
                ((LayerService)ObjectContainer.getInstance(LayerService.class)).createLayer(layerName, true);
                ((IDEProjectManager)ObjectContainer.getInstance(IDEProjectManager.class)).createLayer(layerName);
                MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)String.format("%s\u5c42\u521b\u5efa\u6210\u529f", layerName));
                this.shell.close();
            }
            catch (Throwable ex) {
                this.log.error((Object)String.format("\u521b\u5efa%s\u5c42\u9519\u8bef", layerName), ex);
                MessageDialog.openError((Shell)this.shell, (String)"\u63d0\u793a", (String)ex.getMessage());
            }
        }
    }
}

