/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.actions;

import gongqi.gdt.actions.WorkbenchWindowActionDelegateAdapter;
import gongqi.gdt.hql.HQLStatement;
import info.gongqi.hql.util.ASTHelper;
import info.gongqi.util.Gongqi;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class HqlCheckAction
extends WorkbenchWindowActionDelegateAdapter {
    private static Logger log = Logger.getLogger(HqlCheckAction.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IAction action) {
        ArrayList<ICompilationUnit> compilationUnits = new ArrayList<ICompilationUnit>();
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof ITreeSelection) {
            Object element = ((ITreeSelection)selection).getFirstElement();
            if (element instanceof IJavaProject || element instanceof IProject) {
                IJavaProject javaProject = null;
                if (element instanceof IJavaProject) {
                    javaProject = (IJavaProject)element;
                } else if (element instanceof IProject) {
                    javaProject = JavaCore.create((IProject)((IProject)element));
                }
                if (!"LayerProject".equals(javaProject.getProject().getName())) {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"\u63d0\u793a", (String)"\u4ec5\u652f\u6301\u5bf9LayerProject\u9879\u76ee\u6267\u884cHQL\u68c0\u67e5");
                    return;
                }
                try {
                    IPackageFragmentRoot[] packageFragmentRoots = javaProject.getAllPackageFragmentRoots();
                    if (packageFragmentRoots != null && packageFragmentRoots.length > 0) {
                        IPackageFragmentRoot[] iPackageFragmentRootArray = packageFragmentRoots;
                        int n = packageFragmentRoots.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                            compilationUnits.addAll(this.getCompilationUnits(packageFragmentRoot));
                            ++n2;
                        }
                    }
                }
                catch (JavaModelException e) {
                    log.warn((Object)("HQL\u8bed\u6cd5\u68c0\u67e5\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u9009\u4e2d\u9879\u76ee\u7f16\u8bd1\u5355\u5143\uff1a" + javaProject.getPath()), (Throwable)e);
                }
            } else {
                if (!(element instanceof IPackageFragmentRoot)) {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"\u63d0\u793a", (String)"\u4ec5\u652f\u6301\u5bf9LayerProject\u9879\u76ee\u6e90\u6587\u4ef6\u6839\u76ee\u5f55\u6267\u884cHQL\u68c0\u67e5");
                    return;
                }
                IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)element;
                try {
                    compilationUnits.addAll(this.getCompilationUnits(packageFragmentRoot));
                }
                catch (JavaModelException e) {
                    log.warn((Object)("HQL\u8bed\u6cd5\u68c0\u67e5\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u9009\u4e2d\u5305\u7f16\u8bd1\u5355\u5143\uff1a" + packageFragmentRoot.getPath()), (Throwable)e);
                }
            }
        }
        if (!compilationUnits.isEmpty()) {
            this.compilationUnitSyntaxCheck(compilationUnits);
        }
    }

    private List<ICompilationUnit> getCompilationUnits(IPackageFragmentRoot rootPackage) throws JavaModelException {
        ArrayList<ICompilationUnit> compilationUnits = new ArrayList<ICompilationUnit>();
        if (rootPackage != null && rootPackage.hasChildren()) {
            IJavaElement[] elements = rootPackage.getChildren();
            int i = 0;
            while (i < elements.length) {
                String prefixRegex;
                IPackageFragment packageFragment;
                String packageName;
                if (!(!(elements[i] instanceof IPackageFragment) || (packageName = (packageFragment = (IPackageFragment)elements[i]).getElementName()).matches(String.valueOf(prefixRegex = "^[a-zA-Z0-9]+(\\.[a-zA-Z0-9]*)\\.layers\\.[a-z]{3}") + "\\.classes\\.base$") || packageName.matches(String.valueOf(prefixRegex) + "\\.datatypes$") || packageName.matches(String.valueOf(prefixRegex) + "+\\.tables\\.base$") || packageName.matches(String.valueOf(prefixRegex) + "\\.forms\\.[a-zA-Z0-9]+\\.base$") || packageName.matches(String.valueOf(prefixRegex) + "\\.forms\\.[a-zA-Z0-9]+\\.datasource\\.base$") || packageName.matches(String.valueOf(prefixRegex) + "\\.menuitems$"))) {
                    compilationUnits.addAll(Arrays.asList(packageFragment.getCompilationUnits()));
                }
                ++i;
            }
        }
        return compilationUnits;
    }

    public static void compilationUnitSyntaxCheck(ICompilationUnit unit) {
        if (unit == null) {
            return;
        }
        Gongqi.deleteMarker(unit.getResource(), Gongqi.HQL_MARKER_ID);
        List<ASTNode> nodes = ASTHelper.findCheckHqlNode(unit);
        if (nodes.isEmpty()) {
            return;
        }
        for (ASTNode _node : nodes) {
            ASTNode node = ASTHelper.findHqlNode(_node);
            if (node == null || "".equals(ASTHelper.getHql(node).trim())) continue;
            try {
                HQLStatement hqlObject = new HQLStatement(unit, node);
                hqlObject.syntaxCheck();
            }
            catch (Exception e) {
                log.debug((Object)String.format("%s\u6587\u4ef6HQL\u8bed\u6cd5\u68c0\u67e5\u9519\u8bef", unit.getResource().getFullPath().toOSString()), (Throwable)e);
            }
        }
    }

    private void compilationUnitSyntaxCheck(final List<ICompilationUnit> compilationUnits) {
        try {
            IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Hql\u8bed\u53e5\u68c0\u67e5", compilationUnits.size());
                    int i = 0;
                    while (i < compilationUnits.size()) {
                        if (monitor.isCanceled()) {
                            monitor.setTaskName("\u6b63\u5728\u53d6\u6d88Hql\u8bed\u53e5\u68c0\u67e5");
                            break;
                        }
                        monitor.setTaskName("\u6b63\u5728\u68c0\u67e5" + ((ICompilationUnit)compilationUnits.get(i)).getElementName());
                        HqlCheckAction.compilationUnitSyntaxCheck((ICompilationUnit)compilationUnits.get(i));
                        monitor.worked(1);
                        ++i;
                    }
                    monitor.done();
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"\u63d0\u793a", (String)"HQL\u68c0\u67e5\u5b8c\u6210");
                        }
                    });
                }
            };
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(null);
            progressMonitorDialog.run(true, true, runnableWithProgress);
        }
        catch (Exception e) {
            log.debug((Object)"HQL\u8bed\u6cd5\u68c0\u67e5\u9519\u8bef", (Throwable)e);
        }
    }
}

