/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt;

import gongqi.gdt.hql.HQLStatement;
import info.gongqi.hql.util.ASTHelper;
import info.gongqi.layer.CodeVerify;
import info.gongqi.util.Gongqi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class GongqiBuilder
extends IncrementalProjectBuilder {
    private IProject currentProject;
    private IJavaProject javaProject;

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        this.currentProject = this.getProject();
        if (this.currentProject == null || !this.currentProject.isAccessible()) {
            return new IProject[0];
        }
        this.getDelta(this.currentProject);
        long startTimeMillis = System.currentTimeMillis();
        this.javaProject = JavaCore.create((IProject)this.currentProject);
        this.scanSources();
        System.out.println("GongqiBuilder " + (System.currentTimeMillis() - startTimeMillis) / 1000L);
        return new IProject[]{this.currentProject};
    }

    private void validateHqlSyntax() {
        List<ICompilationUnit> sourceFiles = this.scanSources();
        String regexPattern = "^gongqi\\.erp\\.layers\\.[a-zA-z]{3}\\.%s";
        long searchTime = 0L;
        for (ICompilationUnit compilationUnit : sourceFiles) {
            IPackageFragment packageFragment = (IPackageFragment)compilationUnit.getPrimaryElement().getParent();
            String packageName = packageFragment.getElementName();
            if (packageName.matches(String.format(regexPattern, "classes\\.base")) || packageName.matches(String.format(regexPattern, "datatypes")) || packageName.matches(String.format(regexPattern, "enums")) || packageName.matches(String.format(regexPattern, "forms\\.[a-zA-Z0-9_]+\\.base")) || packageName.matches(String.format(regexPattern, "forms\\.[a-zA-Z0-9_]+\\.datasource\\.base")) || packageName.matches(String.format(regexPattern, "menuitems")) || packageName.matches(String.format(regexPattern, "tables\\.base"))) continue;
            Gongqi.deleteMarker(compilationUnit.getResource(), Gongqi.HQL_MARKER_ID);
            long startSearch = System.currentTimeMillis();
            List<ASTNode> hqlNodes = ASTHelper.findCheckHqlNode(compilationUnit);
            searchTime += System.currentTimeMillis() - startSearch;
            for (ASTNode hqlNode : hqlNodes) {
                ASTNode hqlTextNode = ASTHelper.findHqlNode(hqlNode);
                if (hqlTextNode == null || "".equals(ASTHelper.getHql(hqlTextNode).trim())) continue;
                try {
                    HQLStatement hqlStatement = new HQLStatement(compilationUnit, hqlTextNode);
                    hqlStatement.syntaxCheck();
                }
                catch (Exception e) {
                    Gongqi.createMarker(compilationUnit.getResource(), Gongqi.HQL_MARKER_ID, hqlTextNode.getStartPosition(), hqlTextNode.getStartPosition() + hqlTextNode.getLength(), e.getMessage());
                }
            }
        }
        System.out.println("searchTime " + searchTime);
    }

    private void validateCodeSpec(List<ICompilationUnit> sourceUnits) {
        for (ICompilationUnit compilationUnit : sourceUnits) {
            CompilationUnit domCompilationUnit = ASTHelper.parseDomCompilationUnit(compilationUnit);
            CodeVerify.verify(domCompilationUnit);
        }
    }

    private List<ICompilationUnit> scanSources() {
        ArrayList<ICompilationUnit> sourceUnits = new ArrayList<ICompilationUnit>();
        try {
            IPackageFragmentRoot[] packageFragmentRoots = this.javaProject.getPackageFragmentRoots();
            int i = 0;
            while (i < packageFragmentRoots.length) {
                IPackageFragmentRoot packageFragmentRoot = packageFragmentRoots[i];
                if (packageFragmentRoot.getKind() == 1) {
                    try {
                        IJavaElement[] rootFragments = packageFragmentRoot.getChildren();
                        int j = 0;
                        while (j < rootFragments.length) {
                            IPackageFragment packageFragment = (IPackageFragment)rootFragments[j];
                            ICompilationUnit[] compilationUnits = packageFragment.getCompilationUnits();
                            sourceUnits.addAll(Arrays.asList(compilationUnits));
                            ++j;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return sourceUnits;
    }
}

