"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toArray(r) { return _arrayWithHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var Message = /*#__PURE__*/function () {
  function Message(_ref) {
    var container = _ref.container,
      _ref$messages = _ref.messages,
      messages = _ref$messages === void 0 ? [] : _ref$messages;
    _classCallCheck(this, Message);
    this.messages = messages.map(function (msg, index) {
      return _objectSpread(_objectSpread({}, msg), {}, {
        id: msg.id || index
      });
    }); // 确保每条消息有唯一 id
    this.container = container;
    this.renderToDOM();
  }
  return _createClass(Message, [{
    key: "insert",
    value: function insert(message) {
      if (!message.id) {
        message.id = Date.now(); // 自动生成唯一 id
      }
      this.messages.push(message);
      if (this.container) {
        var newMessageElement = this.renderSingle(message.id);
        if (newMessageElement) {
          this.container.appendChild(newMessageElement);
          this.scrollToBottom();
        }
      }
      return this;
    }
  }, {
    key: "handleMessage",
    value: function handleMessage(message) {
      var findItem = false;
      for (var i = 0; i < this.messages.length; i++) {
        if (this.messages[i].id === message.id) {
          findItem = true;
        }
      }
      if (findItem) {
        this.update(message.id, message);
      } else {
        this.insert(message);
      }
    }
  }, {
    key: "update",
    value: function update(id, newMessage) {
      // 使用 for 循环替代 findIndex
      var index = -1;
      for (var i = 0; i < this.messages.length; i++) {
        if (this.messages[i].id === id) {
          index = i;
          break;
        }
      }
      console.log('index', index);
      if (index === -1) {
        console.error("Error: No message found with id ".concat(id, "."));
        return this;
      }
      this.messages[index] = _objectSpread(_objectSpread({}, this.messages[index]), newMessage);
      if (this.container) {
        var existingElement = this.container.querySelector("[data-id=\"".concat(id, "\"] .message"));
        if (existingElement) {
          existingElement.innerHTML = newMessage.content;
          this.scrollToBottom();
        }
      }
      return this;
    }
  }, {
    key: "delete",
    value: function _delete(id) {
      // 使用 for 循环替代 findIndex
      var index = -1;
      for (var i = 0; i < this.messages.length; i++) {
        if (this.messages[i].id === id) {
          index = i;
          break;
        }
      }
      if (index === -1) {
        console.error("Error: No message found with id ".concat(id, "."));
        return this;
      }
      this.messages.splice(index, 1);
      this.renderMessages();
      return this;
    }
  }, {
    key: "renderSingle",
    value: function renderSingle(id) {
      // 使用 for 循环替代 find
      var message = null;
      for (var i = 0; i < this.messages.length; i++) {
        if (this.messages[i].id === id) {
          message = this.messages[i];
          break;
        }
      }
      if (!message) {
        console.error("Error: No message found with id ".concat(id, "."));
        return null;
      }
      return this.createMessageElement(message.id, message);
    }
  }, {
    key: "createMessageElement",
    value: function createMessageElement(id, message) {
      var div = document.createElement('div');
      div.setAttribute('data-id', id); // 使用 id 替代 index

      var _this$getMessageClass = this.getMessageClassNames(message.role),
        _this$getMessageClass2 = _toArray(_this$getMessageClass),
        wrapperClass = _this$getMessageClass2[0],
        contentClasses = _this$getMessageClass2.slice(1);
      if (wrapperClass) {
        div.classList.add(wrapperClass);
      }
      if (message.role === 'user') {
        var send = document.createElement('div');
        send.classList.add(contentClasses[0]);
        send.innerHTML = message.content;
        div.appendChild(send);
      } else if (message.role === 'assistant') {
        // const avatar = document.createElement('div');
        // avatar.classList.add(contentClasses[0]);
        // const image = document.createElement('div');
        // image.classList.add(contentClasses[1]);
        // avatar.appendChild(image);
        // div.appendChild(avatar);

        var messageContent = document.createElement('div');
        messageContent.classList.add(contentClasses[2]);
        messageContent.innerHTML = message.content;
        div.appendChild(messageContent);
      }
      return div;
    }
  }, {
    key: "renderToDOM",
    value: function renderToDOM() {
      if (!this.container) {
        console.error('Error: Container not found.');
        return this;
      }
      this.renderMessages();
      return this;
    }
  }, {
    key: "getAll",
    value: function getAll() {
      return this.messages;
    }
  }, {
    key: "clear",
    value: function clear() {
      this.messages = [];
      return this;
    }

    // 提取消息类型的类名逻辑，增强代码复用性
  }, {
    key: "getMessageClassNames",
    value: function getMessageClassNames(type) {
      if (type === 'user') {
        return ['send-wrap', 'send'];
      } else if (type === 'assistant') {
        return ['receiver-wrap', 'avatar', 'image', 'message'];
      }
      return [];
    }
  }, {
    key: "renderMessages",
    value: function renderMessages() {
      this.container.innerHTML = '';
      if (this.messages.length === 0) {
        // const noMessagesDiv = document.createElement('div');
        // noMessagesDiv.textContent = 'No messages available.';
        // this.container.appendChild(noMessagesDiv);
      } else {
        var fragment = document.createDocumentFragment(); // 使用 DocumentFragment 提升性能
        for (var i = 0; i < this.messages.length; i++) {
          var div = this.createMessageElement(i, this.messages[i]);
          fragment.appendChild(div);
        }
        this.container.appendChild(fragment);
      }
      this.scrollToBottom();
    }
  }, {
    key: "scrollToBottom",
    value: function scrollToBottom() {
      this.container.scrollTop = this.container.scrollHeight;
    }
  }]);
}();
var SendMessage = /*#__PURE__*/function () {
  function SendMessage(_ref2) {
    var textarea = _ref2.textarea,
      sendBtn = _ref2.sendBtn,
      container = _ref2.container,
      _ref2$messages = _ref2.messages,
      messages = _ref2$messages === void 0 ? [] : _ref2$messages,
      copySelect = _ref2.copySelect;
    _classCallCheck(this, SendMessage);
    this.textarea = textarea;
    this.sendBtn = sendBtn;
    this.IMUI = new Message({
      container: container,
      messages: messages
    });
    // this.init()
    this.startStop = false;
    this.copySelect = copySelect;
  }
  return _createClass(SendMessage, [{
    key: "init",
    value: function init() {
      var _this = this;
      this.sendBtn.addEventListener('click', function () {
        var message = _this.textarea.value.trim();
        if (message === '' || _this.startStop) {
          return;
        }
        _this.sendMessage(message);
        _this.textarea.value = '';
      });
      this.textarea.addEventListener('keydown', function (e) {
        if (e.key === 'Enter' && !e.shiftKey) {
          e.preventDefault();
          _this.sendBtn.click();
        }
      });
    }
  }, {
    key: "sendMessage",
    value: function sendMessage(message) {
      if (!message.trim()) {
        console.warn('Warning: Attempted to send an empty message.');
        return; // 防止发送空消息
      }
      console.log(messageType);
      // const _message = {
      //     role: 'user',
      //     id: Date.now().toString(),
      //     content: message
      // };
      try {
        if (window.sendMessage && typeof window.sendMessage === 'function') {
          window.sendMessage(message, messageType);
        } else {
          throw new Error('window.sendMessage is not a function');
        }
      } catch (err) {
        throw err;
      }
      // this.IMUI.insert(_message);
    }
  }, {
    key: "appendMessage",
    value: function appendMessage(message) {
      this.IMUI.handleMessage(message);
    }
  }, {
    key: "appendMessages",
    value: function appendMessages(messages) {
      if (!Array.isArray(messages)) {
        console.log('appendMessages: messages is not array');
        return;
      }
      for (var i = 0; i < messages.length; i++) {
        this.IMUI.handleMessage(messages[i]);
      }
    }
  }, {
    key: "handleMessage",
    value: function handleMessage(message) {
      if (Array.isArray(message)) {
        this.appendMessages(message);
      } else if (Object.prototype.toString.call(message) === '[object Object]') {
        this.appendMessage(message);
      }
    }
  }, {
    key: "changeStartStop",
    value: function changeStartStop(startStop) {
      this.startStop = startStop;
      // if (startStop) {
      //     this.removeEvent()
      // } else {
      //     this.setEvent()
      // }
    }
  }, {
    key: "setEvent",
    value: function setEvent() {
      var domList = document.querySelectorAll(this.copySelect);
      for (var i = 0; i < domList.length; i++) {
        domList[i].addEventListener('click', this.clickEvent);
      }
    }
  }, {
    key: "removeEvent",
    value: function removeEvent() {
      var domList = document.querySelectorAll(this.copySelect);
      for (var i = 0; i < domList.length; i++) {
        domList[i].removeEventListener('click', this.clickEvent);
      }
    }
  }, {
    key: "clickEvent",
    value: function clickEvent($event, type) {
      var target = $event.target || $event.srcElement;
      try {
        while (!target.classList.contains('code-wrap')) {
          target = target.parentNode;
        }
        var code = target.querySelector('.language-java').innerHTML;
        window.copyCode(code, type);
      } catch (error) {
        alert(error);
      }
    }
  }]);
}();
