/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service.modify;

import gongqi.gdt.designer.service.GOTModel;
import gongqi.gdt.designer.service.modify.BaseModify;
import gongqi.gdt.designer.service.node.GOTEntity;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class DataTypeModify
extends BaseModify {
    public DataTypeModify(GOTModel sourceGOT, GOTModel targetGOT, GOTModel originalTargetGOT) {
        super(sourceGOT, targetGOT, originalTargetGOT);
    }

    @Override
    protected void afterEntityRename(GOTEntity entity, String srcName, String destName) {
        File srcJavaFile = new File(this.getJavaSourceDir(entity), String.format("/datatypes/DataType_%s.java", srcName));
        if (!srcJavaFile.exists()) {
            this.log.warn((Object)String.format("\u5b9e\u4f53%sJava\u6587\u4ef6\u4e0d\u5b58\u5728%s", entity.getId(), srcJavaFile.getName()));
            return;
        }
        try {
            String srcJavaText = FileUtils.readFileToString((File)srcJavaFile, (String)"UTF-8");
            String destJavaText = srcJavaText.replaceFirst(String.format("package\\s+%s\\.datatypes;", this.getJavaPackage(entity).replace(".", "\\.")), String.format("package %s.datatypes;", this.getJavaPackage(entity))).replaceFirst(String.format("public\\s+class\\s+DataType_%s", srcName), String.format("public class DataType_%s", destName)).replaceAll(String.format("public\\s+DataType_%s\\s*\\(", srcName), String.format("public DataType_%s(", destName)).replace(String.format("%s.datatypes.DataType_%s", this.getJavaPackage(entity), srcName), String.format("%s.datatypes.DataType_%s", this.getJavaPackage(entity), destName));
            Pattern pattern = Pattern.compile(String.format("extends\\s+[a-zA-Z]+[0-9a-zA-Z_]*(\\.[a-zA-Z]+[0-9a-zA-Z_]*)*\\.layers\\.[a-zA-Z0-9]{3}\\.datatypes\\.%s\\DataType_s*\\{", srcName));
            Matcher matcher = pattern.matcher(destJavaText);
            if (matcher.find()) {
                String src = matcher.group();
                String dest = src.replaceFirst(String.format("\\.datatypes\\.DataType_%s\\s*\\{", srcName), String.format(".datatypes.DataType_%s {", destName, destName));
                destJavaText = destJavaText.replace(src, dest);
            }
            FileUtils.write((File)srcJavaFile, (CharSequence)destJavaText, (String)"utf-8");
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("\u4fee\u6539\u5b9e\u4f53\u3010%s %s\u3011\u5185\u5bb9\u9519\u8bef", entity.getId(), srcName), e);
        }
        File destJavaFile = new File(this.getJavaSourceDir(entity), String.format("/datatypes/DataType_%s.java", destName));
        if (!destJavaFile.exists()) {
            srcJavaFile.renameTo(destJavaFile);
        } else {
            this.log.warn((Object)String.format("\u5b9e\u4f53%sJava\u6587\u4ef6\u91cd\u547d\u540d\u3010%s -> %s\u3011\u5931\u8d25\uff0c\u5b58\u5728\u91cd\u540d\u76ee\u6807\u6587\u4ef6", entity.getId(), srcName, destName));
        }
    }
}

