/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.tool;

import gongqi.gdt.designer.utils.Images;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.util.GOTMessageDialog;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class EnterNodeRef
extends Dialog {
    protected Object result;
    protected Shell shell;
    private Element xml;
    private Tree tree;
    private Label info;
    private boolean flag;

    public EnterNodeRef(Shell parent, int style, Element element, boolean flags) {
        super(parent, style);
        this.setText("ref");
        this.xml = element;
        this.flag = flags;
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), this.getStyle());
        this.shell.setSize(500, 320);
        this.shell.setText("\u63d0\u793a");
        this.shell.setImage(Images.getIcon("EnumItem.png"));
        Monitor monitor = this.shell.getMonitor();
        Rectangle bounds = monitor.getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        this.shell.setLayout((Layout)new FormLayout());
        this.tree = new Tree((Composite)this.shell, 2624);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!EnterNodeRef.this.xml.getName().equals("tempRoot")) {
                    List elements = EnterNodeRef.this.xml.elements();
                    Collections.sort(elements, new Comparator<Element>(){

                        @Override
                        public int compare(Element o1, Element o2) {
                            return o1.attributeValue("nodeType").compareToIgnoreCase(o2.attributeValue("nodeType"));
                        }
                    });
                    EnterNodeRef.this.xml.setContent(elements);
                }
                EnterNodeRef.this.buildTree(EnterNodeRef.this.xml, EnterNodeRef.this.tree, null);
            }
        });
        FormData fd_table = new FormData();
        fd_table.top = new FormAttachment(0, 0);
        fd_table.bottom = new FormAttachment(100, -27);
        fd_table.left = new FormAttachment(0, 0);
        fd_table.right = new FormAttachment(100, 0);
        this.tree.setLayoutData((Object)fd_table);
        Button button = new Button((Composite)this.shell, 0x800000);
        button.setText("  \u786e\u5b9a  ");
        FormData fd_button = new FormData();
        fd_button.top = new FormAttachment((Control)this.tree, 2);
        fd_button.bottom = new FormAttachment(100, -2);
        fd_button.right = new FormAttachment(100, -2);
        button.setLayoutData((Object)fd_button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterNodeRef.this.shell.close();
            }
        });
        this.info = new Label((Composite)this.shell, 0);
        FormData fd_info = new FormData();
        fd_info.top = new FormAttachment((Control)this.tree, 2);
        fd_info.bottom = new FormAttachment(100, -2);
        fd_info.left = new FormAttachment(0, 2);
        fd_info.right = new FormAttachment(90, 0);
        this.info.setLayoutData((Object)fd_info);
        if (this.flag) {
            this.tree.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    TreeItem trtmNewTreeitem = (TreeItem)event.item;
                    Element element = (Element)trtmNewTreeitem.getData();
                    String title = EnterNodeRef.this.getAttrChain(element, "relation");
                    EnterNodeRef.this.shell.setText(title);
                }
            });
            this.tree.addListener(8, new Listener(){

                public void handleEvent(Event event) {
                    int count = EnterNodeRef.this.tree.getSelectionCount();
                    if (count != 0) {
                        Point point = new Point(event.x, event.y);
                        TreeItem treeitem = EnterNodeRef.this.tree.getItem(point);
                        if (treeitem == null) {
                            event.doit = false;
                            return;
                        }
                        Element element = (Element)treeitem.getData();
                        FormDataSyn.refTreeItem(element);
                    }
                }
            });
        }
        GOTMessageDialog.shells.add(this.shell);
    }

    private void buildTree(Element elementTar, Tree treeParent, TreeItem parentItem) {
        if (elementTar.getName().equals("tempRoot")) {
            List elements = elementTar.elements();
            for (Element element : elements) {
                this.buildTree(element, treeParent, null);
            }
            return;
        }
        TreeItem trtmNewTreeitem = null;
        if (parentItem != null) {
            trtmNewTreeitem = new TreeItem(parentItem, 0);
            if (parentItem.getParentItem() == null) {
                parentItem.setExpanded(true);
            }
        } else {
            trtmNewTreeitem = new TreeItem(treeParent, 0);
            trtmNewTreeitem.setExpanded(true);
        }
        String text = "";
        if (this.flag) {
            text = this.extendsChainTreeLabelFunc(elementTar);
            trtmNewTreeitem.setData((Object)elementTar);
        } else {
            text = elementTar.getText().equals("") || elementTar.getText() == null ? elementTar.getName() : String.valueOf(elementTar.getName()) + " --> " + elementTar.getText();
        }
        trtmNewTreeitem.setText(text);
        if (this.flag) {
            trtmNewTreeitem.setImage(this.extendsChainTreeIconFunc(elementTar));
        }
        List elements = elementTar.elements();
        for (Element element : elements) {
            this.buildTree(element, null, trtmNewTreeitem);
        }
    }

    private String extendsChainTreeLabelFunc(Element item) {
        String _nodeType;
        String label = item.attributeValue("name");
        if (item.attribute("relation") != null) {
            label = String.valueOf(label) + " --> [" + item.attributeValue("relation") + "]";
        }
        if (item.attribute("nodeType") != null && (_nodeType = item.attributeValue("nodeType")) != null) {
            label = "[" + _nodeType + "]   " + label;
        }
        return label;
    }

    public String getAttrChain(Element node, String ... args) {
        if (node == null) {
            return "";
        }
        String entityId = node.attributeValue("entityId");
        String innerId = node.attributeValue("innerId");
        String str = "entityId:" + entityId + ",innerId:" + innerId;
        HashMap<String, Integer> type = new HashMap<String, Integer>();
        this.typeMap(node, type);
        String msg = "";
        for (String key : type.keySet()) {
            msg = String.valueOf(msg) + key + "[" + type.get(key) + "] ";
        }
        this.info.setText(msg);
        return str;
    }

    private void typeMap(Element node, Map<String, Integer> type) {
        List elements = node.elements();
        for (Element element : elements) {
            String nodeType = element.attributeValue("nodeType");
            if (type.containsKey(nodeType)) {
                int num = type.get(nodeType);
                type.put(nodeType, ++num);
            } else {
                type.put(nodeType, 1);
            }
            this.typeMap(element, type);
        }
    }

    private Image extendsChainTreeIconFunc(Element item) {
        String nodeName = item.attributeValue("nodeType");
        String iconClassName = nodeName;
        Image image = Images.getIcon(String.valueOf(iconClassName) + ".png");
        if (image == null) {
            image = Images.getIcon("Default.png");
        }
        return image;
    }
}

