/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.model;

import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.core.toolsgot.GOTXMLHelper;
import info.gongqi.got.tool.SwitchCurrentLayerDialog;
import info.gongqi.got.ui.ConfigComposite;
import info.gongqi.got.ui.LoadXML;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.util.GOTUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.swt.widgets.TreeItem;

public class GotXmlDto {
    private static GotXmlDto gotXmlhelp;
    private Map<String, Map<String, String>> gotMap = new LinkedHashMap<String, Map<String, String>>();
    private static String gotXML;
    private Map<EntityType, Map<String, String>> enttiys;
    private Map<String, Map<String, String>> entityIdAndName = new HashMap<String, Map<String, String>>();

    static {
        gotXML = "<GOT><DataDictionary><Enums/><DataTypes/><Tables/></DataDictionary><Menus/><MenuItems/><Forms/><Reports/><Classes/></GOT>";
    }

    private GotXmlDto() {
    }

    public int getTableCount() {
        if (this.gotMap.get("Tables") == null) {
            return 0;
        }
        return this.gotMap.get("Tables").size();
    }

    public int getBusinessTableCount() {
        if (this.entityIdAndName.get("Tables") == null) {
            return 0;
        }
        int systemTableCount = (int)this.entityIdAndName.get("Tables").entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("300") && ((String)entry.getValue()).toLowerCase().startsWith("sys")).count();
        return this.getTableCount() - systemTableCount;
    }

    public int getFormCount() {
        if (this.gotMap.get("Forms") == null) {
            return 0;
        }
        return this.gotMap.get("Forms").size();
    }

    public static GotXmlDto getInstance() {
        if (gotXmlhelp == null) {
            gotXmlhelp = new GotXmlDto();
        }
        return gotXmlhelp;
    }

    public void init() {
        this.gotMap.clear();
        this.entityIdAndName.clear();
        this.enttiys = LoadXmlCore.gotServices.getGOTEnttiys();
        this.gotMap.put("Enums", new LinkedHashMap<String, String>(this.enttiys.get(EntityType.Enum)));
        this.gotMap.put("DataTypes", new LinkedHashMap<String, String>(this.enttiys.get(EntityType.DataType)));
        this.gotMap.put("Tables", new LinkedHashMap<String, String>(this.enttiys.get(EntityType.Table)));
        this.gotMap.put("Menus", new LinkedHashMap<String, String>(this.enttiys.get(EntityType.Menu)));
        this.gotMap.put("MenuItems", new LinkedHashMap<String, String>(this.enttiys.get(EntityType.MenuItem)));
        this.gotMap.put("Forms", new LinkedHashMap<String, String>(this.enttiys.get(EntityType.Form)));
        this.gotMap.put("Reports", new LinkedHashMap<String, String>(this.enttiys.get(EntityType.Report)));
        this.gotMap.put("Classes", new LinkedHashMap<String, String>(this.enttiys.get(EntityType.Class)));
    }

    public Map<String, String> addMaps(Map<String, String> tarMaps, List<String> list) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String xml : tarMaps.keySet()) {
            Element element = GOTXMLHelper.createElementByXMLString(tarMaps.get(xml));
            if (!this.checkElement(element, list)) continue;
            map.put(xml, tarMaps.get(xml));
        }
        return map;
    }

    private boolean checkElement(Element node, List<String> list) {
        String id = node.attributeValue("id");
        String modifiedLayer = node.attributeValue("modifiedLayer");
        if (!this.shouLayer(modifiedLayer, list)) {
            return false;
        }
        if ("app".equals(SwitchCurrentLayerDialog.layer)) {
            if ("ext".equals(modifiedLayer)) {
                return false;
            }
            if (id.contains(".") && !id.startsWith(SwitchCurrentLayerDialog.solution)) {
                return false;
            }
        } else if ("ext".equals(SwitchCurrentLayerDialog.layer) && ("ext".equals(modifiedLayer) || "app".equals(modifiedLayer)) && id.contains(".") && !id.startsWith(SwitchCurrentLayerDialog.solution)) {
            return false;
        }
        return true;
    }

    private boolean shouLayer(String layer, List<String> list) {
        int currentIndex = list.indexOf(SwitchCurrentLayerDialog.layer);
        int tarIndex = list.indexOf(layer);
        return tarIndex <= currentIndex && currentIndex != -1;
    }

    public Element getGotXMl() {
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)gotXML);
        }
        catch (DocumentException e) {
            Logger.getLogger(this.getClass()).error((Object)e);
            return null;
        }
        Element root = document.getRootElement();
        Element DataDictionary2 = root.element("DataDictionary");
        if (DataDictionary2 != null) {
            ConfigComposite.progressBar.setShellText("\u6b63\u5728\u52a0\u8f7dEnums");
            this.addNode(DataDictionary2.element("Enums"), this.gotMap.get("Enums"));
            ConfigComposite.progressBar.setShellText("\u6b63\u5728\u52a0\u8f7dDataTypes");
            this.addNode(DataDictionary2.element("DataTypes"), this.gotMap.get("DataTypes"));
            ConfigComposite.progressBar.setShellText("\u6b63\u5728\u52a0\u8f7dTables");
            this.addNode(DataDictionary2.element("Tables"), this.gotMap.get("Tables"));
        }
        this.addNode(root.element("Menus"), this.gotMap.get("Menus"));
        this.addNode(root.element("MenuItems"), this.gotMap.get("MenuItems"));
        this.addNode(root.element("Forms"), this.gotMap.get("Forms"));
        this.addNode(root.element("Reports"), this.gotMap.get("Reports"));
        this.addNode(root.element("Classes"), this.gotMap.get("Classes"));
        return root;
    }

    public List<Element> getGotXMl(String path) {
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)gotXML);
        }
        catch (DocumentException e) {
            Logger.getLogger(this.getClass()).error((Object)e);
            return null;
        }
        Element root = document.getRootElement();
        if (path.contains("DataDictionary")) {
            Element DataDictionary2 = root.element("DataDictionary");
            if (DataDictionary2 != null && !path.contains("Enums")) {
                if (path.contains("Enums")) {
                    this.addNode(DataDictionary2.element("Enums"), this.gotMap.get("Enums"));
                } else if (path.contains("DataTypes")) {
                    this.addNode(DataDictionary2.element("DataTypes"), this.gotMap.get("DataTypes"));
                } else if (path.contains("Tables")) {
                    this.addNode(DataDictionary2.element("Tables"), this.gotMap.get("Tables"));
                }
            }
        } else if (path.contains("Menus")) {
            this.addNode(root.element("Menus"), this.gotMap.get("Menus"));
        } else if (path.contains("MenuItems")) {
            this.addNode(root.element("MenuItems"), this.gotMap.get("MenuItems"));
        } else if (path.contains("Forms")) {
            this.addNode(root.element("Forms"), this.gotMap.get("Forms"));
        } else if (path.contains("Reports")) {
            this.addNode(root.element("Reports"), this.gotMap.get("Reports"));
        } else if (path.contains("Classes")) {
            this.addNode(root.element("Classes"), this.gotMap.get("Classes"));
        }
        return root.selectNodes(path);
    }

    private void addNode(Element node, Map<String, String> maps) {
        HashMap<String, String> idAndName = new HashMap<String, String>();
        for (String key : maps.keySet()) {
            String xml = maps.get(key);
            Document document = this.xml(xml);
            Element root = document.getRootElement();
            if (!LoadXML.nodeShowRule(root)) continue;
            idAndName.put(root.attributeValue("id"), root.attributeValue("name"));
            node.add(root.detach());
        }
        this.entityIdAndName.put(node.getName(), idAndName);
        this.orderByNode(node);
    }

    public void orderByNode(Element node) {
        List menuOrders;
        List elements = node.elements();
        Collections.sort(elements, new Comparator<Element>(){

            @Override
            public int compare(Element o1, Element o2) {
                if (GOTUtil.button_pre) {
                    return o1.attributeValue("name").compareToIgnoreCase(o2.attributeValue("name"));
                }
                return LoadXML.fmt(o1.attributeValue("name")).compareToIgnoreCase(LoadXML.fmt(o2.attributeValue("name")));
            }
        });
        if ("Menus".equals(node.getName()) && (menuOrders = LoadXmlCore.gotServices.getMenuOrder()).size() > 0) {
            Collections.sort(elements, new Comparator<Element>(){

                @Override
                public int compare(Element o1, Element o2) {
                    int o1Index = menuOrders.indexOf(o1.attributeValue("id"));
                    int o2Index = menuOrders.indexOf(o2.attributeValue("id"));
                    if (o1Index == -1) {
                        return 1;
                    }
                    if (o2Index == -1) {
                        return 1;
                    }
                    return o1Index - o2Index;
                }
            });
        }
        node.setContent(elements);
    }

    private Document xml(String xml) {
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException e) {
            Logger.getLogger(this.getClass()).error((Object)e);
        }
        return document;
    }

    public void resEntity(String entityId, String entityType) {
        String xml = "";
        if (entityType.equals("Enum")) {
            xml = this.enttiys.get(EntityType.Enum).get(entityId);
            this.gotMap.get("Enums").put(entityId, xml);
        } else if (entityType.equals("DataType")) {
            xml = this.enttiys.get(EntityType.DataType).get(entityId);
            this.gotMap.get("DataTypes").put(entityId, xml);
        } else if (entityType.equals("Table")) {
            xml = this.enttiys.get(EntityType.Table).get(entityId);
            this.gotMap.get("Tables").put(entityId, xml);
        } else if (entityType.equals("Menu")) {
            xml = this.enttiys.get(EntityType.Menu).get(entityId);
            this.gotMap.get("Menus").put(entityId, xml);
        } else if (entityType.equals("MenuItem")) {
            xml = this.enttiys.get(EntityType.MenuItem).get(entityId);
            this.gotMap.get("MenuItems").put(entityId, xml);
        } else if (entityType.equals("Form")) {
            xml = this.enttiys.get(EntityType.Form).get(entityId);
            this.gotMap.get("Forms").put(entityId, xml);
        } else if (entityType.equals("Report")) {
            xml = this.enttiys.get(EntityType.Report).get(entityId);
            this.gotMap.get("Reports").put(entityId, xml);
        } else if (entityType.equals("Class")) {
            xml = this.enttiys.get(EntityType.Class).get(entityId);
            this.gotMap.get("Classes").put(entityId, xml);
        }
    }

    public Element currentEntityByTypeAndId(String entityType, String entytyId) {
        if (entityType == null || entityType.equals("")) {
            return null;
        }
        if (entityType.equals("Enum") || entityType.equals("Enums")) {
            String xml = this.gotMap.get("Enums").get(entytyId);
            if (xml == null) {
                return null;
            }
            return GOTXMLHelper.createElementByXMLString(xml);
        }
        if (entityType.equals("DataType") || entityType.equals("DataTypes")) {
            String xml = this.gotMap.get("DataTypes").get(entytyId);
            if (xml == null) {
                return null;
            }
            return GOTXMLHelper.createElementByXMLString(xml);
        }
        if (entityType.equals("Table") || entityType.equals("Tables")) {
            String xml = this.gotMap.get("Tables").get(entytyId);
            if (xml == null) {
                return null;
            }
            return GOTXMLHelper.createElementByXMLString(xml);
        }
        if (entityType.equals("Menu") || entityType.equals("Menus")) {
            String xml = this.gotMap.get("Menus").get(entytyId);
            if (xml == null) {
                return null;
            }
            return GOTXMLHelper.createElementByXMLString(xml);
        }
        if (entityType.equals("MenuItem") || entityType.equals("MenuItems")) {
            String xml = this.gotMap.get("MenuItems").get(entytyId);
            if (xml == null) {
                return null;
            }
            return GOTXMLHelper.createElementByXMLString(xml);
        }
        if (entityType.equals("Form") || entityType.equals("Forms")) {
            String xml = this.gotMap.get("Forms").get(entytyId);
            if (xml == null) {
                return null;
            }
            return GOTXMLHelper.createElementByXMLString(xml);
        }
        if (entityType.equals("Report") || entityType.equals("Reports")) {
            String xml = this.gotMap.get("Reports").get(entytyId);
            if (xml == null) {
                return null;
            }
            return GOTXMLHelper.createElementByXMLString(xml);
        }
        if (entityType.equals("Class") || entityType.equals("Classes")) {
            String xml = this.gotMap.get("Classes").get(entytyId);
            if (xml == null) {
                return null;
            }
            return GOTXMLHelper.createElementByXMLString(xml);
        }
        return null;
    }

    public String getServiceEntity(String entityType) {
        return this.getServiceEntityElement(entityType).asXML();
    }

    public Element getServiceEntityElement(String entityType) {
        if (entityType.equals("Enums")) {
            Element root = GOTXMLHelper.createElement("Enums");
            this.addNode(root, this.enttiys.get(EntityType.Enum));
            return root;
        }
        if (entityType.equals("Tables")) {
            Element root = GOTXMLHelper.createElement("Tables");
            this.addNode(root, this.enttiys.get(EntityType.Table));
            return root;
        }
        if (entityType.equals("DataTypes")) {
            Element root = GOTXMLHelper.createElement("DataTypes");
            this.addNode(root, this.enttiys.get(EntityType.DataType));
            return root;
        }
        if (entityType.equals("Menus")) {
            Element root = GOTXMLHelper.createElement("Menus");
            this.addNode(root, this.enttiys.get(EntityType.Menu));
            return root;
        }
        if (entityType.equals("MenuItems")) {
            Element root = GOTXMLHelper.createElement("MenuItems");
            this.addNode(root, this.enttiys.get(EntityType.MenuItem));
            return root;
        }
        if (entityType.equals("Forms")) {
            Element root = GOTXMLHelper.createElement("Forms");
            this.addNode(root, this.enttiys.get(EntityType.Form));
            return root;
        }
        if (entityType.equals("Reports")) {
            Element root = GOTXMLHelper.createElement("Reports");
            this.addNode(root, this.enttiys.get(EntityType.Report));
            return root;
        }
        if (entityType.equals("Classes")) {
            Element root = GOTXMLHelper.createElement("Classes");
            this.addNode(root, this.enttiys.get(EntityType.Class));
            return root;
        }
        return null;
    }

    public Element getCurrentElements(String entityType) {
        if (entityType.equals("Enums")) {
            Element root = GOTXMLHelper.createElement("Enums");
            this.addNode(root, this.gotMap.get("Enums"));
            return root;
        }
        if (entityType.equals("Tables")) {
            Element root = GOTXMLHelper.createElement("Tables");
            this.addNode(root, this.gotMap.get("Tables"));
            return root;
        }
        if (entityType.equals("DataTypes")) {
            Element root = GOTXMLHelper.createElement("DataTypes");
            this.addNode(root, this.gotMap.get("DataTypes"));
            return root;
        }
        if (entityType.equals("Menus")) {
            Element root = GOTXMLHelper.createElement("Menus");
            this.addNode(root, this.gotMap.get("Menus"));
            return root;
        }
        if (entityType.equals("MenuItems")) {
            Element root = GOTXMLHelper.createElement("MenuItems");
            this.addNode(root, this.gotMap.get("MenuItems"));
            return root;
        }
        if (entityType.equals("Forms")) {
            Element root = GOTXMLHelper.createElement("Forms");
            this.addNode(root, this.gotMap.get("Forms"));
            return root;
        }
        if (entityType.equals("Reports")) {
            Element root = GOTXMLHelper.createElement("Reports");
            this.addNode(root, this.gotMap.get("Reports"));
            return root;
        }
        if (entityType.equals("Classs") || entityType.equals("Classes")) {
            Element root = GOTXMLHelper.createElement("Classes");
            this.addNode(root, this.gotMap.get("Classes"));
            return root;
        }
        return null;
    }

    public List<Element> currentElements(String entityType) {
        return this.getCurrentElements(entityType).elements();
    }

    public List<Element> currentElements(String entityType, String attr, String value) {
        Map<String, String> map;
        ArrayList<Element> elements = new ArrayList<Element>();
        if (attr.equals("name") && (map = this.entityIdAndName.get(entityType)).containsValue(value)) {
            for (String key : map.keySet()) {
                if (!map.get(key).equals(value)) continue;
                elements.add(this.currentEntityByTypeAndId(entityType, key));
                return elements;
            }
        }
        List all = this.getCurrentElements(entityType).elements();
        for (Element element : all) {
            if (element.attribute(attr) == null || !value.equals(element.attributeValue(attr))) continue;
            elements.add(element);
        }
        return elements;
    }

    public Element getCurrentElement(Object elementId, Object entityId) {
        if (elementId == null || entityId == null) {
            return null;
        }
        if (entityId.equals(elementId)) {
            return this.getEntity(entityId.toString());
        }
        Element entityEle = this.getEntity(entityId.toString());
        String xpath = "//@id";
        List elements = entityEle.selectNodes(xpath);
        for (Element element : elements) {
            if (!element.attributeValue("id").equals(elementId)) continue;
            return element;
        }
        return null;
    }

    public Element getEntity(String entityId) {
        for (String key : this.gotMap.keySet()) {
            Map<String, String> map = this.gotMap.get(key);
            if (!map.containsKey(entityId)) continue;
            String xml = map.get(entityId);
            return GOTXMLHelper.createElementByXMLString(xml);
        }
        return null;
    }

    public Element getCurrentElement(TreeItem treeItem) {
        if (treeItem == null || treeItem.isDisposed()) {
            return null;
        }
        String elementId = treeItem.getData("elementId") == null ? null : treeItem.getData("elementId").toString();
        String elementEntityId = treeItem.getData("elementEntityId") == null ? null : treeItem.getData("elementEntityId").toString();
        String elementName = treeItem.getData("elementName").toString();
        if (elementEntityId == null) {
            return this.getCurrentEntytyElementPort(elementName);
        }
        if (elementEntityId.equals(elementId)) {
            return this.getEntity(elementEntityId.toString());
        }
        Element entityEle = this.getEntity(elementEntityId.toString());
        if (entityEle == null) {
            return null;
        }
        if (elementId != null) {
            String xpath = "//" + elementName + "[@id='" + elementId + "']";
            List elements = entityEle.selectNodes(xpath);
            for (Element element : elements) {
                if (!element.attributeValue("id").equals(elementId)) continue;
                return element;
            }
        } else {
            String xpath = "//" + elementName;
            List elements = entityEle.selectNodes(xpath);
            for (Element element : elements) {
                TreeItem parent = treeItem.getParentItem();
                Element parentParent = element.getParent();
                while (parent.getData("elementId") == null) {
                    parent = parent.getParentItem();
                    parentParent = parentParent.getParent();
                }
                if (!parent.getData("elementId").toString().equals(parentParent.attributeValue("id"))) continue;
                return element;
            }
        }
        return null;
    }

    public Element getCurrentEntityElement(TreeItem treeItem) {
        String elementEntityId;
        if (treeItem == null) {
            return null;
        }
        String string = elementEntityId = treeItem.getData("elementEntityId") == null ? null : treeItem.getData("elementEntityId").toString();
        if (elementEntityId == null) {
            return null;
        }
        return this.getEntity(elementEntityId.toString());
    }

    private Element getCurrentEntytyElementPort(String entityType) {
        if (entityType.equals("Enums")) {
            Element root = GOTXMLHelper.createElement("Enums");
            return root;
        }
        if (entityType.equals("Tables")) {
            Element root = GOTXMLHelper.createElement("Tables");
            return root;
        }
        if (entityType.equals("DataTypes")) {
            Element root = GOTXMLHelper.createElement("DataTypes");
            return root;
        }
        if (entityType.equals("Menus")) {
            Element root = GOTXMLHelper.createElement("Menus");
            return root;
        }
        if (entityType.equals("MenuItems")) {
            Element root = GOTXMLHelper.createElement("MenuItems");
            return root;
        }
        if (entityType.equals("Forms")) {
            Element root = GOTXMLHelper.createElement("Forms");
            return root;
        }
        if (entityType.equals("Reports")) {
            Element root = GOTXMLHelper.createElement("Reports");
            return root;
        }
        if (entityType.equals("Classes")) {
            Element root = GOTXMLHelper.createElement("Classes");
            return root;
        }
        if (entityType.equals("GOT")) {
            Element root = GOTXMLHelper.createElement("GOT");
            return root;
        }
        if (entityType.equals("DataDictionary")) {
            Element root = GOTXMLHelper.createElement("DataDictionary");
            return root;
        }
        return null;
    }

    public void updateEntityElement(Element element) {
        block3: {
            String name;
            block4: {
                block2: {
                    String entityId = element.attributeValue("id");
                    if (entityId == null) break block2;
                    for (String key : this.gotMap.keySet()) {
                        Map<String, String> map = this.gotMap.get(key);
                        if (!map.containsKey(entityId)) continue;
                        map.put(entityId, element.asXML());
                        this.gotMap.put(key, map);
                        String names = element.getName();
                        names = names.equals("Class") ? String.valueOf(names) + "es" : String.valueOf(names) + "s";
                        this.entityIdAndName.get(names).put(entityId, element.attributeValue("name"));
                        return;
                    }
                    break block3;
                }
                name = element.getName();
                if (!this.gotMap.containsKey(name)) break block4;
                this.updataElement(name, element);
                break block3;
            }
            if (!name.equals("DataDictionary")) break block3;
            List elements = element.elements();
            for (Element element2 : elements) {
                this.updataElement(name, element2);
            }
        }
    }

    private void updataElement(String name, Element element) {
        this.gotMap.remove(name);
        HashMap<String, String> map = new HashMap<String, String>();
        List elements = element.elements();
        for (Element entity : elements) {
            String id = entity.attributeValue("id");
            map.put(id, entity.asXML());
            String names = element.getName();
            String string = names = names.equals("Class") ? String.valueOf(names) + "es" : String.valueOf(names) + "s";
            if (!this.entityIdAndName.containsKey(names)) continue;
            this.entityIdAndName.get(names).put(id, element.attributeValue("name"));
        }
        this.gotMap.put(name, map);
    }

    public void addEntityElement(Element element) {
        String entityId = element.attributeValue("id");
        String name = element.getName();
        name = name.equals("Class") ? String.valueOf(name) + "es" : String.valueOf(name) + "s";
        Map<String, String> temps = this.gotMap.get(name);
        temps.put(entityId, element.asXML());
        this.gotMap.put(name, temps);
        this.entityIdAndName.get(name).put(entityId, element.attributeValue("name"));
    }

    public void deleteEntityElement(Element element) {
        String entityId = element.attributeValue("id");
        String name = element.getName();
        name = name.equals("Class") ? String.valueOf(name) + "es" : String.valueOf(name) + "s";
        Map<String, String> temps = this.gotMap.get(name);
        temps.remove(entityId, element.asXML());
        this.gotMap.put(name, temps);
        this.entityIdAndName.get(name).remove(entityId);
    }

    public String getUnsaveText() {
        String text = "";
        HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
        for (String key : this.gotMap.keySet()) {
            Map<String, String> map = this.gotMap.get(key);
            for (String entityKey : map.keySet()) {
                String xml = map.get(entityKey);
                if (!xml.contains("saved=\"0\"")) continue;
                Element element = GOTXMLHelper.createElementByXMLString(xml);
                String entityName = element.getName();
                if (valueMap.containsKey(entityName)) {
                    int num = (Integer)valueMap.get(entityName);
                    if (num > 0) {
                        ++num;
                    }
                    valueMap.put(entityName, num);
                    continue;
                }
                valueMap.put(entityName, 1);
            }
        }
        for (String entityName : valueMap.keySet()) {
            if ((Integer)valueMap.get(entityName) <= 0) continue;
            text = String.valueOf(text) + entityName + "[" + valueMap.get(entityName) + "]";
        }
        return text;
    }

    public boolean checkUniqueName(String type, String enyityId, String name) {
        Map<String, String> map = this.entityIdAndName.get(type = type.equals("Class") ? String.valueOf(type) + "es" : String.valueOf(type) + "s");
        if (!map.containsValue(name)) {
            return true;
        }
        for (String key : map.keySet()) {
            if (key.equals(enyityId) || !map.get(key).equals(name)) continue;
            return false;
        }
        return true;
    }

    public List<String> typesNameList(String type, String enyityId) {
        type = type.equals("Class") ? String.valueOf(type) + "es" : String.valueOf(type) + "s";
        ArrayList<String> names = new ArrayList<String>();
        Map<String, String> map = this.entityIdAndName.get(type);
        for (String key : map.keySet()) {
            if (key.equals(enyityId)) continue;
            names.add(map.get(key));
        }
        return names;
    }

    public String getEntityNameById(String type, String entityId) {
        Map<String, String> map = this.entityIdAndName.get(type = type.equals("Class") ? String.valueOf(type) + "es" : String.valueOf(type) + "s");
        if (map.containsKey(entityId)) {
            return map.get(entityId);
        }
        return "";
    }
}

