/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service;

import com.ximpleware.NavException;
import com.ximpleware.VTDException;
import gongqi.erp.framework.core.LayerDefination;
import gongqi.erp.framework.core.LayerDefiner;
import gongqi.erp.framework.core.LayerDeploymentMode;
import gongqi.erp.framework.core.LayerLocator;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.extension.SolutionExtensionDefinition;
import gongqi.erp.framework.core.extension.SolutionExtensionDefinitionManager;
import gongqi.erp.framework.core.extension.SolutionExtensionDeploymentMode;
import gongqi.erp.framework.core.extension.SolutionExtensionLocator;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinition;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinitionManager;
import gongqi.erp.framework.core.plugin.SolutionPluginDeploymentMode;
import gongqi.erp.framework.core.solution.SolutionDefinition;
import gongqi.erp.framework.core.solution.SolutionDefinitionManager;
import gongqi.erp.framework.core.solution.SolutionDeploymentMode;
import gongqi.erp.framework.core.solution.SolutionLocator;
import gongqi.erp.framework.exception.ERPException;
import gongqi.erp.framework.tools.ZipUtil;
import gongqi.erp.framework.tools.io.FileIOXML;
import gongqi.erp.framework.util.FileUtils;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.service.GOTModel;
import gongqi.gdt.designer.service.ProgressMonitor;
import gongqi.gdt.designer.service.analysis.ClassAnalysis;
import gongqi.gdt.designer.service.analysis.DataTypeAnalysis;
import gongqi.gdt.designer.service.analysis.EnumAnalysis;
import gongqi.gdt.designer.service.analysis.FormAnalysis;
import gongqi.gdt.designer.service.analysis.MenuAnalysis;
import gongqi.gdt.designer.service.analysis.MenuItemAnalysis;
import gongqi.gdt.designer.service.analysis.TableAnalysis;
import gongqi.gdt.designer.service.modify.ClassModify;
import gongqi.gdt.designer.service.modify.DataTypeModify;
import gongqi.gdt.designer.service.modify.EnumModify;
import gongqi.gdt.designer.service.modify.FormModify;
import gongqi.gdt.designer.service.modify.MenuItemModify;
import gongqi.gdt.designer.service.modify.MenuModify;
import gongqi.gdt.designer.service.modify.ModifyLevel;
import gongqi.gdt.designer.service.modify.TableModify;
import gongqi.gdt.designer.service.node.GOTEntity;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class LayerUpgradeService {
    private static Logger log = Logger.getLogger(LayerUpgradeService.class);
    private GOTModel sourceGOT;
    private GOTModel targetGOT;
    private GOTModel originalGOT;

    public void initGOTModel(File layerFile, Collection<File> solutionFiles, Collection<File> solutionPluginFiles, Collection<File> solutionExtensionFiles) {
        try {
            log.debug((Object)"\u52a0\u8f7d\u5f53\u524d\u5c42\u6a21\u578b");
            this.initSourceGOTModel();
            this.sourceGOT.catchRefInnerId();
            log.debug((Object)"\u52a0\u8f7d\u5347\u7ea7\u5c42\u6a21\u578b");
            this.initTargetGOTModel(layerFile, solutionFiles, solutionPluginFiles, solutionExtensionFiles);
            log.debug((Object)"\u52a0\u8f7d\u8fc7\u6e21\u5c42\u6a21\u578b");
            this.initOriginalTargetGOTModel();
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u6790\u5c42\u6a21\u578b\u9519\u8bef", e);
        }
    }

    public void analysis(ProgressMonitor monitor) throws VTDException, IOException {
        HashSet<String> entityIds = new HashSet<String>();
        entityIds.addAll(this.sourceGOT.getEntitys(EntityType.Enum).keySet());
        entityIds.addAll(this.sourceGOT.getEntitys(EntityType.DataType).keySet());
        entityIds.addAll(this.sourceGOT.getEntitys(EntityType.Table).keySet());
        entityIds.addAll(this.sourceGOT.getEntitys(EntityType.Form).keySet());
        entityIds.addAll(this.sourceGOT.getEntitys(EntityType.MenuItem).keySet());
        entityIds.addAll(this.sourceGOT.getEntitys(EntityType.Menu).keySet());
        entityIds.addAll(this.sourceGOT.getEntitys(EntityType.Class).keySet());
        entityIds.addAll(this.targetGOT.getEntitys(EntityType.Enum).keySet());
        entityIds.addAll(this.targetGOT.getEntitys(EntityType.DataType).keySet());
        entityIds.addAll(this.targetGOT.getEntitys(EntityType.Table).keySet());
        entityIds.addAll(this.targetGOT.getEntitys(EntityType.Form).keySet());
        entityIds.addAll(this.targetGOT.getEntitys(EntityType.MenuItem).keySet());
        entityIds.addAll(this.targetGOT.getEntitys(EntityType.Menu).keySet());
        entityIds.addAll(this.targetGOT.getEntitys(EntityType.Class).keySet());
        monitor.beginTask(entityIds.size());
        Throwable throwable = null;
        try {
            CompletableFuture.allOf(CompletableFuture.runAsync(() -> {
                new EnumAnalysis(this.sourceGOT, this.targetGOT, this.originalGOT).analysis(monitor);
                new DataTypeAnalysis(this.sourceGOT, this.targetGOT, this.originalGOT).analysis(monitor);
                new TableAnalysis(this.sourceGOT, this.targetGOT, this.originalGOT).analysis(monitor);
            }), CompletableFuture.runAsync(() -> new FormAnalysis(this.sourceGOT, this.targetGOT, this.originalGOT).analysis(monitor)), CompletableFuture.runAsync(() -> {
                new MenuItemAnalysis(this.sourceGOT, this.targetGOT, this.originalGOT).analysis(monitor);
                new MenuAnalysis(this.sourceGOT, this.targetGOT, this.originalGOT).analysis(monitor);
                new ClassAnalysis(this.sourceGOT, this.targetGOT, this.originalGOT).analysis(monitor);
            })).get();
        }
        catch (Throwable e) {
            throwable = e;
        }
        monitor.done(throwable);
        this.sourceGOT.clearCatchRefInnerId();
    }

    public void modifys(Element modifyElements, ProgressMonitor monitor) throws Exception {
        if (this.sourceGOT.getTopLayerDefination().getDeploymentMode() != LayerDeploymentMode.Source) {
            throw new ERPException("\u5f53\u524d\u5c42\u6e90\u7801\u5c42\uff0c\u65e0\u6cd5\u5347\u7ea7");
        }
        List cannotModifyItems = modifyElements.selectNodes(String.format("//ModifyItem[@modifyLevel='%s']", ModifyLevel.Cannot.name()));
        if (cannotModifyItems.size() > 0) {
            throw new ERPException("\u5b58\u5728\u4e0d\u80fd\u5347\u7ea7\u7684\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7");
        }
        monitor.beginTask(0);
        Throwable throwable = null;
        try {
            Element enumModifys = (Element)modifyElements.selectSingleNode("./DataDictionary/Enums");
            new EnumModify(this.sourceGOT, this.targetGOT, this.originalGOT).modify(enumModifys, monitor);
            Element dataTypeModifys = (Element)modifyElements.selectSingleNode("./DataDictionary/DataTypes");
            new DataTypeModify(this.sourceGOT, this.targetGOT, this.originalGOT).modify(dataTypeModifys, monitor);
            Element tableModifys = (Element)modifyElements.selectSingleNode("./DataDictionary/Tables");
            new TableModify(this.sourceGOT, this.targetGOT, this.originalGOT).modify(tableModifys, monitor);
            Element formModifys = (Element)modifyElements.selectSingleNode("./Forms");
            new FormModify(this.sourceGOT, this.targetGOT, this.originalGOT).modify(formModifys, monitor);
            Element menuItemModifys = (Element)modifyElements.selectSingleNode("./MenuItems");
            new MenuItemModify(this.sourceGOT, this.targetGOT, this.originalGOT).modify(menuItemModifys, monitor);
            Element menuModifys = (Element)modifyElements.selectSingleNode("./Menus");
            new MenuModify(this.sourceGOT, this.targetGOT, this.originalGOT).modify(menuModifys, monitor);
            Element classModifys = (Element)modifyElements.selectSingleNode("./Classes");
            new ClassModify(this.sourceGOT, this.targetGOT, this.originalGOT).modify(classModifys, monitor);
        }
        catch (Throwable e) {
            throwable = e;
        }
        if (throwable == null) {
            this.saveGOTEntitys();
            this.deployFiles();
        }
        monitor.done(throwable);
    }

    private void saveGOTEntitys() throws VTDException, IOException, DocumentException {
        this.writeEntityFile(this.sourceGOT.getEntitys(EntityType.Enum));
        this.writeEntityFile(this.sourceGOT.getEntitys(EntityType.DataType));
        this.writeEntityFile(this.sourceGOT.getEntitys(EntityType.Table));
        this.writeEntityFile(this.sourceGOT.getEntitys(EntityType.Form));
        this.writeEntityFile(this.sourceGOT.getEntitys(EntityType.MenuItem));
        this.writeEntityFile(this.sourceGOT.getEntitys(EntityType.Menu));
        for (GOTEntity entity : this.sourceGOT.getRemoveEntitys()) {
            File layerJavaPath;
            File layerGOTPath;
            String solutionName;
            LayerDefination layerDefination = this.sourceGOT.getLayerDefination(entity.getModifiedLayer());
            if (layerDefination.getLayerName().equals("app")) {
                solutionName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
                SolutionDefinition solutionDefinition = ((SolutionDefinitionManager)ObjectContainer.getInstance(SolutionDefinitionManager.class)).getSolution(solutionName);
                if (solutionDefinition.getDeploymentMode() != SolutionDeploymentMode.Source) continue;
                layerGOTPath = new File(solutionDefinition.getSolutionModelDir(), "got");
                layerJavaPath = ((SolutionLocator)ObjectContainer.getInstance(SolutionLocator.class)).getSolutionSourceDir(solutionName);
            } else if (layerDefination.getLayerName().equals("ext")) {
                solutionName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
                SolutionExtensionDefinition solutionExtensionDefinition = ((SolutionExtensionDefinitionManager)ObjectContainer.getInstance(SolutionExtensionDefinitionManager.class)).getSolutionExtension(solutionName);
                if (solutionExtensionDefinition.getDeploymentMode() != SolutionExtensionDeploymentMode.Source) continue;
                layerGOTPath = new File(solutionExtensionDefinition.getExtensionModelDir(), "got");
                layerJavaPath = ((SolutionExtensionLocator)ObjectContainer.getInstance(SolutionExtensionLocator.class)).getSolutionExtensionSourceDir(solutionName);
            } else {
                if (layerDefination.getDeploymentMode() != LayerDeploymentMode.Source) continue;
                layerGOTPath = new File(layerDefination.getLayerModelDir(), "got");
                layerJavaPath = ((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayerSourceDir(layerDefination.getLayerName());
            }
            switch (entity.getEntityType()) {
                case Enum: {
                    FileUtils.deleteQuietly((File)new File(layerJavaPath, "enums/" + entity.getName() + ".java"));
                    FileUtils.deleteQuietly((File)new File(layerGOTPath, "datadictionary/enums/" + entity.getName() + ".xml"));
                    break;
                }
                case DataType: {
                    FileUtils.deleteQuietly((File)new File(layerJavaPath, "datatypes/DataType_" + entity.getName() + ".java"));
                    FileUtils.deleteQuietly((File)new File(layerGOTPath, "datadictionary/datatypes/" + entity.getName() + ".xml"));
                    break;
                }
                case Table: {
                    FileUtils.deleteQuietly((File)new File(layerJavaPath, "tables/base/Base" + entity.getName() + ".java"));
                    FileUtils.deleteQuietly((File)new File(layerJavaPath, "tables/" + entity.getName() + ".java"));
                    FileUtils.deleteQuietly((File)new File(layerGOTPath, "datadictionary/tables/" + entity.getName() + ".xml"));
                    break;
                }
                case Form: {
                    FileUtils.deleteQuietly((File)new File(layerJavaPath, "forms/" + entity.getName()));
                    FileUtils.deleteQuietly((File)new File(layerGOTPath, "forms/" + entity.getName() + ".xml"));
                    break;
                }
                case MenuItem: {
                    FileUtils.deleteQuietly((File)new File(layerJavaPath, "menuitems/MenuItem_" + entity.getName()));
                    FileUtils.deleteQuietly((File)new File(layerGOTPath, "menuitems/" + entity.getName() + ".xml"));
                    break;
                }
                case Menu: {
                    FileUtils.deleteQuietly((File)new File(layerGOTPath, "menus/" + entity.getName() + ".xml"));
                    break;
                }
                default: {
                    throw new ERPException("\u5b9e\u4f53\u8282\u70b9\u79fb\u9664\u672a\u5904\u7406");
                }
            }
        }
    }

    private void deployFiles() throws IOException {
        List<LayerDefination> layerDefinations = this.targetGOT.getLayerDefinations();
        for (LayerDefination layerDefination : layerDefinations) {
            File destFile;
            File srcFile;
            LayerDefination sourceLayerDefination = this.sourceGOT.getLayerDefination(layerDefination.getLayerName());
            if ("ent".equals(layerDefination.getLayerName())) continue;
            if ("app".equals(layerDefination.getLayerName())) {
                List<SolutionDefinition> solutionDefinitions = this.targetGOT.getSolutionDefinitions();
                for (SolutionDefinition solutionDefinition : solutionDefinitions) {
                    srcFile = new File(this.targetGOT.getLayersRootDir(), String.format("/%s/%s%s", "app", solutionDefinition.getSolutionName(), ".app"));
                    destFile = new File(this.sourceGOT.getLayersRootDir(), String.format("/%s/%s%s", "app", solutionDefinition.getSolutionName(), ".app"));
                    if (!destFile.exists()) continue;
                    destFile.delete();
                    FileUtils.copyFile((File)srcFile, (File)destFile);
                }
                continue;
            }
            if ("plg".equals(layerDefination.getLayerName())) {
                List<SolutionPluginDefinition> solutionPluginDefinitions = this.targetGOT.getSolutionPluginDefinitions();
                for (SolutionPluginDefinition solutionPluginDefinition : solutionPluginDefinitions) {
                    srcFile = new File(this.targetGOT.getLayersRootDir(), String.format("/%s/%s/%s%s", "plg", solutionPluginDefinition.getSolutionName(), solutionPluginDefinition.getName(), ".plugin"));
                    destFile = new File(this.sourceGOT.getLayersRootDir(), String.format("/%s/%s/%s%s", "plg", solutionPluginDefinition.getSolutionName(), solutionPluginDefinition.getName(), ".plugin"));
                    if (!destFile.exists()) continue;
                    destFile.delete();
                    FileUtils.copyFile((File)srcFile, (File)destFile);
                }
                continue;
            }
            if ("ext".equals(layerDefination.getLayerName())) {
                List<SolutionExtensionDefinition> solutionExtensionDefinitions = this.targetGOT.getSolutionExtensionDefinitions();
                for (SolutionExtensionDefinition solutionExtensionDefinition : solutionExtensionDefinitions) {
                    srcFile = new File(this.targetGOT.getLayersRootDir(), String.format("/%s/%s%s", "ext", solutionExtensionDefinition.getSolutionName(), ".app.ext"));
                    destFile = new File(this.sourceGOT.getLayersRootDir(), String.format("/%s/%s%s", "ext", solutionExtensionDefinition.getSolutionName(), ".app.ext"));
                    if (!destFile.exists()) continue;
                    destFile.delete();
                    FileUtils.copyFile((File)srcFile, (File)destFile);
                }
                continue;
            }
            File srcLayerDir = new File(layerDefination.getLayerDir());
            File destLayerDir = new File(sourceLayerDefination.getLayerDir());
            FileUtils.deleteDirectory((File)destLayerDir);
            FileUtils.copyDirectory((File)srcLayerDir, (File)destLayerDir);
        }
    }

    private void writeEntityFile(Map<String, GOTEntity> entitys) throws NavException, IOException, DocumentException {
        for (GOTEntity entity : entitys.values()) {
            Path entityPath;
            Path gotPath;
            LayerDefination layerDefination = this.sourceGOT.getLayerDefination(entity.getModifiedLayer());
            if (layerDefination.getLayerName().equals("app")) {
                String solutionName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
                SolutionDefinition solutionDefinition = ((SolutionDefinitionManager)ObjectContainer.getInstance(SolutionDefinitionManager.class)).getSolution(solutionName);
                if (solutionDefinition.getDeploymentMode() != SolutionDeploymentMode.Source) continue;
                gotPath = Paths.get(solutionDefinition.getSolutionModelDir(), "got");
            } else if (layerDefination.getLayerName().equals("plg")) {
                String solutionPluginName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
                SolutionPluginDefinition solutionPluginDefinition = ((SolutionPluginDefinitionManager)ObjectContainer.getInstance(SolutionPluginDefinitionManager.class)).getSolutionPlugin(solutionPluginName);
                if (solutionPluginDefinition != null && solutionPluginDefinition.getDeploymentMode() != SolutionPluginDeploymentMode.Source) continue;
                gotPath = Paths.get(solutionPluginDefinition.getPluginModelDir(), "got");
            } else if (layerDefination.getLayerName().equals("ext")) {
                String namespace = entity.getId().substring(0, entity.getId().lastIndexOf("."));
                SolutionExtensionDefinition solutionExtensionDefinition = null;
                if (entity.getCreatedLayer().equals("plg")) {
                    SolutionPluginDefinition solutionPluginDefinition = ((SolutionPluginDefinitionManager)ObjectContainer.getInstance(SolutionPluginDefinitionManager.class)).getSolutionPlugin(namespace);
                    solutionExtensionDefinition = ((SolutionExtensionDefinitionManager)ObjectContainer.getInstance(SolutionExtensionDefinitionManager.class)).getSolutionExtension(solutionPluginDefinition.getSolutionName());
                } else {
                    solutionExtensionDefinition = ((SolutionExtensionDefinitionManager)ObjectContainer.getInstance(SolutionExtensionDefinitionManager.class)).getSolutionExtension(namespace);
                }
                if (solutionExtensionDefinition.getDeploymentMode() != SolutionExtensionDeploymentMode.Source) continue;
                gotPath = Paths.get(solutionExtensionDefinition.getExtensionModelDir(), "got");
            } else {
                if (layerDefination.getDeploymentMode() != LayerDeploymentMode.Source) continue;
                gotPath = Paths.get(layerDefination.getLayerModelDir(), "got");
            }
            if (entity.getEntityType() == EntityType.Enum) {
                entityPath = gotPath.resolve("datadictionary/enums/" + entity.getName() + ".xml");
            } else if (entity.getEntityType() == EntityType.DataType) {
                entityPath = gotPath.resolve("datadictionary/datatypes/" + entity.getName() + ".xml");
            } else if (entity.getEntityType() == EntityType.Table) {
                entityPath = gotPath.resolve("datadictionary/tables/" + entity.getName() + ".xml");
            } else if (entity.getEntityType() == EntityType.Menu) {
                entityPath = gotPath.resolve("menus/" + entity.getName() + ".xml");
            } else if (entity.getEntityType() == EntityType.MenuItem) {
                entityPath = gotPath.resolve("menuitems/" + entity.getName() + ".xml");
            } else if (entity.getEntityType() == EntityType.Form) {
                entityPath = gotPath.resolve("forms/" + entity.getName() + ".xml");
            } else if (entity.getEntityType() == EntityType.Class) {
                entityPath = gotPath.resolve("classes/" + entity.getName() + ".xml");
            } else {
                throw new ERPException(String.format("\u6682\u4e0d\u652f\u6301\u4fdd\u5b58\u3010%s\u3011\u7c7b\u578b\u8282\u70b9", entity.getEntityType().name()));
            }
            FileIOXML.saveDocument((String)entityPath.toString(), (Document)DocumentHelper.parseText((String)entity.asXML()));
            if (!entity.isRename() || !Files.exists(entityPath = entityPath.getParent().resolve(String.valueOf(entity.getOrigName()) + ".xml"), new LinkOption[0])) continue;
            Files.delete(entityPath);
        }
    }

    private void initSourceGOTModel() throws IOException {
        File layersRootDir = ((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayersRoot();
        this.sourceGOT = new GOTModel(layersRootDir);
    }

    private void initTargetGOTModel(File layersFile, Collection<File> solutionFiles, Collection<File> solutionPluginFiles, Collection<File> solutionExtensionFiles) throws IOException {
        File targetLayersRootDir = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString());
        targetLayersRootDir.mkdirs();
        try {
            ZipUtil.unZipFiles((String)layersFile.getAbsolutePath(), (String)targetLayersRootDir.getAbsolutePath());
        }
        catch (ZipException e) {
            throw new RuntimeException(String.format("\u5347\u7ea7\u5c42\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u635f\u574f\uff1a%s", layersFile.getAbsolutePath()), e);
        }
        File[] lyrFiles = targetLayersRootDir.listFiles();
        File[] fileArray = lyrFiles;
        int n = lyrFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File lyrFile = fileArray[n2];
            if (!lyrFile.isFile() || !lyrFile.getName().endsWith(".lyr")) {
                throw new RuntimeException("\u5347\u7ea7\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0c\u5305\u542b\u65e0\u6548\u7684\u5c42\u6253\u5305\u6587\u4ef6");
            }
            this.extractLayer(lyrFile, targetLayersRootDir);
            lyrFile.delete();
            ++n2;
        }
        File entLayerDir = new File(targetLayersRootDir, "ent");
        if ((solutionFiles != null && !solutionFiles.isEmpty() || solutionPluginFiles != null && !solutionPluginFiles.isEmpty() || solutionExtensionFiles != null && !solutionExtensionFiles.isEmpty()) && !entLayerDir.exists()) {
            this.makeLayerDir("ent", "iny", entLayerDir.toPath());
        }
        if (solutionFiles != null && !solutionFiles.isEmpty()) {
            File solutionsRootDir = new File(targetLayersRootDir, "app");
            solutionsRootDir.mkdirs();
            for (File solutionFile : solutionFiles) {
                FileUtils.copyFileToDirectory((File)solutionFile, (File)solutionsRootDir);
            }
        }
        if (solutionPluginFiles != null && !solutionPluginFiles.isEmpty()) {
            File solutionPluginsRootDir = new File(targetLayersRootDir, "plg");
            solutionPluginsRootDir.mkdirs();
            for (File solutionPluginFile : solutionPluginFiles) {
                FileUtils.copyFileToDirectory((File)solutionPluginFile, (File)solutionPluginsRootDir);
            }
        }
        if (solutionExtensionFiles != null && !solutionExtensionFiles.isEmpty()) {
            if (solutionPluginFiles == null || solutionPluginFiles.isEmpty()) {
                File solutionPluginsRootDir = new File(targetLayersRootDir, "plg");
                solutionPluginsRootDir.mkdirs();
            }
            File solutionExtensionsRootDir = new File(targetLayersRootDir, "ext");
            solutionExtensionsRootDir.mkdir();
            for (File solutionExtensionFile : solutionExtensionFiles) {
                FileUtils.copyFileToDirectory((File)solutionExtensionFile, (File)solutionExtensionsRootDir);
            }
        }
        this.targetGOT = new GOTModel(targetLayersRootDir);
    }

    private void extractLayer(File lyrFile, File descDir) {
        String layerName;
        File layerTempDir = new File(descDir, UUID.randomUUID().toString());
        try {
            ZipUtil.unZipFiles((String)lyrFile.getAbsolutePath(), (String)layerTempDir.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException("\u65e0\u6548\u7684\u5347\u7ea7\u6587\u4ef6\uff0c\u89e3\u6790\u9519\u8bef\uff1a" + lyrFile.getAbsolutePath(), e);
        }
        File gotPackageFile = new File(layerTempDir, "model").listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".got");
            }
        })[0];
        try {
            Throwable throwable = null;
            Object var7_10 = null;
            try (ZipFile gotZipFile = new ZipFile(gotPackageFile);){
                ZipEntry entry = gotZipFile.getEntry("Layer.xml");
                if (entry == null) {
                    throw new RuntimeException("\u65e0\u6548\u7684\u5347\u7ea7\u6587\u4ef6\uff0cgot\u538b\u7f29\u5305\u7f3a\u5c11\u5c42\u5b9a\u4e49\u6587\u4ef6");
                }
                SAXReader reader = new SAXReader();
                Document document = reader.read(gotZipFile.getInputStream(entry));
                layerName = document.getRootElement().elementText("name");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | DocumentException e) {
            throw new RuntimeException("\u65e0\u6548\u7684\u5347\u7ea7\u6587\u4ef6\uff0cgot\u538b\u7f29\u5305\u89e3\u6790\u9519\u8bef", e);
        }
        File descLayerDir = new File(descDir, layerName);
        if (descLayerDir.exists()) {
            throw new RuntimeException(String.format("\u5347\u7ea7\u6587\u4ef6\u9519\u8bef\uff0c\u5b58\u5728\u91cd\u590d\u7684%s\u5c42", layerName));
        }
        if (!layerTempDir.renameTo(descLayerDir)) {
            throw new RuntimeException(String.format("%s\u5c42\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u6587\u4ef6\u5939\u91cd\u547d\u540d\u5931\u8d25", layerName));
        }
    }

    private void initOriginalTargetGOTModel() throws IOException {
        File layersRootDir = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString());
        layersRootDir.mkdirs();
        List<LayerDefination> layerDefinations = this.targetGOT.getLayerDefinations();
        for (LayerDefination layerDefination : layerDefinations) {
            File srcFile;
            File destLayerDir = new File(layersRootDir, layerDefination.getLayerName());
            if (!destLayerDir.exists()) {
                destLayerDir.mkdirs();
            }
            if ("app".equals(layerDefination.getLayerName())) {
                List<SolutionDefinition> solutionDefinitions = this.targetGOT.getSolutionDefinitions();
                for (SolutionDefinition solutionDefinition : solutionDefinitions) {
                    srcFile = new File(new File(this.sourceGOT.getLayersRootDir(), "app"), String.valueOf(solutionDefinition.getSolutionName()) + ".app");
                    FileUtils.copyFileToDirectory((File)srcFile, (File)destLayerDir);
                }
                continue;
            }
            if ("plg".equals(layerDefination.getLayerName())) {
                List<SolutionPluginDefinition> solutionPluginDefinitions = this.targetGOT.getSolutionPluginDefinitions();
                for (SolutionPluginDefinition solutionPluginDefinition : solutionPluginDefinitions) {
                    srcFile = new File(new File(this.sourceGOT.getLayersRootDir(), "plg"), String.format("/%s/%s%s", solutionPluginDefinition.getSolutionName(), solutionPluginDefinition.getName(), ".plugin"));
                    FileUtils.copyFileToDirectory((File)srcFile, (File)destLayerDir);
                }
                continue;
            }
            if ("ext".equals(layerDefination.getLayerName())) {
                List<SolutionExtensionDefinition> solutionExtensionDefinitions = this.targetGOT.getSolutionExtensionDefinitions();
                for (SolutionExtensionDefinition solutionExtensionDefinition : solutionExtensionDefinitions) {
                    srcFile = new File(new File(this.sourceGOT.getLayersRootDir(), "ext"), String.valueOf(solutionExtensionDefinition.getSolutionName()) + ".app.ext");
                    FileUtils.copyFileToDirectory((File)srcFile, (File)destLayerDir);
                }
                continue;
            }
            FileUtils.copyDirectory((File)new File(this.sourceGOT.getLayerDefination(layerDefination.getLayerName()).getLayerDir()), (File)destLayerDir);
        }
        this.originalGOT = new GOTModel(layersRootDir);
    }

    private void makeLayerDir(String layerName, String lowerLayer, Path targetDir) throws IOException {
        try {
            if (Files.exists(targetDir, new LinkOption[0])) {
                if (Files.isDirectory(targetDir, new LinkOption[0])) {
                    FileUtils.deleteDirectory((File)targetDir.toFile());
                } else {
                    Files.delete(targetDir);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)String.format("\u6e05\u7a7a\u76ee\u5f55\u9519\u8bef\uff1a%s", targetDir.toString()), (Throwable)e);
        }
        Files.createDirectories(targetDir, new FileAttribute[0]);
        Path binaryDir = targetDir.resolve("binary");
        Files.createDirectories(binaryDir, new FileAttribute[0]);
        Path modelDir = targetDir.resolve("model");
        Files.createDirectories(modelDir, new FileAttribute[0]);
        Path gotDir = modelDir.resolve("got");
        Files.createDirectories(gotDir, new FileAttribute[0]);
        Files.createDirectories(gotDir.resolve("datadictionary/datatypes"), new FileAttribute[0]);
        Files.createDirectories(gotDir.resolve("datadictionary/enums"), new FileAttribute[0]);
        Files.createDirectories(gotDir.resolve("datadictionary/tables"), new FileAttribute[0]);
        Files.createDirectories(gotDir.resolve("forms"), new FileAttribute[0]);
        Files.createDirectories(gotDir.resolve("menuitems"), new FileAttribute[0]);
        Files.createDirectories(gotDir.resolve("menus"), new FileAttribute[0]);
        Files.createDirectories(gotDir.resolve("classes"), new FileAttribute[0]);
        Files.createDirectories(gotDir.resolve("reports"), new FileAttribute[0]);
        Files.createDirectories(modelDir.resolve("resource"), new FileAttribute[0]);
        ((LayerDefiner)ObjectContainer.getInstance(LayerDefiner.class)).defineLayer(modelDir.toString(), layerName, "1.0.0", lowerLayer, "1.0.0", true);
    }
}

