/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.tool;

import gongqi.gdt.designer.core.got.validate.MergeMapTool;
import gongqi.gdt.designer.core.got.validate.ValidateROpr;
import info.gongqi.got.ui.LoadXML;
import info.gongqi.got.util.GOTMessageDialog;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class MergeMatchingTips
extends Dialog {
    protected Object resultDialog = "";
    protected Shell shell;
    public ProgressBar progressBar;
    private Boolean canceled = false;
    private List<String> resultList = new ArrayList<String>();
    private List<MergeMapTool> subItemListCache = new ArrayList<MergeMapTool>();
    private List<Object> result = new ArrayList<Object>();

    public MergeMatchingTips(Shell parent, int style) {
        super(parent, style);
        this.setText("\u6b63\u5728\u9a8c\u8bc1");
    }

    public Object open(Element item, String url, int cur, Boolean listExsits, ValidateROpr validator) {
        this.createContents(item, url, cur, listExsits, validator);
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.resultDialog;
    }

    private void createContents(Element item, String url, int cur, Boolean listExsits, ValidateROpr validator) {
        this.shell = new Shell(this.getParent(), this.getStyle());
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                MergeMatchingTips.this.canceled = true;
            }
        });
        this.shell.setSize(600, 50);
        this.shell.setText(this.getText());
        this.shell.setLayout((Layout)new FillLayout(256));
        Monitor monitor = this.shell.getMonitor();
        Rectangle bounds = monitor.getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        this.progressBar = new ProgressBar((Composite)this.shell, 65536);
        this.progressBar.setMaximum(100);
        this.progressBar.setMinimum(0);
        this.start(item, url, cur, listExsits, validator);
        GOTMessageDialog.shells.add(this.shell);
    }

    public void start(final Element item, final String url, final int cur, final Boolean listExsits, final ValidateROpr validator) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                MergeMatchingTips.this.validateResolverItem(item, url, cur, listExsits, validator);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).MergeMatchingTips.this.shell.isDisposed()) {
                            return;
                        }
                        (this).MergeMatchingTips.this.shell.dispose();
                    }
                });
            }
        };
        new Thread(runnable).start();
    }

    public void validateResolverItem(Element item, String url, int cur, Boolean listExsits, ValidateROpr validator) {
        String s = "";
        if (this.canceled.booleanValue()) {
            for (String r : this.resultList) {
                s = String.valueOf(s) + r + "\n";
            }
            if (s.equals("")) {
                s = "\u672a\u53d1\u73b0\u5dee\u5f02";
            }
            this.setAlert(s, "\u8bca\u65ad\u4fe1\u606f(\u64cd\u4f5c\u88ab\u4e2d\u65ad)");
            this.canceled = false;
            return;
        }
        if (!listExsits.booleanValue()) {
            this.descendantsXML(item, url);
        }
        if (item.element("Properties") != null) {
            validator._url = url;
            List<Object> ob = validator.validate(item);
            if (ob != null && !ob.isEmpty()) {
                this.result.addAll(ob);
            }
        }
        if (cur == 0) {
            this.setProgressBar(0);
        }
        int total = this.subItemListCache.size();
        int i = 1;
        while (i <= total) {
            int block;
            Element subItem = this.subItemListCache.get(i - 1).getXml();
            String subUrl = this.subItemListCache.get(i - 1).getUrl();
            int n = block = total / 25 == 0 ? 1 : total / 25;
            if ((cur + 1) % block == 0) {
                float percent = (float)(cur + 1) / (float)total;
                this.setShellText("\u6b63\u5728\u9a8c\u8bc1" + subUrl + " " + percent * 100.0f + "%");
                this.setProgressBar((int)(percent * 100.0f));
            } else {
                this.setShellText("\u6b63\u5728\u9a8c\u8bc1" + subUrl);
            }
            ++cur;
            if (this.canceled.booleanValue()) {
                s = "";
                for (Object r : this.result) {
                    s = String.valueOf(s) + r + "\n";
                }
                if (s.equals("")) {
                    s = "\u672a\u53d1\u73b0\u5dee\u5f02";
                } else {
                    this.resultDialog = "true";
                }
                this.setAlert(s, "\u8bca\u65ad\u4fe1\u606f(\u64cd\u4f5c\u88ab\u4e2d\u65ad)");
                return;
            }
            if (!"Properties".equals(subItem.getName())) {
                this.validateResolverItem(subItem, subUrl, validator);
            }
            ++i;
        }
        if (cur == total) {
            this.setProgressBar(100);
            s = "";
            for (Object r : this.result) {
                s = String.valueOf(s) + r + "\n";
            }
            if (s.equals("")) {
                s = "\u672a\u53d1\u73b0\u5dee\u5f02";
                validator.validateEnd(false);
            } else {
                this.resultDialog = "true";
                validator.validateEnd(true);
            }
            this.setAlert(s, "\u8bca\u65ad\u4fe1\u606f");
        }
    }

    public void validateResolverItem(Element item, String url, ValidateROpr validator) {
        String s = "";
        if (this.canceled.booleanValue()) {
            for (String r : this.resultList) {
                s = String.valueOf(s) + r + "\n";
            }
            if (s.equals("")) {
                s = "\u672a\u53d1\u73b0\u5dee\u5f02";
            }
            this.setAlert(s, "\u8bca\u65ad\u4fe1\u606f(\u64cd\u4f5c\u88ab\u4e2d\u65ad)");
            this.canceled = false;
            return;
        }
        if (item.element("Properties") != null) {
            validator._url = url;
            List<Object> ob = validator.validate(item);
            if (ob != null && !ob.isEmpty()) {
                this.result.addAll(ob);
            }
        }
    }

    private void descendantsXML(Element item, String url) {
        if (item.element("Properties") != null && LoadXML.nodeShowRuleDoMerge(item)) {
            MergeMapTool map = new MergeMapTool(item, url);
            this.subItemListCache.add(map);
        }
        List elements = item.elements();
        for (Element child : elements) {
            String str = child.attribute("name") != null ? child.attributeValue("name") : child.getName();
            String subUrl = String.valueOf(url) + "/" + str;
            this.descendantsXML(child, subUrl);
        }
    }

    public void setProgressBar(final int num) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (MergeMatchingTips.this.progressBar.isDisposed()) {
                    return;
                }
                MergeMatchingTips.this.progressBar.setSelection(num);
            }
        });
    }

    public void setShellText(final String text) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (MergeMatchingTips.this.shell.isDisposed()) {
                    return;
                }
                MergeMatchingTips.this.shell.setText(text);
            }
        });
    }

    public void setAlert(final String text, final String title) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MergeMatchingTips.this.shell.close();
                GOTMessageDialog.showXmlInfo(text, title);
            }
        });
    }
}

