/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.tool;

import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.gdt.designer.core.toolsgot.GOTHelper;
import gongqi.gdt.designer.core.toolsgot.GOTXMLHelper;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.util.GOTMessageDialog;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class MergeCleanAllTable
extends Dialog {
    protected Object resultDialog = "";
    protected Shell shell;
    public ProgressBar progressBar;
    private Boolean canceled = false;
    private List<Element> xmllist = new ArrayList<Element>();

    public MergeCleanAllTable(Shell parent, int style) {
        super(parent, style);
        this.setText("\u6b63\u5728\u9a8c\u8bc1");
    }

    public Object open(boolean all) {
        this.createContents(all);
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.resultDialog;
    }

    private void createContents(boolean all) {
        this.shell = new Shell(this.getParent(), this.getStyle());
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                MergeCleanAllTable.this.canceled = true;
            }
        });
        this.shell.setSize(600, 50);
        this.shell.setText(this.getText());
        this.shell.setLayout((Layout)new FillLayout(256));
        Monitor monitor = this.shell.getMonitor();
        Rectangle bounds = monitor.getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        this.progressBar = new ProgressBar((Composite)this.shell, 65536);
        this.progressBar.setMaximum(100);
        this.progressBar.setMinimum(0);
        if (all) {
            this.xmllist = GotXmlDto.getInstance().currentElements("Tables");
        } else {
            TreeItem[] items;
            Tree tree = FormDataSyn.currentTreeUi.getTree();
            TreeItem[] treeItemArray = items = tree.getSelection();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem treeItem = treeItemArray[n2];
                Element element = GotXmlDto.getInstance().getCurrentElement(treeItem);
                if (element.getName().equals("Table")) {
                    this.xmllist.add(element);
                }
                ++n2;
            }
        }
        int total = this.xmllist.size();
        if (total > 0) {
            this.start(0, total, this.xmllist, "");
        } else {
            this.shell.setText("\u6ca1\u6709\u9700\u8981\u6e05\u7406\u7684table");
        }
    }

    public void start(final int i, final int total, final List<Element> list, final String result) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                MergeCleanAllTable.this.stepCheckTables(i, total, list, result);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).MergeCleanAllTable.this.shell.isDisposed()) {
                            return;
                        }
                    }
                });
            }
        };
        new Thread(runnable).start();
    }

    public void stepCheckTables(int cur, int total, List<Element> tables, String result) {
        Element table = tables.get(cur);
        int percent = ++cur * 100 / total;
        this.setShellText("\u6b63\u5728\u534f\u540c" + table.attributeValue("name") + " " + percent + "%");
        this.setProgressBar(percent);
        result = String.valueOf(result) + this.checkSingleTable(table);
        if (this.canceled.booleanValue() || cur >= total) {
            this.setProgressBar(100);
            if (result.equals("")) {
                result = "\u5df2\u81ea\u52a8\u5904\u7406\uff0c\u65e0\u9700\u624b\u52a8\u8c03\u6574";
            }
            String _title = "\u68c0\u67e5\u7ed3\u679c";
            if (this.canceled.booleanValue() && cur < total) {
                _title = String.valueOf(_title) + "(\u5df2\u4e2d\u65ad)";
            }
            this.canceled = false;
            this.setAlert(result, _title);
        } else {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)e);
            }
            this.stepCheckTables(cur, total, tables, result);
        }
    }

    public void setProgressBar(final int num) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (MergeCleanAllTable.this.progressBar.isDisposed()) {
                    return;
                }
                if (num == 100) {
                    MergeCleanAllTable.this.shell.close();
                } else {
                    MergeCleanAllTable.this.progressBar.setSelection(num);
                }
            }
        });
    }

    public void setShellText(final String text) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (MergeCleanAllTable.this.shell.isDisposed()) {
                    return;
                }
                MergeCleanAllTable.this.shell.setText(text);
            }
        });
    }

    public void setAlert(final String text, final String title) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                GOTMessageDialog.showXmlInfo(text, title);
            }
        });
    }

    public String checkSingleTable(Element table) {
        String result = "";
        String tableId = table.attributeValue("id");
        List<Element> forms = GotXmlDto.getInstance().currentElements("Forms");
        for (Element form : forms) {
            List dss = form.element("FormDataSources").elements("FormDataSource");
            for (Element ds : dss) {
                Element tablePro = GOTHelper.getProperty(ds, "Table");
                if (!tableId.equals(tablePro.attributeValue("refentityid")) || !this.tableToDsChanged(ds, table).booleanValue()) continue;
                result = String.valueOf(result) + this.adjustDsByTable(ds, table);
            }
        }
        return result;
    }

    private Boolean tableToDsChanged(Element ds, Element table) {
        List tableFields = table.element("TableFields").elements("TableField");
        List formdatasourcefields = ds.element("FormDataSourceFields").elements("FormDataSourceField");
        int j = 0;
        int i = 0;
        while (i < formdatasourcefields.size()) {
            Element fdsf = (Element)formdatasourcefields.get(i);
            String fdsfName = fdsf.attributeValue("name");
            if (fdsfName.indexOf(".") == -1) {
                Element tableField = (Element)tableFields.get(j);
                Element fieldPro = GOTHelper.getProperty(fdsf, "Field");
                String refinnerid = fieldPro.attributeValue("refinnerid");
                if (!refinnerid.equals(tableField.attributeValue("id"))) {
                    return true;
                }
                String tableFieldName = tableField.attributeValue("name");
                if (!fdsfName.equals(tableFieldName)) {
                    return true;
                }
                if (!tableField.attributeValue("type").equals(fdsf.attributeValue("type"))) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private String adjustDsByTable(final Element ds, final Element table) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Element form = ds.getParent().getParent();
                List tableFields = table.element("TableFields").elements("TableField");
                Element datasourcefields = ds.element("FormDataSourceFields");
                form.addAttribute("saved", "0");
                TreeItem trtmNewTreeitem = FormDataSyn.getTreeItrmByElement(form, FormDataSyn.treeUis.get(0));
                FormDataSyn.setUnSave(trtmNewTreeitem);
                Element base = null;
                for (Element tableField : tableFields) {
                    Element fieldPro;
                    String _id = tableField.attributeValue("id");
                    ArrayList<Element> fdsfList = new ArrayList<Element>();
                    List fdsfs = datasourcefields.elements("FormDataSourceField");
                    for (Element temp : fdsfs) {
                        fieldPro = GOTHelper.getProperty(temp, "Field");
                        if (!_id.equals(fieldPro.attributeValue("refinnerid"))) continue;
                        fdsfList.add(temp);
                    }
                    if (fdsfList.size() == 0) {
                        Element extPro;
                        String nextInnerId = form.attributeValue("nextInnerId");
                        Element fdsf = "String".equals(tableField.attributeValue("type")) ? GOTXMLHelper.formDataSourceField_String_Template.createCopy() : GOTXMLHelper.formDataSourceFieldTemplate.createCopy();
                        fdsf.addAttribute("id", nextInnerId);
                        fdsf.addAttribute("name", tableField.attributeValue("name"));
                        fdsf.addAttribute("type", tableField.attributeValue("type"));
                        fdsf.addAttribute("createdLayer", ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer());
                        fdsf.addAttribute("modifiedLayer", ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer());
                        int intnextinnerid = Integer.parseInt(nextInnerId);
                        Element fieldPro2 = GOTHelper.getProperty(fdsf, "Field");
                        fieldPro2.addAttribute("refentityid", table.attributeValue("id"));
                        fieldPro2.addAttribute("refinnerid", tableField.attributeValue("id"));
                        if (fieldPro2.element("Value") == null) {
                            fieldPro2.addElement("Value");
                        }
                        fieldPro2.element("Value").setText(tableField.attributeValue("name"));
                        fdsfList.add(fdsf);
                        if ("Component".equals(tableField.attributeValue("type")) && (extPro = GOTHelper.getProperty(tableField, "Extends")).attribute("refentityid") != null) {
                            String dataTypeId = extPro.attributeValue("refentityid");
                            Element dataTypes = GotXmlDto.getInstance().currentEntityByTypeAndId("DataType", dataTypeId);
                            if (dataTypes != null) {
                                Element dataType = dataTypes;
                                List arrayItems = dataType.element("DataTypeArray").elements("DataTypeArrayItem");
                                int length = arrayItems.size();
                                int i = 0;
                                while (i < length) {
                                    if (i == 0) {
                                        if (base == null) {
                                            datasourcefields.add(fdsf.detach());
                                        } else {
                                            GOTHelp.insertChildAfter(datasourcefields, base, fdsf);
                                        }
                                        fdsfList.remove(fdsf);
                                        base = fdsf;
                                    }
                                    Element arrayItem = (Element)arrayItems.get(i);
                                    fdsf = GOTXMLHelper.formDataSourceField_String_Template.createCopy();
                                    fdsf.addAttribute("id", String.valueOf(++intnextinnerid));
                                    String compItem = String.valueOf(tableField.attributeValue("name")) + "." + arrayItem.attributeValue("name");
                                    fdsf.addAttribute("name", compItem);
                                    fdsf.addAttribute("type", "String");
                                    fdsf.addAttribute("createdLayer", ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer());
                                    fdsf.addAttribute("modifiedLayer", ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer());
                                    fieldPro2 = GOTHelper.getProperty(fdsf, "Field");
                                    fieldPro2.addAttribute("refentityid", table.attributeValue("id"));
                                    fieldPro2.addAttribute("refinnerid", tableField.attributeValue("id"));
                                    if (fieldPro2.element("Value") == null) {
                                        fieldPro2.addElement("Value");
                                    }
                                    fieldPro2.element("Value").setText(compItem);
                                    GOTHelp.insertChildAfter(datasourcefields, base, fdsf);
                                    base = fdsf;
                                    ++i;
                                }
                            }
                        }
                        form.addAttribute("nextInnerId", String.valueOf(++intnextinnerid));
                    } else {
                        for (Element fdsf : fdsfList) {
                            fdsfs.remove(fdsf);
                            fieldPro = GOTHelper.getProperty(fdsf, "Field");
                            String refinnerid = fieldPro.attributeValue("refinnerid");
                            String fdsfName = fdsf.attributeValue("name");
                            String tableFieldName = tableField.attributeValue("name");
                            String tableFieldId = tableField.attributeValue("id");
                            String fdsfType = fdsf.attributeValue("type");
                            String tableFieldType = tableField.attributeValue("type");
                            if (tableFieldId.equals(refinnerid)) {
                                if (fdsfName.indexOf(".") == -1) {
                                    fdsf.addAttribute("name", tableFieldName);
                                    if (fieldPro.element("Value") == null) {
                                        fieldPro.addElement("Value");
                                    }
                                    fieldPro.element("Value").setText(tableFieldName);
                                } else {
                                    String[] array = fdsfName.split("\\.");
                                    array[0] = tableFieldName;
                                    String newFdsfName = "";
                                    int i = 0;
                                    while (i < array.length) {
                                        newFdsfName = i == 0 ? String.valueOf(newFdsfName) + array[i] : String.valueOf(newFdsfName) + "." + array[i];
                                        ++i;
                                    }
                                    fdsf.addAttribute("name", newFdsfName);
                                    if (fieldPro.element("Value") == null) {
                                        fieldPro.addElement("Value");
                                    }
                                    fieldPro.element("Value").setText(newFdsfName);
                                }
                            }
                            if ("Component".equals(tableFieldType) || fdsfType.equals(tableFieldType)) continue;
                            fdsf.addAttribute("type", tableFieldType);
                        }
                    }
                    for (Element fdsf : fdsfList) {
                        if (base == null) {
                            datasourcefields.add(fdsf.detach());
                        } else {
                            GOTHelp.insertChildAfter(datasourcefields, base, fdsf);
                        }
                        base = fdsf;
                    }
                }
                List fdsfs = datasourcefields.elements("FormDataSourceField");
                for (Element fdsf : fdsfs) {
                    Element fieldPro = GOTHelper.getProperty(fdsf, "Field");
                    String _id = fieldPro.attributeValue("refinnerid");
                    Element tableField = null;
                    for (Element element : tableFields) {
                        if (!_id.equals(element.attributeValue("id"))) continue;
                        tableField = element;
                        break;
                    }
                    if (tableField != null) continue;
                    GOTXMLHelper.deleteNode(fdsf);
                }
                GotXmlDto.getInstance().updateEntityElement(form);
                FormDataSyn.restore(trtmNewTreeitem, form, false);
            }
        });
        String formItemPrompt = "";
        return formItemPrompt;
    }
}

