/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.utils.cache;

import gongqi.erp.framework.core.FrameworkEnvironment;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.data.DataAreaHelper;
import gongqi.erp.framework.logging.Logger;
import gongqi.erp.gotmodel.form.load.FormObjectAuthority;
import gongqi.erp.gotmodel.form.load.FormObjectStandard;
import gongqi.erp.gotmodel.form.load.FormObjectUserSet;
import gongqi.erp.gotmodel.form.load.FormPrefetchCommandResult;
import gongqi.erp.gotmodel.userset.form.UserSetFormDAO;
import info.gongqi.got.ui.LoadXmlCore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CacheManager {
    private static Logger log = Logger.getLogger(CacheManager.class);
    private static Map<String, FormObjectStandard> mapFormObjectStandard;

    private static void initMapFormObjectUserSet() {
        DataAreaHelper.put((String)"mapFormObjectUserSet", new HashMap());
    }

    private static void initMapFormObjectAuthority() {
        DataAreaHelper.put((String)"mapFormObjectAuthority", new HashMap());
    }

    private static void initMapFormPrefetchCommandResult() {
        DataAreaHelper.put((String)"mapFormPrefetchCommandResult", new HashMap());
    }

    private static Map<String, FormObjectUserSet> mapFormObjectUserSet() {
        return (Map)DataAreaHelper.get((String)"mapFormObjectUserSet");
    }

    private static Map<String, Map<String, FormObjectAuthority>> mapFormObjectAuthority() {
        return (Map)DataAreaHelper.get((String)"mapFormObjectAuthority");
    }

    private static Map<String, FormPrefetchCommandResult> mapFormPrefetchCommandResult() {
        return (Map)DataAreaHelper.get((String)"mapFormPrefetchCommandResult");
    }

    public static void init() {
        if (FrameworkEnvironment.isDebug()) {
            return;
        }
        mapFormObjectStandard = new HashMap<String, FormObjectStandard>();
    }

    public static void initForCurrentDataArea() {
        CacheManager.initMapFormObjectUserSet();
        CacheManager.initMapFormObjectAuthority();
        CacheManager.initMapFormPrefetchCommandResult();
    }

    public static synchronized void initForm(String formId) {
        if (formId == null) {
            return;
        }
        if (LoadXmlCore.gotServices.getEntity(formId) == null) {
            return;
        }
        if (FrameworkEnvironment.isDebug()) {
            return;
        }
        if (mapFormObjectStandard == null) {
            mapFormObjectStandard = new HashMap<String, FormObjectStandard>();
        }
        if (CacheManager.mapFormObjectUserSet() == null) {
            CacheManager.initMapFormObjectUserSet();
        }
        if (CacheManager.mapFormObjectAuthority() == null) {
            CacheManager.initMapFormObjectAuthority();
        }
        if (CacheManager.mapFormPrefetchCommandResult() == null) {
            CacheManager.initMapFormPrefetchCommandResult();
        }
        CacheManager.clearFormObjectStandard(formId);
        FormObjectStandard formObjectStandard = new FormObjectStandard(formId);
        log.debug((Object)(String.valueOf(formId) + "->" + formObjectStandard.md5));
        mapFormObjectStandard.put(formId, formObjectStandard);
        CacheManager.clearFormPrefetchCommandResult(formId);
    }

    public static synchronized FormObjectStandard getFormObjectStandard(String formId) {
        if (mapFormObjectStandard.containsKey(formId)) {
            return mapFormObjectStandard.get(formId);
        }
        CacheManager.initForm(formId);
        return mapFormObjectStandard.get(formId);
    }

    public static synchronized FormPrefetchCommandResult getFormPrefetchCommandResult(String formId) {
        if (CacheManager.mapFormPrefetchCommandResult() == null) {
            return null;
        }
        if (CacheManager.mapFormPrefetchCommandResult().containsKey(formId)) {
            return CacheManager.mapFormPrefetchCommandResult().get(formId);
        }
        FormPrefetchCommandResult formPrefetchCommandResult = new FormPrefetchCommandResult(formId);
        CacheManager.mapFormPrefetchCommandResult().put(formId, formPrefetchCommandResult);
        return formPrefetchCommandResult;
    }

    public static synchronized FormObjectUserSet getFormObjectUserSet(String formId, String menuItemId, String userId) {
        if (CacheManager.mapFormObjectUserSet() == null) {
            return null;
        }
        if (LoadXmlCore.gotServices.getEntity(formId) == null) {
            return null;
        }
        String key = String.valueOf(formId) + "." + menuItemId + "." + userId;
        if (CacheManager.mapFormObjectUserSet().containsKey(key)) {
            return CacheManager.mapFormObjectUserSet().get(key);
        }
        FormObjectUserSet formObjectUserSet = new FormObjectUserSet(formId, menuItemId, userId);
        log.debug((Object)(String.valueOf(formId) + "." + menuItemId + "." + userId + "->" + formObjectUserSet.md5));
        CacheManager.mapFormObjectUserSet().put(key, formObjectUserSet);
        return formObjectUserSet;
    }

    public static synchronized FormObjectAuthority getFormObjectAuthority(String menuItemId, String userGroupId) {
        Map<String, FormObjectAuthority> map;
        if (CacheManager.mapFormObjectAuthority() == null) {
            return null;
        }
        if (CacheManager.mapFormObjectAuthority().containsKey(userGroupId) && (map = CacheManager.mapFormObjectAuthority().get(userGroupId)) != null && map.containsKey(menuItemId)) {
            return map.get(menuItemId);
        }
        FormObjectAuthority formObjectAuthority = new FormObjectAuthority(menuItemId, userGroupId, null);
        if (!formObjectAuthority.allNone) {
            log.debug((Object)(String.valueOf(menuItemId) + "." + userGroupId + "->" + formObjectAuthority.md5));
            Map<String, FormObjectAuthority> map2 = CacheManager.mapFormObjectAuthority().get(userGroupId);
            if (map2 == null) {
                map2 = new HashMap<String, FormObjectAuthority>();
                CacheManager.mapFormObjectAuthority().put(userGroupId, map2);
            }
            map2.put(menuItemId, formObjectAuthority);
        }
        return formObjectAuthority;
    }

    public static synchronized void clearFormObjectStandard(String formId) {
        if (mapFormObjectStandard != null) {
            mapFormObjectStandard.remove(formId);
        }
    }

    public static synchronized void clearFormObjectAuthority(String userGroupId) {
        if (CacheManager.mapFormObjectAuthority() != null) {
            CacheManager.mapFormObjectAuthority().remove(userGroupId);
        }
    }

    public static synchronized void clearFormPrefetchCommandResult(String formId) {
        if (CacheManager.mapFormPrefetchCommandResult() != null) {
            CacheManager.mapFormPrefetchCommandResult().remove(formId);
        }
    }

    public static synchronized void clearFormObjectUserSet(String formId, String menuItemId, String userId) {
        if (CacheManager.mapFormObjectUserSet() == null) {
            return;
        }
        String key = String.valueOf(formId) + "." + menuItemId + "." + userId;
        if (CacheManager.mapFormObjectUserSet().containsKey(key)) {
            CacheManager.mapFormObjectUserSet().remove(key);
        }
        List list = ((UserSetFormDAO)ObjectContainer.getInstance(UserSetFormDAO.class)).listUsersByDefaultUserId(formId, menuItemId, userId);
        for (String user : list) {
            String tmp = String.valueOf(formId) + "." + menuItemId + "." + user;
            if (!CacheManager.mapFormObjectUserSet().containsKey(tmp)) continue;
            CacheManager.mapFormObjectUserSet().remove(tmp);
        }
    }
}

