/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service.node;

import com.ximpleware.AutoPilot;
import com.ximpleware.ModifyException;
import com.ximpleware.NavException;
import com.ximpleware.PilotException;
import com.ximpleware.VTDException;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLModifier;
import gongqi.erp.framework.exception.ERPException;
import gongqi.gdt.designer.service.node.GOTEntity;
import gongqi.gdt.designer.service.node.GOTProperty;
import gongqi.gdt.designer.utils.VTDUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class GOTNode {
    private volatile GOTEntity entity;
    private int nodeIndex;
    private boolean rename = false;
    private String origName;
    private String nodeType;

    GOTNode() {
    }

    protected GOTNode(GOTEntity entity, int nodeIndex) throws NavException {
        this.entity = entity;
        this.nodeIndex = nodeIndex;
        this.nodeType = this.getNodeType();
    }

    public GOTEntity getEntity() {
        return this.entity;
    }

    void setEntity(GOTEntity entity) {
        this.entity = entity;
    }

    void setNodeIndex(int nodeIndex) {
        this.nodeIndex = nodeIndex;
    }

    public boolean isRename() {
        return this.rename;
    }

    public String getOrigName() {
        return this.origName;
    }

    public String getNodeType() {
        if (this.nodeType == null) {
            try {
                try {
                    VTDNav entityNav = this.entity.acquireEntityNav(true);
                    this.recoverNode();
                    this.nodeType = entityNav.toString(this.nodeIndex);
                }
                catch (NavException e) {
                    throw new RuntimeException("\u83b7\u53d6\u8282\u70b9\u7c7b\u578b\u5f02\u5e38", e);
                }
            }
            finally {
                this.entity.releaseEntityNav();
            }
        }
        return this.nodeType;
    }

    public boolean isEntityNode() throws NavException {
        return this.getNodeType().equals(this.getEntity().getNodeType());
    }

    public String getId() {
        try {
            this.entity.acquireEntityNav();
            this.recoverNode();
            String string = this.getAttributeValue("id");
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6\u8282\u70b9\u7f16\u53f7\u9519\u8bef", e);
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    public String getName() {
        try {
            this.entity.acquireEntityNav();
            this.recoverNode();
            String string = this.getAttributeValue("name");
            return string;
        }
        catch (NavException e) {
            throw new RuntimeException("\u83b7\u53d6\u8282\u70b9\u540d\u79f0\u9519\u8bef", e);
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    public void setName(String name) throws VTDException, IOException {
        if (!this.getName().equals(name)) {
            this.rename = true;
            this.origName = this.getName();
        }
        this.setAttributeValue("name", name);
    }

    public String getCreatedLayer() throws NavException {
        try {
            this.entity.acquireEntityNav();
            this.recoverNode();
            String string = this.getAttributeValue("createdLayer");
            return string;
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    public String getModifiedLayer() throws NavException {
        try {
            this.entity.acquireEntityNav();
            this.recoverNode();
            String string = this.getAttributeValue("modifiedLayer");
            return string;
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    public GOTNode getParent() throws NavException {
        try {
            VTDNav entityNav = this.getEntity().acquireEntityNav();
            this.recoverNode();
            if (VTDUtils.toParent(entityNav)) {
                GOTNode gOTNode = new GOTNode(this.entity, entityNav.getCurrentIndex());
                return gOTNode;
            }
            return null;
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    public GOTNode getPrevSiblingNode() throws VTDException {
        try {
            VTDNav entityNav = this.getEntity().acquireEntityNav();
            this.recoverNode();
            if (VTDUtils.toPrevSiblingElement(entityNav, this.getNodeType())) {
                GOTNode gOTNode = new GOTNode(this.entity, entityNav.getCurrentIndex());
                return gOTNode;
            }
            return null;
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    public GOTNode getNextSiblingNode() throws VTDException {
        try {
            VTDNav entityNav = this.getEntity().acquireEntityNav();
            this.recoverNode();
            if (VTDUtils.toNextSiblingElement(entityNav, this.getNodeType())) {
                GOTNode gOTNode = new GOTNode(this.entity, entityNav.getCurrentIndex());
                return gOTNode;
            }
            return null;
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    public List<GOTNode> getChildNodeBFS(boolean recursive) throws VTDException {
        return this.getChildNodeBFS(this, recursive);
    }

    private List<GOTNode> getChildNodeBFS(GOTNode node, boolean recursive) throws VTDException {
        ArrayList<GOTNode> nodeList = new ArrayList<GOTNode>();
        try {
            node.recoverNode();
            VTDNav entityNav = node.getEntity().acquireEntityNav();
            if (VTDUtils.toFirstChildElement(entityNav)) {
                if ("Properties".equals(VTDUtils.getName(entityNav)) && !VTDUtils.toNextSiblingElement(entityNav)) {
                    ArrayList<GOTNode> arrayList = nodeList;
                    return arrayList;
                }
                do {
                    if ("Properties".equals(VTDUtils.getName(entityNav))) continue;
                    GOTNode childNode = new GOTNode(this.getEntity(), entityNav.getCurrentIndex());
                    nodeList.add(childNode);
                } while (VTDUtils.toNextSiblingElement(entityNav));
            }
            int count = nodeList.size();
            int i = 0;
            while (i < count) {
                block14: {
                    block13: {
                        GOTNode childNode = (GOTNode)nodeList.get(i);
                        childNode.recoverNode();
                        if (!VTDUtils.toFirstChildElement(entityNav)) break block13;
                        if ("Properties".equals(VTDUtils.getName(entityNav)) && !VTDUtils.toNextSiblingElement(entityNav)) break block14;
                        do {
                            if ("Properties".equals(VTDUtils.getName(entityNav))) continue;
                            childNode = new GOTNode(this.getEntity(), entityNav.getCurrentIndex());
                            nodeList.add(childNode);
                        } while (VTDUtils.toNextSiblingElement(entityNav));
                    }
                    count = nodeList.size();
                }
                ++i;
            }
        }
        finally {
            this.entity.releaseEntityNav();
        }
        return nodeList;
    }

    public boolean hasAttribute(String name) throws NavException {
        try {
            VTDNav entityNav = this.entity.acquireEntityNav();
            this.recoverNode();
            boolean bl = VTDUtils.hasAttribute(entityNav, name);
            return bl;
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    public String getAttributeValue(String name) throws NavException {
        try {
            VTDNav entityNav = this.entity.acquireEntityNav();
            this.recoverNode();
            String string = VTDUtils.getAttributeValue(entityNav, name);
            return string;
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributeValue(String name, String value) throws VTDException, IOException {
        try {
            VTDNav entityNav = this.entity.acquireEntityNav();
            XMLModifier modifier = this.entity.getEntityModifier();
            this.recoverNode();
            XMLModifier xMLModifier = modifier;
            synchronized (xMLModifier) {
                if (VTDUtils.hasAttribute(entityNav, name)) {
                    if (StringUtils.isNotBlank((String)value)) {
                        modifier.updateToken(entityNav.getAttrVal(name), value);
                    } else {
                        AutoPilot pilot = new AutoPilot(entityNav);
                        pilot.selectAttr("innerid");
                        int attrNameIndex = pilot.iterateAttr();
                        modifier.removeAttribute(attrNameIndex);
                    }
                } else if (StringUtils.isNotBlank((String)value)) {
                    modifier.insertAttribute(String.format(" %s=\"%s\"", name, value));
                }
            }
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    public Map<String, String> getAttributes() throws PilotException, NavException {
        try {
            VTDNav entityNav = this.entity.acquireEntityNav();
            this.recoverNode();
            Map<String, String> map = VTDUtils.getAttributes(entityNav);
            return map;
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    public boolean hasProperty(String propertyName) throws VTDException {
        try {
            VTDNav entityNav = this.entity.acquireEntityNav();
            this.recoverNode();
            boolean bl = VTDUtils.toXPathElement(entityNav, String.format("Properties/Property/Name[text()='%s']", propertyName));
            return bl;
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    public List<GOTProperty> getPropertys() throws VTDException {
        ArrayList<GOTProperty> propertys = new ArrayList<GOTProperty>();
        try {
            VTDNav entityNav = this.entity.acquireEntityNav();
            this.recoverNode();
            if (VTDUtils.toXPathElement(entityNav, "Properties/Property")) {
                do {
                    GOTProperty property = new GOTProperty(this, entityNav.getCurrentIndex());
                    propertys.add(property);
                } while (VTDUtils.toNextSiblingElement(entityNav));
            }
            ArrayList<GOTProperty> arrayList = propertys;
            return arrayList;
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    public GOTProperty getProperty(String propertyName) throws VTDException {
        try {
            VTDNav entityNav = this.entity.acquireEntityNav();
            GOTProperty property = null;
            this.recoverNode();
            if (VTDUtils.toXPathElement(entityNav, String.format("Properties/Property/Name[text()='%s']/..", propertyName))) {
                property = new GOTProperty(this, entityNav.getCurrentIndex());
            }
            GOTProperty gOTProperty = property;
            return gOTProperty;
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    public GOTNode selectSingleNode(String xpath) throws VTDException {
        try {
            this.entity.acquireEntityNav();
            List<GOTNode> selectNodes = this.selectNodes(xpath);
            if (selectNodes.size() > 1) {
                throw new ERPException(String.format("xpath\u8868\u8fbe\u5f0f\u3010%s\u3011\u9009\u62e9\u7684\u8282\u70b9\u4e0d\u552f\u4e00", xpath));
            }
            GOTNode gOTNode = selectNodes.isEmpty() ? null : selectNodes.get(0);
            return gOTNode;
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    public List<GOTNode> selectNodes(String xpath) throws VTDException {
        try {
            VTDNav entityNav = this.entity.acquireEntityNav();
            ArrayList<GOTNode> nodes = new ArrayList<GOTNode>();
            this.recoverNode();
            AutoPilot pilot = new AutoPilot(entityNav);
            pilot.selectXPath(xpath);
            int index = -1;
            while ((index = pilot.evalXPath()) != -1) {
                nodes.add(new GOTNode(this.entity, index));
            }
            pilot.resetXPath();
            ArrayList<GOTNode> arrayList = nodes;
            return arrayList;
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    public List<GOTProperty> selectPropertys(String xpath) throws VTDException {
        ArrayList<GOTProperty> propertys = new ArrayList<GOTProperty>();
        try {
            VTDNav entityNav = this.entity.acquireEntityNav();
            this.recoverNode();
            AutoPilot pilot = new AutoPilot(entityNav);
            pilot.selectXPath(xpath);
            int index = -1;
            while ((index = pilot.evalXPath()) != -1) {
                if (!"Property".equals(entityNav.toString(index))) {
                    throw new IllegalArgumentException(String.format("xpath\u9519\u8bef\uff0c\u9009\u62e9\u8282\u70b9\u975eProperty\u8282\u70b9\uff1a%s", xpath));
                }
                if (!entityNav.toElement(1) || !entityNav.toElement(1)) {
                    throw new ERPException("Property\u7ed3\u6784\u9519\u8bef\uff01");
                }
                GOTNode node = new GOTNode(this.entity, entityNav.getCurrentIndex());
                propertys.add(new GOTProperty(node, index));
                entityNav.recoverNode(index);
            }
            pilot.resetXPath();
            ArrayList<GOTProperty> arrayList = propertys;
            return arrayList;
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAfterElement(String element) throws VTDException, IOException {
        try {
            XMLModifier modifier;
            this.getEntity().acquireEntityNav();
            XMLModifier xMLModifier = modifier = this.getEntity().getEntityModifier();
            synchronized (xMLModifier) {
                this.recoverNode();
                modifier.insertAfterElement(element.getBytes("UTF-8"));
            }
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertBeforeElement(String element) throws VTDException, IOException {
        try {
            XMLModifier modifier;
            this.getEntity().acquireEntityNav();
            XMLModifier xMLModifier = modifier = this.getEntity().getEntityModifier();
            synchronized (xMLModifier) {
                this.recoverNode();
                modifier.insertBeforeElement(element.getBytes("UTF-8"));
            }
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAfterHead(String element) throws VTDException, IOException {
        try {
            XMLModifier modifier;
            VTDNav entityNav = this.getEntity().acquireEntityNav();
            XMLModifier xMLModifier = modifier = this.getEntity().getEntityModifier();
            synchronized (xMLModifier) {
                this.recoverNode();
                if (VTDUtils.toFirstChildElement(entityNav, "Properties")) {
                    modifier.insertAfterElement(element.getBytes("UTF-8"));
                } else {
                    modifier.insertAfterHead(element.getBytes("UTF-8"));
                }
            }
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertBeforeTail(String element) throws VTDException, IOException {
        try {
            XMLModifier modifier;
            this.getEntity().acquireEntityNav();
            XMLModifier xMLModifier = modifier = this.getEntity().getEntityModifier();
            synchronized (xMLModifier) {
                this.recoverNode();
                modifier.insertBeforeTail(element.getBytes("UTF-8"));
            }
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() throws NavException, ModifyException {
        if (this.isEntityNode()) {
            return;
        }
        try {
            XMLModifier modifier;
            VTDNav entityNav = this.getEntity().acquireEntityNav();
            XMLModifier xMLModifier = modifier = this.getEntity().getEntityModifier();
            synchronized (xMLModifier) {
                this.recoverNode();
                modifier.remove(entityNav.getElementFragment());
            }
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    public String getEntityXPath() throws NavException {
        if (this.isEntityNode()) {
            return ".";
        }
        try {
            VTDNav entityNav = this.getEntity().acquireEntityNav();
            this.recoverNode();
            String string = this.getXPath(entityNav);
            return string;
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    private synchronized String getXPath(VTDNav nav) throws NavException {
        StringBuffer pathBuf = new StringBuffer();
        String elementName = VTDUtils.getName(nav);
        String id = VTDUtils.getAttributeValue(nav, "id");
        String name = VTDUtils.getAttributeValue(nav, "name");
        if (VTDUtils.toParent(nav)) {
            pathBuf.append(this.getXPath(nav));
        }
        pathBuf.append("/").append(elementName);
        if (StringUtils.isNotBlank((String)id)) {
            pathBuf.append("[@id='").append(id).append("']");
        } else if (StringUtils.isNotBlank((String)name)) {
            pathBuf.append("[@name='").append(name).append("']");
        }
        return pathBuf.toString();
    }

    public String asXML() {
        try {
            VTDNav entityNav = this.entity.acquireEntityNav();
            try {
                this.recoverNode();
                String string = VTDUtils.asXML(entityNav);
                return string;
            }
            catch (Exception e) {
                throw new RuntimeException("GOTNode\u8f6c\u6362\u4e3aXML\u6587\u672c\u5931\u8d25", e);
            }
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    public String dumpFragment() {
        try {
            VTDNav entityNav = this.entity.acquireEntityNav();
            this.recoverNode();
            String string = VTDUtils.dumpFragment(entityNav);
            return string;
        }
        catch (NavException | IOException throwable) {
            throw new ERPException("GOTNode\u83b7\u53d6XML\u6bb5\u5931\u8d25!");
        }
        finally {
            this.entity.releaseEntityNav();
        }
    }

    public synchronized String getNodeContent() throws VTDException, IOException {
        this.recoverNode();
        String nodeType = this.getNodeType();
        StringBuilder nodeBuilder = new StringBuilder();
        nodeBuilder.append(String.format("<%s", nodeType));
        StringBuilder attrBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.getAttributes().entrySet()) {
            attrBuilder.append(String.format(" %s=\"%s\"", entry.getKey(), entry.getValue()));
        }
        nodeBuilder.append((CharSequence)attrBuilder).append(">");
        StringBuilder propertiesBuilder = new StringBuilder();
        List<GOTProperty> propertys = this.getPropertys();
        if (propertys.size() > 0) {
            propertiesBuilder.append("<Properties>");
            for (GOTProperty property : propertys) {
                propertiesBuilder.append("<Property ");
                for (Map.Entry<String, String> entry : property.getAttributes().entrySet()) {
                    propertiesBuilder.append(String.format(" %s=\"%s\"", entry.getKey(), entry.getValue()));
                }
                propertiesBuilder.append(">");
                propertiesBuilder.append(String.format("<Name>%s</Name>", VTDUtils.escapeChar(property.getName())));
                if (property.getValue() != null) {
                    propertiesBuilder.append(String.format("<Value>%s</Value>", VTDUtils.escapeChar(property.getValue())));
                } else {
                    propertiesBuilder.append("<Value />");
                }
                propertiesBuilder.append("</Property>");
            }
            propertiesBuilder.append("</Properties>");
        }
        nodeBuilder.append((CharSequence)propertiesBuilder);
        nodeBuilder.append(String.format("</%s>", nodeType));
        return nodeBuilder.toString();
    }

    protected void recoverNode() throws NavException {
        VTDNav entityNav = this.entity.acquireEntityNav(false);
        entityNav.recoverNode(this.nodeIndex);
    }

    public String toString() {
        return this.dumpFragment();
    }
}

