/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.core.got.node;

import com.alibaba.fastjson.JSONObject;
import gongqi.designer.core.DesignerContext;
import gongqi.designer.core.LayerLevelManager;
import gongqi.designer.services.LayerService;
import gongqi.designer.utils.GOTHelper;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinition;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinitionManager;
import gongqi.gdt.designer.core.ResovlerContextMenuValue;
import gongqi.gdt.designer.core.clientsession.LayerType;
import gongqi.gdt.designer.core.event.ValidationResultEvent;
import gongqi.gdt.designer.core.got.node.NodeFactory;
import gongqi.gdt.designer.core.resolvergot.ResolverNode;
import gongqi.gdt.designer.core.resolvergot.ResolverNodeFactory;
import gongqi.gdt.designer.core.toolsgot.GOTXMLHelper;
import gongqi.gdt.designer.core.toolsgot.Macros;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.tool.GotLayerAndUserDialog;
import info.gongqi.got.tool.TreeOperationInfo;
import info.gongqi.got.util.FromToMapping;
import info.gongqi.got.util.GOTMessageDialog;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;
import org.eclipse.swt.events.MouseEvent;

public class NodeGOT {
    public static List<Element> arrayDataType = null;
    public static List<String> arrayEnum = null;
    public ResolverNode rNode;
    public Element xml;
    private String refentityId;
    private static String treeRightMenuDataString = "<root><menuitem label='\u6253\u5f00\u65b0\u7a97\u53e3%W' func='newWindow'/> <menuitem label='\u663e\u793aXML' func='showXML'/> <menuitem type='separator'/>  <menuitem label='\u65b0 \u589e%N' func='new'> </menuitem> <menuitem label='\u590d\u5236' func='copy'/> <menuitem type='separator'/> <menuitem id='save' label='\u4fdd\u5b58%S' func='save'/> <menuitem label='\u540c\u6b65%Y' visible='true' func='sync'/> <menuitem type='separator'/> <menuitem label='\u6062\u590d%R' func='restore'/> <menuitem id='delete' label='\u5220\u9664%Delete' func='delete'/> <menuitem label='\u65b9\u6cd5%M' func='method'/> <menuitem type='separator'/> <menuitem label='\u5f15\u7528\u5217\u8868%Q' func='quote'/> <menuitem label='\u5c42\u63a7\u5236'> <menuitem label='\u6807\u8bb0\u5e9f\u5f03' visible='true' func='deprecate'/> <menuitem label='\u6807\u8bb0\u542f\u7528' visible='true' func='undeprecate'/> <menuitem label='\u6807\u8bb0\u53ef\u89c1' visible='true' func='tovisible'/> <menuitem label='\u6807\u8bb0\u4e0d\u53ef\u89c1' visible='true' func='tounvisible'/> <menuitem label='\u6807\u8bb0\u9501\u5b9a' visible='true' func='lock'/> <menuitem label='\u89e3\u9664\u9501\u5b9a' visible='true' func='unlock'/> </menuitem><menuitem label='\u8f85\u52a9\u529f\u80fd' visible='false' > <menuitem label='\u540c\u6b65\u6570\u636e\u6e90\u5b57\u6bb5' func='syncFDSF' visible='true' /> <menuitem label='\u91cd\u7f6e\u5173\u8054\u8282\u70b9\u540d\u79f0' func='resetRelationName' visible='true' /> </menuitem><menuitem label='\u8f85\u52a9\u529f\u80fd' visible='false' > <menuitem label='\u91cd\u7f6e\u5173\u8054\u8282\u70b9\u540d\u79f0' func='resetRelationName' visible='true' /> <menuitem label='FormDataSourceField\u5229\u7528\u7387' func='checkFormDataSourceFieldRate' visible='true' /> </menuitem><menuitem label='\u8c03\u6574\u521b\u5efa\u5c42' func='AdjustCreatedLayer'/> </root>";
    public static Element treeRightMenuData = GOTXMLHelper.createElementByXMLString(treeRightMenuDataString);
    public static String gridRightMenuDataString = "<root><menuitem label='\u663e\u793aXML' func='showXML'/><menuitem label='\u8fdb\u5165\u5173\u8054[1]' func='enterRelation'/><menuitem label='\u7ee7\u627f\u8ffd\u6eaf[2]' func='enterNodeExtends'/><menuitem label='\u5e2e\u52a9' func='help'/></root>";
    public static Element gridRightMenuData = GOTXMLHelper.createElementByXMLString(gridRightMenuDataString);
    private static String javakeys = "BOOLEAN ABSTRACT ASSERT BREAK BYTE CASE CATCH CHAR CLASS CONST CONTINUE DEFAULT DO DOUBLE ELSE ENUM EXTENDS FINAL FINALLY FLOAT FOR GOTO IF IMPLEMENTS IMPORT INSTANCEOF INT INTERFACE NATIVE NEW PACKAGE PRIVATE PROTECTED PUBLIC STRICTFP SUPER SWITCH SYNCHRONIZED THIS THROW THROWS TRANSIENT TRY VOID VOLATILE";

    public String getRefentityId() {
        return this.refentityId;
    }

    public void setRefentityId(String refentityId) {
        this.refentityId = refentityId;
    }

    public String getDragAccpAction() {
        return "new";
    }

    public final void createXml(String id) {
        this.xml = GOTXMLHelper.createElement(this.rNode.getNode().attributeValue("name"));
        this.createAttriubtes(id);
        this.createProperties();
        this.createChildren();
    }

    private void createAttriubtes(String id) {
        List<Element> array = this.rNode.getAttributes();
        if (this.rNode.getInfoValue("NodeType").equals("entity")) {
            this.xml.addAttribute("saved", "0");
        }
        for (Element attr : array) {
            if ("optional".equals(attr.elementText("Use"))) continue;
            if (attr.elementText("Name").equals("id")) {
                if (id == null) continue;
                this.xml.addAttribute("id", id);
                continue;
            }
            if (attr.element("Name").getText().equals("type")) {
                this.xml.addAttribute("type", this.rNode.getInfoValue("Type"));
                continue;
            }
            if (attr.element("Name").getText().equals("name")) {
                this.xml.addAttribute("name", this.getDefaultAttrName(attr));
                continue;
            }
            if (attr.element("Name").getText().equals("createdLayer")) {
                this.xml.addAttribute("createdLayer", ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer());
                continue;
            }
            if (attr.element("Name").getText().equals("modifiedLayer")) {
                this.xml.addAttribute("modifiedLayer", ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer());
                continue;
            }
            this.xml.addAttribute(attr.elementText("Name"), attr.element("Default").getText());
        }
    }

    protected String getDefaultAttrName(Element attr) {
        return attr.element("Default").getText();
    }

    private void createProperties() {
        this.setProperties();
        if (this.rNode.getInfoValue("NodeType").equals("entity")) {
            GOTXMLHelper.addDateAndTime(this.xml);
        }
    }

    public String validateDelete() {
        String currentLayer = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer();
        if (this.xml.attribute("createdLayer") != null && !this.xml.attributeValue("createdLayer").equals(currentLayer)) {
            return String.valueOf(Macros.INFO_FALSE) + ":" + "\u975e\u5f53\u524d\u5c42\u8282\u70b9\u4e0d\u80fd\u5220\u9664";
        }
        return Macros.INFO_TRUE;
    }

    public String validateRollback() {
        return Macros.INFO_TRUE;
    }

    private void createChildren() {
        List childList = this.rNode.getNode().elements("node");
        if (childList.size() > 0) {
            for (Element child : childList) {
                ResolverNode childrNode = ResolverNodeFactory.getRNode(child.attributeValue("name"), child.element("Info").elementText("Type"));
                if (!childrNode.getInfoValue("MinOccurs").equals("1")) continue;
                String id = "";
                NodeGOT childNode = NodeFactory.createNode(child.attributeValue("name"), child.element("Info").elementText("Type"), id);
                this.xml.add(childNode.xml.detach());
            }
        }
    }

    private String getNextInnerId() {
        Element xmlEntity = NodeGOT.getEntity(this.xml);
        String result = xmlEntity.attributeValue("nextInnerId");
        int maxInnerId = Integer.valueOf(result);
        xmlEntity.addAttribute("nextInnerId", String.valueOf(++maxInnerId));
        return result;
    }

    public void doAfterInsert() {
        String unique = this.rNode.getAttributeValue("name", "Unique");
        if ("brother".equals(unique)) {
            this.setBrotherUniqueName(this.xml);
        } else if ("inner".equals(unique)) {
            this.setInnerUniqueName(this.xml);
        }
        if (this.xml.attribute("saved") != null) {
            this.xml.remove(this.xml.attribute("saved"));
        }
        this.setUnsaved();
        this.setInnerId(this);
    }

    private void setInnerId(NodeGOT node) {
        List childList = node.xml.elements();
        ResolverNode childrNode = node.rNode;
        if ("##getInnerId".equals(childrNode.getAttributeValue("id", "Default"))) {
            node.xml.addAttribute("id", node.getNextInnerId());
        }
        for (Element child : childList) {
            if (child.getName().equals("Properties")) continue;
            this.setInnerId(NodeFactory.getNode(child));
        }
    }

    protected void setInnerUniqueName(Element newNode) {
        String origName = newNode.attributeValue("name");
        if (origName.equals("")) {
            origName = "A_" + this.xml.getName();
        }
        String temp = origName;
        String xpath = "./descendant::*[@name]";
        List itemList = NodeGOT.getEntity(this.xml).selectNodes(xpath);
        int last = 0;
        boolean same = false;
        for (Element child : itemList) {
            int num;
            String attrName;
            if (child == this.xml || child.attribute("name") == null || !(attrName = child.attributeValue("name")).startsWith(origName)) continue;
            if (attrName.equals(origName)) {
                same = true;
            }
            if (!NodeGOT.isNumber(attrName = attrName.replace(origName, "")) || (num = Integer.valueOf(attrName).intValue()) <= last) continue;
            last = num;
        }
        if (last > 0) {
            temp = String.valueOf(origName) + ++last;
        } else if (same) {
            temp = String.valueOf(origName) + 1;
        }
        newNode.attribute("name").setValue(temp);
    }

    public static void setBrotherUniqueName1(Element newNode) {
        String strExtends;
        String origName = newNode.attributeValue("name");
        if (!NodeGOT.isEntity(newNode).booleanValue() && !newNode.getName().equals("FormDataSourceField") && !newNode.getName().equals("FormDataSourceRelationItem") && origName != null && origName.contains(".")) {
            origName = origName.substring(origName.indexOf(".") + 1);
        }
        String newName = (strExtends = GOTHelp.getPPAttValue(newNode, "Name", "Extends")).equals("") ? (origName == "" ? "A_" + newNode.getName() : origName) : (origName.equals("") || origName.contains(newNode.getName()) ? strExtends : origName);
        String temp = newName;
        Element parent = newNode.getParent();
        if (NodeGOT.checkParentNodes(parent)) {
            List<String> names = GotXmlDto.getInstance().typesNameList(newNode.getName(), newNode.attributeValue("id"));
            int last = 0;
            boolean same = false;
            for (String name : names) {
                int num;
                if (!name.startsWith(newName)) continue;
                if (name.equals(newName)) {
                    same = true;
                }
                if (!NodeGOT.isNumber(name = name.replace(newName, "")) || (num = Integer.valueOf(name).intValue()) <= last) continue;
                last = num;
            }
            if (last > 0) {
                temp = String.valueOf(newName) + ++last;
            } else if (same) {
                temp = String.valueOf(newName) + 1;
            }
            newNode.attribute("name").setValue(temp);
        } else {
            List childList = parent.elements(newNode.getName());
            int last = 0;
            boolean same = false;
            for (Element child : childList) {
                int num;
                String attrName;
                if (child == newNode || child.attribute("name") == null || !(attrName = child.attributeValue("name")).startsWith(newName)) continue;
                if (attrName.equals(newName)) {
                    same = true;
                }
                if (!NodeGOT.isNumber(attrName = attrName.replace(newName, "")) || (num = Integer.valueOf(attrName).intValue()) <= last) continue;
                last = num;
            }
            if (last > 0) {
                temp = String.valueOf(newName) + ++last;
            } else if (same) {
                temp = String.valueOf(newName) + 1;
            }
            newNode.attribute("name").setValue(temp);
        }
    }

    public void setBrotherUniqueName(Element newNode) {
        String newName;
        String origName = newNode.attributeValue("name");
        String strExtends = GOTHelp.getPPAttValue(newNode, "Name", "Extends");
        if (newNode.getName().equals("TableField") && strExtends.contains(".")) {
            String[] name = strExtends.split("\\.");
            strExtends = name[name.length - 1];
        }
        if (strExtends.equals("")) {
            if (origName.equals("")) {
                newName = "A_" + newNode.getName();
                if (newNode.attribute("version") != null && (GotLayerAndUserDialog.layer.equals("app") || GotLayerAndUserDialog.layer.equals("ext")) && StringUtils.isNotBlank((String)GotLayerAndUserDialog.solution)) {
                    newName = String.valueOf(GotLayerAndUserDialog.solution) + ".A_" + newNode.getName();
                }
            } else {
                newName = origName;
            }
        } else {
            newName = origName.equals("") || origName.contains(newNode.getName()) ? strExtends : origName;
        }
        String temp = newName;
        Element parent = newNode.getParent();
        if (NodeGOT.checkParentNodes(parent)) {
            List<String> names = GotXmlDto.getInstance().typesNameList(newNode.getName(), newNode.attributeValue("id"));
            int last = 0;
            boolean same = false;
            for (String name : names) {
                int num;
                if (!name.startsWith(newName)) continue;
                if (name.equals(newName)) {
                    same = true;
                }
                if (!NodeGOT.isNumber(name = name.replace(newName, "")) || (num = Integer.valueOf(name).intValue()) <= last) continue;
                last = num;
            }
            if (last > 0) {
                temp = String.valueOf(newName) + ++last;
            } else if (same) {
                temp = String.valueOf(newName) + 1;
            }
            newNode.attribute("name").setValue(temp);
        } else {
            List childList = parent.elements(newNode.getName());
            int last = 0;
            boolean same = false;
            for (Element child : childList) {
                int num;
                String attrName;
                if (child == newNode || child.attribute("name") == null || !(attrName = child.attributeValue("name")).startsWith(newName)) continue;
                if (attrName.equals(newName)) {
                    same = true;
                }
                if (!NodeGOT.isNumber(attrName = attrName.replace(newName, "")) || (num = Integer.valueOf(attrName).intValue()) <= last) continue;
                last = num;
            }
            if (last > 0) {
                temp = String.valueOf(newName) + ++last;
            } else if (same) {
                temp = String.valueOf(newName) + 1;
            }
            newNode.attribute("name").setValue(temp);
        }
    }

    public static boolean checkParentNodes(Element parent) {
        return parent == null || parent.getName().equals("Forms") || parent.getName().equals("Tables") || parent.getName().equals("Menus") || parent.getName().equals("Enums") || parent.getName().equals("DataTypes") || parent.getName().equals("Classes");
    }

    public static boolean isNumber(String string) {
        if (string == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
        return pattern.matcher(string).matches();
    }

    public String getInsertAt() {
        return this.rNode.getInfoValue("InsertAt");
    }

    public void doAfterNameModified(String oldName) {
        this.setUnsaved();
    }

    protected void addRelation(Element property) {
        String propertyName = property.elementText("Name");
        String propertyValue = property.elementText("Value");
        List result = null;
        String _rType = this.rNode.getPropertyValue(propertyName, "Type");
        if ("enum".equals(_rType) || "comboBox".equals(_rType)) {
            if (_rType.equals("comboBox") && (propertyValue.indexOf("dt:") == 0 || propertyValue.indexOf("lookup:") == 0)) {
                ArrayList attributes = new ArrayList();
                attributes.addAll(property.attributes());
                for (Attribute attribute : attributes) {
                    property.remove(attribute);
                }
                return;
            }
            if (this.xml.getName().equals("FormItem") && propertyName.equals("DynamicColumn")) {
                if (propertyValue.equals("") && property.attribute("innerid") != null) {
                    property.remove(property.attribute("innerid"));
                    return;
                }
                String xpath = "./FormItem[@name='" + propertyValue + "']";
                result = this.xml.selectNodes(xpath);
                if (result.size() == 0 || result.size() > 1) {
                    GOTMessageDialog.alert("entity\u8282\u70b9\u95f4\u5173\u8054\u7ed3\u679c\u4e0d\u552f\u4e00");
                }
                if (result.size() == 1) {
                    property.addAttribute("innerid", ((Element)result.get(0)).attributeValue("id"));
                }
                return;
            }
            String regular = this.rNode.getPropertyValue(propertyName, "Regular");
            if (regular.equals("")) {
                return;
            }
            if (regular.substring(0, 2).equals("##")) {
                regular = regular.substring(2);
                if (propertyValue.equals("")) {
                    ArrayList attributes = new ArrayList();
                    attributes.addAll(property.attributes());
                    for (Attribute attribute : attributes) {
                        property.remove(attribute);
                    }
                    return;
                }
                if (regular.substring(0, 7).equals("entity.")) {
                    Element baseXML = NodeGOT.getEntity(this.xml).createCopy();
                    regular = regular.substring(7);
                    regular = String.valueOf(regular) + "[@name='" + propertyValue + "']";
                    result = baseXML.selectNodes(regular = regular.substring(regular.indexOf("/") + 1));
                    if (result.size() == 0 || result.size() > 1) {
                        GOTMessageDialog.alert("entity\u5185\u5173\u8054\u7ed3\u679c\u4e0d\u552f\u4e00");
                    }
                    if (result.size() == 1) {
                        property.addAttribute("innerid", ((Element)result.get(0)).attributeValue("id"));
                    }
                } else if (regular.substring(0, 6).equals("parent") || regular.substring(0, 7).equals("brother")) {
                    String[] parentArray;
                    Element parent = this.xml.getParent();
                    String proName = "";
                    String temp = regular.substring(regular.indexOf(".", 0) + 1, regular.lastIndexOf("."));
                    String[] stringArray = parentArray = temp.split(".");
                    int n = parentArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        if (!s.equals("parent")) {
                            proName = s;
                            break;
                        }
                        parent = parent.getParent();
                        ++n2;
                    }
                    Element refPro = GOTHelp.getPPAttElement(parent, "Name", proName);
                    if (refPro.attribute("refentityid") == null) {
                        GOTMessageDialog.alert("Inner\u8282\u70b9\u95f4\u5173\u8054 \u7236\u8282\u70b9\u65e0refentityid");
                        return;
                    }
                    String refEntityId = refPro.attributeValue("refentityid");
                    String basePath = "GOT/";
                    basePath = String.valueOf(basePath) + ResolverNodeFactory.getRNodeByItem(parent).getPropertyValue(proName, "Regular").substring(2);
                    basePath = String.valueOf(basePath) + "[@id=" + refEntityId + "]";
                    regular = (regular = regular.substring(regular.indexOf("/"))).indexOf("[") == -1 ? String.valueOf(basePath) + regular + "[@name='" + property.getText() + "']" : String.valueOf(basePath) + regular.substring(0, regular.length() - 1) + " and @name='" + property.getText() + "']";
                    result = GotXmlDto.getInstance().getGotXMl(regular);
                    if (result.size() == 0 || result.size() > 1) {
                        GOTMessageDialog.alert("inner\u8282\u70b9\u95f4\u5173\u8054\u7ed3\u679c\u4e0d\u552f\u4e00" + result.toString());
                    }
                    if (result.size() == 1) {
                        property.addAttribute("refentityid", refEntityId);
                        property.addAttribute("refinnerid", result.get(0).attributeValue("id"));
                    }
                } else if (regular.substring(0, 4).equals("this")) {
                    String proName = (regular = regular.substring(regular.indexOf(".") + 1)).substring(0, regular.indexOf("."));
                    Element refPro = GOTHelp.getPPAttElement(this.xml, "Name", proName);
                    if (refPro.attribute("refentityid") == null) {
                        GOTMessageDialog.alert("Inner\u8282\u70b9\u95f4\u5173\u8054 \u65e0refentityid");
                        return;
                    }
                    String refEntityId = refPro.attributeValue("refentityid");
                    Element baseEntity = GotXmlDto.getInstance().getEntity(refEntityId);
                    result = baseEntity.selectNodes(regular = (regular = regular.substring(regular.indexOf("/"))).indexOf("[") == -1 ? String.valueOf(regular) + "[@name='" + property.elementText("Value") + "']" : String.valueOf(regular.substring(0, regular.length() - 1)) + " and @name='" + property.elementText("Value") + "']");
                    if (result.size() == 0 || result.size() > 1) {
                        GOTMessageDialog.alert("inner\u8282\u70b9\u95f4\u5173\u8054\u7ed3\u679c\u4e0d\u552f\u4e00" + result.toString());
                    }
                    if (result.size() == 1) {
                        property.addAttribute("refentityid", refEntityId);
                        property.addAttribute("refinnerid", ((Element)result.get(0)).attributeValue("id"));
                    }
                } else {
                    if ((regular = "./" + regular).indexOf("[") == -1) {
                        regular = String.valueOf(regular) + "[@name='" + property.elementText("Value") + "']";
                    } else {
                        regular = regular.substring(0, regular.length() - 1);
                        regular = String.valueOf(regular) + " and @name='" + property.elementText("Value") + "']";
                    }
                    result = GotXmlDto.getInstance().getGotXMl(regular);
                    if (result.size() == 0 || result.size() > 1) {
                        GOTMessageDialog.alert("entity\u8282\u70b9\u95f4\u5173\u8054\u7ed3\u679c\u4e0d\u552f\u4e00");
                    }
                    if (result.size() == 1) {
                        property.addAttribute("refentityid", result.get(0).attributeValue("id"));
                    }
                }
            }
        }
    }

    public void doAfterPropertyModified(Element property, String ... args) {
        this.setUnsaved();
        this.addRelation(property);
        this.doIfExtendsAndFecth(property);
        this.doPropertyTrigger(property);
    }

    protected void setIfExtends(Element item, ResolverNode rNode) {
        List pps = item.element("Properties").elements("Property");
        if (StringUtils.isNotBlank((String)this.getRefentityId()) && item.getName().equals("TableField")) {
            Element dataType = GotXmlDto.getInstance().currentEntityByTypeAndId("DataType", this.getRefentityId());
            for (Element property : pps) {
                if (!property.elementText("Name").equals("CreatedDate")) {
                    if (!rNode.getPropertyValue(property.elementText("Name"), "Nonblank").equals("ifExtends")) continue;
                    property.element("Value").setText(GOTHelp.getPPAttValue(dataType, "Name", property.elementText("Name")));
                    continue;
                }
                break;
            }
        } else {
            for (Element property : pps) {
                if (!property.elementText("Name").equals("CreatedDate")) {
                    if (!rNode.getPropertyValue(property.elementText("Name"), "Nonblank").equals("ifExtends")) continue;
                    property.element("Value").setText(this.rNode.getPropertyValue(property.elementText("Name"), "Default"));
                    continue;
                }
                break;
            }
        }
    }

    protected void clearIfExtends(Element item, ResolverNode rNode) {
        List pps = item.element("Properties").elements("Property");
        for (Element property : pps) {
            if (property.elementText("Name").equals("CreatedDate")) break;
            if ("ifExtends".equals(rNode.getPropertyValue(property.elementText("Name"), "Nonblank"))) {
                property.element("Value").setText("");
            }
            if ("fetch".equals(rNode.getPropertyValue(property.elementText("Name"), "Nonblank"))) {
                List<Element> extendsPro = GOTHelp.getPPAttElementList(item, "Name", "Extends");
                if (extendsPro.isEmpty() || extendsPro.size() == 0) {
                    throw new Error("fetch\u4e0d\u88ab\u5173\u8054\u5230Extends");
                }
                if (extendsPro.get(0).attribute("refentityid") != null) {
                    try {
                        property.element("Value").setText(this.getFetchFinalValue(extendsPro.get(0).attributeValue("refentityid"), property.elementText("Name")));
                    }
                    catch (Exception e) {
                        Logger.getLogger(this.getClass()).error((Object)e);
                    }
                }
            }
            if (property.elementText("Name").equals("ChangeCase")) {
                property.element("Value").setText("");
                continue;
            }
            if (property.elementText("Name").equals("Trim")) {
                property.element("Value").setText("");
                continue;
            }
            if (!property.elementText("Name").equals("NumOfDecimals") || !item.getName().equals("Table")) continue;
            property.element("Value").setText("");
        }
    }

    private String getFetchFinalValue(String dataTypeId, String proName) {
        Element dataType = GotXmlDto.getInstance().currentEntityByTypeAndId("DataType", dataTypeId);
        if (dataType == null) {
            return "";
        }
        List<Element> property = GOTHelp.getPPAttElementList(dataType, "Name", proName);
        if (property.size() < 1) {
            return "";
        }
        if (!property.get(0).elementText("Value").equals("")) {
            return property.get(0).elementText("Value");
        }
        Element dataTypeElement = dataType;
        Element extendsPro = GOTHelper.getProperty((Element)dataTypeElement, (String)"Extends");
        Attribute refentityidattr = extendsPro.attribute("refentityid");
        if (refentityidattr != null) {
            return this.getFetchFinalValue(refentityidattr.getStringValue(), proName);
        }
        return "";
    }

    protected void doIfExtendsAndFecth(Element property) {
        String proName = property.elementText("Name");
        String proValue = property.elementText("Value");
        if (this.isIfExtendsRelated(proName).booleanValue()) {
            if (proValue.equals("")) {
                this.setIfExtends(this.xml, this.rNode);
            } else {
                this.clearIfExtends(this.xml, this.rNode);
            }
        }
    }

    protected void setUnsaved() {
        Element _entityNode = NodeGOT.getEntity(this.xml);
        if (_entityNode.attribute("saved") == null) {
            _entityNode.addAttribute("saved", "0");
        }
        _entityNode.addAttribute("modifiedLayer", ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer());
        this.xml.addAttribute("modifiedLayer", ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer());
        int base = ((LayerLevelManager)ObjectContainer.getInstance(LayerLevelManager.class)).getLayerLevel(((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer()) * 10000;
        int now = Integer.parseInt(_entityNode.attributeValue("nextInnerId"));
        if (now < base) {
            _entityNode.addAttribute("nextInnerId", String.valueOf(base));
        }
    }

    public void setSelfUnsaved() {
        this.setUnsaved();
    }

    protected void doPropertyTrigger(Element property) {
        String qname;
        String name;
        if (property.elementText("Name").equals("Extends") && ((name = this.xml.attributeValue("name")).contains(qname = this.xml.getName()) || "".equals(name))) {
            NodeGOT.setBrotherUniqueName1(this.xml);
        }
    }

    public static Element getEntity(Element item) {
        while (item != null) {
            if (NodeGOT.isEntity(item).booleanValue()) {
                return item;
            }
            item = item.getParent();
        }
        return null;
    }

    public static Boolean isEntity(Element node) {
        if (node.attribute("version") != null) {
            return true;
        }
        return false;
    }

    public static Boolean validateUniqueBrother(Node item, String newName) {
        String lowerCaseNewName = newName.toLowerCase();
        String itemNodeKind = item.getNodeTypeName();
        if (itemNodeKind.equals("Attribute")) {
            Element node = item.getParent();
            List<Element> brother = NodeGOT.checkParentNodes(node.getParent()) ? GotXmlDto.getInstance().currentElements(String.valueOf(node.getName()) + "s") : node.getParent().elements();
            for (Element child : brother) {
                if (child.getName().equals("Properties") || child.equals(node) || !child.attributeValue(item.getName()).toLowerCase().equals(lowerCaseNewName)) continue;
                return false;
            }
        } else if (itemNodeKind.equals("Element") && item.getName().equals("Property")) {
            Element node = item.getParent().getParent();
            List<Element> brother = node.getParent() == null ? GotXmlDto.getInstance().currentElements(String.valueOf(node.getName()) + "s") : node.getParent().elements();
            for (Element child : brother) {
                if (child.getName().equals("Properties") || child == node) continue;
                Element ps = (Element)child.elements("Properties").get(0);
                List psList = ps.elements();
                for (Element p : psList) {
                    if (!p.elementText("Name").equals(item.getParent().elementText("Name")) || !p.elementText("Value").equals(item.getParent().elementText("Value"))) continue;
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    protected static Boolean validateUniqueOuter(Element item, String newName) {
        return true;
    }

    private static Boolean validateAttrUniqueAllChild(Element item, Element element, String newName) {
        List inner = element.elements();
        Element parent = item.getParent();
        for (Element child : inner) {
            if (child.attribute(item.getName()) != null && parent != child && child.attributeValue(item.getName()).toLowerCase().equals(newName.toLowerCase())) {
                return false;
            }
            if (NodeGOT.validateAttrUniqueAllChild(item, child, newName).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static Boolean validateUniqueInner(Node item, String newName) {
        String itemNodeKind = item.getNodeTypeName();
        Element entity = NodeGOT.getEntity(item.getParent());
        Element parent = item.getParent();
        if (itemNodeKind.equals("Attribute") || itemNodeKind.equals("attribute")) {
            List inner = entity.elements();
            for (Element child : inner) {
                if (child.attribute(item.getName()) != null && parent != child && child.attributeValue(item.getName()).toLowerCase().equals(newName.toLowerCase())) {
                    return false;
                }
                if (NodeGOT.validateAttrUniqueAllChild(item.getParent(), child, newName).booleanValue()) continue;
                return false;
            }
            return true;
        }
        if (itemNodeKind.equals("Element") && item.getName().equals("Property")) {
            String xpath = ".//Property";
            List inner = entity.selectNodes(xpath);
            Element item_ = (Element)item;
            for (Element child : inner) {
                if (child == item || !child.elementText("Name").equals(item_.elementText("Name")) || !child.elementText("Value").equals(item_.elementText("Value"))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Boolean getContextMenuShortCutEnable(Element node, String type) {
        if (node == null) {
            return false;
        }
        if (type == ResovlerContextMenuValue.SAVE && NodeGOT.getEntity(node) != null) {
            return true;
        }
        ResolverNode rnode = ResolverNodeFactory.getRNode(node.getName(), node.attribute("type") == null ? node.attributeValue("type") : "");
        String result = rnode.getContextMenuValue(type);
        return result == "Y";
    }

    private static Boolean treeRightMenu_filterFunc(Element item) {
        if (item.attribute("visible") != null && item.attributeValue("visible").equals("false")) {
            return false;
        }
        return true;
    }

    public static Boolean canRevert(Element node) {
        if (node == null) {
            return false;
        }
        String currentLayer = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer();
        if (NodeGOT.isEntity(node).booleanValue() && node.attribute("saved") == null && !currentLayer.equals(node.attributeValue("createdLayer")) && currentLayer.equals(node.attributeValue("modifiedLayer"))) {
            return true;
        }
        return false;
    }

    public static Boolean canPromote(Element node) {
        if (node == null) {
            return false;
        }
        String currentLayer = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer();
        if (NodeGOT.isEntity(node).booleanValue() && node.attribute("saved") == null && !currentLayer.equals(node.attributeValue("createdLayer")) && !currentLayer.equals(node.attributeValue("modifiedLayer"))) {
            return true;
        }
        return false;
    }

    public static int setContextMenu(Element node) {
        Boolean _ref;
        Boolean _duplicate;
        String nodeType = node.attribute("type") != null ? node.attributeValue("type") : "";
        ResolverNode rnode = ResolverNodeFactory.getRNode(node.getName(), nodeType);
        int num = 0;
        List treeRightDataList = treeRightMenuData.elements("menuitem");
        Boolean _newWindow = rnode.getContextMenuValue("NewWindow").equals("Y");
        if (_newWindow.booleanValue()) {
            ++num;
        }
        ((Element)treeRightDataList.get(0)).addAttribute("visible", _newWindow.toString());
        Boolean _showXML = rnode.getContextMenuValue("ShowXML").equals("Y");
        if (_showXML.booleanValue()) {
            ++num;
        }
        ((Element)treeRightDataList.get(1)).addAttribute("visible", _showXML.toString());
        Boolean _new = rnode.getContextMenuValue("New").equals("Y");
        if (_new.booleanValue()) {
            ++num;
        }
        ((Element)treeRightDataList.get(3)).addAttribute("visible", _new.toString());
        if (_new.booleanValue()) {
            List rNodeList = rnode.getNode().elements("node");
            Element _node3 = (Element)treeRightDataList.get(3);
            List _node3items = _node3.elements();
            for (Element element : _node3items) {
                _node3.remove(element);
            }
            if (rNodeList.size() > 1) {
                ArrayList<Element> tmp = new ArrayList<Element>();
                for (Element child : rNodeList) {
                    Element menuitem = GOTXMLHelper.createElementByXMLString("<menuitem func='new'/>");
                    String _type = child.element("Info").elementText("Type");
                    menuitem.addAttribute("label", !_type.equals("") ? _type : child.attributeValue("name"));
                    menuitem.addAttribute("nodeType", String.valueOf(child.attributeValue("name")) + "." + _type);
                    menuitem.addAttribute("visible", "true");
                    tmp.add(menuitem);
                }
                for (Element element : tmp) {
                    _node3.add(element.detach());
                }
            }
        }
        if ((_duplicate = Boolean.valueOf(rnode.getContextMenuValue("Duplicate").equals("Y"))).booleanValue()) {
            ++num;
        }
        ((Element)treeRightDataList.get(4)).addAttribute("visible", _duplicate.toString());
        Boolean _save = rnode.getContextMenuValue("Save").equals("Y");
        if (_save.booleanValue()) {
            ++num;
            if (NodeGOT.canPromote(node).booleanValue()) {
                ((Element)treeRightDataList.get(6)).addAttribute("label", "\u63d0\u5347");
            } else {
                ((Element)treeRightDataList.get(6)).addAttribute("label", "\u4fdd\u5b58%S");
            }
        }
        ((Element)treeRightDataList.get(6)).addAttribute("visible", _save.toString());
        Boolean _sync = rnode.getContextMenuValue("Sync").equals("Y");
        if (_sync.booleanValue()) {
            ++num;
        }
        ((Element)treeRightDataList.get(7)).addAttribute("visible", _sync.toString());
        Boolean _restore = rnode.getContextMenuValue("Restore").equals("Y");
        if (_restore.booleanValue()) {
            ++num;
        }
        ((Element)treeRightDataList.get(9)).addAttribute("visible", _restore.toString());
        Boolean _del = rnode.getContextMenuValue("Delete").equals("Y");
        if (_del.booleanValue()) {
            ++num;
            if (NodeGOT.canRevert(node).booleanValue()) {
                ((Element)treeRightDataList.get(10)).attribute("label").setValue("\u56de\u6eda");
            } else {
                ((Element)treeRightDataList.get(10)).attribute("label").setValue("\u5220\u9664&Delete");
            }
        }
        ((Element)treeRightDataList.get(10)).addAttribute("visible", _del.toString());
        Boolean _m = true;
        if (node.getName().equals("Table") || node.getName().equals("Form") || node.getName().equals("FormDataSource") || "Button".equals(node.attributeValue("type"))) {
            ((Element)treeRightDataList.get(11)).addAttribute("visible", "true");
            if (!"0".equals(node.attributeValue("version"))) {
                ((Element)treeRightDataList.get(11)).addAttribute("enabled", "true");
            } else {
                ((Element)treeRightDataList.get(11)).addAttribute("enabled", "false");
            }
        } else {
            ((Element)treeRightDataList.get(11)).addAttribute("visible", "false");
            _m = false;
        }
        if (_m.booleanValue()) {
            ++num;
        }
        if ((_ref = Boolean.valueOf(node.attribute("id") != null)).booleanValue()) {
            ++num;
        }
        ((Element)treeRightDataList.get(13)).addAttribute("visible", _ref.toString());
        Boolean _layerEnable = NodeGOT.isEntity(node) != false && node.attribute("createdLayer") != null && node.attributeValue("createdLayer").equals(((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer());
        if (_layerEnable.booleanValue()) {
            ++num;
        }
        ((Element)treeRightDataList.get(14)).addAttribute("visible", _layerEnable.toString());
        Boolean bool = !(_newWindow == false && _showXML == false || _new == false && _duplicate == false && _save == false && _sync == false && _restore == false && _del == false && _m == false && _ref == false);
        if (bool.booleanValue()) {
            ++num;
        }
        ((Element)treeRightDataList.get(2)).addAttribute("visible", bool.toString());
        bool = !(_new == false && _duplicate == false || _save == false && _sync == false && _restore == false && _del == false && _m == false && _ref == false);
        if (bool.booleanValue()) {
            ++num;
        }
        ((Element)treeRightDataList.get(5)).addAttribute("visible", bool.toString());
        bool = !(_save == false && _sync == false || _restore == false && _del == false && _m == false && _ref == false);
        if (bool.booleanValue()) {
            ++num;
        }
        ((Element)treeRightDataList.get(8)).addAttribute("visible", bool.toString());
        bool = (_restore != false || _del != false || _m != false) && _ref != false;
        if (bool.booleanValue()) {
            ++num;
        }
        ((Element)treeRightDataList.get(12)).addAttribute("visible", bool.toString());
        if (node.getName().equals("Table")) {
            ((Element)treeRightDataList.get(15)).addAttribute("visible", "true");
        } else {
            ((Element)treeRightDataList.get(15)).addAttribute("visible", "false");
        }
        if (node.getName().equals("FormDataSource")) {
            ((Element)treeRightDataList.get(16)).addAttribute("visible", "true");
        } else {
            ((Element)treeRightDataList.get(16)).addAttribute("visible", "false");
        }
        if ("Enum".equals(node.getName()) || "DataType".equals(node.getName()) || "Table".equals(node.getName()) || "Form".equals(node.getName()) || "MenuItem".equals(node.getName()) || "Menu".equals(node.getName())) {
            String entityId = node.attributeValue("id");
            String modifiedLayer = node.attributeValue("modifiedLayer");
            boolean visible = false;
            if ("app".equals(modifiedLayer)) {
                String solutionName = entityId.substring(0, entityId.lastIndexOf("."));
                visible = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCanEditSolutionList().contains(solutionName);
            } else if ("plg".equals(modifiedLayer)) {
                String solutionPuginName = entityId.substring(0, entityId.lastIndexOf("."));
                SolutionPluginDefinition solutionPluginDefinition = ((SolutionPluginDefinitionManager)ObjectContainer.getInstance(SolutionPluginDefinitionManager.class)).getSolutionPlugin(solutionPuginName);
                visible = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCanEditSolutionPluginList(solutionPluginDefinition.getSolutionName()).contains(solutionPuginName);
            } else if ("ext".equals(modifiedLayer)) {
                String createdLayer = node.attributeValue("createdLayer");
                if ("plg".equals(createdLayer)) {
                    String solutionPluginName = entityId.substring(0, entityId.lastIndexOf("."));
                    SolutionPluginDefinition solutionPluginDefinition = ((SolutionPluginDefinitionManager)ObjectContainer.getInstance(SolutionPluginDefinitionManager.class)).getSolutionPlugin(solutionPluginName);
                    visible = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCanEditExtensionList().contains(solutionPluginDefinition.getSolutionName());
                } else {
                    String soluitionName = entityId.substring(0, entityId.lastIndexOf("."));
                    visible = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCanEditExtensionList().contains(soluitionName);
                }
            } else {
                visible = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCanEditLayerList().contains(modifiedLayer);
            }
            ((Element)treeRightDataList.get(17)).addAttribute("visible", Boolean.toString(visible));
        } else {
            ((Element)treeRightDataList.get(17)).addAttribute("visible", "false");
        }
        return num;
    }

    public String allowPropertyEdit(String propertyName) {
        if (((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer().equals(LayerType.PACKAGE)) {
            GOTMessageDialog.alert("\u5f53\u524d\u5c42\u4e3a\u4e8c\u8fdb\u5236\u5c42\uff0c\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c");
            return Macros.INFO_OPR_LAYERBINARAY_NOT_ALLOW;
        }
        switch (propertyName) {
            case "CreatedBy": 
            case "ModifiedBy": 
            case "ModifiedDate": 
            case "ModifiedTime": 
            case "CreatedDate": 
            case "CreatedTime": {
                return Macros.INFO_OPR_NOT_ALLOW;
            }
            case "StringSize": 
            case "NumOfDecimals": {
                Element pro = GOTHelp.getPPAttElement(this.xml, "Name", "Extends");
                if (pro == null) {
                    return Macros.INFO_TRUE;
                }
                if (pro.elementText("Value").equals("")) {
                    return Macros.INFO_TRUE;
                }
                return Macros.INFO_FALSE;
            }
        }
        Element entity = NodeGOT.getEntity(this.xml);
        if (entity.attribute("locked") != null && entity.attributeValue("locked").equals("true") && entity.attribute("createdLayer") != null && !entity.attributeValue("createdLayer").equals(((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer())) {
            return Macros.INFO_OPR_LAYERLOCK_NOT_ALLOW;
        }
        DesignerContext context = (DesignerContext)ObjectContainer.getInstance(DesignerContext.class);
        entity.attributeValue("createdLayer");
        String modifiedLayer = entity.attributeValue("modifiedLayer");
        if (!modifiedLayer.equals(context.getEditLayer())) {
            return Macros.INFO_OPR_LAYERLOCK_NOT_ALLOW;
        }
        return Macros.INFO_TRUE;
    }

    public List<String> getPropertyItemEditorArray(String propertyName, String fixedRegular, Element fixedBaseXML) {
        ArrayList<String> array = new ArrayList<String>();
        if (!fixedRegular.equals("")) {
            array = new ArrayList();
            List list = fixedBaseXML == null ? GotXmlDto.getInstance().getGotXMl(fixedRegular) : fixedBaseXML.selectNodes(fixedRegular);
            for (Element item : list) {
                if (item == this.xml) continue;
                array.add(item.attributeValue("name"));
            }
            array.add(0, "");
            return array;
        }
        if (this.rNode.getPropertyValue(propertyName, "Type").equals("boolean")) {
            array = new ArrayList();
            array.add("");
            array.add("true");
            array.add("false");
        } else if (this.rNode.getPropertyValue(propertyName, "Type").equals("enum") || this.rNode.getPropertyValue(propertyName, "Type").equals("comboBox")) {
            try {
                String regular = this.rNode.getPropertyValue(propertyName, "Regular");
                if (regular.equals("")) {
                    if ("AttachmentFileType".equals(propertyName)) {
                        array.addAll(FromToMapping.AttachmentFileTypeMap.keySet());
                    } else {
                        array = null;
                    }
                } else if (regular.substring(0, 2).equals("##")) {
                    String proName;
                    array = new ArrayList();
                    regular = regular.substring(2);
                    Element baseXML = null;
                    if (regular.substring(0, 7).equals("entity.")) {
                        baseXML = NodeGOT.getEntity(this.xml).createCopy();
                        regular = regular.substring(7);
                        regular = regular.substring(regular.indexOf("/") + 1);
                    } else if (regular.substring(0, 6).equals("parent")) {
                        String[] parentArray;
                        Element parent = this.xml.getParent();
                        String proName2 = "";
                        String temp = regular.substring(regular.indexOf(".", 0) + 1, regular.lastIndexOf("."));
                        String[] stringArray = parentArray = temp.split("\\.");
                        int n = parentArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String s = stringArray[n2];
                            if (!s.equals("parent")) {
                                proName2 = s;
                                break;
                            }
                            parent = parent.getParent();
                            ++n2;
                        }
                        Element property = GOTHelp.getPPAttElement(parent, "Name", proName2);
                        String proValue = property.elementText("Value");
                        if (proValue.equals("")) {
                            array.add("");
                            return array;
                        }
                        String refEntityId = property.attributeValue("refentityid");
                        String basePath = "";
                        basePath = String.valueOf(basePath) + ResolverNodeFactory.getRNodeByItem(parent).getPropertyValue(proName2, "Regular").substring(2);
                        basePath = String.valueOf(basePath) + "[@id='" + refEntityId + "']";
                        List<Element> baseList = GotXmlDto.getInstance().getGotXMl(basePath);
                        baseXML = baseList.get(0).createCopy();
                        regular = regular.substring(regular.indexOf("/") - 1);
                    } else if (regular.substring(0, 7).equals("brother")) {
                        regular = regular.substring(regular.indexOf(".") + 1);
                        proName = regular.substring(0, regular.indexOf("."));
                        List brothers = this.xml.getParent().elements();
                        List<Element> properties = GOTHelp.getPPAttElementList((Element)brothers.get(0), "Name", proName);
                        Element selfProperty = GOTHelp.getPPAttElement(this.xml, "Name", proName);
                        String tempstr = "DataDictionary/Tables/Table[";
                        for (Element property : properties) {
                            if (property.attribute("refentityid") == null || property == selfProperty) continue;
                            tempstr = String.valueOf(tempstr) + "@id =" + property.attributeValue("refentityid") + " or ";
                        }
                        tempstr = String.valueOf(tempstr.substring(0, tempstr.length() - 4)) + "]";
                        regular = String.valueOf(tempstr) + regular.substring(regular.indexOf("/"));
                    } else if (regular.substring(0, 4).equals("this")) {
                        proName = (regular = regular.substring(regular.indexOf(".") + 1)).substring(0, regular.indexOf("."));
                        Element property = GOTHelp.getPPAttElement(this.xml, "Name", proName);
                        if (property.attribute("refentityid") == null) {
                            array.add("");
                            return array;
                        }
                        String refEntityId = property.attributeValue("refentityid");
                        String basePath = "";
                        basePath = String.valueOf(basePath) + ResolverNodeFactory.getRNodeByItem(this.xml).getPropertyValue(proName, "Regular").substring(2);
                        basePath = String.valueOf(basePath) + "[@id='" + refEntityId + "']";
                        List<Element> baseList = GotXmlDto.getInstance().getGotXMl(basePath);
                        baseXML = baseList.get(0).createCopy();
                        regular = regular.substring(regular.indexOf("/"));
                    }
                    if (regular.startsWith("//")) {
                        regular = "." + regular;
                    }
                    List<Element> list = baseXML != null ? baseXML.selectNodes(regular) : GotXmlDto.getInstance().getGotXMl(regular);
                    for (Element item : list) {
                        if (item.asXML().equals(this.xml.asXML()) || item.attribute("saved") != null) continue;
                        array.add(item.attributeValue("name"));
                    }
                    array.add(0, "");
                } else {
                    String[] strs;
                    String[] stringArray = strs = regular.split("\\|");
                    int n = strs.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String string = stringArray[n3];
                        array.add(string);
                        ++n3;
                    }
                    array.add(0, "");
                }
            }
            catch (Exception e) {
                array = null;
                GOTMessageDialog.alert(e);
            }
        }
        return array;
    }

    protected String getPropertyStrict(String propertyName) {
        return null;
    }

    protected void setProperties() {
        List<Element> array = this.rNode.getProperties();
        for (Element property : array) {
            GOTXMLHelper.addProperty(this.xml, property.elementText("Name"), property.element("Default").getText());
        }
    }

    public static List<Object> getExtended(Element node, Element base) {
        ArrayList<Object> array = new ArrayList<Object>();
        String extendName = node.attributeValue("name");
        String xpath = "/descendant::Property";
        List allProList = base.selectNodes(xpath);
        for (Element pro : allProList) {
            if (!pro.elementText("Name").equals("Extends") || !pro.elementText("Value").equals(extendName)) continue;
            node = pro.getParent().getParent();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name", (Object)node.attributeValue("name"));
            jsonObject.put("qname", (Object)node.getName());
            array.add(jsonObject);
        }
        return array;
    }

    public NodeGOT getAccpDragNewNode(Element src) {
        return null;
    }

    protected NodeGOT doAccpDragNew(String name, String type) {
        NodeGOT node = NodeFactory.createNode(name, type, "");
        return node;
    }

    public String getAccpDragNewInsertBase() {
        return "false";
    }

    public String validateAccpDragMove(Element srcItem, MouseEvent event) {
        return "true";
    }

    public String validateAccpDragNew(Element srcItem) {
        return "true";
    }

    public Element getInsertChildBefore(Element parent) {
        return null;
    }

    public void doAfterDragDroped() {
    }

    public String moveType(Element srcItem, MouseEvent event) {
        return "false";
    }

    public Boolean isSibling(Element srcItem) {
        if (srcItem.getName().equals(this.xml.getName())) {
            return true;
        }
        return false;
    }

    public Boolean switchSelf() {
        return false;
    }

    public String allowDcEnter() {
        return "true";
    }

    public String allowEdit() {
        if (((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer().equals(LayerType.PACKAGE)) {
            return "\u5f53\u524d\u5c42\u4e3a\u4e8c\u8fdb\u5236\u5c42,\u4e0d\u5141\u8bb8\u7f16\u8f91";
        }
        if (this.rNode.getInfoValue("Editable").equals("false")) {
            return "\u8be5\u8282\u70b9\u4e0d\u5141\u8bb8\u88ab\u7f16\u8f91";
        }
        if (!this.xml.attributeValue("createdLayer").equals(((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer())) {
            return "\u8be5\u8282\u70b9\u4e3a\u4e0b\u5c42\u521b\u5efa,\u4e0d\u5141\u8bb8\u7f16\u8f91";
        }
        return "true";
    }

    public Boolean autoEdit() {
        return true;
    }

    public Boolean allowNew() {
        Element entity = NodeGOT.getEntity(this.xml);
        if (entity != null && entity.attribute("locked") != null && entity.attributeValue("locked").equals("locked") && entity.attribute("createdLayer") != null && !entity.attributeValue("createdLayer").equals(((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer())) {
            return false;
        }
        return true;
    }

    protected Boolean isNameValid(String name) {
        if (name != null && name.indexOf(".") != -1) {
            int lastIndex = name.lastIndexOf(".");
            name = name.substring(lastIndex + 1);
        }
        Boolean isjavakey = javakeys.contains(name.trim());
        String reg = "^[A-Z][a-zA-Z0-9_]*$";
        Boolean b = name.matches(reg);
        if (b.booleanValue() && !isjavakey.booleanValue()) {
            return true;
        }
        return false;
    }

    public Boolean validateNewName(String newName) {
        String isBlank = this.rNode.getAttributeValue("name", "Nonblank");
        if (!"false".equals(isBlank) && newName.equals("")) {
            return false;
        }
        if (!this.isNameValid(newName).booleanValue()) {
            return false;
        }
        String nameUnique = this.rNode.getAttributeValue("name", "Unique");
        if ("brother".equals(nameUnique)) {
            Attribute el = this.xml.attribute("name");
            return NodeGOT.validateUniqueBrother((Node)el, newName);
        }
        if ("inner".equals(nameUnique)) {
            Attribute el = this.xml.attribute("name");
            return NodeGOT.validateUniqueInner((Node)el, newName);
        }
        return true;
    }

    protected Boolean isIfExtendsRelated(String proName) {
        return false;
    }

    public Boolean editOnCreate() {
        return false;
    }

    public void doBeforeInsert() {
    }

    public void showXML(String info) {
        TreeOperationInfo.addInfo(info);
    }

    public Boolean isFocusAfterDragDroped(Element src) {
        return true;
    }

    /*
     * Exception decompiling
     */
    public ValidationResultEvent validateProperty(Element property) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[17] lbl146 : CaseStatement: default:\u000a, @NONE, blocks:[17] lbl146 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ValidationResultEvent validatePropertyChanged(Element property) {
        return null;
    }
}

