package info.gongqi.got.util;

import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.ObjectContainer;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import javax.imageio.ImageIO;

import org.dom4j.Attribute;
import org.dom4j.Element;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.swt.SWTResourceManager;

public class ComposeIMG {
	
	public static String TABLE = "Table";
	public static String TABLEFIELD = "TableField";
	public static String TABLEFIELDGROUPITEM = "TableFieldGroupItem";
	public static String FORM = "Form";
	public static String FORMDATASOURCEFIELD = "FormDataSourceField";
	public static String DATATYPE = "DataType";
	public static String ENUM = "Enum";
	public static String MENU = "Menu";
	public static String MENUITEM = "MenuItem";
	public static String REPORTFIELD = "ReportField";
	
	public final static String TYPE_STRING = "String";
	public final static String TYPE_ENUM = "Enum";
	public final static String TYPE_LONG = "Long";
	public final static String TYPE_TIME = "Time";
	public final static String TYPE_DATE = "Date";
	public final static String TYPE_DECIMAL = "Decimal";
	public final static String TYPE_COMPONENT = "Component";
	public final static String TYPE_BOOLEAN = "Boolean";

	protected static Boolean currentLayer = false;
	protected static Boolean locked = false;
	protected static Boolean invisible = false;
	protected static Boolean deprecated = false;
	protected static Boolean unsaved = false;
	protected static Boolean baseTypeImg = false;
	protected static String data_type;
	protected static String data_type_img_name;
	
	protected static String layer_currentLayer = "/resources/res/layer_currentLayer.png";
	protected static String layer_deprecated = "/resources/res/layer_deprecated.png";
	protected static String layer_invisible = "/resources/res/layer_invisible.png";
	protected static String layer_locked = "/resources/res/layer_locked.png";
	protected static String layer_unsaved = "/resources/res/layer_unsaved.png";
	
	public static Map<String, Image> imgMap = new HashMap<String, Image>();
	
	public static Image drawImg(Element node){
		Image image = null;
		baseTypeImg = false;
		String imgName = treeItemImgName(node);
		choiceRes(node);
		if(!currentLayer && !locked && !invisible && !deprecated && !unsaved && !baseTypeImg){
			image = drawImgDef(node);
			return image;
		}
		String mapKey = locked.toString() + invisible.toString() + currentLayer.toString() + 
				deprecated.toString() + unsaved.toString() + imgName + node.getName();
		
		if(data_type_img_name != null && !"".equals(data_type_img_name)){
			mapKey += data_type_img_name;
		}
		
		if(imgMap.get(mapKey) != null){
			baseTypeImg = false;
			locked = false;
			invisible = false;
			currentLayer = false;
			deprecated = false;
			unsaved = false;
			return imgMap.get(mapKey);
		}
		
		String imgPath = "/resources/nodeicons/" + imgName + ".png";
		InputStream inStream = ComposeIMG.class.getResourceAsStream(imgPath);
		if(inStream == null){
			System.out.println("没有找到对应的图标，path:" + imgPath);
			return image;
		}
		
		try {
			BufferedImage buf = ImageIO.read(inStream);
			
			if(baseTypeImg){
				if(data_type_img_name != null && !"".equals(data_type_img_name)){
					inStream = ComposeIMG.class.getResourceAsStream("/resources/nodeicons/" + data_type_img_name + ".png");
					if(inStream == null){
						System.out.println("/resources/nodeicons/" + data_type_img_name + ".png");
					}else{
						BufferedImage buf_locked = ImageIO.read(inStream);
						Graphics2D graphics2d = buf.createGraphics();
						int x = buf.getWidth() - buf_locked.getWidth();
						int y = buf.getHeight() - buf_locked.getHeight();
						graphics2d.drawImage(buf_locked, x, y, buf_locked.getWidth(), buf_locked.getHeight(), null);
						graphics2d.dispose();
						baseTypeImg = false;
					}
				}
			}
			
			//右下角 locked是在右下角
			if(locked){
				inStream = ComposeIMG.class.getResourceAsStream(layer_locked);
				BufferedImage buf_locked = ImageIO.read(inStream);
				Graphics2D graphics2d = buf.createGraphics();
				int x = buf.getWidth() - buf_locked.getWidth();
				int y = buf.getHeight() - buf_locked.getHeight();
				graphics2d.drawImage(buf_locked, x, y, buf_locked.getWidth(), buf_locked.getHeight(), null);
				graphics2d.dispose();
				locked = false;
			}
			
			//右上角
			if(invisible){
				inStream = ComposeIMG.class.getResourceAsStream(layer_invisible);
				BufferedImage buf_locked = ImageIO.read(inStream);
				Graphics2D graphics2d = buf.createGraphics();
				int x = buf.getWidth() - buf_locked.getWidth();
				graphics2d.drawImage(buf_locked, x, 0, buf_locked.getWidth(), buf_locked.getHeight(), null);
				graphics2d.dispose();
				invisible = false;
			}
			
			//左下角
			if(currentLayer){
				inStream = ComposeIMG.class.getResourceAsStream(layer_currentLayer);
				BufferedImage buf_locked = ImageIO.read(inStream);
				Graphics2D graphics2d = buf.createGraphics();
				int y = buf.getHeight() - buf_locked.getHeight();
				graphics2d.drawImage(buf_locked, 0, y, buf_locked.getWidth(), buf_locked.getHeight(), null);
				graphics2d.dispose();
				currentLayer = false;
			}
			
			//中间1
			if(deprecated){
				inStream = ComposeIMG.class.getResourceAsStream(layer_deprecated);
				BufferedImage buf_locked = ImageIO.read(inStream);
				Graphics2D graphics2d = buf.createGraphics();
				int x = buf.getWidth() - buf_locked.getWidth();
				int y = buf.getHeight() - buf_locked.getHeight();
				graphics2d.drawImage(buf_locked, x/2, y/2, buf_locked.getWidth(), buf_locked.getHeight(), null);
				graphics2d.dispose();
				deprecated = false;
			}
			
			//中间2
			if(unsaved){
				inStream = ComposeIMG.class.getResourceAsStream(layer_unsaved);
				BufferedImage buf_locked = ImageIO.read(inStream);
				Graphics2D graphics2d = buf.createGraphics();
				int x = buf.getWidth() - buf_locked.getWidth();
				int y = buf.getHeight() - buf_locked.getHeight();
				graphics2d.drawImage(buf_locked, x/2-1, y/2-1, buf_locked.getWidth(), buf_locked.getHeight(), null);
				graphics2d.dispose();
				unsaved = false;
			}

			InputStream inputStream = bufferedImageToInputStream(buf);
			if(inputStream != null){
				image = getImage(inputStream);
			}
			inStream.close();
			imgMap.put(mapKey, image);
		} catch (IOException e) {
			e.printStackTrace();
		}
		return image;
		
	}
	
	public static Image drawImgDef(Element node){
		Image image = null;
		String imgName = treeItemImgName(node);
		if("".equals(imgName)){
			return image;
		}
		if(imgMap.containsKey(imgName)){
			return imgMap.get(imgName);
		}
		String imgPath = "/resources/nodeicons/" + imgName + ".png";
		image = SWTResourceManager.getImage(ComposeIMG.class, imgPath);
		imgMap.put(imgName, image);
		return image;
		
	}
	
	public static Image drawImgDef(String imgName){
		Image image = null;
		if("".equals(imgName) || imgName.startsWith("Node_")){
			imgName = "Default";
		}
		if(imgMap.containsKey(imgName)){
			return imgMap.get(imgName);
		}
		String imgPath = "/resources/nodeicons/" + imgName + ".png";
		image = SWTResourceManager.getImage(ComposeIMG.class, imgPath);
		if(image == null){
			image = SWTResourceManager.getImage(ComposeIMG.class, "/resources/nodeicons/Default.png");
		}
		imgMap.put(imgName, image);
		return image;
		
	}
	
	private static String treeItemImgName(Element node){
//		String value_path = LoadXML.map.get(node.getName() + "_got_file_path");
//		if(value_path != null && !"".equals(value_path)){
//			return 
//		}
		String name = node.getName();
		String imgName = "";
		if(!"".endsWith(name) && name != null){
			imgName = name;
			if(!name.equals(DATATYPE) && !name.equals(TABLEFIELD) && !name.equals(FORMDATASOURCEFIELD) && !name.equals(REPORTFIELD)){
				Attribute attribute = node.attribute("type");
				if(attribute != null && !name.equals(TABLEFIELDGROUPITEM)){
					imgName += attribute.getText().replace("Editor", "");
					return imgName;
				}
			}
			
			if(GOTUtil.imgNames.contains(imgName + ".png")){
				return imgName;
			}
		}
		
		Attribute attribute = node.attribute("saved");
		if(attribute != null && "0".equals(attribute.getText())){
			imgName = "DefaultUnsaved";
		}else{
			
			imgName = "Default";
		}
		
		return imgName;
	}
	
	private static void choiceRes(Element node){
		Attribute attribute = node.attribute("nextInnerId");
		if(attribute != null){
			attribute = node.attribute("createdLayer");
			if(attribute != null){
				if(attribute.getText().equals(ObjectContainer.getInstance(LayerService.class).getCurrentLayer())){
					currentLayer = true;
				}
			}

			attribute = node.attribute("locked");
			if(attribute != null){
				if(attribute.getText().equals("true")){
					locked = true;
				}
			}
			
			attribute = node.attribute("visible");
			if(attribute != null){
				if(attribute.getText().equals("false")){
					invisible = true;
				}
			}
			
			attribute = node.attribute("deprecated");
			if(attribute != null){
				if(attribute.getText().equals("true")){
					deprecated = true;
				}
			}
			
			attribute = node.attribute("saved");
			if(attribute != null){
				if(attribute.getText().equals("0")){
					unsaved = true;
				}
			}

		}
		
		attribute = node.attribute("id");
		if(attribute != null){
			attribute = node.attribute("createdLayer");
			if(attribute.getText().equals(ObjectContainer.getInstance(LayerService.class).getCurrentLayer())){
				currentLayer = true;
			}
		}
		
		String nodeName = node.getName();
		if(nodeName.equals(DATATYPE) || nodeName.equals(TABLEFIELD) || nodeName.equals(FORMDATASOURCEFIELD) || nodeName.equals(REPORTFIELD)){
			attribute = node.attribute("type");
			if(attribute != null){
				switch (attribute.getText()) {
				case TYPE_BOOLEAN:
					data_type_img_name = !unsaved ? "BooleanType":"BooleanTypeUnSaved";
					baseTypeImg = true;
					break;
				case TYPE_COMPONENT:
					data_type_img_name = !unsaved ? "ComponentType":"ComponentTypeUnSaved";
					baseTypeImg = true;
					break;
				case TYPE_DATE:
					data_type_img_name = !unsaved ? "DateType":"DateTypeUnSaved";
					baseTypeImg = true;
					break;
				case TYPE_DECIMAL:
					data_type_img_name = !unsaved ? "DecimalType":"DecimalTypeUnSaved";
					baseTypeImg = true;
					break;
				case TYPE_ENUM:
					data_type_img_name = !unsaved ? "EnumType":"EnumTypeUnSaved";
					baseTypeImg = true;
					break;
				case TYPE_LONG:
					data_type_img_name = !unsaved ? "LongType":"LongTypeUnSaved";
					baseTypeImg = true;
					break;
				case TYPE_STRING:
					data_type_img_name = !unsaved ? "StringType":"StringTypeUnSaved";
					baseTypeImg = true;
					break;
				case TYPE_TIME:
					data_type_img_name = !unsaved ? "TimeType":"TimeTypeUnSaved";
					baseTypeImg = true;
					break;
				default:
					break;
				}
			}
		}
	}
	
	private static InputStream bufferedImageToInputStream(BufferedImage image) throws IOException{
	    ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write(image, "png", os);
        InputStream input = new ByteArrayInputStream(os.toByteArray());
        os.close();
        return input;
	}
	
	private static Image getImage(InputStream stream) throws IOException {
		try {
			Display display = Display.getCurrent();
			ImageData data = new ImageData(stream);
			if (data.transparentPixel > 0) {
				return new Image(display, data, data.getTransparencyMask());
			}
			return new Image(display, data);
		} finally {
			stream.close();
		}
	}
	
}
