package info.gongqi.got.ui.event;

import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.TreeOperationInfo;
import info.gongqi.got.ui.TreeUi;

import java.util.Arrays;
import java.util.List;

import org.dom4j.Element;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TreeItem;

import client.gongqi.designer.got.node.NodeGOT;

public class TreeMouseRigthMenuEvent extends MouseAdapter{

	private TreeUi treeUi;
	public MouseEvent dragEvent;
	public MouseRightMenuEvent mouseRightMenuEvent;
	
	@Override
	public void mouseDoubleClick(MouseEvent e) {
		super.mouseDoubleClick(e);
	}

	@Override
	public void mouseDown(MouseEvent e) {
		dragEvent = e;
    	if(e.button == 3){
        	Point point = new Point(e.x, e.y);
        	TreeItem treeitem = treeUi.getTree().getItem(point);
        	if(treeitem != null){
        		Element node = GotXmlDto.getInstance().getCurrentElement(treeitem);
            	NodeGOT.setContextMenu(node);
            	initPopup(treeitem);
        	}else{
        		TreeOperationInfo.addErrorInfo("右键菜单时，未能获取到对应节点的xml");
        	}
    	}else if(e.button == 1){
    		Point point = new Point(e.x, e.y);
        	TreeItem treeitem = treeUi.getTree().getItem(point);
        		if(e.stateMask == SWT.CTRL){
        			treeUi.ctrl = true;
                	if(treeitem != null){
                    	if(treeUi.selects.contains(treeitem)){
                    		treeUi.selects.remove(treeitem);
                    	}else{
                    		treeUi.selects.add(treeitem);
                    	}
                	}
        		}else if(e.stateMask == SWT.SHIFT){
        			treeUi.ctrl = true;
        			treeUi.selects.clear();
        			treeUi.selects.addAll(Arrays.asList(treeUi.getTree().getSelection()));
        		}else{
        			treeUi.ctrl = false;
        		}
        	}
    	}
    	
	@Override
	public void mouseUp(MouseEvent e) {
		super.mouseUp(e);
	}
	
	@SuppressWarnings("unchecked")
	public void initPopup(final TreeItem treeitem){
		Menu menu = new Menu(treeUi.getTree());
        List<Element> elements = NodeGOT.treeRightMenuData.elements("menuitem");
        for (Element element : elements) {
        	addMenu(element, menu, treeitem);
		}
        
//		 MenuItem open = new MenuItem(menu, SWT.PUSH);
//	     open.setText("调整标签宽度");
//	     open.addSelectionListener(new SelectionAdapter() {
//				@Override
//				public void widgetSelected(SelectionEvent e) {
//					
//					LayerInfo info = new LayerInfo(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE, "changeWidth");
//					info.open();
//				}
//		});
        
        treeUi.getTree().setMenu(menu);
    }
	
	/**
	 * 按钮的element
	 * @param element
	 * @param menu
	 * @param treeitem
	 */
	@SuppressWarnings("unchecked")
	private void addMenu(Element element, Menu menu, TreeItem treeitem){
	     String visible = element.attributeValue("visible");
	     if("true".equals(visible)){
	    	 String label = element.attributeValue("label");
	    	 if("新 增%N".equals(label) || "层控制".equals(label) || "辅助功能".equals(label)){
	    		List<Element> elements = element.elements("menuitem");
	    		if(elements.size() > 1){
	    	        MenuItem other = new MenuItem(menu, SWT.CASCADE);
	    	        other.setText(label.replace("%", "&"));
	    	        Menu menu_other = new Menu(other);
	    	        other.setMenu(menu_other);
	    	        for (Element child : elements) {
	    	        	addMenu(child, menu_other, treeitem);
	    			}
	    		}else{
					 MenuItem open=new MenuItem(menu, SWT.PUSH);
				     open.setText(label.replace("%", "&"));
				     open.addSelectionListener(new MouseRightMenuEvent(element, treeitem));
	    		}

	    	 }else if(label != null){
				 MenuItem open=new MenuItem(menu, SWT.PUSH);
			     open.setText(label.replace("%", "&"));
			     open.addSelectionListener(new MouseRightMenuEvent(element, treeitem));
	    	 }

	     }
		 
	}

	public TreeMouseRigthMenuEvent(TreeUi treeUi) {
		super();
		this.treeUi = treeUi;
	}
	
}
