package info.gongqi.got.ui.event;

import gongqi.designer.core.LayerLevelManager;
import gongqi.designer.services.GOTService;
import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.LayerConstants;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.tools.io.FileIO;
import gongqi.erp.gotmodel.core.EntityType;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.tool.ProgressBarRefNodeUtil;
import info.gongqi.got.tool.ProgressBarUtil;
import info.gongqi.got.tool.TreeOperationInfo;
import info.gongqi.got.ui.ConfigComposite;
import info.gongqi.got.ui.LoadXML;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.ui.TreeUi;
import info.gongqi.got.ui.TreeUiBean;
import info.gongqi.got.util.GOTMessageDialog;
import info.gongqi.got.util.NumCore;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

import client.gongqi.designer.got.GOTNodesConst;
import client.gongqi.designer.got.node.Branch;
import client.gongqi.designer.got.node.Entity;
import client.gongqi.designer.got.node.Inner;
import client.gongqi.designer.got.node.NodeFactory;
import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.got.validate.DoMerge;
import client.gongqi.designer.resolvergot.ResolverNode;
import client.gongqi.designer.resolvergot.ResolverNodeFactory;
import client.gongqi.designer.toolsgot.GOTXMLHelper;
import client.gongqi.designer.toolsgot.Macros;

public class MouseRightMenuEvent extends SelectionAdapter{

	//菜单的xml
	public Element menuItem;

	public Element currentTreeNode;
	
	//树节点
	private TreeItem treeitem;
	
	public MouseRightMenuEvent(Element element, TreeItem treeitem) {
		super();
		this.menuItem = element;
		this.treeitem = treeitem;
		this.currentTreeNode = GotXmlDto.getInstance().getCurrentElement(treeitem);
		FormDataSyn.current = treeitem;
	}
	
	public TreeItem getTreeitem() {
		return treeitem;
	}

	public void setTreeitem(TreeItem treeitem) {
		this.treeitem = treeitem;
	}
	
	@Override
	public void widgetDefaultSelected(SelectionEvent e) {
		super.widgetDefaultSelected(e);
	}
	
	@Override
	public void widgetSelected(SelectionEvent e) {
		try {
			this.currentTreeNode = GotXmlDto.getInstance().getCurrentElement(treeitem);
			ConfigComposite.configComposite.set_text_op_info("");
			String function = this.menuItem.attributeValue("func");
			if(!function.equals("new")){
				TreeOperationInfo.addInfo(this.menuItem.attributeValue("label")+ ":" + treeitem.getText());
			}
			switch (function) {
			case "new":AddHandle();
			TreeOperationInfo.addInfo(this.menuItem.attributeValue("label") + ":" + treeitem.getText() + "子节点");
				break;
			case "save":saveHandle(false);
			break;
			case "delete":deleteNodeCMI(false);
			break;
			case "restore":restoreNode();
			break;
			case "sync":syncNodes();
			break;
			case "copy":duplicateNode();
			break;
			case "showXML":showXML();
			break;
			case "quote":enterNodeRef();
			break;
			case "method":methodSet();
			break;
			case "newWindow":openNewFrom(e.stateMask == SWT.CTRL);
			break;
			case "syncFDSF":syncFDSF();
			break;
			case "resetRelationName":resetRelationName();
			break;
			case "checkFormDataSourceFieldRate":checkFormDataSourceFieldRate();
			break;
			case "AdjustCreatedLayer":{
				adjustCreatedLayer();
				break;
			}
			default:
				break;
			}
		} catch (final Exception e1) {
			e1.printStackTrace();
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e1);
				}
			});
			
		}
		ConfigComposite.configComposite.setUnsavedText();
	}
	
	private void adjustCreatedLayer(){
		final Shell shell = new Shell(Display.getCurrent(), SWT.APPLICATION_MODAL|SWT.TITLE);
		shell.setText("调整创建层");
		shell.setSize(200, 190);
        Monitor monitor = shell.getMonitor();  
        Rectangle bounds = monitor.getBounds ();
        Rectangle rect = shell.getBounds ();
        int x = bounds.x + (bounds.width - rect.width) / 2;  
        int y = bounds.y + (bounds.height - rect.height) / 2;  
        shell.setLocation (x, y);
        shell.setLayout(new FormLayout());
        
        Label label_LayerName = new Label(shell, SWT.RIGHT);
        label_LayerName.setText("  层名称");
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment(0, 10);
        label_LayerName.setLayoutData(formData);
        final Combo combo_LayerName = new Combo(shell, SWT.READ_ONLY);
        formData = new FormData();
        formData.left = new FormAttachment(label_LayerName, 5, SWT.RIGHT);
        formData.top = new FormAttachment(label_LayerName, 0, SWT.TOP);
        formData.right = new FormAttachment(100, -5);
		combo_LayerName.setLayoutData(formData);
		
		Label label_SolutionName = new Label(shell, SWT.RIGHT);
		label_SolutionName.setText("应用名称");
		formData = new FormData();
        formData.left = new FormAttachment(label_LayerName, 0, SWT.LEFT);
        formData.top = new FormAttachment(label_LayerName, 20, SWT.BOTTOM);
        formData.right = new FormAttachment(label_LayerName, 0, SWT.RIGHT);
        label_SolutionName.setLayoutData(formData);
        final Combo combo_SolutionName = new Combo(shell, SWT.READ_ONLY);
        formData = new FormData();
        formData.left = new FormAttachment(label_SolutionName, 5, SWT.RIGHT);
        formData.top = new FormAttachment(label_SolutionName, 0, SWT.TOP);
        formData.right = new FormAttachment(combo_LayerName, 0, SWT.RIGHT);
		combo_SolutionName.setLayoutData(formData);
		combo_SolutionName.setEnabled(false);
		
		Label label_SolutionPluginName = new Label(shell, SWT.RIGHT);
		label_SolutionPluginName.setText("插件名称");
		formData = new FormData();
		formData.left = new FormAttachment(label_SolutionName, 0, SWT.LEFT);
		formData.top = new FormAttachment(label_SolutionName, 20, SWT.BOTTOM);
		formData.right = new FormAttachment(label_SolutionName, 0, SWT.RIGHT);
		label_SolutionPluginName.setLayoutData(formData);
		final Combo combo_solutionPluginName = new Combo(shell, SWT.READ_ONLY);
		formData = new FormData();
        formData.left = new FormAttachment(label_SolutionPluginName, 5, SWT.RIGHT);
        formData.top = new FormAttachment(label_SolutionPluginName, 0, SWT.TOP);
        formData.right = new FormAttachment(combo_SolutionName, 0, SWT.RIGHT);
        combo_solutionPluginName.setLayoutData(formData);
        combo_solutionPluginName.setEnabled(false);
		
		final Button button_confirm = new Button(shell, SWT.NONE);
		button_confirm.setText("确定");
		formData = new FormData();
		formData.width = 60;
        formData.left = new FormAttachment(20);
        formData.bottom = new FormAttachment(100, -10);
        button_confirm.setLayoutData(formData);
		
		Button button_cancel = new Button(shell, SWT.NONE);
		button_cancel.setText("取消");
		formData = new FormData();
		formData.width = 60;
        formData.left = new FormAttachment(60);
        formData.bottom = new FormAttachment(button_confirm, 0, SWT.BOTTOM);
        button_cancel.setLayoutData(formData);
        
        //add listener
        combo_LayerName.addSelectionListener(new SelectionAdapter() {
        	@Override
        	public void widgetSelected(SelectionEvent e) {
        		String layerName = combo_LayerName.getText();
        		if (LayerConstants.SOLUTION_LAYER.equals(layerName)) {
					combo_SolutionName.setEnabled(true);
					 List<String> canEditSolutionList = ObjectContainer.getInstance(LayerService.class).getCanEditSolutionList();
					 String createdLayer  = MouseRightMenuEvent.this.currentTreeNode.attributeValue("createdLayer");
//					 String modifiedLayer = MouseRightMenuEvent.this.currentTreeNode.attributeValue("modifiedLayer");
					 if (LayerConstants.SOLUTION_LAYER.equals(createdLayer)) {
						 String entityId = MouseRightMenuEvent.this.currentTreeNode.attributeValue("id");
						 String solutionName = entityId.substring(0, entityId.lastIndexOf("."));
						canEditSolutionList.remove(solutionName);
					}
					 combo_SolutionName.setItems(canEditSolutionList.toArray(new String[canEditSolutionList.size()]));
					
					 combo_solutionPluginName.setEnabled(false);
					 combo_solutionPluginName.setText("");
					 
					 button_confirm.setEnabled(false);
				} else if (LayerConstants.SOLUTION_PLUGIN_LAYER.equals(layerName)){
					combo_SolutionName.setEnabled(true);
					 List<String> canEditSolutionList = ObjectContainer.getInstance(LayerService.class).getCanEditSolutionList();
					 combo_SolutionName.setItems(canEditSolutionList.toArray(new String[canEditSolutionList.size()]));
					
					 combo_solutionPluginName.setEnabled(false);
					 combo_solutionPluginName.setText("");
					 
					 button_confirm.setEnabled(false);
				}  else if (LayerConstants.SOLUTION_EXTENSION_LAYER.equals(layerName)){
					combo_SolutionName.setEnabled(true);
					List<String> canEditSolutionExtensionList = ObjectContainer.getInstance(LayerService.class).getCanEditExtensionList();
					combo_SolutionName.setItems(canEditSolutionExtensionList.toArray(new String[canEditSolutionExtensionList.size()]));
					
					combo_solutionPluginName.setEnabled(false);
					combo_solutionPluginName.setText("");
					
					 button_confirm.setEnabled(false);
				} else {
					combo_SolutionName.setEnabled(false);
					combo_SolutionName.setText("");
					
					combo_solutionPluginName.setEnabled(false);
					combo_solutionPluginName.setText("");
					
					 button_confirm.setEnabled(true);
				}
        	}
        });
        
        combo_SolutionName.addSelectionListener(new SelectionAdapter() {
        	@Override
        	public void widgetSelected(SelectionEvent e) {
        		String layerName = combo_LayerName.getText();
        		if (LayerConstants.SOLUTION_PLUGIN_LAYER.equals(layerName)) {
        			combo_solutionPluginName.setEnabled(true);
					String solutionName = combo_SolutionName.getText();
					List<String> canEditSolutionPluginList = ObjectContainer.getInstance(LayerService.class).getCanEditSolutionPluginList(solutionName);
					 String createdLayer  = MouseRightMenuEvent.this.currentTreeNode.attributeValue("createdLayer");
//					 String modifiedLayer = MouseRightMenuEvent.this.currentTreeNode.attributeValue("modifiedLayer");
					 if (LayerConstants.SOLUTION_PLUGIN_LAYER.equals(createdLayer)) {
						 String entityId = MouseRightMenuEvent.this.currentTreeNode.attributeValue("id");
						 String solutionPluginName = entityId.substring(0, entityId.lastIndexOf("."));
						 canEditSolutionPluginList.remove(solutionPluginName);
					}
					combo_solutionPluginName.setItems(canEditSolutionPluginList.toArray(new String[canEditSolutionPluginList.size()]));
					
					 button_confirm.setEnabled(false);
        		} else {
        			 button_confirm.setEnabled(true);
        		}
        	}
        });
        
        combo_solutionPluginName.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				 button_confirm.setEnabled(true);
			}
        	
		});
		
		button_cancel.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				shell.close();
			}
		});
		
		button_confirm.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				String layerName = combo_LayerName.getText();
				String solutionName = combo_SolutionName.getText();
				String solutionPluginName = combo_solutionPluginName.getText();
				String entityId = currentTreeNode.attributeValue("id");
				try {
					ObjectContainer.getInstance(GOTService.class).adjustCreatedLayer(entityId, layerName, solutionName, solutionPluginName);
					MessageDialog.openInformation(shell, "提示", "调整创建层完成，请重新加载GOT");
					shell.close();
				} catch (Exception ex) {
					Logger.getLogger(MouseRightMenuEvent.class).error("调整创建层错误", ex);
					MessageDialog.openWarning(shell, "提示", "调整创建层错误：" + ex.getMessage());
				}
			}
		});
		
		List<String> canEditorLayers =  ObjectContainer.getInstance(LayerService.class).getCanEditLayerList();
		String modifiedLayer = this.currentTreeNode.attributeValue("modifiedLayer");
		if (modifiedLayer != null && !LayerConstants.SOLUTION_LAYER.equals(modifiedLayer) 
				&& !LayerConstants.SOLUTION_PLUGIN_LAYER.equals(modifiedLayer) 
				&& !LayerConstants.SOLUTION_EXTENSION_LAYER.equals(modifiedLayer)) {
			canEditorLayers.remove(modifiedLayer);
		}
		if (!canEditorLayers.isEmpty()) {
			combo_LayerName.setItems(canEditorLayers.toArray(new String[canEditorLayers.size()]));
		}
		
		shell.open();
	}
	
	//新增操作
	@SuppressWarnings("unchecked")
	public void AddHandle(){
		String type = this.menuItem.attribute("nodeType") == null ? null : this.menuItem.attributeValue("nodeType");
		//选中的节点的getCurrentNode
		Element elementDate = this.currentTreeNode;
		//获取选中新增节点的解析器
		NodeGOT nodeGOT = NodeFactory.getNode(elementDate);

		List<Element> rNodeList = new ArrayList<>();
		if(nodeGOT.allowNew()){
			rNodeList = nodeGOT.rNode.getNode().elements("node");
		}else{
			return;
		}
		
		if(rNodeList.isEmpty()){
			GOTMessageDialog.alert("无该操作");
		}
		
		if(rNodeList.size() == 1){
			//获取将要新增的节点的解析器
			String _name = rNodeList.get(0).attributeValue("name");
			String _type = rNodeList.get(0).element("Info").elementText("Type");
			ResolverNode rnodeGOT = ResolverNodeFactory.getRNode(_name, _type);
			newNode(rnodeGOT, true);
		}else{
			if(type == null){
				List<String> array = new ArrayList<>();
				for(Element child : rNodeList){
					//隐含要求存在@name
					array.add(child.attributeValue("name") + "." + child.element("Info").elementText("Type"));
				}
				String returnstr = GOTMessageDialog.typeSelector(array);
				if(returnstr == null || "".equals(returnstr)){
					return;
				}
				nodeTypeSelected(returnstr);
			}else{
				nodeTypeSelected(type);
			}
		}
	}
	
	//checkType默认true
	private void newNode(ResolverNode rNode, boolean checkType){
		if(rNode == null){
			GOTMessageDialog.alert("新增时未找到rNode");
			return;
		}
		
		if(!validateNodeNum(this.currentTreeNode, rNode, checkType)){
			TreeOperationInfo.addErrorInfo("超过最大数量");
			return;
		}
		
		String name = rNode.getNode().attributeValue("name");	//必定有@name
		String type = rNode.getInfoValue("Type");	//必定有Info.Type
		String idType = rNode.getAttributeValue("id","Default");
		
		if("##getEntityId".equals(idType)){
			String id = "";
			try {
				id = LoadXmlCore.gotServices.getEntityId(EntityType.valueOf(name));
			} catch (Exception e) {
				e.printStackTrace();
				GOTMessageDialog.alert(e);
				return;
			}
			if(id.equals("-1")){
				GOTMessageDialog.alert("获取id失败");
				return;
			}
			resultNew(name, type, id, false);
		}else if("##getInnerId".equals(idType)){
			resultNew(name, type, "", true);
		}else if("".equals(idType)){
			resultNew(name, type, null, false);
		}else if(idType == null){
			this.resultNew(name, type, null, false);
		}else{
			GOTMessageDialog.alert("未知Id:" + idType);
		}
	}
	
	@SuppressWarnings("unchecked")
	private Boolean validateNodeNum(Element parent, ResolverNode rNode, Boolean checkType){
		if(rNode.getInfoValue("MaxOccurs").equals("unbounded")){
			return true ;
		}
		
		int maxNum = Integer.parseInt(rNode.getInfoValue("MaxOccurs"));
		int num = 0;
		
		List<Element> list = parent.elements(rNode.getNode().attributeValue("name"));
		String type = rNode.getInfoValue("Type");
		
		//@name 必须有
		//@type 可选
		if(checkType){
			for (Element child : list){
				if(type.equals(child.attributeValue("type"))){
					num++;
				}
			}
		}else{
			num = list.size();
		}
		
		if(num >= maxNum){
			return false;
		}else{
			return true ;
		}
		
	}
	
	private void resultNew(String name, String type, String id, Boolean isGetInnerId){
		NodeGOT node = NodeFactory.createNode(name, type, id);
		if(node.editOnCreate()){
			node.xml.addAttribute("editOnCreate", "true");
		}
		
		Element childBefore = node.getInsertChildBefore(this.currentTreeNode);
		insertNode(node, null, childBefore, true);
		
		String nodeName = node.xml.getName();
		
		if(nodeName.equals("Form")){
			ConfigComposite.fromNum ++;
			ConfigComposite.text_static_info();
		}else if(nodeName.equals("Table")){
			ConfigComposite.tableNum ++;
			ConfigComposite.text_static_info();
		}
		
		
	}
	
	@SuppressWarnings("unchecked")
	public void insertNode(NodeGOT node, Element parent, Element childBefore, Boolean autoEnterEdit){
		node.doBeforeInsert();
		Integer index = null;
		Element xml = node.xml;
		if(parent == null){
			parent = this.currentTreeNode;
		}
		//此处不需要再写入父节点
		if(childBefore == null){
			String insertAt = node.getInsertAt();
			if(insertAt.equals("append")){
				parent.add(xml.detach());
			}else{
				parent.elements().add(0, xml);
				index =0;
			}
		}else{
			int beforeIndex = parent.elements().indexOf(childBefore);
			parent.elements().add(beforeIndex, xml);
		}
		
		node.doAfterInsert();
		//进入编辑
		if(autoEnterEdit){
			this.getTreeitem().setData("autoEdit", "true");
		}
		
	 	String treeItemId = NumCore.getId();
		if(!this.getTreeitem().getExpanded()){
			this.getTreeitem().setExpanded(true);
		}
		
		if(NodeGOT.getEntity(parent) == null){
			GotXmlDto.getInstance().addEntityElement(xml);
		}else{
			GotXmlDto.getInstance().updateEntityElement(NodeGOT.getEntity(parent));
		}
		
		FormDataSyn.actionSyn(this.getTreeitem(), treeItemId, xml, node, index, "new");
	}
	
	private void nodeTypeSelected(String type){
		if(type.equals("##close")){
			TreeOperationInfo.addInfo( this.getTreeitem().getText() + "新增操作取消");
			ConfigComposite.configComposite.set_text_op_info("操作取消");
			return ;
		}
		String _name = "";
		String _type = "";
		//字符.要转义
		String[] str = type.split("\\.");
		if(str.length == 2){
			_name = str[0];
			_type = str[1];
		}else if(str.length == 1){
			_name = str[0];
		}
		ResolverNode rNode = ResolverNodeFactory.getRNode(_name, _type); 
		newNode(rNode, true);
	}
	
	
	/**
	 * --------                  -----------
	 *    0000						  0000
	 *       
	 * 
	 * 
	 * 					------
	 * 						  - - -
	 * 
	 * 
	 */
	
	/**
	 * 以上均是新增操作，往下是保存
	 */
	@SuppressWarnings("unchecked")
	public void saveHandle(boolean fromShortCut){
		//选中的节点的getCurrentNode
		Element elementDate = GotXmlDto.getInstance().getCurrentElement(this.treeitem);
		//获取选中新增节点的解析器
		NodeGOT node = NodeFactory.getNode(elementDate);
		if(!fromShortCut && NodeGOT.canPromote(node.xml)){
			Entity entity = (Entity) node;
			String info = entity.validateBeforePromote();
			if(!info.equals(Macros.INFO_TRUE)) {
				TreeOperationInfo.addInfo(this.getTreeitem().getText() + "保存:" + Macros.INFO_OPR_FAIL);
				ConfigComposite.configComposite.set_text_op_info(Macros.INFO_OPR_FAIL);
				if(info.substring(0,4) == "tree"){
					TreeOperationInfo.addInfo(this.getTreeitem().getText() + "保存:" + info.substring(5));
					ConfigComposite.configComposite.set_text_op_info(info.substring(5));
					GOTMessageDialog.alert(this.getTreeitem().getText() + "保存:" + info.substring(5));
				}else{
					TreeOperationInfo.addInfo(this.getTreeitem().getText() + "保存:" + info.substring(4));
					ConfigComposite.configComposite.set_text_op_info(info.substring(4));
					GOTMessageDialog.alert(info.substring(4));
				}
				return ;
			}
			
			entity.setSelfUnsaved();
			String entityName = entity.xml.getName();
			if(entityName.equals("Form")){
				List<Element> dslist = entity.xml.element("FormDataSources").elements("ForDataSource");
				if(dslist.size()>0){
					for (Element item : dslist){
						item.addAttribute("modifiedLayer", ObjectContainer.getInstance(LayerService.class).getCurrentLayer());	
					}
				}
			}
			String result = "";
			try {
				result = LoadXmlCore.gotServices.promoteEntity(entity.xml.asXML());
			} catch (Exception e) {
				e.printStackTrace();
				GOTMessageDialog.alert(e);
				return;
			}
			rpc_result_Save(result, info, entity);
			
		}else{
			Entity entity = null;
			if(node instanceof  Entity){
				entity =  (Entity) node;
			}else if((node instanceof Inner) || (node instanceof Branch)){
				Element entityXML = NodeGOT.getEntity(node.xml);
				if(entityXML != null){
					entity = (Entity) NodeFactory.getNode(entityXML);
				}
			}
			
			if(entity == null)
				return;
			
			String info = entity.validateBeforeSave();
			if(!info.equals("true")) {
				TreeOperationInfo.addInfo(this.getTreeitem().getText() + "保存:" + Macros.INFO_OPR_FAIL);
				ConfigComposite.configComposite.set_text_op_info(Macros.INFO_OPR_FAIL);
				if(info.substring(0,4) == "tree"){
					TreeOperationInfo.addInfo(this.getTreeitem().getText() + "保存:" + info.substring(5));
					ConfigComposite.configComposite.set_text_op_info(info.substring(5));
				}else{
					TreeOperationInfo.addInfo(this.getTreeitem().getText() + "保存:" + info.substring(4));
					ConfigComposite.configComposite.set_text_op_info(info.substring(4));
				}
				return ;
			}
			
			String result = "";

			try {
				result = LoadXmlCore.gotServices.saveEntity(entity.xml.asXML());
			} catch (Throwable e) {
				e.printStackTrace();
				GOTMessageDialog.alert(e.getMessage());
				return;
			}
			if(!"".equals(result)){
				rpc_result_Save(result, "", entity);
			}
			
		}
		
	}

	private Element getGOTNodeByQname(String qname, String nodeId){
		if(qname.equals("Form")){
			return GotXmlDto.getInstance().currentEntityByTypeAndId("Form", nodeId);
		}else if(qname.equals("Table")){
			return GotXmlDto.getInstance().currentEntityByTypeAndId("Table", nodeId);
		}else if(qname.equals("DataType")){
			return GotXmlDto.getInstance().currentEntityByTypeAndId("DataType", nodeId);
		}else if(qname.equals("MenuItem")){
			return GotXmlDto.getInstance().currentEntityByTypeAndId("MenuItem", nodeId);
		}else if(qname.equals("Menu")){
			return GotXmlDto.getInstance().currentEntityByTypeAndId("Menu", nodeId);
		}else if(qname.equals("Enum")){
			return GotXmlDto.getInstance().currentEntityByTypeAndId("Enum", nodeId);
		}else if(qname.equals("Report")){	
			return GotXmlDto.getInstance().currentEntityByTypeAndId("Report", nodeId);
		}else if(qname.equals("Map")){
			return GotXmlDto.getInstance().currentEntityByTypeAndId("Map", nodeId);
		}else if(qname.equals("Class")){
			return GotXmlDto.getInstance().currentEntityByTypeAndId("Class", nodeId);
		}
		return null;
	}
	
	@SuppressWarnings("unchecked")
	private void rpc_result_Save(String result, String info, Entity entity){
		clearDeletedNodesCache(entity.xml.attributeValue("id"));
		result = "<rootTemp>" + result + "</rootTemp>";
		Element xmlParent = GOTXMLHelper.createElementByXMLString(result);
		List<Element> list =  xmlParent.elements();
		String nodeId ;
		int total = list.size();
		String his = "";
		
		Element node = null;
		int j;
		int k;
		for(j=0; j<total; j++){
			Element xml = list.get(j);
			if(xml.attribute("id") != null){
				String strId = xml.attributeValue("id");	
				for(k=j+1; k<total; k++){
					Element xmlCompare = list.get(k);
					if(xmlCompare.attribute("id") != null ){
						if(xmlCompare.attributeValue("id").equals(strId)){
							xml.addAttribute("del", "true");
							break;
						}
					}
				}
			}
		}
		
		for(Element r : list){
			if(r.attribute("del") != null)
				continue;
			
			if(r.getName().equals("Error")){
				info += r.getText() + "\n保存失败，应执行右键恢复，以防数据丢失\n" ;
				continue ;
			}
			
			if(his.indexOf(r.attributeValue("id")) != -1){
				continue ;
			}
			his += "$" + r.attributeValue("id");
			
			nodeId = r.attributeValue("id") ;
			String qname = r.getName();
			node = getGOTNodeByQname(qname,nodeId);
			
			if(node == null){
//				GOTMessageDialog.alert("不存在id为"+nodeId+"的节点，应新建");
				continue ;
			}
			if(entity.xml.attributeValue("id").equals(r.attributeValue("id"))) {
				if(node.attribute("saved") != null){
					node.remove(node.attribute("saved"));
				}
				node.addAttribute("modifiedLayer", r.attributeValue("modifiedLayer"));
				List<Element> elements = r.element("Properties").elements("Property");
				for(Element propertyNode : elements){
					GOTHelp.getPPAttElement(node, "Name", propertyNode.elementText("Name")).element("Value").setText(propertyNode.elementText("Value"));
				}
				String entityName = entity.xml.getName();
				if(entityName.equals("Form")){
					List<Element> datasourcelist = entity.xml.element("FormDataSources").elements("FormDataSource");
					if(datasourcelist.size() > 0){
						for(Element item : datasourcelist){
							item.addAttribute("modifiedLayer", r.attributeValue("modifiedLayer"));
						}
					}
				}
				node.addAttribute("version", r.attributeValue("version"));
				node.addAttribute("name", r.attributeValue("name"));
				info += r.attributeValue("name") + ":" + r.getName() + "  已修改 OK\n";
				GotXmlDto.getInstance().updateEntityElement(NodeGOT.getEntity(node));
				FormDataSyn.setSaved(treeitem);
				continue ;
			}
			
			TreeItem item = FormDataSyn.getTreeItrmByElement(node, null);
			if(item != null){
				if("0".equals(r.attributeValue("saved"))){
					node.remove(r.attribute("saved"));
				}
				/*Element parent = node.getParent();
				if(parent == null){
					parent = GotXmlDto.getInstance().getCurrentEntytyElement(node.getName() + "s");
				}
					
				GOTHelp.insertChildBefore(parent, node, r);
				parent.remove(node);*/
//				System.out.println(node.asXML());
				GotXmlDto.getInstance().updateEntityElement(NodeGOT.getEntity(r));
//				GotXmlDto.getInstance().updateEntityElement(node);
				//这里重构关联的树节点
				FormDataSyn.restore(item, r, item.getExpanded());
			}
			
			info += r.attributeValue("name") + ":" + r.getName() + "  已修改 OK\n";
		}
		
		if(list.size() > 1){
			GOTMessageDialog.info(info);
			TreeOperationInfo.addErrorInfo(this.getTreeitem().getText() + "保存:" + info);
			FormDataSyn.setSaved(treeitem);
		}else if(list.size()==1){
			Element error = list.get(0);
			if(error.getName().equals("Error")){
				TreeOperationInfo.addInfo(this.getTreeitem().getText() + "保存:" + Macros.INFO_OPR_FAIL);
				ConfigComposite.configComposite.set_text_op_info(Macros.INFO_OPR_FAIL);
				GOTMessageDialog.alert(info);
				return;
			}else{
				TreeOperationInfo.addInfo(this.getTreeitem().getText() + "保存:" + Macros.INFO_OPR_SUCCESS);
				ConfigComposite.configComposite.set_text_op_info(Macros.INFO_OPR_SUCCESS);
				if(NodeGOT.getEntity(node.getParent()) == null){
					GotXmlDto.getInstance().addEntityElement(node);
				}else{
					GotXmlDto.getInstance().updateEntityElement(NodeGOT.getEntity(node));
				}
				FormDataSyn.setSaved(treeitem);
				Element el = GotXmlDto.getInstance().getCurrentElement(treeitem);
				FormDataSyn.currentTreeUi.loadTableValue(FormDataSyn.currentTreeUi.getTable(), el, treeitem);
				
				Element item = GotXmlDto.getInstance().getCurrentEntityElement(this.treeitem);
				Element _entity = NodeGOT.getEntity(item);
				if(_entity==null)
					return;
				
				TreeItem entityTreeItem = FormDataSyn.getEntityTreeItem(treeitem);
				//刷新实体节点的名称
				if(_entity.getName().equals("Table")){
					entityTreeItem.setText(LoadXML.nodeText(_entity));
				}
				
				String _entityId = _entity.attributeValue("id");
				String _innerId;
				if(_entityId.equals(item.attributeValue("id"))){
					_innerId = null;
				}else{
					_innerId = item.attributeValue("id");
				}

				String result_ = "";
				try {
					result_ = LoadXmlCore.gotServices.getNodeRef(item.getName(), _entityId, _innerId);
				} catch (Exception e) {
					e.printStackTrace();
					GOTMessageDialog.alert(e);
					return;
				}
				if(StringUtils.isNotBlank(result_)){
					Element flash_xml = GOTXMLHelper.createElementByXMLString(result_);
					List<Element> elements = flash_xml.elements();
					for (Element element : elements) {
						if(element.attributeValue("entityId") != null && 
								!element.attributeValue("entityId").equals(_entityId)){
							TreeItem treeItemId = FormDataSyn.getEntityTreeItem(element.attributeValue("entityId"));
							if(treeItemId != null){
								Element element2 = GotXmlDto.getInstance().getCurrentElement(treeItemId);
								FormDataSyn.restore(treeItemId, element2, true);
								break;
							}
							
						}
					}
				}
				
			}
		}else{
			GOTMessageDialog.alert("返回list.length()<1，异常");
		}
	} 
	
	/**
	 * --------                  -----------
	 *    0000						  0000
	 *       
	 * 
	 * 
	 * 					------
	 * 						  - - -
	 * 
	 * 
	 */
	
	public void deleteNodeCMI(boolean fromShortCut){
		String strValidate;
		TreeItem[] items = this.treeitem.getParent().getSelection();
		if(items.length == 1){
			//选中的节点的getCurrentNode
			Element item = this.currentTreeNode;
			//获取选中新增节点的解析器
			NodeGOT node = NodeFactory.getNode(item);
			if(fromShortCut == false && NodeGOT.canRevert(node.xml)){
				String prompt = "确认回滚";
				strValidate = node.validateRollback();
				
				if(!this.validateResult(strValidate))
					return;
				
				prompt += " " + item.getName() + " " + item.attributeValue("name");
				MessageBox messagebox = new MessageBox(GOTMessageDialog.shell, SWT.ICON_QUESTION
		                | SWT.YES | SWT.NO);
		        messagebox.setText("确定要回滚吗，回滚后将无法恢复");
		        messagebox.setMessage(prompt) ;
		        int message = messagebox.open();
				if(message == SWT.YES){
					doCmi_Revert(node);
				}
				return;
			}
			
		}
		if(items.length > 0){
			String prompt = "确认删除";
			if(items.length == 1){
				//选中的节点的getCurrentNode
				Element item = this.currentTreeNode;
				//获取选中新增节点的解析器
				NodeGOT node = NodeFactory.getNode(item);
				strValidate = node.validateDelete();
				if(!this.validateResult(strValidate))
					return;
				prompt += " " + item.getName() + " " + item.attributeValue("name");
			}else{
				Element parent = (this.currentTreeNode).getParent();
				for(TreeItem item : items){
					Element itemElement = GotXmlDto.getInstance().getCurrentElement(item);
					NodeGOT node = NodeFactory.getNode(itemElement);
					if(!node.rNode.getInfoValue("NodeType").equals("inner") || !itemElement.getParent().asXML().equals(parent.asXML()) ){	
						GOTMessageDialog.alert("只能同时删除多个节点");
						//同级的Inner
						return ;								
					}
					strValidate = node.validateDelete();
					if(!this.validateResult(strValidate))
						return;
				}
				prompt += items.length+"个节点";
			}
			
			MessageBox messagebox = new MessageBox(GOTMessageDialog.shell, SWT.ICON_QUESTION
	                | SWT.YES | SWT.NO );
	        messagebox.setText("确定要删除吗，删除后将无法恢复");
	        messagebox.setMessage(prompt) ;
	        int message = messagebox.open();
	        if(message == SWT.YES){
				Element item = this.currentTreeNode;
				//获取选中新增节点的解析器
				NodeGOT node = NodeFactory.getNode(item);
	        	String nodeType = node.rNode.getInfoValue("NodeType");
				switch(nodeType){
					case "entity":{
						//这里是未被保存的实体节点所以不用回传
						if("0".equals(item.attributeValue("version"))){
							if(this.deleteNode(items)){
								doDeleteUiTreeItem(items);
							}
							break;
						}else{
							Entity entity = null;
							if(node instanceof Entity){
								entity = (Entity) node; 
							}
							if(entity == null)
								return;
							String msg = "";
							try {
								msg = LoadXmlCore.gotServices.deleteEntity(item.asXML());
							} catch (Exception e) {
								e.printStackTrace();
								GOTMessageDialog.alert(e);
							}
							rpc_result_Delete(msg, entity);
							break;
						}
					}
					case "inner":{
						deleteInnerNode();
						break;
					}
					case "branch":{
						TreeItem[] sitems = this.treeitem.getParent().getSelection();
						if(sitems.length==1){
							if(this.deleteNode(sitems)==true){
								setEntityUnsaved();
							}
						}
						doDeleteUiTreeItem(items);
						break;
					}
						
					default:break;
				}
	        }else{
	        	return;
	        }
		}

	}
	
	private Boolean validateResult(String result){
		if(result.length() <= 4){
			return true;
		}
		String isResultValid = result.substring(0,5);
		if(isResultValid.equals(Macros.INFO_FALSE) || isResultValid.equals(Macros.INFO_ERROR)){
			GOTMessageDialog.showXmlInfo(result, "信息");
			return false;
		}else{
			return true;
		}
	}
	
	private Boolean deleteNode(TreeItem[] items){
		for (TreeItem trtmNewTreeitem : items){
			Element item = GotXmlDto.getInstance().getCurrentElement(trtmNewTreeitem);
			Element parent = item.getParent();
			Boolean isSuc = GOTXMLHelper.deleteNode(item);
			if(!isSuc){
				GOTMessageDialog.alert("删除失败");
				return false;
			}else{
				String nodeName = item.getName();
				if(nodeName.equals("Form")){
					ConfigComposite.fromNum --;
					ConfigComposite.text_static_info();
				}else if(nodeName.equals("Table")){
					ConfigComposite.tableNum --;
					ConfigComposite.text_static_info();
				}
				if(item.attribute("version") != null){
					GotXmlDto.getInstance().deleteEntityElement(item);
				}else{
					GotXmlDto.getInstance().updateEntityElement(NodeGOT.getEntity(parent));
				}
			}
		}
		return true;
		
	}
	
	public void rpc_result_Revert(String result, NodeGOT entity){
		if(!this.validateResult(result))
			return;
		do_rpc_result_Revert(result, entity);
	}
	
	private void do_rpc_result_Revert(String result, NodeGOT entity){
		List<String> list =  Arrays.asList(result);
		clearDeletedNodesCache(entity.xml.attributeValue("id"));
		if(list == null){
			return;
		}

//		String nodeId ;
//		Element node ;
		int total = list.size();
		String info = "";
		String his = "";
		
		int j;
		int k;
		for(j=0; j<total; j++){
			Element xml = GOTXMLHelper.createElementByXMLString(list.get(j));
			if(xml.attribute("id") != null){
				String strId = xml.attributeValue("id");	
				for(k=j+1; k<total; k++){
					Element xmlCompare = GOTXMLHelper.createElementByXMLString(list.get(k));
					if(xmlCompare.attribute("id") != null ){
						if(xmlCompare.attributeValue("id").equals(strId)){
							xml.addAttribute("del", "true");
							break;
						}
					}
				}
			}
		}
		
		
		for (String str : list){
			Element r = GOTXMLHelper.createElementByXMLString(str);
			if(r.attribute("del") != null)
				continue;
			
			if(r.getName().equals("Error")){
				info += r.getText() + "\n回滚失败，应执行右键恢复，以防数据丢失\n" ;
				continue ;
			}
			
			if(his.indexOf(r.attributeValue("id")) != -1){
				continue ;
			}
			
			his += "$" + r.attributeValue("id");
//			nodeId = r.attributeValue("id");
//			String xpath = "//" + r.getName() + "[@id='" + nodeId + "']";
//			List<Element> elements = GotXmlDto.getInstance().getGotXMl(xpath);
//			if(elements.isEmpty()){
//				GOTMessageDialog.alert("不存在id为"+nodeId+"的节点");
//				continue ;
//			}
//			node = (Element) GotXmlDto.getInstance().getGotXMl(xpath).get(0);
		}
		if(list.size() > 1){
			TreeOperationInfo.addErrorInfo(treeitem.getText() + "恢复:" + info);
			GOTMessageDialog.alert(info);
			ConfigComposite.configComposite.set_text_op_info(info);
		}else if(list.size()==1){
			Element xml = GOTXMLHelper.createElementByXMLString(list.get(0));
			if(xml.getName().equals("Error")){
				TreeOperationInfo.addErrorInfo(treeitem.getText() + "恢复:" + info);
				ConfigComposite.configComposite.set_text_op_info(info);
			}
			FormDataSyn.setFont(xml, treeitem);
			ConfigComposite.configComposite.set_text_op_info("成功");
		}else{
			GOTMessageDialog.alert("返回list.length()<1，异常");
			TreeOperationInfo.addErrorInfo(treeitem.getText() + "恢复:返回list.length()<1，异常" + info);
		}
	}
	
	private void rpc_result_Delete(String result, NodeGOT entity){
		
		if(!this.validateResult(result))
			return;
		
		if(result.equals(Macros.INFO_TRUE)){
			TreeItem[] items = this.treeitem.getParent().getSelection();
			this.deleteNode(items);
			doDeleteUiTreeItem(items);
		}

	}
	
	private void deleteInnerNode(){
		TreeItem[] sitems = this.treeitem.getParent().getSelection();
		if(sitems.length>0){
			Element item = GotXmlDto.getInstance().getCurrentElement(sitems[0]);
			if(item != null){
				if(item.getName().equals("TableField")){
					String tableFieldIds = "";
					for (TreeItem treeitem : sitems){
						Element tableField = GotXmlDto.getInstance().getCurrentElement(treeitem);
						tableFieldIds += tableField.attributeValue("id") + ",";
					}if(!tableFieldIds.equals(""))
						tableFieldIds = tableFieldIds.substring(0,tableFieldIds.length()-1);
					Element table = NodeGOT.getEntity(item);
					
					String result = "";
					try {
						result = LoadXmlCore.gotServices.validateDeleteTableField(table.attributeValue("id"), tableFieldIds);
					} catch (Exception e) {
						e.printStackTrace();
						GOTMessageDialog.alert(e);
						return;
					}
					if(result != null && !"".equals(result)){
						GOTMessageDialog.alert(result);
					}else{
						doDeleteInnerNode(sitems);	
					}
					
				}else{
					doDeleteInnerNode(sitems);
				}
			}
		}
		
	}
	
	private void doDeleteInnerNode(TreeItem[] sitems){
		if(this.deleteNode(sitems)==true){
			//找到树节点对应的实体节点
//			TreeItem treeItem = getEntityTreeItem(this.treeitem);
			Element entityNode = GotXmlDto.getInstance().getCurrentEntityElement(this.treeitem);
			if(entityNode.getName().equals("Table")){
				for(TreeItem treeItem2 : sitems){
//					Element sitem = GotXmlDto.getInstance().getCurrentElement(treeItem2);
					addDeletedNodesCache(entityNode.attributeValue("id"), String.valueOf(treeItem2.getData("elementName")));
				}
			}
			setEntityUnsaved();
			doDeleteUiTreeItem(sitems);
		}
	}
	
	public void setEntityUnsaved(){
		TreeItem treeItem = getEntityTreeItem(this.treeitem);
		Element _entityNode = GotXmlDto.getInstance().getCurrentElement(treeItem);
		if(_entityNode != null && _entityNode.attribute("saved") == null){
			_entityNode.addAttribute("saved", "0");
		}
		for (TreeUi treeUi : FormDataSyn.treeUis) {
			String id = treeItem.getData("id").toString();
			TreeItem item = FormDataSyn.getTreeItrmEntityById(treeUi, id);
			if(item != null){
				FormDataSyn.setUnSave(item);
			}
		}
	}
	
	public static Map<String, List<String>> deletedNodesCache = new HashMap<String, List<String>>();
	
	private static void addDeletedNodesCache(String entityid, String name){
		if(deletedNodesCache.get(entityid) != null){
			List<String> sv = deletedNodesCache.get(entityid);
			if(sv.indexOf(name)==-1)
				sv.add(name);
		}else{
			List<String> sv = new ArrayList<>();
			sv.add(name);
			deletedNodesCache.put(entityid, sv);
		}
	}
	
	private static void clearDeletedNodesCache(String key){
		deletedNodesCache.remove(key);
	}
	
	public static List<String> getDeletedNodesCache(String key){
		return deletedNodesCache.get(key);	
	}
	
	private static TreeItem getEntityTreeItem(TreeItem treeItem){
		Object element = GotXmlDto.getInstance().getCurrentElement(treeItem);
		if(element == null){
			return getEntityTreeItem(treeItem.getParentItem());
		}else{
			Element entity = (Element) element;
			if(entity.attribute("version") != null){
				return treeItem;
			}else{
				return getEntityTreeItem(treeItem.getParentItem());
			}
		}
	}
	
	private void doDeleteUiTreeItem(TreeItem[] sitems){
		for (TreeItem treeItem : sitems) {
//			Element element = NodeGOT.getEntity(this.currentTreeNode);
////			if(element.attributeValue("id").equals(this.currentTreeNode.attributeValue("id"))){
////				GotXmlDto.getInstance().deleteEntityElement(element);
////			}else{
////				GotXmlDto.getInstance().updateEntityElement(NodeGOT.getEntity(this.currentTreeNode));
////			}
			FormDataSyn.deleteTreeItem(treeItem);
		}
	}
	
	/**
	 * 
	 * 
	 * 以上是删除
	 * 
	 * 
	 * 
	 * 
	 * @return
	 */
	public boolean _isDeletingNode = false;
	
	private void doCmi_Revert(NodeGOT node){
		_isDeletingNode = false;
		
		String nodeType = node.rNode.getInfoValue("NodeType");
		
		switch(nodeType){
			case "entity":{
				if("0".equals(this.currentTreeNode.attribute("version"))){
					FormDataSyn.setSaved(treeitem);
					this.deleteNode(new TreeItem[]{treeitem});
					break;
				}else{
					Entity entity = null;
					if(node instanceof Entity){
						entity = (Entity) node; 
					}
					if(entity == null)
						return;
					String result = LoadXmlCore.gotServices.revertEntity(this.currentTreeNode.asXML());
					rpc_result_Revert(result, entity);
					break;
				}
			}
			case "inner":{
				TreeItem[] sitems = this.treeitem.getParent().getSelection();
				if(this.deleteNode(sitems)==true){
					Element entityNode = NodeGOT.getEntity(currentTreeNode);
					setEntityUnsaved();
					if(entityNode.getName().equals(GOTNodesConst.TABLE)){
						for (TreeItem treeItem : sitems) {
							Element sitem = GotXmlDto.getInstance().getCurrentElement(treeItem);
							addDeletedNodesCache(entityNode.attributeValue("id"), sitem.attributeValue("name"));
						}
					}
				}
				break;
			}
				
			case "branch":{
				TreeItem[] sitems = this.treeitem.getParent().getSelection();
				if(sitems.length==1){
					if(this.deleteNode(sitems)==true){
						setEntityUnsaved();
					}
				}
				break;
			}
				
			default:break;
		}
	}
	
	public void restoreNode(){
		//选中的节点的getCurrentNode
		Element item = this.currentTreeNode;
		//获取选中新增节点的解析器
		NodeGOT node = NodeFactory.getNode(item);
		if("0".equals(item.attributeValue("version"))){
			TreeOperationInfo.addInfo(treeitem.getText() + "恢复：" + Macros.WARNING_VERSION_ZERO);
			ConfigComposite.configComposite.set_text_op_info(Macros.WARNING_VERSION_ZERO);
			return ;
		}
		String name = item.getName();
		
		String nodeType = node.rNode.getInfoValue("NodeType");
		switch(nodeType){
			case "entity":{
				String result = "";
				try {
					result = LoadXmlCore.gotServices.getEntity(item.attributeValue("id"));
				} catch (Exception e) {
					e.printStackTrace();
					GOTMessageDialog.alert(e);
				}
				rpc_result_Restore(result);
				break;
			}
			case "outer":{
				String result = "";
				if(name.equals("Enums")){
					result = GotXmlDto.getInstance().getServiceEntity("Enums");
				}else if(name.equals("DataTypes")){
					result = GotXmlDto.getInstance().getServiceEntity("DataTypes");
				}else if(name.equals("Tables")){
					result = GotXmlDto.getInstance().getServiceEntity("Tables");
				}else if(name.equals("Menus")){
					result = GotXmlDto.getInstance().getServiceEntity("Menus");
				}else if(name.equals("MenuItems")){
					result = GotXmlDto.getInstance().getServiceEntity("MenuItems");
				}else if(name.equals("Forms")){
					result = GotXmlDto.getInstance().getServiceEntity("Forms");
				}else if(name.equals("Reports")){
					result = GotXmlDto.getInstance().getServiceEntity("Reports");
				}else if(name.equals("Classes")){
					result = GotXmlDto.getInstance().getServiceEntity("Classes");
				}
				rpc_result_Restore(result);
				break;
			}
				
			default:break;
		}
	}
	
	private void rpc_result_Restore(String result){
		if(!validateResult(result))
			return;
		Element resultXML = GOTXMLHelper.createElementByXMLString(result);
		String baseId = treeitem.getData("id").toString();
		TreeItem item = FormDataSyn.treeUis.get(0).itemsMap.get(baseId);
		rpc_ui_Restore(item, resultXML);
	}
	
	private void rpc_ui_Restore(TreeItem item, Element resultXML){
//		Element element = GotXmlDto.getInstance().getCurrentElement(item);
		TreeOperationInfo.addInfo(treeitem.getText() + "恢复：" + Macros.INFO_OPR_SUCCESS);
		ConfigComposite.configComposite.set_text_op_info(Macros.INFO_OPR_SUCCESS);
		GotXmlDto.getInstance().updateEntityElement(resultXML);
		FormDataSyn.restore(item, resultXML, false);
//		Element parent = element.getParent();
//		if(parent != null){
//			GOTHelp.insertChildBefore(parent, element, resultXML);
//			parent.remove(element);

//		}else{
//			GOTMessageDialog.alert("当前节点没有父节点！");
//		}
	}
	
	/**
	 * 
	 * 
	 * 
	 * 同步
	 * 
	 * 
	 */
	
	private ProgressBarUtil barUtil;
	
	public void syncNodes(){
		MessageBox messagebox = new MessageBox(GOTMessageDialog.shell, SWT.ICON_QUESTION
                | SWT.YES | SWT.NO);
        messagebox.setText("确认操作");
        messagebox.setMessage("确定要同步吗") ;
        int message = messagebox.open();
        if(message == SWT.YES){
    		barUtil = new ProgressBarUtil(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE, this);
    		barUtil.open();
        }
	}
	
	public void doSyncNodes(){
		TreeItem[] items = this.treeitem.getParent().getSelection();
		int length = items.length;
		String name = "";
		if(length == 1){
			name = items[0].getText();
			if(name.equals("Enums") || name.equals("DataTypes") || name.equals("Tables") || name.equals("Menus")||
					name.equals("MenuItems") || name.equals("Forms") || name.equals("Reports") || name.equals("Classes")
					|| name.equals("GOT")){
				barUtil.setShellText("正在同步：" + name);
				syncNode(name);
				return;
			}else if(name.equals("DataDictionary")){
				GOTMessageDialog.alert("不支持同步" + name);
				return;
			}
		}
		syncResultString = "";
		for (int i =0 ; i < length; i ++) {
			TreeItem treeItem = items[i];
			Element item = GotXmlDto.getInstance().getCurrentElement(treeItem);
			syncNode(item);
			if(barUtil != null && !barUtil.shell.isDisposed()){
				barUtil.setShellText("正在同步：" + item.attributeValue("name"));
				int num = (i + 1) * 100 / length;
				barUtil.setProgressBar(num);
			}else{
				break;
			}
		}
		Display.getDefault().asyncExec(new Runnable() {
			public void run() {
				if(!barUtil.shell.isDisposed()){
					barUtil.shell.dispose();
					syncMessage();
				}
			}
		});
	}
	
	public void syncMessage(){
		Element xml = rpc_result_sync(syncResultString);
		if(SyncResultXMl == null){
			SyncResultXMl = xml;
		}else{
			SyncResultXMl.add(xml.detach());
		}
		if(SyncResultXMl != null){
			GOTMessageDialog.showSynResult(SyncResultXMl);
		}
	} 
	
	public void syncNode(final String name){
    	Thread thread = new Thread(new Runnable() {
			@Override
			public void run() {
				String result = "";
				try {
					if(name.equals("Enums")){
						result = LoadXmlCore.gotServices.syncEntitys(EntityType.Enum);
					}else if(name.equals("DataTypes")){
						result = LoadXmlCore.gotServices.syncEntitys(EntityType.DataType);
					}else if(name.equals("Tables")){
						result = LoadXmlCore.gotServices.syncEntitys(EntityType.Table);
					}else if(name.equals("Menus")){
						result = LoadXmlCore.gotServices.syncEntitys(EntityType.Menu);
					}else if(name.equals("MenuItems")){
						result = LoadXmlCore.gotServices.syncEntitys(EntityType.MenuItem);
					}else if(name.equals("Forms")){
						result = LoadXmlCore.gotServices.syncEntitys(EntityType.Form);
					}else if(name.equals("Reports")){
						result = LoadXmlCore.gotServices.syncEntitys(EntityType.Report);
					}else if(name.equals("Classes")){
						result = LoadXmlCore.gotServices.syncEntitys(EntityType.Class);
					}else if(name.equals("GOT")){
						result = LoadXmlCore.gotServices.syncGOT();
					}
				} catch (Exception e) {
					e.printStackTrace();
					syncResultString +=  name + " " + e.getMessage()  + ":sync False \n";
					return;
				}
				rpc_result_Sync(result, null);
				Display.getDefault().asyncExec(new Runnable() {
					public void run() {
						barUtil.shell.dispose();
						syncMessage();
					}
				});
			}
		});
    	thread.start();
	}
	
	public void syncNode(Element item){
		//获取选中新增节点的解析器
		NodeGOT node = NodeFactory.getNode(item);
		String nodeType = node.rNode.getInfoValue("NodeType");
		String name = item.getName();
		switch(nodeType){
			case "outer":
				MessageBox messagebox = new MessageBox(GOTMessageDialog.shell, SWT.ICON_QUESTION
		                | SWT.YES | SWT.NO);
		        messagebox.setText("确认操作");
		        messagebox.setMessage("确定要同步吗") ;
		        int message = messagebox.open();
		        if(message == SWT.YES){
					String result = "";
					try {
						if(name.equals("Enums")){
							result = LoadXmlCore.gotServices.syncEntitys(EntityType.Enum);
						}else if(name.equals("DataTypes")){
							result = LoadXmlCore.gotServices.syncEntitys(EntityType.DataType);
						}else if(name.equals("Tables")){
							result = LoadXmlCore.gotServices.syncEntitys(EntityType.Table);
						}/*else if(name.equals("Maps")){
							result = LoadXmlCore.gotServices.syncMaps();
						}*/else if(name.equals("Menus")){
							result = LoadXmlCore.gotServices.syncEntitys(EntityType.Menu);
						}else if(name.equals("MenuItems")){
							result = LoadXmlCore.gotServices.syncEntitys(EntityType.MenuItem);
						}/*else if(name.equals("Queries")){
							result = LoadXmlCore.gotServices.syncQueries();
						}*/else if(name.equals("Forms")){
							result = LoadXmlCore.gotServices.syncEntitys(EntityType.Form);
						}else if(name.equals("Reports")){
							result = LoadXmlCore.gotServices.syncEntitys(EntityType.Report);
						}else if(name.equals("Classes")){
							result = LoadXmlCore.gotServices.syncEntitys(EntityType.Class);
						}
					} catch (Exception e) {
						e.printStackTrace();
						syncResultString += item.attributeValue("id") + "." + item.attributeValue("name") + " " + e.getMessage()  + ":sync False \n";
						return;
					}
					rpc_result_Sync(result, null);
		        }
		        
				break;
			case "entity": 
				if(item.attribute("saved") != null ){
					TreeOperationInfo.addInfo(treeitem.getText() + "同步：" + Macros.WARNING_DATA_UNSAVED);
					ConfigComposite.configComposite.set_text_op_info(Macros.WARNING_DATA_UNSAVED);
				}else{
					String result = "";
					try {
						result = LoadXmlCore.gotServices.syncEntity(item.asXML());
					} catch (Exception e) {
						e.printStackTrace();
						syncResultString += item.attributeValue("id") + "." + item.attributeValue("name") + " " +  e.getMessage() + ":sync False \n";
						return;
					}
					rpc_result_Sync(result, item);
					
				}
				break;
			default :
				break;
		}
	}
	
	private Element SyncResultXMl = null;
	private String syncResultString = "";
	
	private void rpc_result_Sync(String result, Element item) {
		if(result.equals(Macros.INFO_TRUE)){
			TreeOperationInfo.addInfo(treeitem.getText() + "同步:" + Macros.INFO_OPR_SUCCESS);
			ConfigComposite.configComposite.set_text_op_info(Macros.INFO_OPR_SUCCESS);
			if(item != null){
				syncResultString += item.attributeValue("id") + "." + item.attributeValue("name") + ":sync OK\n";
			}
		}else if(result.length() > 5 && result.substring(0,5).equals(Macros.INFO_FALSE)){
			TreeOperationInfo.addErrorInfo(item.attributeValue("name") + result);
			if(item != null){
				syncResultString += item.attributeValue("id") + "." + item.attributeValue("name") + ":sync False \n";
			}
		}else{
			syncResultString += result;
		}
	}
	
	private Element rpc_result_sync(String result){
		Element xml = GOTXMLHelper.createElement("tempRoot");
		String[] strs = result.split("\\n");
		for (String string : strs) {
			if(!"".equals(string)){
				String[] rtype = string.split(":");
				String nodeName = rtype[1];
				if(xml.element(nodeName) == null){
					xml.addElement(nodeName);
					xml.element(nodeName).addElement(nodeName).setText(rtype[0]);
				}else{
					xml.element(nodeName).addElement(nodeName).setText(rtype[0]);
				}
			}
		}
		@SuppressWarnings("unchecked")
		List<Element> list = xml.elements();
		for (Element element : list) {
			List<?> list2 = element.elements();
			element.setName(element.getName() + list2.size());
		}
		return xml;
	}
	
	/**
	 * 
	 * 
	 * 
	 * 
	 * 
	 */
	
	public void duplicateNode(){
		Element item = this.currentTreeNode;
		String name = item.getName();
		String id = "";
		try {
			id = LoadXmlCore.gotServices.getEntityId(EntityType.valueOf(name));
		} catch (Exception e) {
			e.printStackTrace();
			GOTMessageDialog.alert(e);
			return;
		}
		if(id.equals("-1")){
			GOTMessageDialog.alert("获取id失败");
			return;
		}
		rpc_result_Duplicate(id);
	}
	
	private void rpc_result_Duplicate(String id){
		if(id != null && !id.equals("")){
			Element item = this.currentTreeNode;
			Element copy = item.createCopy();
			Boolean current = copy.attributeValue("createdLayer").equals(ObjectContainer.getInstance(LayerService.class).getCurrentLayer());
			copy.addAttribute("createdLayer", ObjectContainer.getInstance(LayerService.class).getCurrentLayer());
			copy.addAttribute("modifiedLayer", ObjectContainer.getInstance(LayerService.class).getCurrentLayer());
			copy.addAttribute("name", item.attributeValue("name") + "_copy");
			copy.addAttribute("id", id);
			copy.addAttribute("version", "0");
			copy.addAttribute("saved", "0");
			String nodeName = item.getName();
			if(!current){
				int base = ObjectContainer.getInstance(LayerLevelManager.class).getLayerLevel(ObjectContainer.getInstance(LayerService.class).getCurrentLayer())*10000;
				int _intNextInnerId = base+1;//base + (now % 10000);
				copy.addAttribute("nextInnerId", String.valueOf(_intNextInnerId));
				nodeName = copy.getName();
				Map<String, Integer> mapIdChanged = new HashMap<>();
				mapIdChanged.put("intNextInnerId", _intNextInnerId);
				descendantsChilds(copy, "Table".equals(nodeName), mapIdChanged);
				descendantsChilds2(copy, "Table".equals(nodeName), mapIdChanged);
				copy.addAttribute("nextInnerId", String.valueOf(mapIdChanged.get("intNextInnerId")));
					
			}
			
			if(nodeName.equals("Form")){
				ConfigComposite.fromNum ++;
				ConfigComposite.text_static_info();
			}else if(nodeName.equals("Table")){
				ConfigComposite.tableNum ++;
				ConfigComposite.text_static_info();
			}
			
			NodeGOT node = NodeFactory.getNode(item);
			node.setBrotherUniqueName(copy);
		 	String treeItemId = NumCore.getId();
		 	int index = 0;
		 	if(this.treeitem.getParentItem() == null){
		 		index = 0;
		 	}else{
		 		index = this.treeitem.getParentItem().indexOf(this.treeitem);
		 	}
		 	
		 	GotXmlDto.getInstance().addEntityElement(copy);
			FormDataSyn.actionSyn(this.getTreeitem(), treeItemId, copy, node, index + 1, "copy");
		}
	}
	
	@SuppressWarnings("unchecked")
	private void descendantsChilds(Element copy, Boolean isTable, Map<String, Integer>mapIdChanged){
		List<Element> childs = copy.elements();
		for(Element child : childs){
			if(child.attribute("createdLayer") != null){
				child.addAttribute("createdLayer", ObjectContainer.getInstance(LayerService.class).getCurrentLayer());
				child.addAttribute("modifiedLayer", ObjectContainer.getInstance(LayerService.class).getCurrentLayer());
			}
			
			if(child.attribute("id") != null ){
				if(child.attribute("id") != null){
					int now = Integer.valueOf(child.attributeValue("id"));
					mapIdChanged.put(String.valueOf(now), mapIdChanged.get("intNextInnerId"));
					child.addAttribute("id", mapIdChanged.get("intNextInnerId").toString());
					int num = mapIdChanged.get("intNextInnerId");
					num ++;
					mapIdChanged.put("intNextInnerId", num);
				}

			}
			
			descendantsChilds(child,isTable,mapIdChanged);
		}
	}
	
	@SuppressWarnings("unchecked")
	private void descendantsChilds2(Element copy, Boolean isTable, Map<String, Integer>mapIdChanged){
		List<Element> childs = copy.elements();
		for(Element child : childs){
			if(child.attribute("innerid") != null){
				String now = child.attributeValue("innerid");
				if(mapIdChanged.containsKey(now))
				child.addAttribute("innerid", mapIdChanged.get(now).toString());
			}
			
			descendantsChilds2(child,isTable,mapIdChanged);
		}
	}
	
	/**
	 * 
	 * 
	 * 
	 * 
	 */
	
	public void showXML(){
		Element item = GotXmlDto.getInstance().getCurrentElement(this.treeitem);
		GOTMessageDialog.showXmlInfo(formatXml(item.asXML()), item.attributeValue("name"));
	}
	
	 public static String formatXml(String str) {
		Document document = null;
		StringWriter writer;
		try {
			document = DocumentHelper.parseText(str);
			  // 格式化输出格式
			  OutputFormat format = OutputFormat.createPrettyPrint();
			  format.setEncoding(FileIO.UTF8);
			  writer = new StringWriter();
			  // 格式化输出流
			  XMLWriter xmlWriter = new XMLWriter(writer, format);
			  // 将document写入到输出流
			  xmlWriter.write(document);
			  xmlWriter.close();
			  str = writer.toString();
		} catch (DocumentException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return str ;
	}
	
	/**
	 * 
	 * 
	 * 
	 * 
	 */
	private ProgressBarRefNodeUtil barRefNodeUtil;
	
	public void enterNodeRef(){
		barRefNodeUtil = new ProgressBarRefNodeUtil(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE, this);
		barRefNodeUtil.open();
	}
	
	public void doEnterNodeRef(){
		Element item = this.currentTreeNode;
		Element _entity = NodeGOT.getEntity(item);
		
		if(_entity==null)
			return;
		
		String _entityId = _entity.attributeValue("id");
		String _innerId;
		if(_entityId.equals(item.attributeValue("id"))){
			_innerId = null;
		}else{
			_innerId = item.attributeValue("id");
		}

		String result = "";
		try {
			result = LoadXmlCore.gotServices.getNodeRef(item.getName(), _entityId, _innerId);
			if(barRefNodeUtil != null && !barRefNodeUtil.shell.isDisposed()){
				barRefNodeUtil.shell.close();
				barRefNodeUtil = null;
			}
		} catch (Exception e) {
			e.printStackTrace();
			GOTMessageDialog.alert(e);
		}
		rpc_result_getNodeRef(result);
	}
	
	private void rpc_result_getNodeRef(String result){
		if(result!=null){
			Element xml = GOTXMLHelper.createElementByXMLString(result);
			GOTMessageDialog.showEnterNodeRef(xml);
		}
		
	}
	
	public void methodSet(){
		Element item = this.currentTreeNode;
		GOTMessageDialog.showMethod(item);
	}
	
	/**
	 * 
	 * 打开新窗口
	 * 
	 */
	public void openNewFrom(final boolean open){
		
		Display.getDefault().asyncExec(new Runnable() {
			@Override
			public void run() {
				if(open){
					Display.getDefault().asyncExec(new Runnable() {
						@Override
						public void run() {
							new TreeUiBean(treeitem, true);
						}
					});
				
				}else{
					Display.getDefault().asyncExec(new Runnable() {
						@Override
						public void run() {
							new TreeUiBean(treeitem, false);
						}
					});
					
				}
			}
		});
	}
	
	/**
	 * 同步数据源字段
	 */
	public void syncFDSF(){
		DoMerge.checkSelectTable();
	}
	
	/**
	 * 重置关联节点名称
	 */
	public void resetRelationName(){
		Element item = this.currentTreeNode;
		if(item.getName().equals("Table")){
			String _entityId = item.attributeValue("id");
			String result = "";
			try {
				result = LoadXmlCore.gotServices.getNodeRef(item.getName(), _entityId, null);
			} catch (Exception e) {
				e.printStackTrace();
				GOTMessageDialog.alert(e);
			}
			if(result!=null){
				Element xml = GOTXMLHelper.createElementByXMLString(result);
				GOTMessageDialog.showEnterNodeReset(xml);
			}
			
		}else if(item.getName().equals("FormDataSource")){
			List<Element> difEle = new ArrayList<>();
			Element form = NodeGOT.getEntity(item);
			String id = item.attributeValue("id");
			String xpath = "//FormItem/Properties/Property[@innerid='" + id + "']";
			List<Element> elements = form.selectNodes(xpath);
			for (Element element : elements) {
				Element parent = element.getParent().getParent();
				String type = parent.attributeValue("type");
				if(parent.getName().equals("FormItem") && !type.equals("Button") && !type.equals("MenuItemButton") 
						 && !type.equals("ButtonMenu")){
					if("FieldGroup".equals(parent.getParent().attributeValue("type"))){
						Element pp = GOTHelp.getProperty(parent.getParent(), "Component");
						if(StringUtils.isNotBlank(pp.elementText("Value"))){
							continue;
						}
					}
					difEle.add(parent);
				}
			}
			GOTMessageDialog.showEnterNodeResetFormDataSource(difEle, item);
		}

	}
	
	public void checkFormDataSourceFieldRate(){
		DoMerge.checkFormDataSourceFieldRate();
	}
}
