package info.gongqi.got.ui;

import java.math.BigDecimal;

import org.dom4j.Element;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wb.swt.SWTResourceManager;

import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.tool.ImageButton;
import info.gongqi.got.util.GOTMessageDialog;

public class TreeUiBean {
	
	public TreeUi treeUip;
//	private Text text_Label_title;
	public Table table;
	public Shell shell;
	public Tree tree;
	private boolean onMouseModfied;
	private Point lastPos;
	private Label coolBar;
	public Label text_op_info;
	
	private Label title_info;
	
	public TreeUiBean(TreeItem treeitem, boolean key, boolean expended){
		init(treeitem, key);
		FormDataSyn.treeUis.get(0).loadChildItem(treeitem);
		TreeUi treeUi = new TreeUi(tree, table, treeitem, expended);
		treeUi.treeUiBean = this;
		FormDataSyn.treeUis.add(treeUi);
		treeUip = treeUi;
		GOTMessageDialog.shells.add(shell);
	}
	
	public TreeUiBean(TreeItem treeitem, boolean key){
		String id = treeitem.getData("id").toString();
		treeitem = FormDataSyn.treeUis.get(0).itemsMap.get(id);
		FormDataSyn.treeUis.get(0).loadChildItem(treeitem);
		if(treeitem != null){
			init(treeitem, key);
			TreeUi treeUi = new TreeUi(tree, table, treeitem);
			treeUi.treeUiBean = this;
			FormDataSyn.treeUis.add(treeUi);
			treeUip = treeUi;
			GOTMessageDialog.shells.add(shell);
		}
	}
	
	private void init(TreeItem treeitem, boolean key){
		Element element = GotXmlDto.getInstance().getCurrentElement(treeitem);
		if(element == null){
			System.err.println("数据丢失，无法打开新窗口");
			return;
		}
		shell = new Shell(GOTMessageDialog.shell, SWT.RESIZE );//SWT.SHELL_TRIM | SWT.BORDER | SWT.ON_TOP
		shell.addShellListener(new ShellAdapter() {
            public void shellClosed(ShellEvent e) {
            	for (int i = 0; i < FormDataSyn.treeUis.size(); i++) {
        			if(TreeUiBean.this.treeUip == FormDataSyn.treeUis.get(i)){
        				FormDataSyn.treeUis.remove(i);
        			}
				}
            	
            }
		});
		
//		shell.setEnabled(false);
//        Monitor monitor = shell.getMonitor();
        final Rectangle bounds =  Display.getDefault().getPrimaryMonitor().getBounds();
        shell.setLocation (bounds.x + 100, bounds.y + 100);
        shell.setLayout(new FormLayout());
        int hight = 555;
        int phight =  GOTMessageDialog.shell.getBounds().height;
        if(hight > phight){
        	hight = (int) (phight * 0.9);
        }
        hight =  new BigDecimal(hight).divide(ConfigComposite.configComposite.DPIZOOM).intValue();
		if(key){
			shell.setSize(309, hight);
//			shell.setSize((int)(bounds.width * 0.4),(int)( bounds.height * 0.7));
		}else{
			shell.setSize(625, hight);
//			shell.setSize((int)(bounds.width * 0.45),(int)( bounds.height * 0.7));
		}
        Label block = new Label(shell, SWT.NONE);
		FormData fd_title_block = new FormData();
		fd_title_block.top = new FormAttachment(shell, 0);
		fd_title_block.bottom = new FormAttachment(0, 30);
		fd_title_block.left = new FormAttachment(0, 0);
		fd_title_block.right = new FormAttachment(0, 5);
		block.setLayoutData(fd_title_block);
		block.setBackground(new Color(shell.getDisplay(), 255,255,255));
        
        title_info = new Label(shell, SWT.NONE);
		FormData fd_title_info = new FormData();
		fd_title_info.top = new FormAttachment(shell, 0);
		fd_title_info.bottom = new FormAttachment(0, 30);
		fd_title_info.left = new FormAttachment(block, 0);
		fd_title_info.right = new FormAttachment(100, -45);
		title_info.setLayoutData(fd_title_info);
		title_info.setText(element.getName());
		title_info.setBackground(new Color(shell.getDisplay(), 255,255,255));
		FontData data = title_info.getFont().getFontData()[0];
		data.setStyle(SWT.BOLD);
		title_info.setFont(new Font(shell.getDisplay(), data));
		
		ImageButton buttonClose = new ImageButton(shell, SWTResourceManager.getImage(this.getClass(), "/resources/window_close.png"), 
				SWTResourceManager.getImage(this.getClass(), "/resources/window_close_hover.png"));
		buttonClose.setSize(25, 25);
		FormData fd_title_btn = new FormData();
		fd_title_btn.top = new FormAttachment(shell, 0);
		fd_title_btn.bottom = new FormAttachment(0, 30);
		fd_title_btn.left = new FormAttachment(100, -45);
		fd_title_btn.right = new FormAttachment(100, 0);
		buttonClose.setLayoutData(fd_title_btn);
		buttonClose.setBackground(new Color(shell.getDisplay(), 255,255,255));
		buttonClose.addSelectionListener(new SelectionListener() {
			
			@Override
			public void widgetSelected(SelectionEvent var1) {
				shell.close();
			}
			
			@Override
			public void widgetDefaultSelected(SelectionEvent var1) {
				
			}
		});
		
		
		
		Listener listener = new Listener() {  
		    int startX, startY;  
		    public void handleEvent(Event e) {  
		        if (e.type == SWT.MouseDown && e.button == 1) {  
		            startX = e.x;  
		            startY = e.y;  
		        }  
		        if (e.type == SWT.MouseMove && (e.stateMask & SWT.BUTTON1) != 0) {  
		            Point p = shell.toDisplay(e.x, e.y);  
		            p.x -= startX;  
		            p.y -= startY;  
		            
		            int parentX = Display.getDefault().getBounds().x;
					int parentY = Display.getDefault().getBounds().y;
					
					if(p.x <= parentX + 10 || p.y <= parentY + 110 || p.x + shell.getBounds().width >= parentX + bounds.width - 10
							|| p.y + shell.getBounds().height >= parentY + bounds.height - 10){
						return;
					}
		            
		            shell.setLocation(p);  
		        }  
		    }  
		};  
		title_info.addListener(SWT.MouseDown, listener);  
		title_info.addListener(SWT.MouseMove, listener);
		
        //这里必须要有TreeViewer 否则无法加载
//        TreeViewer treeViewer = new TreeViewer(shell, SWT.BORDER | SWT.MULTI | SWT.FULL_SELECTION);
//        tree = treeViewer.getTree();
        tree = new Tree(shell, SWT.BORDER | SWT.FULL_SELECTION ^ SWT.H_SCROLL | SWT.MULTI);
        FormData fd_tree_1 = new FormData();
        if(key){
        	fd_tree_1.right = new FormAttachment(100, -5);
        }else{
        	fd_tree_1.right = new FormAttachment(51, -10);
        }
        fd_tree_1.bottom = new FormAttachment(100, -20);
        fd_tree_1.top = new FormAttachment(title_info, 2);
        fd_tree_1.left = new FormAttachment(0, 5);
        tree.setLayoutData(fd_tree_1);
        tree.getHorizontalBar().setEnabled(false);
        Font fonts = new Font(tree.getDisplay(), "宋体", 9, SWT.NONE);
        tree.setFont(fonts);
        
        coolBar = new Label(shell, SWT.BORDER);
		FormData fd_coolBar = new FormData();
		fd_coolBar.top = new FormAttachment(title_info, 2);
	    fd_coolBar.bottom = new FormAttachment(100, -20);
		fd_coolBar.left = new FormAttachment(tree, 0);
		fd_coolBar.right = new FormAttachment(51, 0);
		coolBar.setLayoutData(fd_coolBar);
		coolBar.setBackground(new Color(coolBar.getDisplay(), 240,240,246));
		
		final Cursor CURSOR_SIZEWE = new Cursor(Display.getDefault(),SWT.CURSOR_SIZEWE);
		coolBar.setCursor(CURSOR_SIZEWE);
		coolBar.addMouseMoveListener(new MouseMoveListener() {
			
			Long lastTime = System.currentTimeMillis();
					
			@Override
			public void mouseMove(MouseEvent e) {
				if(onMouseModfied && (System.currentTimeMillis() -lastTime) > 50){
                    Point pos=((Control)(e.widget)).toDisplay(e.x, e.y);
                    modify(pos.x-lastPos.x, new Rectangle(1,0,1,1));
                    lastPos = pos;
                    lastTime = System.currentTimeMillis();
				}
			}
		});
		
		coolBar.addMouseListener(new MouseAdapter() {           
            @Override
            public void mouseDown(MouseEvent e) {
                // 记录当前鼠标位置，以供mouseMove消息时计算鼠标移动距离
                lastPos=((Control)(e.widget)).toDisplay(e.x, e.y);
                onMouseModfied=true;
            }
            
            @Override
            public void mouseUp(MouseEvent e) {
                onMouseModfied=false;
            }
        });
		
        table = new Table(shell, SWT.BORDER | SWT.MULTI | SWT.FULL_SELECTION | SWT.V_SCROLL);
        if(!key){
            FormData fd_table = new FormData();
            fd_table.top = new FormAttachment(title_info, 2);
            fd_table.bottom = new FormAttachment(100, -20);
            fd_table.left = new FormAttachment(coolBar, 0);
            fd_table.right = new FormAttachment(100, -5);
            table.setLayoutData(fd_table);
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            Rectangle bound = table.getBounds();
    		TableColumn Name = new TableColumn(table, SWT.NONE);
    		Name.setWidth(bound.width/2 -5);
    		Name.setText("Name");
    		
    		TableColumn Value = new TableColumn(table, SWT.NONE);
    		Value.setWidth(bound.width/2 -5);
    		Value.setText("Value");
        }
        table.setFont(fonts);
        
		initTextLabel(shell);
		
        tree.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
                TreeItem trtmNewTreeitem = (TreeItem) event.item;
                Element element = GotXmlDto.getInstance().getCurrentElement(trtmNewTreeitem);
                if(element != null){
                	String titleInfo = element.getName();
                	if(element.attribute("name") != null){
                		titleInfo += " name=" + element.attributeValue("name");
                	}
                	if(element.attribute("id") != null){
                		titleInfo += " id=" + element.attributeValue("id");
                	}
                	if(element.attribute("version") != null){
                		titleInfo += " version=" + element.attributeValue("version");
                	}
                	if(element.attribute("vislble") != null){
                		titleInfo += " vislble=" + element.attributeValue("vislble");
                	}
                	if(element.attribute("locked") != null){
                		titleInfo += " locked=" + element.attributeValue("locked");
                	}
                	if(element.attribute("type") != null){
                		titleInfo += " type=" + element.attributeValue("type");
                	}
                 	if(element.attribute("createdLayer") != null){
                 		titleInfo += " createdLayer=" + element.attributeValue("createdLayer");
                 	}
                 	if(element.attribute("modifiedLayer") != null){
                 		titleInfo += " modifiedLayer=" + element.attributeValue("modifiedLayer");
                 	}
//                	text_Label_title.setText(titleInfo);
                	title_info.setText(titleInfo);
                }
            }
        });
        
        tree.addListener(SWT.Expand, new Listener() {
            public void handleEvent(Event event) {
            	TreeItem trtmNewTreeitem = (TreeItem) event.item;
            	if(trtmNewTreeitem == null || trtmNewTreeitem.getText().equals("Tables") || trtmNewTreeitem.getText().equals("Forms")){
            		event.doit = false;
            		return;
            	}
            	if(trtmNewTreeitem.getData("items") != null && trtmNewTreeitem.getData("items").equals("part")){
                	String id = (String) trtmNewTreeitem.getData("id");
                	TreeItem base = FormDataSyn.treeUis.get(0).itemsMap.get(id);
                	if(base != null){
                		trtmNewTreeitem.removeAll();
                		FormDataSyn.restoreSyn(base, trtmNewTreeitem, treeUip, false);
                		trtmNewTreeitem.setData("items", "all");
                	}
            	}
            }
            
        });
        
        text_op_info = new Label(shell,SWT.READ_ONLY);
        FormData text_op_info_data = new FormData();
        text_op_info_data.right = new FormAttachment(100, -5);
        text_op_info_data.bottom = new FormAttachment(100, 0);
        text_op_info_data.top = new FormAttachment(tree, 0);
        text_op_info_data.left = new FormAttachment(0, 5);
        text_op_info.setLayoutData(text_op_info_data);
        text_op_info.setForeground(shell.getDisplay().getSystemColor(SWT.COLOR_RED));
        
        text_op_info.addListener(SWT.MouseDoubleClick, new Listener() {
            public void handleEvent(Event event) {
                FormData fd_tree_1 = new FormData();
                fd_tree_1.bottom = new FormAttachment(100, -20);
                fd_tree_1.top = new FormAttachment(title_info, 0);
                fd_tree_1.left = new FormAttachment(0, 5);
               
            	if(table.getVisible()){
            		fd_tree_1.right = new FormAttachment(100, -5);
            		Rectangle rectangle = shell.getBounds();
            		rectangle.width = tree.getBounds().width + 20;
            		shell.setBounds(rectangle);
            		Rectangle rectangleTree = tree.getBounds();
            		rectangleTree.width = rectangle.width -25;
            		tree.setBounds(rectangleTree);
            		 tree.setLayoutData(fd_tree_1);
            	}else{
            		fd_tree_1.right = new FormAttachment(51, -10);
            		Rectangle rectangle = shell.getBounds();
//            		rectangle.width = (int)(bounds.width * 0.45);
            		rectangle.width = 625;
            		shell.setBounds(rectangle);
            		Rectangle rectangleTree = tree.getBounds();
            		rectangleTree.width = rectangle.width/2-10;
            		tree.setBounds(rectangleTree);
            		tree.setLayoutData(fd_tree_1);
            		shell.setSize(625 + 1,555);
            	}
            	table.setVisible(!table.getVisible());
            	coolBar.setVisible(table.getVisible());
            }
        });
        shell.open();
	}
	
    /**
     * 改变窗口位置和尺寸
     * @param x x轴移动距离
     * @param y y轴移动距离
     * @param mask 锚点位置计算的掩码
     */
    protected void modify(int x,Rectangle mask){
        // 计算出新的窗口位置和尺寸
        Rectangle boundTree = tree.getBounds();
        boundTree.width += x*mask.width;
        tree.setBounds(boundTree);
        
        Rectangle boundLable = coolBar.getBounds();
        boundLable.x += x*mask.x;
        coolBar.setBounds(boundLable);
        
        Rectangle boundTable = table.getBounds();
        boundTable.x += x*mask.x;
        boundTable.width += -x*mask.width;
        table.setBounds(boundTable);
        
    }
    
	private void initTextLabel(Composite parentCom){
    	FormData dataLabel = new FormData();
    	dataLabel.top = new FormAttachment(0,0);
    	dataLabel.left = new FormAttachment(0,5);
    	dataLabel.right = new FormAttachment(100,-5);
    	dataLabel.bottom = new FormAttachment(0,30);
	}
	
}
