package info.gongqi.got.ui;

import gongqi.designer.core.DesignerServer;
import gongqi.designer.got.ref.RefErrorNode;
import gongqi.designer.services.CodeService;
import gongqi.designer.services.DatabaseService;
import gongqi.designer.services.GOTService;
import gongqi.erp.framework.core.ObjectContainer;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.util.GOTMessageDialog;
import info.gongqi.got.util.GOTUtil;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.resolvergot.ResolverUi;
import client.gongqi.designer.toolsgot.GOTXMLHelper;

public class LoadXmlCore {
	
	private static Logger log = Logger.getLogger(LoadXmlCore.class);
	
	public static GOTService gotServices;
	public static CodeService codeServices;
	public static DatabaseService databaseServices;
	public static List<Map<String, Object>> softData ;
	public static boolean softModel = false;
	public static Map<String, Map<String, String>> gotMap = new HashMap<>();
	
	public static void init(final Tree tree, final Table table){
		if(!DesignerServer.status.equals("started")){
			try {
				File file = new File(GOTUtil.proect_root);
//				DesignerServer.db_url = GOTUtil.jdbc_url;
//				DesignerServer.db_username = GOTUtil.jdbc_name;
//				DesignerServer.db_password = GOTUtil.jdbc_password;
				DesignerServer.start(file);
				
				gotServices = ObjectContainer.getInstance(GOTService.class);
				codeServices = ObjectContainer.getInstance(CodeService.class);
				databaseServices = ObjectContainer.getInstance(DatabaseService.class);
				ConfigComposite.progressBar.setProgressBar(20);
				
				Display.getDefault().syncExec(new Runnable() {
					@Override
					public void run() {
						boolean result = GOTMessageDialog.ChoseUser();
						if(result){
							tree.setBackgroundImage(null);
							Element e = null;
							TreeUi treeUi = new TreeUi(tree, table, e);
							FormDataSyn.treeUis.add(treeUi);
							ConfigComposite.text_static_info();
						}else{
							Display.getDefault().syncExec(new Runnable() {
								@Override
								public void run() {
									ConfigComposite.progressBar.setShellText("加载配置错误");
									ConfigComposite.progressBar.setProgressBar(100);
									ConfigComposite.configComposite.init();
									ConfigComposite.configComposite.button_restart.setEnabled(true);
								}
							});
						}
					}
				});
			} catch (final Exception e) {
				Display.getDefault().syncExec(new Runnable() {
					@Override
					public void run() {
						ConfigComposite.progressBar.setShellText("加载配置错误");
						ConfigComposite.progressBar.setProgressBar(100);
						ConfigComposite.configComposite.init();
						ConfigComposite.configComposite.button_restart.setEnabled(true);
					}
				});
		        Display.getDefault().syncExec(new Runnable() {
					@Override
					public void run() {
						GOTMessageDialog.alert(e);
						
					}
		        });
				return;
			}
		}
	}
	
	@SuppressWarnings("unchecked")
	public static void load(){
		Display.getDefault().syncExec(new Runnable() {
			
			@Override
			public void run() {
				ConfigComposite.progressBar.setShellText("正在加载GOT");
				ConfigComposite.progressBar.setProgressBar(30);
			}
		});
		
		GotXmlDto.getInstance().init();
		//赋值全局GOT
		ResolverUi.init();
		softData = new ArrayList<Map<String,Object>>();
		NodeGOT.gridRightMenuData = GOTXMLHelper.createElementByXMLString(NodeGOT.gridRightMenuDataString);
	}
	
	public static void softModel(){
		try {
			if(LoadXmlCore.gotServices.isSafeMode()){
				log.info("进入安全模式");
				Object object = gotServices.getErrors();
				Map<String, Object> map =  (Map<String, Object>) object;
				List<RefErrorNode> ref = (List<RefErrorNode>) map.get("ref");
				List<Map<String, Object>> db = (List<Map<String, Object>>) map.get("db");
				if(!ref.isEmpty()){
					for (RefErrorNode mapNode : ref) {
						softData.add(javaBeanMap(mapNode));
					}
				}
				if(!db.isEmpty()){
					softData.addAll(db);
				}
				Display.getDefault().syncExec(new Runnable() {
					
					@Override
					public void run() {
						ConfigComposite.label_soft.setText("异常数量" + softData.size());
						ConfigComposite.label_soft.setVisible(true);
					}
				});
				
				
				String xml = "<menuitem label='修改继承关系' func='modifyExtends'/>";
				Element addele = GOTXMLHelper.createElementByXMLString(xml);
				NodeGOT.gridRightMenuData.add(addele.detach());
				softModel = true;
			}
			Display.getDefault().syncExec(new Runnable() {
				
				@Override
				public void run() {
					FormDataSyn.treeUis.get(0).afterInit();
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
			GOTMessageDialog.alert(e);
		}
	}
	
	public static Map<String, Object> javaBeanMap(RefErrorNode javaBean) {
        Map<String, Object> map = new HashMap<>();
        if(javaBean.entityId != null){
        	map.put("entityId", javaBean.entityId);
        }
        if(javaBean.errorInfo != null){
        	map.put("errorInfo", javaBean.errorInfo);
        }
        if(javaBean.innerId != null){
        	map.put("innerId", javaBean.innerId);
        }
        if(javaBean.nodeType != null){
        	map.put("nodeType", javaBean.nodeType);
        }
        if(javaBean.propertyName != null){
        	map.put("propertyName", javaBean.propertyName);
        }
        return map;
    }
	
	
	
	
	
}
