package info.gongqi.got.ui;

import gongqi.designer.core.DesignerContext;
import gongqi.designer.services.LayerService;
import gongqi.designer.utils.GOTHelper;
import gongqi.erp.framework.core.LayerConstants;
import gongqi.erp.framework.core.ObjectContainer;
import info.gongqi.got.tool.GotLayerAndUserDialog;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.bcel.generic.IF_ACMPEQ;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class LoadXML {
	
	public static Map<String, String> map = new HashMap<>();
	
	/**
	 * 获取node的text
	 * @param node
	 * @return
	 */
	public static String nodeText(Element node){
		String result = "";
		if(node.attribute("name") != null ){
			if(node.getName().equals("FormItem")){
				result = node.attributeValue("type") + "::" + node.attributeValue("name");
			}else{
				result = node.attributeValue("name");
			}
		}
		//只有实体节点才需要隐藏前缀FormDataSourceField
		if(node.attribute("version") != null){
			if(!ConfigComposite.configComposite.button_pre.getSelection()){
				result = fmt(result);
			}
		}
//		else if(!node.getName().equals("FormDataSourceField") && !node.getName().equals("FormDataSourceRelationItem")){
//			result = fmt(result);
//		}
		
		return result;
	}
	
	public static String fmt(String tar){
		if(tar.contains(".")){
			String[] name = tar.split("\\.");
			tar = name[name.length - 1];
		}
		return tar;
	}
	
	public static boolean nodeShowRule(Element node){
		String name = node.getName();
		if("Properties".equals(name)){
			return false;
		}else{
			if(name.equals("Enum") || name.equals("DataType") || name.equals("Table") ||
					name.equals("Map") || name.equals("Menu") || name.equals("MenuItem") ||
					name.equals("Form") || name.equals("Class") || name.equals("Report")){
				/*String id = node.attributeValue("id");
				String modifiedLayer = node.attributeValue("modifiedLayer");
				
				if(!shouLayer(modifiedLayer)){
					return false;
				}
				
				if("app".equals(GotLayerAndUserDialog.layer)){
					if("ext".equals(modifiedLayer)){
						return false;
					}
					
					if(id.contains(".") && !id.startsWith(GotLayerAndUserDialog.solution)){
						return false;
					}
				}else if("ext".equals(GotLayerAndUserDialog.layer)){
					if("ext".equals(modifiedLayer) || "app".equals(modifiedLayer)){
						if(id.contains(".") && !id.startsWith(GotLayerAndUserDialog.solution)){
							return false;
						}
					} else if (LayerConstants.SOLUTION_PLUGIN_LAYER.equals(modifiedLayer)){
						
					}
				}*/
				return true;
			}
			Attribute attribute = node.attribute("fixVisible");
			if(attribute != null){
				if(attribute.getValue().equals("false")){
					return false;
				}
			}
			
			Attribute att = node.attribute("visible");
			if(att != null){
				if(att.getValue().equals("false")){
					String createLayer = node.attributeValue("createdLayer");
					if(!createLayer.equals(ObjectContainer.getInstance(LayerService.class).getCurrentLayer())){
						return false;
					}
				}
			}
		}

		return true;
	}
	
	public static boolean nodeShowRuleDoMerge(Element node){
		String name = node.getName();
		if("Properties".equals(name)){
			return false;
		}else{
			DesignerContext designerContext = ObjectContainer.getInstance(DesignerContext.class);
			Element entityElement = GOTHelper.getEntityElement(node);
			String entityId = entityElement.attributeValue("id");
			if (entityElement.attributeValue("modifiedLayer").equals(designerContext.getEditLayer())) {
				if (LayerConstants.SOLUTION_LAYER.equals(designerContext.getEditLayer())) {
					String solutionName = entityId.substring(0, entityId.lastIndexOf("."));
					if (!solutionName.equals(designerContext.getEditSolution())) {
						return false;
					}
				} else if (LayerConstants.SOLUTION_EXTENSION_LAYER.equals(designerContext.getEditLayer())){
					String solutionName = entityId.substring(0, entityId.lastIndexOf("."));
					if (!solutionName.equals(designerContext.getEditSolution())) {
						return false;
					}
				} else if (LayerConstants.SOLUTION_PLUGIN_LAYER.equals(designerContext.getEditLayer())){
					String solutionPluginName = entityId.substring(0, entityId.lastIndexOf("."));
					if (!solutionPluginName.equals(designerContext.getEditSolutionPlugin())) {
						return false;
					}
				}
				
				if (node.attributeValue("modifiedLayer").equals(designerContext.getEditLayer())) {
					return true;
				}
			/*if(name.equals("Enum") || name.equals("DataType") || name.equals("Table") ||
					name.equals("Map") || name.equals("Menu") || name.equals("MenuItem") ||
					name.equals("Form") || name.equals("Class") || name.equals("Report")){
				String modifiedLayer = node.attributeValue("modifiedLayer");
				if(modifiedLayer.equals(ObjectContainer.getInstance(LayerService.class).getCurrentLayer())){
					return true;
				}
			}*/
			}
		}
		
		return false;
	}
	
	private static boolean shouLayer(String layer){
		LayerService layerService = ObjectContainer.getInstance(LayerService.class);
		List<String> list = layerService.getLayers();
		int currentIndex = list.indexOf(GotLayerAndUserDialog.layer);
		int tarIndex = list.indexOf(layer);
		if(tarIndex <= currentIndex && currentIndex != -1){
			return true;
		}
		return false;
	}
	
	public static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	
	//打印当前时间
/*	public static void printCurrentTime(final String test){
		String msg = test + dateFormat.format(new Date(System.currentTimeMillis()));
		System.out.println(msg);

	}*/
}
