package info.gongqi.got.tool.display;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;

import com.alibaba.fastjson.JSONObject;

public class StyleComposit extends Composite {

	public List list;
	public CompositeNumber compositeNumber;
	public CompositeDate compositeDate;
	public CompositeTime compositeTime;
	public CompositeDateTime compositeDateTime;
	public CompositeBoolean compositeBoolean;
	public CompositeButton compositeButton;
	
	public StyleComposit(Composite parent, int style) {
		super(parent, style);
		this.setLayout(new FormLayout());
		this.setBackground(Display.getDefault().getSystemColor(SWT.COLOR_WHITE));
		this.setBackgroundMode(SWT.INHERIT_FORCE);
		
		Label fenlei = new Label(this, SWT.NONE);
		FormData formData = new FormData();
		formData.top = new FormAttachment(0, 10);
		formData.left = new FormAttachment(0, 10);
		fenlei.setLayoutData(formData);
		fenlei.setText("分类(C):");
		
		list = new List(this, SWT.BORDER);
		list.setItems(new String[] { "DecimalEditor", "DateEditor", "TimeEditor", 
				"DateTimeEditor", /* "BooleanEditor", */ "Button"});
		list.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				String[] selections = list.getSelection();
				if (selections == null || selections.length == 0) {
					return;
				}
				
				compositeNumber.setVisible("DecimalEditor".equals(selections[0]));
				compositeDate.setVisible("DateEditor".equals(selections[0]));
				compositeTime.setVisible("TimeEditor".equals(selections[0]));
				compositeDateTime.setVisible("DateTimeEditor".equals(selections[0]));
				compositeBoolean.setVisible("BooleanEditor".equals(selections[0]));
				compositeButton.setVisible("Button".equals(selections[0]));
			}
		});
		formData = new FormData();
		formData.top = new FormAttachment(fenlei, 5);
		formData.left = new FormAttachment(0, 5);
		formData.right = new FormAttachment(30, 0);
		formData.bottom = new FormAttachment(100, -5);
		list.setLayoutData(formData);
		
		compositeNumber = new CompositeNumber(this, SWT.NONE);
		FormData fd_group = new FormData();
		fd_group.top = new FormAttachment(fenlei, 5);
		fd_group.left = new FormAttachment(list, 10);
		fd_group.right = new FormAttachment(100, -5);
		fd_group.bottom = new FormAttachment(100, -5);
		compositeNumber.setLayoutData(fd_group);
		compositeNumber.setVisible(true);
		
		compositeDate = new CompositeDate(this, SWT.NONE);
		compositeDate.setLayoutData(fd_group);
		compositeDate.setVisible(false);
		
		compositeTime = new CompositeTime(this, SWT.NONE);
		compositeTime.setLayoutData(fd_group);
		compositeTime.setVisible(false);
		
		compositeDateTime = new CompositeDateTime(this, SWT.NONE);
		compositeDateTime.setLayoutData(fd_group);
		compositeDateTime.setVisible(false);
		
		compositeBoolean = new CompositeBoolean(this, SWT.NONE);
		compositeBoolean.setLayoutData(fd_group);
		compositeBoolean.setVisible(false);
		
		compositeButton = new CompositeButton(this, SWT.NONE);
		compositeButton.setLayoutData(fd_group);
		compositeButton.setVisible(false);
		
	}

	@Override
	protected void checkSubclass() {
		
	}
	
	public JSONObject getJson(){
		JSONObject jsonObject = new JSONObject();
		if(compositeNumber.getVisible()) {
			String value = compositeNumber.decimalPlaces_Text.getText();
			if(value != null){
				jsonObject.put("DisplayDecimals", value);
			}
			if(compositeNumber.thousandSeperator_Button.getSelection()){
				jsonObject.put("ThousandSeperator", "true");
			}
			String single = compositeNumber.currencySymbol_Combo.getText();
			if(!single.equals("")){
				jsonObject.put("CurrencyPrefix", single);
			}
			/*Object color = compositeNumber.color_Label.getData("hex");
			if(color != null){
				jsonObject.put("Color", color);
			}*/
			jsonObject.put("IsPercent", compositeNumber.percentage_Button.getSelection());
		} else if(compositeDate.getVisible()) {
			String[] select = compositeDate.list.getSelection();
			if(select.length > 0){
				jsonObject.put("DisplayFormat", select[0]);
			}
		} else if(compositeTime.getVisible()) {
			String[] select = compositeTime.list.getSelection();
			if(select.length > 0){
				jsonObject.put("DisplayFormat", select[0]);
			}
		} else if(compositeDateTime.getVisible()){
			String[] select = compositeDateTime.list.getSelection();
			if(select.length > 0){
				jsonObject.put("DisplayFormat", select[0]);
			}
		} else if(compositeBoolean.getVisible()){
			String[] select = compositeBoolean.list.getSelection();
			if(select.length > 0){
				String[] values = select[0].split(":");
				jsonObject.put("TextTrue", values[0]);
				jsonObject.put("TextFalse", values[1]);
			}
		} else if(compositeButton.getVisible()){
			String[] select = compositeButton.list.getSelection();
			if(select.length > 0){
				jsonObject.put("buttonStyle", select[0]);
			}
		}
		
		return jsonObject;
	}
	
	public void after(JSONObject jsonObject) {
		if(jsonObject.containsKey("DisplayDecimals")){
			compositeNumber.decimalPlaces_Text.setText(jsonObject.getString("DisplayDecimals"));
		}

		if (jsonObject.containsKey("IsPercent")) {
			compositeNumber.percentage_Button.setSelection(jsonObject.getBooleanValue("IsPercent"));
		}
		
		if(jsonObject.containsKey("ThousandSeperator")) {
			compositeNumber.thousandSeperator_Button.setSelection(jsonObject.getString("ThousandSeperator").equals("true"));;
		}
		
		if(jsonObject.containsKey("CurrencyPrefix")){
			compositeNumber.currencySymbol_Combo.setText(jsonObject.getString("CurrencyPrefix"));
		}
		
		/*if(jsonObject.containsKey("buttonStyle")){
			compositeButton.setVisible(true);
		}*/
		
	}
}
