package info.gongqi.got.tool.display;

import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

import com.alibaba.fastjson.JSONObject;

import edu.emory.mathcs.backport.java.util.Arrays;

public class DisplayStyleDialog extends Dialog {

	protected String result = "";
	protected Shell shell;

	private StyleComposit styleComposit;
	private AlignmentComposite alignmentComposite;
	private TextFontComposite textFontComposite;
	
	public String displayJsonText;
	
	public DisplayStyleDialog(Shell parent, int style, String displayJson) {
		super(parent, style);
		displayJsonText = displayJson;
	}

	public String open() {
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return result;
	}

	private void createContents() {
		shell = new Shell(getParent(), getStyle());
		shell.setSize(501, 405);
		shell.setText("DisplayStyle");
		shell.setLayout(new FormLayout());
		
        Monitor monitor = shell.getMonitor();  
        Rectangle bounds = monitor.getBounds ();
        Rectangle rect = shell.getBounds ();
        int x = bounds.x + (bounds.width - rect.width) / 2;  
        int y = bounds.y + (bounds.height - rect.height) / 2;  
        shell.setLocation (x, y);
        
		final TabFolder tabFolder = new TabFolder(shell, SWT.NONE);
		FormData formData = new FormData();
		formData.top = new FormAttachment(0, 5);
		formData.left = new FormAttachment(0, 5);
		formData.right = new FormAttachment(100, -5);
		formData.bottom = new FormAttachment(100, -45);
		tabFolder.setLayoutData(formData);
		tabFolder.setLayout(new FormLayout());

		//格式
		TabItem styleTabItem = new TabItem(tabFolder, SWT.NONE);
		styleTabItem.setText("格式");
		styleComposit = new StyleComposit(tabFolder, SWT.NONE);
		formData = new FormData();
		formData.left = new FormAttachment(0);
		formData.right = new FormAttachment(100);
		formData.top = new FormAttachment(0);
		formData.bottom = new FormAttachment(100);
		styleComposit.setLayoutData(formData);
		styleComposit.setBackground(Display.getDefault().getSystemColor(SWT.COLOR_WHITE));
		styleTabItem.setControl(styleComposit);
		
		//对齐
		TabItem alignmentTabItem = new TabItem(tabFolder, SWT.NONE);
		alignmentTabItem.setText("对齐");
		alignmentComposite = new AlignmentComposite(tabFolder, SWT.NONE);
		alignmentComposite.setLayoutData(formData);
		alignmentComposite.setBackground(Display.getDefault().getSystemColor(SWT.COLOR_WHITE));
		alignmentTabItem.setControl(alignmentComposite);
		
		//字体
		TabItem fontTabItem = new TabItem(tabFolder, SWT.NONE);
		fontTabItem.setText("字体");		
		textFontComposite = new TextFontComposite(tabFolder, SWT.NONE);
		textFontComposite.setLayoutData(formData);
		textFontComposite.setBackground(Display.getDefault().getSystemColor(SWT.COLOR_WHITE));
		fontTabItem.setControl(textFontComposite);
		
		Button cancel_Button = new Button(shell, SWT.NONE);
		cancel_Button.setText("取消");
		FormData fd_cancel = new FormData(60, 30);
		fd_cancel.bottom = new FormAttachment(100, -10);
		fd_cancel.right = new FormAttachment(100, -10);
		cancel_Button.setLayoutData(fd_cancel);
		
		Button confirm_Button = new Button(shell, SWT.NONE);
		formData = new FormData(60, 30);
		formData.bottom = new FormAttachment(cancel_Button, 0, SWT.BOTTOM);
		formData.right = new FormAttachment(cancel_Button, -20, SWT.LEFT);
		confirm_Button.setLayoutData(formData);
		confirm_Button.setText("确定");
		
		confirm_Button.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				JSONObject obj = styleComposit.getJson();
				obj.putAll(alignmentComposite.getJson());
				JSONObject cssStyleJson = textFontComposite.getJson();
				Object color = alignmentComposite.color_Label.getData("hex");
				if(color != null){
					cssStyleJson.put("color", color);
				}
				obj.put("cssStyle", cssStyleJson);
				result = obj.toJSONString();
				shell.close();
			}
			
		});
		
		cancel_Button.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				result = displayJsonText;
				shell.close();
			}
			
		});
		
		/*Button buttonReset = new Button(shell, SWT.NONE);
		FormData fd_buttonOK_re = new FormData(60, 30);
		fd_buttonOK_re.bottom = new FormAttachment(buttonOK, 0, SWT.BOTTOM);
		fd_buttonOK_re.left = new FormAttachment(cancel, 6);
		buttonReset.setLayoutData(fd_buttonOK_re);
		buttonReset.setText("重置");
		buttonReset.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				result = "";
				shell.close();
			}
			
		});*/
		
		/*tabFolder.addSelectionListener(new SelectionAdapter() {
			
			@Override
			public void widgetSelected(SelectionEvent arg0) {
				int index = tabFolder.getSelectionIndex();
				if(index == 0){
					styleComposit.setVisible(true);
					alignmentComposite.setVisible(false);
					textFont.setVisible(false);
				}else if(index == 1){
					styleComposit.setVisible(false);
					alignmentComposite.setVisible(true);
					textFont.setVisible(false);
				}else if(index == 2){
					styleComposit.setVisible(false);
					alignmentComposite.setVisible(false);
					textFont.setVisible(true);
				}
			}
			
		});*/
		
		if (StringUtils.isNotBlank(displayJsonText)) {
			JSONObject displayJson = JSONObject.parseObject(displayJsonText);
			styleComposit.after(displayJson);
			
			if (displayJson.containsKey("HorizontalAlignment")) {
				String horizontalAlignment = displayJson.getString("HorizontalAlignment");
				if ("Left".equals(horizontalAlignment)) {
					alignmentComposite.horizontalAlignment_comboi.setText("靠左");
				} else if ("Right".equals(horizontalAlignment)){
					alignmentComposite.horizontalAlignment_comboi.setText("靠右");
				} else if ("Center".equals(horizontalAlignment)){
					alignmentComposite.horizontalAlignment_comboi.setText("居中");
				}  else if ("Top".equals(horizontalAlignment)){
					alignmentComposite.horizontalAlignment_comboi.setText("靠上");
				}  else if ("Bottom".equals(horizontalAlignment)){
					alignmentComposite.horizontalAlignment_comboi.setText("靠下");
				}
			}
			
			if (displayJson.containsKey("VerticalAlignment")) {
				String verticalAlignment = displayJson.getString("VerticalAlignment");
				if ("Left".equals(verticalAlignment)) {
					alignmentComposite.verticalAlignment_combo.setText("靠左");
				} else if ("Right".equals(verticalAlignment)){
					alignmentComposite.verticalAlignment_combo.setText("靠右");
				} else if ("Center".equals(verticalAlignment)){
					alignmentComposite.verticalAlignment_combo.setText("居中");
				}  else if ("Top".equals(verticalAlignment)){
					alignmentComposite.verticalAlignment_combo.setText("靠上");
				}  else if ("Bottom".equals(verticalAlignment)){
					alignmentComposite.verticalAlignment_combo.setText("靠下");
				}
			}
			
			JSONObject cssStyleJson = displayJson.getJSONObject("cssStyle");
			if (cssStyleJson != null) {
				if (cssStyleJson.containsKey("Color")) {
					String colorText = cssStyleJson.getString("Color");
					int red = Integer.valueOf(colorText.substring(1, 3), 16);
					int green = Integer.valueOf(colorText.substring(3, 5), 16);
					int blue = Integer.valueOf(colorText.substring(5, 7), 16);
					Color color = new Color(Display.getCurrent(), red, green, blue);
					alignmentComposite.color_Label.setBackground(color);
					alignmentComposite.color_Label.setData("hex", colorText);
				}
				
				if (cssStyleJson.containsKey("fontFamily")) {
					String fontFamily = cssStyleJson.getString("fontFamily");
					int index = Arrays.asList(textFontComposite.fontFamily.getItems()).indexOf(fontFamily);
					if (index >= 0) {
						textFontComposite.fontFamily.select(index);
					}
				}
				
				if (cssStyleJson.containsKey("fontStyle") && cssStyleJson.containsKey("fontWeight")) {
					String fontStyle = cssStyleJson.getString("fontStyle");
					String fontWeight = cssStyleJson.getString("fontWeight");
					String fontStyleAndWeight = null;
					if ("normal".equals(fontStyle) && StringUtils.isBlank(fontWeight)) {
						fontStyleAndWeight = "常规";
					} else if ("italic".equals(fontStyle) && StringUtils.isBlank(fontWeight)) {
						fontStyleAndWeight = "斜体";
					} else if (StringUtils.isBlank(fontStyle) && "bold".equals(fontWeight)) {
						fontStyleAndWeight = "粗体";
					}  else if ("italic".equals(fontStyle) && "bold".equals(fontWeight)) {
						fontStyleAndWeight = "斜体加粗";
					}
					int index = Arrays.asList(textFontComposite.fontStyleAndWeight.getItems()).indexOf(fontStyleAndWeight);
					if (index >= 0) {
						textFontComposite.fontStyleAndWeight.select(index);
					}
				}
				
				if (cssStyleJson.containsKey("fontSize")) {
					String fontSize = cssStyleJson.getString("fontSize");
					int index = Arrays.asList(textFontComposite.fontSize.getItems()).indexOf(fontSize);
					if (index >= 0) {
						textFontComposite.fontSize.select(index);
					}
				}
				
			}
		}
		
	}
	
}
