package info.gongqi.got.tool.display;

import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class CompositeNumber extends Composite {

	Text decimalPlaces_Text;
	Button percentage_Button;
	Button thousandSeperator_Button;
	Combo currencySymbol_Combo;
//	Label color_Label;
	
	public CompositeNumber(final Composite parent, int style) {
		super(parent, style);
		this.setLayout(new FormLayout());
		
		//小数位数
		Label decimalPlacesLabel = new Label(this, SWT.NONE);
		decimalPlacesLabel.setText("小数位数：");
		FormData formData = new FormData();
		formData.top = new FormAttachment(0, 5);
		formData.left = new FormAttachment(0, 5);
		decimalPlacesLabel.setLayoutData(formData);
		
		decimalPlaces_Text = new Text(this, SWT.SINGLE|SWT.BORDER);
		formData = new FormData(20, 20);
		formData.top = new FormAttachment(decimalPlacesLabel, -2, SWT.TOP);
		formData.left = new FormAttachment(decimalPlacesLabel, 5, SWT.RIGHT);
		decimalPlaces_Text.setLayoutData(formData);
		decimalPlaces_Text.addFocusListener(new FocusListener() {
			
			@Override
			public void focusLost(FocusEvent var1) {
				String value = decimalPlaces_Text.getText();
				if (StringUtils.isBlank(value)) {
					decimalPlaces_Text.setText("");
					return;
				}
				try {
					Integer port = Integer.valueOf(value);
					if(port < 0){
						decimalPlaces_Text.setText("0");
					}
				} catch (NumberFormatException e) {
					decimalPlaces_Text.setText("");
				}
			}
			
			@Override
			public void focusGained(FocusEvent var1) {
				// TODO Auto-generated method stub
				
			}
		});
		
		//百分比
		percentage_Button = new Button(this, SWT.CHECK);
		formData = new FormData();
		formData.top = new FormAttachment(decimalPlaces_Text, 15, SWT.BOTTOM);
		formData.left = new FormAttachment(0, 5);
		percentage_Button.setLayoutData(formData);
		Label percentage_Label = new Label(this, SWT.NONE);
		percentage_Label.setText("使用百分比（%）");
		formData = new FormData();
		formData.top = new FormAttachment(percentage_Button, 0, SWT.TOP);
		formData.left = new FormAttachment(percentage_Button, 5, SWT.RIGHT);
		percentage_Label.setLayoutData(formData);
		
		//千分位 ThousandSeperator
		thousandSeperator_Button = new Button(this, SWT.CHECK);
		formData = new FormData();
		formData.top = new FormAttachment(percentage_Button, 15);
		formData.left = new FormAttachment(0, 5);
		thousandSeperator_Button.setLayoutData(formData);
		Label thousandSeperator_Label = new Label(this, SWT.NONE);
		thousandSeperator_Label.setText("使用千分位分割符（,）");
		formData = new FormData();
		formData.top = new FormAttachment(thousandSeperator_Button, 0, SWT.TOP);
		formData.left = new FormAttachment(thousandSeperator_Button, 5, SWT.RIGHT);
		thousandSeperator_Label.setLayoutData(formData);
		
		//货币符号
		Label currencySymbol_Label = new Label(this, SWT.NONE);
		formData = new FormData();
		formData.top = new FormAttachment(thousandSeperator_Button, 15);
		formData.left = new FormAttachment(0, 5);
		currencySymbol_Label.setLayoutData(formData);
		currencySymbol_Label.setText("货币符号：");
		
		currencySymbol_Combo = new Combo(this, SWT.NONE);
		FormData fd_combo = new FormData(20, 20);
		fd_combo.top = new FormAttachment(thousandSeperator_Button, 12);
		fd_combo.left = new FormAttachment(currencySymbol_Label, 5, SWT.RIGHT);
		currencySymbol_Combo.setLayoutData(fd_combo);
		//人民币、美元、英镑、欧元、日元
		currencySymbol_Combo.setItems(new String[]{"", "¥", "$", "￡", "€", "円"});
		
		/*//颜色
		Button color_Button = new Button(this, SWT.NONE);
		color_Button.setText("颜色");
		FormData fd_btn_color = new FormData();
		fd_btn_color.top = new FormAttachment(currencySymbol_Combo, 15);
		fd_btn_color.left = new FormAttachment(0, 10);
		color_Button.setLayoutData(fd_btn_color);
		color_Button.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				ColorDialog colorDialog = new ColorDialog(parent.getShell());
				final RGB rgb = colorDialog.open();
				if(rgb == null){
					return;
				}
				String hex = String.format("#%02X%02X%02X", rgb.red, rgb.green, rgb.blue);
				color_Label.setBackground(new Color(getDisplay(), rgb));
				color_Label.setData("hex", hex);
			}
		});
		
		color_Label = new Label(this, SWT.BORDER);
		FormData fd_labelColor = new FormData(20, 20);
		fd_labelColor.top = new FormAttachment(currencySymbol_Combo, 18);
		fd_labelColor.left = new FormAttachment(color_Button, 5);
		color_Label.setLayoutData(fd_labelColor);*/

		percentage_Button.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				if (percentage_Button.getSelection()) {
					thousandSeperator_Button.setSelection(false);
					currencySymbol_Combo.setText("");
				}
			}
			
		});
		thousandSeperator_Button.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				if (thousandSeperator_Button.getSelection()) {
					percentage_Button.setSelection(false);
					currencySymbol_Combo.setText("");
				}
			}
			
		});
		
		currencySymbol_Combo.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				if (StringUtils.isNotBlank(currencySymbol_Combo.getText())) {
					percentage_Button.setSelection(false);
					thousandSeperator_Button.setSelection(false);
				}
			}
			
		});
		
	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

}
