package info.gongqi.got.tool.display;

import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.widgets.Combo;

import com.alibaba.fastjson.JSONObject;

public class AlignmentComposite extends Composite {

	Combo horizontalAlignment_comboi; 
	Combo  verticalAlignment_combo;
	
	Label color_Label;
	
	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	public AlignmentComposite(Composite parent, int style) {
		super(parent, style);
		setLayout(new FormLayout());
		this.setBackgroundMode(SWT.INHERIT_FORCE);
		
		Group alignment_Group = new Group(this, SWT.NULL);
		alignment_Group.setText("  对齐方式  ");
		alignment_Group.setLayout(new FormLayout());
		FormData formData = new FormData();
		formData.top = new FormAttachment(0, 10);
		formData.left = new FormAttachment(0, 10);
		formData.right = new FormAttachment(100, -10);
		alignment_Group.setLayoutData(formData);
		
		Label horizontalAlignment_Label = new Label(alignment_Group, SWT.NONE);
		formData = new FormData();
		formData.top = new FormAttachment(0, 10);
		formData.bottom = new FormAttachment(100, -10);
		formData.left = new FormAttachment(0, 10);
		horizontalAlignment_Label.setLayoutData(formData);
		horizontalAlignment_Label.setText("水平对齐：");
		
		horizontalAlignment_comboi = new Combo(alignment_Group, SWT.NONE);
		horizontalAlignment_comboi.setItems(new String[]{"靠左", "居中", "靠右"});
//		horizontalAlignment_comboi.setText("靠左");
		formData = new FormData(50, 20);
		formData.top = new FormAttachment(horizontalAlignment_Label, -5, SWT.TOP);
		formData.left = new FormAttachment(horizontalAlignment_Label, 0, SWT.RIGHT);
		horizontalAlignment_comboi.setLayoutData(formData);
		
		Label verticalAlignment_Label = new Label(alignment_Group, SWT.NONE);
		formData = new FormData();
		formData.top = new FormAttachment(horizontalAlignment_Label, 0, SWT.TOP);
		formData.left = new FormAttachment(horizontalAlignment_comboi, 20, SWT.RIGHT);
		verticalAlignment_Label.setLayoutData(formData);
		verticalAlignment_Label.setText("垂直对齐：");
		
		verticalAlignment_combo = new Combo(alignment_Group, SWT.NONE);
		verticalAlignment_combo.setItems(new String[]{"靠上", "居中", "靠下"});
//		verticalAlignment_combo.setText("靠上");
		formData = new FormData(50, 20);
		formData.top = new FormAttachment(horizontalAlignment_comboi,0, SWT.TOP);
		formData.left = new FormAttachment(verticalAlignment_Label, 0, SWT.RIGHT);
		verticalAlignment_combo.setLayoutData(formData);
		
		//颜色
		Group color_Group = new Group(this, SWT.NULL);
		color_Group.setText("  颜色  ");
		color_Group.setLayout(new FormLayout());
		formData = new FormData();
		formData.top = new FormAttachment(alignment_Group, 20, SWT.BOTTOM);
		formData.left = new FormAttachment(0, 10);
		formData.right = new FormAttachment(100, -10);
		color_Group.setLayoutData(formData);
		
		Button color_Button = new Button(color_Group, SWT.NONE);
		color_Button.setText("颜色");
		formData = new FormData();
		formData.top = new FormAttachment(0, 10);
		formData.bottom = new FormAttachment(100, -10);
		formData.left = new FormAttachment(0, 10);
		color_Button.setLayoutData(formData);
		color_Button.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				ColorDialog colorDialog = new ColorDialog(AlignmentComposite.this.getShell());
				final RGB rgb = colorDialog.open();
				if(rgb == null){
					return;
				}
				String hex = String.format("#%02X%02X%02X", rgb.red, rgb.green, rgb.blue);
				color_Label.setBackground(new Color(getDisplay(), rgb));
				color_Label.setData("hex", hex);
			}
		});
		
		color_Label = new Label(color_Group, SWT.BORDER);
		FormData fd_labelColor = new FormData(20, 20);
		fd_labelColor.top = new FormAttachment(color_Button, 0, SWT.TOP);
		fd_labelColor.left = new FormAttachment(color_Button, 5);
		color_Label.setLayoutData(fd_labelColor);

	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}
	
	public JSONObject getJson(){
		JSONObject alignmentJson = new JSONObject();
		if (StringUtils.isNotBlank(horizontalAlignment_comboi.getText())) {			
			alignmentJson.put("HorizontalAlignment", getText(horizontalAlignment_comboi.getText()));
		}
		if (StringUtils.isNotBlank(verticalAlignment_combo.getText())) {			
			alignmentJson.put("VerticalAlignment", getText(verticalAlignment_combo.getText()));
		}
		
		return alignmentJson;
	}
	
	private String getText(String text){
		String returnStr = "";
		switch (text) {
			case "靠左":
				returnStr = "Left";
				break;
			case "靠右":
				returnStr = "Right";
				break;
			case "居中":
				returnStr = "Center";
				break;
			case "靠上":
				returnStr = "Top";
				break;
			case "靠下":
				returnStr = "Bottom";
				break;
			default:
				break;
		}
		
		return returnStr;
	}
}
