package info.gongqi.got.tool;

import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.ui.TreeUiBean;
import info.gongqi.got.util.GOTMessageDialog;

public class SofeView extends Dialog {

	protected Object result;
	public Shell shell;
	private List list;
	private Text textViewer;
	private java.util.List<Map<String, Object>> data;
	public static SofeView sofeView;
	private boolean onMouseModfied;
	private Point lastPos;
	private Label coolBar;
	/**
	 * Create the dialog.
	 * @param parent
	 * @param style
	 */
	public SofeView(Shell parent, int style, java.util.List<Map<String, Object>> datas) {
		super(parent, style);
		setText("错误列表");
		data = datas;
	}

	/**
	 * Open the dialog.
	 * @return the result
	 */
	public Object open() {
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return result;
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents() {
		shell = new Shell(getParent(), getStyle());
		shell.setSize(600, 800);
		shell.setText(getText());
		shell.setLayout(new FormLayout());
		
        Monitor monitor = shell.getMonitor();  
        Rectangle bounds = monitor.getBounds ();
        Rectangle rect = shell.getBounds ();
        int x = bounds.x + (bounds.width - rect.width) ;  
        int y = bounds.y + (bounds.height - rect.height)/2 ;  
        shell.setLocation (x, y);
        
		list = new List(shell, SWT.BORDER | SWT.V_SCROLL);
		list.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				int num = list.getSelectionIndex();
				Map<String, Object> map  = data.get(num);
				String info = map.get("errorInfo") == null ? "" : map.get("errorInfo").toString();
				if(map.containsKey("propertyName") || info.contains("propertyName") ){
					String errorInfo = map.get("errorInfo") == null ? "" : map.get("errorInfo").toString();
					textViewer.setText(errorInfo);
				}else{
					String description = map.get("description") == null ? "" : map.get("description").toString();
					textViewer.setText(description);
				}
			}
		});
		FormData fd_list = new FormData();
		fd_list.bottom = new FormAttachment(100, -5);
		fd_list.left = new FormAttachment(0, 5);
		fd_list.top = new FormAttachment(0, 20);
		fd_list.right = new FormAttachment(40, -10);
		list.setLayoutData(fd_list);
		
		coolBar = new Label(shell, SWT.SEPARATOR | SWT.VERTICAL);
		FormData fd_coolBar = new FormData();
		fd_coolBar.top = new FormAttachment(0, 20);
	    fd_coolBar.bottom = new FormAttachment(100, -5);
		fd_coolBar.left = new FormAttachment(list,0);
		fd_coolBar.right = new FormAttachment(40, 0);
		coolBar.setLayoutData(fd_coolBar);
		
		final Cursor CURSOR_SIZEWE = new Cursor(Display.getDefault(),SWT.CURSOR_SIZEWE);
		coolBar.setCursor(CURSOR_SIZEWE);
		coolBar.addMouseMoveListener(new MouseMoveListener() {
			
			Long lastTime = System.currentTimeMillis();
					
			@Override
			public void mouseMove(MouseEvent e) {
				if(onMouseModfied && (System.currentTimeMillis() -lastTime) > 50){
                    Point pos=((Control)(e.widget)).toDisplay(e.x, e.y);
                    modify(pos.x-lastPos.x, new Rectangle(1,0,1,1));
                    lastPos = pos;
                    lastTime = System.currentTimeMillis();
				}
			}
		});
		
		coolBar.addMouseListener(new MouseAdapter() {           
            @Override
            public void mouseDown(MouseEvent e) {
                // 记录当前鼠标位置，以供mouseMove消息时计算鼠标移动距离
                lastPos=((Control)(e.widget)).toDisplay(e.x, e.y);
                onMouseModfied=true;
            }
            
            @Override
            public void mouseUp(MouseEvent e) {
                onMouseModfied=false;
            }
        });
		
		Label lblNewLabel = new Label(shell, SWT.NONE);
		FormData fd_lblNewLabel = new FormData();
		fd_lblNewLabel.left = new FormAttachment(0, 5);
		fd_lblNewLabel.top = new FormAttachment(0, 2);
		fd_lblNewLabel.right = new FormAttachment(40, 0);
		lblNewLabel.setLayoutData(fd_lblNewLabel);
		lblNewLabel.setText("错误列表");
		
		//TODO 换行关键
		textViewer = new Text(shell, SWT.BORDER | SWT.MULTI | SWT.WRAP);
//		StyledText styledText = textViewer.getTextWidget();
		FormData fd_styledText = new FormData();
		fd_styledText.bottom = new FormAttachment(100, -5);
		fd_styledText.left = new FormAttachment(coolBar,0);
		fd_styledText.top = new FormAttachment(0, 20);
		fd_styledText.right = new FormAttachment(100, -5);
		textViewer.setLayoutData(fd_styledText);
//		textViewer.setEnabled(false);
		textViewer.setEditable(false);
		
		Label lblNewLabel_1 = new Label(shell, SWT.NONE);
		
		fd_lblNewLabel = new FormData();
		fd_lblNewLabel.left = new FormAttachment(lblNewLabel, 5);
		fd_lblNewLabel.top = new FormAttachment(0, 2);
		fd_lblNewLabel.right = new FormAttachment(100, 0);
		lblNewLabel_1.setLayoutData(fd_lblNewLabel);
		lblNewLabel_1.setText("错误信息");
		for (Map<String, Object> map : data) {
			String item = "";
			String info = map.get("errorInfo") == null ? "" : map.get("errorInfo").toString();
			if(map.containsKey("propertyName") || info.contains("propertyName") ){
				item = "实体ID:"+map.get("entityId")+" 内部ID:"+map.get("innerId")+" 节点类型:"+ map.get("nodeType")+" 属性名称:"+ map.get("propertyName");
			}else{
				item = map.get("tableName") == null ? "无": map.get("tableName").toString();
				item += ":" + map.get("description");
			}
			list.add(item);
		}
		
		if(data != null && data.size() > 0){
			list.setSelection(0);
			Map<String, Object> map  = data.get(0);
			String info = map.get("errorInfo") == null ? "" : map.get("errorInfo").toString();
			if(map.containsKey("propertyName") || info.contains("propertyName")){
				textViewer.setText(info);
			}else{
				String description = map.get("description") == null ? "" : map.get("description").toString();
				textViewer.setText(description);
			}
		}
		
		list.addListener(SWT.MouseDoubleClick, new Listener() {
            public void handleEvent(Event event) {
				int num = list.getSelectionIndex();
				Map<String, Object> map  = data.get(num);
				if(map.containsKey("entityId")){
					String entityId = (String) map.get("entityId");
					String innerId = (String) map.get("innerId");
					TreeItem item = FormDataSyn.getEntityTreeItem(entityId);
					if(item == null){
						GOTMessageDialog.alert("节点不在当前层");
						return;
					}
					TreeUiBean bean = new TreeUiBean(item, false, true);
					if(StringUtils.isNotBlank(innerId)){
						TreeItem child = FormDataSyn.getTreeItemById(innerId, bean.treeUip);
						if(child != null){
							bean.treeUip.getTree().setSelection(child);
							Element element = GotXmlDto.getInstance().getCurrentElement(child);
							bean.treeUip.loadTableValue(bean.treeUip.getTable(), element, child);
						}
					}
				}else if(map.containsKey("tableId")){
					final String entityId = (String) map.get("tableId");
					if(entityId != null){
						TreeItem item = FormDataSyn.getEntityTreeItem(entityId);
						if(item == null){
							Display.getDefault().asyncExec(new Runnable() {
								
								@Override
								public void run() {
									// TODO 自动生成的方法存根
									GOTMessageDialog.alert("实体节点不存在id:" + entityId);
								}
							});
							
						}
						new TreeUiBean(item, false, false);
//						FormDataSyn.treeUis.get(0).openEntityShell(entityId);
					}
				}
            }
        });
		GOTMessageDialog.shells.add(shell);
	}
	
    /**
     * 改变窗口位置和尺寸
     * @param x x轴移动距离
     * @param y y轴移动距离
     * @param mask 锚点位置计算的掩码
     */
    protected void modify(int x,Rectangle mask){
        // 计算出新的窗口位置和尺寸
        Rectangle boundTree = list.getBounds();
        boundTree.width += x*mask.width;
        list.setBounds(boundTree);
        
        Rectangle boundLable = coolBar.getBounds();
        boundLable.x += x*mask.x;
        coolBar.setBounds(boundLable);
        
        Rectangle boundTable = textViewer.getBounds();
        boundTable.x += x*mask.x;
        boundTable.width += -x*mask.width;
        textViewer.setBounds(boundTable);
    }
}
