package info.gongqi.got.tool;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Element;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

import client.gongqi.designer.got.node.NodeGOT;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.util.GOTMessageDialog;

public class MergeSaveAll extends Dialog {

	protected Object resultDialog = "";
	protected Shell shell;

	public ProgressBar progressBar;
 
	private Boolean canceled = false;
	private List<Element> xmllist = new ArrayList<>();
	/** 
	 * Create the dialog.
	 * 
	 * @param parent
	 * @param style
	 */
	public MergeSaveAll(Shell parent, int style) {
		super(parent, style);
		setText("正在验证");
	}

	/**
	 * Open the dialog.
	 * 
	 * @return the result
	 */
	public Object open(String action) {
		createContents(action);
		if (!canceled) {			
			shell.open();
			shell.layout();
			Display display = getParent().getDisplay();
			while (!shell.isDisposed()) {
				if (!display.readAndDispatch()) {
					display.sleep();
				}
			}
		}
		return resultDialog;
	}

	/**
	 * Create contents of the dialog.
	 */
	@SuppressWarnings("unchecked")
	private void createContents(String action) {
		if("all".equals(action)){
			getUnsavedXML(GotXmlDto.getInstance().getGotXMl(), xmllist);
		}else if("Form".equals(action)){
			xmllist = GotXmlDto.getInstance().currentElements("Forms");
		}
		
		if (xmllist == null || xmllist.isEmpty()) {
			canceled = true;
			return;
		}
		
		shell = new Shell(getParent(), getStyle());
		shell.addDisposeListener(new DisposeListener() {
			public void widgetDisposed(DisposeEvent arg0) {
				canceled = true;
			}
		});
		shell.setSize(600, 50);
		shell.setText(getText());
		shell.setLayout(new FillLayout(SWT.HORIZONTAL));

		Monitor monitor = shell.getMonitor();
		Rectangle bounds = monitor.getBounds();
		Rectangle rect = shell.getBounds();
		int x = bounds.x + (bounds.width - rect.width) / 2;
		int y = bounds.y + (bounds.height - rect.height) / 2;
		shell.setLocation(x, y);
 
		progressBar = new ProgressBar(shell, SWT.SMOOTH);

		progressBar.setMaximum(100);
		progressBar.setMinimum(0);
		
		start(0, xmllist.size(), true);
		
	}

	public void start(final int i, final int total, final Boolean merge) {
		Runnable runnable = new Runnable() {
			public void run() {
				saveAllUnsavedNode(i, total, merge);
				Display.getDefault().syncExec(new Runnable() {
					@Override
					public void run() {
						if (shell.isDisposed()){
							return;
						}
						shell.dispose();
					}
				});
			}
		};
		// 启动这个线程
		new Thread(runnable).start();
	}
	
	public void saveAllUnsavedNode(int i,int total,Boolean merge) {
		if(canceled == true){
			canceled = false;
			return;
		}
		if(i == 0){
			setProgressBar(0);
		}
		
		if(i >= total){
			if(canceled == true){
				canceled = false;
			}
			return;
		}
		
		final Element nodeSaving = xmllist.get(i);
		int percent = (i + 1)*100/total;
		
		setShellText("正在保存" + nodeSaving.attributeValue("name") + " " + percent + "%" );
		setProgressBar(percent);
		if(nodeSaving.attribute("saved") != null){
			nodeSaving.remove(nodeSaving.attribute("saved"));
			Display.getDefault().syncExec(new Runnable() {
				@Override
				public void run() {
					TreeItem treeItem = FormDataSyn.getTreeItrmByElement(nodeSaving, null);
					GotXmlDto.getInstance().updateEntityElement(nodeSaving);
					if(treeItem != null){
						FormDataSyn.setSaved(treeItem);
					}
				}
			});
		}
		if(merge){
			try {
				LoadXmlCore.gotServices.updateEntityAlone(nodeSaving.asXML());
			} catch (Exception e) {
				e.printStackTrace();
				GOTMessageDialog.alert(e);
			}
		}else{
			try {
				LoadXmlCore.gotServices.saveEntity(nodeSaving.asXML());
			} catch (Exception e) {
				e.printStackTrace();
				GOTMessageDialog.alert(e);
			}
		}
		saveAllUnsavedNode(i + 1, total, true);
	}


	public void setProgressBar(final int num){
		Display.getDefault().syncExec(new Runnable() {
			@Override
			public void run() {
				if (progressBar.isDisposed())
					return;
				progressBar.setSelection(num);
			}
		});
	}
	
	public void setShellText(final String text){
		Display.getDefault().syncExec(new Runnable() {
			@Override
			public void run() {
				if (shell.isDisposed())
					return;
				shell.setText(text);
			} 
		});
	}
	
	public void setAlert(final String text, final String title){
		Display.getDefault().syncExec(new Runnable() {
			@Override
			public void run() {
				GOTMessageDialog.showXmlInfo(text, title);
			}
		});
	}
	
	@SuppressWarnings("unchecked")
	private void getUnsavedXML(Element node, List<Element> xmllist){
		List<Element> elements = node.elements();
		for (Element subnode : elements){
			if(NodeGOT.isEntity(subnode)){
				if(subnode.attribute("saved") != null)
					xmllist.add(subnode);

			}else{
				getUnsavedXML(subnode, xmllist);
			}
		}
	}
}
