package info.gongqi.got.tool;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Element;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

import client.gongqi.designer.got.validate.MergeMapTool;
import client.gongqi.designer.got.validate.ValidateROpr;
import info.gongqi.got.ui.LoadXML;
import info.gongqi.got.util.GOTMessageDialog;

public class MergeMatchingTips extends Dialog {

	protected Object resultDialog = "";
	protected Shell shell;

	public ProgressBar progressBar;
 
	private Boolean canceled = false;
	private List<String> resultList = new ArrayList<>();
	private List<MergeMapTool> subItemListCache = new ArrayList<>();
//	private ValidateROpr validator;
	private List<Object> result = new ArrayList<>();

	/** 
	 * Create the dialog.
	 * 
	 * @param parent
	 * @param style
	 */
	public MergeMatchingTips(Shell parent, int style) {
		super(parent, style);
		setText("正在验证");
	}

	/**
	 * Open the dialog.
	 * 
	 * @return the result
	 */
	public Object open(Element item, String url, int cur, Boolean listExsits, ValidateROpr validator) {
		createContents(item,url,cur, listExsits, validator);
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return resultDialog;
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents(Element item, String url, int cur, Boolean listExsits, ValidateROpr validator) {
		shell = new Shell(getParent(), getStyle());
		shell.addDisposeListener(new DisposeListener() {
			public void widgetDisposed(DisposeEvent arg0) {
				canceled = true;
			}
		});
		shell.setSize(600, 50);
		shell.setText(getText());
		shell.setLayout(new FillLayout(SWT.HORIZONTAL));

		Monitor monitor = shell.getMonitor();
		Rectangle bounds = monitor.getBounds();
		Rectangle rect = shell.getBounds();
		int x = bounds.x + (bounds.width - rect.width) / 2;
		int y = bounds.y + (bounds.height - rect.height) / 2;
		shell.setLocation(x, y);
 
		progressBar = new ProgressBar(shell, SWT.SMOOTH);

		progressBar.setMaximum(100);
		progressBar.setMinimum(0);
		start(item,url,cur, listExsits, validator);
		GOTMessageDialog.shells.add(shell);
	}

	public void start(final Element item, final String url, final int cur, final Boolean listExsits, final ValidateROpr validator) {
		Runnable runnable = new Runnable() {
			public void run() {
				validateResolverItem(item, url, cur, listExsits, validator);
				Display.getDefault().syncExec(new Runnable() {
					@Override
					public void run() {
						if (shell.isDisposed())
							return;
						shell.dispose();
					}
				});
			}
		};
		// 启动这个线程
		new Thread(runnable).start();
	}
	
	public void validateResolverItem(Element item, String url, int cur, Boolean listExsits, ValidateROpr validator) {
		String s = "";
		if (canceled == true) {
			for (String r : resultList) {
				s += r + "\n";
			}
			if (s.equals("")) {
				s = "未发现差异";
			}
			setAlert(s, "诊断信息(操作被中断)");
			canceled = false;
			return;
		}
		if (!listExsits) {
			descendantsXML(item, url);
		}

		if (item.element("Properties") != null) {
			validator._url = url;
			List<Object> ob = validator.validate(item);
			if(ob != null && !ob.isEmpty()){
				result.addAll(ob);
			}
			
		}

		if (cur == 0) {
			setProgressBar(0);
		}
		int total = subItemListCache.size();

		for (int i = 1; i <= total; i++) {
			Element subItem = subItemListCache.get(i - 1).getXml();
			String subUrl = subItemListCache.get(i - 1).getUrl();
			int block = (total / 25) == 0 ? 1 : total / 25;
			if ((cur + 1) % block == 0) {
				float percent = (float)(cur + 1)/ total;
				setShellText("正在验证" + subUrl + " " + (percent*100) + "%");
				setProgressBar((int) (percent * 100));
			} else {
				setShellText("正在验证" + subUrl);
			}
			cur ++;
			if (canceled == true) {
				s = "";
				for (Object r : result) {
					s += r + "\n";
				}
				if (s.equals("")) {
					s = "未发现差异";
				}else{
					resultDialog = "true";
				}
				setAlert(s,"诊断信息(操作被中断)");
				return;
			}

			if (!"Properties".equals(subItem.getName())) {
//				try {
//					Thread.sleep(50);
//				} catch (InterruptedException e) {
//					e.printStackTrace();
//				}
//				validateResolverItem(subItem, subUrl, i, true, validator);
//				break;
				validateResolverItem(subItem, subUrl, validator);
			}
			
		}
		
		if(cur == total){
			setProgressBar(100);
			s = "";
			for (Object r : result) {
				s += r + "\n";
			}

			if (s.equals("")){
				s = "未发现差异";
				validator.validateEnd(false);
			}else{
				resultDialog = "true";
				validator.validateEnd(true);
			}
				
			setAlert(s, "诊断信息");
		}
	}

	public void validateResolverItem(Element item, String url, ValidateROpr validator) {
		String s = "";
		if (canceled == true) {
			for (String r : resultList) {
				s += r + "\n";
			}
			if (s.equals("")) {
				s = "未发现差异";
			}
			setAlert(s, "诊断信息(操作被中断)");
			canceled = false;
			return;
		}

		if (item.element("Properties") != null) {
			validator._url = url;
			List<Object> ob = validator.validate(item);
			if(ob != null && !ob.isEmpty()){
				result.addAll(ob);
			}
		}
	}
	
	
	@SuppressWarnings("unchecked")
	private void descendantsXML(Element item, String url) {
		if (item.element("Properties") != null && LoadXML.nodeShowRuleDoMerge(item)) {
			MergeMapTool map = new MergeMapTool(item, url);
			subItemListCache.add(map);
		}
		List<Element> elements = item.elements();
		for (Element child : elements) {
			String str = child.attribute("name") != null ? child.attributeValue("name") : child.getName();
			String subUrl = url + "/" + str;
			descendantsXML(child, subUrl);
		}
	}

	public void setProgressBar(final int num){
		Display.getDefault().syncExec(new Runnable() {
			@Override
			public void run() {
				if (progressBar.isDisposed())
					return;
				progressBar.setSelection(num);
			}
		});
	}
	
	public void setShellText(final String text){
		Display.getDefault().syncExec(new Runnable() {
			@Override
			public void run() {
				if (shell.isDisposed())
					return;
				shell.setText(text);
			} 
		});
	}
	
	public void setAlert(final String text, final String title){
		Display.getDefault().syncExec(new Runnable() {
			@Override
			public void run() {
				shell.close();
				GOTMessageDialog.showXmlInfo(text, title);
			}
		});
	}
}
