package info.gongqi.got.tool;

import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.ObjectContainer;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.ui.TreeUi;
import info.gongqi.got.util.GOTMessageDialog;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LayerInfo extends Dialog {

	protected Object result;
	protected Shell shell;
	private Text text_1;
	private Text text_2;
	private Button btnCheckButton;

	private String action;
	/**
	 * Create the dialog.
	 * @param parent
	 * @param style
	 */
	public LayerInfo(Shell parent, int style, String actions) {
		super(parent, style);
		setText("");
		action = actions;
	}

	/**
	 * Open the dialog.
	 * @return the result
	 */
	public Object open() {
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return result;
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents() {
		shell = new Shell(getParent(), getStyle());
		shell.setSize(310, 209);
		shell.setText(getText());
		
		GOTMessageDialog.shells.add(shell);
		
		Monitor monitor = shell.getMonitor();
		Rectangle bounds = monitor.getBounds();
		Rectangle rect = shell.getBounds();
		int x = bounds.x + (bounds.width - rect.width) / 2;
		int y = bounds.y + (bounds.height - rect.height) / 2;
		shell.setLocation(x, y);
		
		Label text1_label = new Label(shell, SWT.NONE);
		text1_label.setBounds(36, 13, 62, 17);
		text1_label.setText("");
		
		text_1 = new Text(shell, SWT.BORDER);
		text_1.setBounds(104, 10, 129, 23);
		
		Label text2_label = new Label(shell, SWT.NONE);
		text2_label.setBounds(36, 62, 62, 17);
		text2_label.setText("");
		
		text_2 = new Text(shell, SWT.BORDER);
		text_2.setBounds(104, 59, 129, 23);
		
		Button confirm = new Button(shell, SWT.NONE);
		confirm.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				try {
					if("createLayer".equals(action)){
						LayerService layerService = ObjectContainer.getInstance(LayerService.class); 
						layerService.createLayer(text_1.getText(), btnCheckButton.getSelection());
						GOTMessageDialog.info("已成功执行");
						shell.close();
					}else if("recycleLayer".equals(action)){
						LayerService layerService = ObjectContainer.getInstance(LayerService.class); 
						Object ob = layerService.recycleLayer(text_1.getText());
						if(ob != null && ob.toString().contains("database")){
							GOTMessageDialog.showXmlInfo(ob.toString(), "销毁层返回信息");
						}else{
							GOTMessageDialog.info("已成功执行");
							shell.close();
						}
					}else if("packLayer".equals(action)){
						LayerService layerService = ObjectContainer.getInstance(LayerService.class); 
						layerService.packLayer(text_1.getText(), text_2.getText(), btnCheckButton.getSelection());
						GOTMessageDialog.info("已成功执行");
						shell.close();
					}else if("moduleImport".equals(action)){
						if(text_1.getText().equals("")){
							GOTMessageDialog.alert("请填写参数");
						}else{
							try {
								LoadXmlCore.gotServices.importModule(text_1.getText());
							} catch (Exception e1) {
								e1.printStackTrace();
								GOTMessageDialog.alert(e1);
							}
							GOTMessageDialog.info("已成功执行");
							shell.close();
						}
					}else if("moduleExport".equals(action)){
						if(text_1.getText().equals("")){
							GOTMessageDialog.alert("请填写参数");
						}else{
							try {
								LoadXmlCore.gotServices.exportModule(text_1.getText());
							} catch (Exception e1) {
								e1.printStackTrace();
								GOTMessageDialog.alert(e1);
							}
							GOTMessageDialog.info("已成功执行");
							shell.close();
						}
					}else if("moduleDelete".equals(action)){
						if(text_1.getText().equals("")){
							GOTMessageDialog.alert("请填写参数");
						}else{
							try {
								LoadXmlCore.gotServices.deleteModule(text_1.getText());
							} catch (Exception e1) {
								e1.printStackTrace();
								GOTMessageDialog.alert(e1);
							}
							GOTMessageDialog.info("已成功执行");
							shell.close();
						}
					}else{
						shell.close();
					}
				} catch (Exception e1) {
					GOTMessageDialog.alert(e1.getMessage());
					e1.printStackTrace();
				}
				
				
			}
		});
		confirm.setBounds(46, 128, 80, 27);
		confirm.setText("确定");
		
		Button cancel = new Button(shell, SWT.NONE);
		cancel.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				shell.close();
			}
		});
		cancel.setBounds(179, 128, 80, 27);
		cancel.setText("取消");
		
		btnCheckButton = new Button(shell, SWT.CHECK);
		btnCheckButton.setBounds(52, 98, 162, 17);
		btnCheckButton.setText("");

		if("getCurrentLayer".equals(action)){
			text1_label.setText("获得层");
			text_1.setText(ObjectContainer.getInstance(LayerService.class).getCurrentLayer());
			text_1.setEditable(false);
			text_2.setVisible(false);
			text2_label.setVisible(false);
			btnCheckButton.setVisible(false);
			shell.setText("层控制");
		}else if("createLayer".equals(action)){
			text1_label.setText("创建层");
			text_1.setText("");
			text_2.setVisible(false);
			text2_label.setVisible(false);
			btnCheckButton.setText("是否按层控制规范代码");
			shell.setText("层控制");
		}else if("recycleLayer".equals(action)){
			text1_label.setText("销毁层");
			text_1.setText("");
			text_2.setVisible(false);
			text2_label.setVisible(false);
			btnCheckButton.setVisible(false);
			shell.setText("层控制");
		}else if("packLayer".equals(action)){
			text1_label.setText("打包层");
			text2_label.setText("版本号");
			btnCheckButton.setText("多层打包");
			shell.setText("层控制");
		}else if("moduleImport".equals(action)){
			text1_label.setText("请输入参数");
			text_2.setVisible(false);
			text2_label.setVisible(false);
			btnCheckButton.setVisible(false);
			shell.setText("模块导入");
		}else if("moduleExport".equals(action)){
			text1_label.setText("请输入参数");
			text_2.setVisible(false);
			text2_label.setVisible(false);
			btnCheckButton.setVisible(false);
			shell.setText("模块导出");
		}else if("moduleDelete".equals(action)){
			text1_label.setText("请输入参数");
			text_2.setVisible(false);
			text2_label.setVisible(false);
			btnCheckButton.setVisible(false);
			shell.setText("模块删除");
		}else if("changeWidth".equals(action)){
			text1_label.setText("文本宽+10");
			text1_label.addMouseListener(new MouseListener() {
				
				@Override
				public void mouseUp(MouseEvent arg0) {
					
				}
				
				@Override
				public void mouseDown(MouseEvent arg0) {
					for (TreeUi ui : FormDataSyn.treeUis) {
						int a = ui.trclmnNewColumnLabel.getWidth();
						int b = ui.trclmnNewColumnText.getWidth();
						if(a >= 10){
							ui.trclmnNewColumnLabel.setWidth(a - 10);
							ui.trclmnNewColumnText.setWidth(b + 10);
							text_1.setText((b + 10) + "");
							text_2.setText((a - 10) + "");
						}
					}
				}
				
				@Override
				public void mouseDoubleClick(MouseEvent arg0) {
					
				}
			});
			text_1.setText(FormDataSyn.treeUis.get(0).trclmnNewColumnText.getWidth()+"");
			text_1.setEditable(false);
			text_2.setVisible(true);
			text2_label.setVisible(true);
			text2_label.setText("标签宽+10");
			btnCheckButton.setVisible(false);
			shell.setText("调整文本和标签的宽度，单击+10");
			text2_label.addMouseListener(new MouseListener() {
				
				@Override
				public void mouseUp(MouseEvent arg0) {
					
				}
				
				@Override
				public void mouseDown(MouseEvent arg0) {
					for (TreeUi ui : FormDataSyn.treeUis) {
						int a = ui.trclmnNewColumnLabel.getWidth();
						int b = ui.trclmnNewColumnText.getWidth();
						if(a >= 10){
							ui.trclmnNewColumnLabel.setWidth(a + 10);
							ui.trclmnNewColumnText.setWidth(b - 10);
							text_1.setText((b - 10) + "");
							text_2.setText((a + 10) + "");
						}
					}
				}
				
				@Override
				public void mouseDoubleClick(MouseEvent arg0) {
					
				}
			});
			text_2.setText(FormDataSyn.treeUis.get(0).trclmnNewColumnLabel.getWidth()+"");
			text_2.setEditable(false);
		}
		
	}
	
}
