package info.gongqi.got.tool;

import java.util.Objects;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;

public class ImageButton extends Label {

	private Image normalImage;
	private Image hoverImage;
	
	public ImageButton(Composite parent, Image normalImage, Image hoverImage) {
		super(parent, SWT.SHADOW_OUT);
		Objects.requireNonNull(normalImage, "normalImage is null");
		this.normalImage = normalImage;
		this.hoverImage = hoverImage;
		initialization();
	}
	
	private void initialization(){
		setImage(normalImage);
		addMouseTrackListener(new MouseTrackListener() {
			
			@Override
			public void mouseHover(MouseEvent e) {
				
			}
			
			@Override
			public void mouseExit(MouseEvent e) {
				ImageButton.this.setImage(normalImage);
			}
			
			@Override
			public void mouseEnter(MouseEvent e) {
				ImageButton.this.setImage(hoverImage);
			}
		});
		
/*		addPaintListener(new PaintListener() {
			@Override
			public void paintControl(PaintEvent arg0) {
				Image image = ImageButton.this.getImage();
				int h = ImageButton.this.getBounds().height; //获取控件的高
				int w = ImageButton.this.getBounds().width; //获取控件的宽度
				int height = image.getBounds().height; //获取原图片的高度
				int width = image.getBounds().width; //获取原图片的初始宽度
				//绘制图片，将原图片按照控件的高度和宽度进行重绘
				arg0.gc.drawImage(image, 0, 0, width, height, 0, 0, w, h);
			}
		});*/
	}
	
	public void addSelectionListener (final SelectionListener listener) {
		addMouseListener(new MouseListener() {
			
			@Override
			public void mouseUp(MouseEvent e) {
				Rectangle bounds = ImageButton.this.getBounds();
				if (e.x >= 0 && e.x <= bounds.width 
						&& e.y >= 0 && e.y <= bounds.height) {
					Event event = new Event();
					event.widget = e.widget;
					event.item = e.widget;
					event.x = e.x;
					event.y = e.y;
					event.data = e.data;
					listener.widgetSelected(new SelectionEvent(event));
				}
			}
			
			@Override
			public void mouseDown(MouseEvent e) {
				
			}
			
			@Override
			public void mouseDoubleClick(MouseEvent e) {
				
			}
		});
	}

	@Override
	protected void checkSubclass() {
		// do nothing
	}
 
	@Override
	public void setText(String string) {
		throw new IllegalArgumentException(this.getClass().getSimpleName() + "不支持文本");
	}

	public void setImage(Image normalImage, Image hoverImage){
		this.normalImage = normalImage;
		this.hoverImage = hoverImage;
		if (getEnabled()) {
			setImage(normalImage);
		}
	}

	@Override
	public void setEnabled(boolean enabled) {
		if(enabled){
			this.setBackground(null);
		}
		super.setEnabled(enabled);
	}
	
	
}
