package info.gongqi.got.tool;

import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.LayerConstants;
import gongqi.erp.framework.core.ObjectContainer;
import info.gongqi.got.ui.ConfigComposite;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.util.GOTMessageDialog;

import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class GotLayerAndUserDialog extends Dialog {

	protected boolean result = false;
	protected Shell shell;
	
	public static String layer = "";
	
	public static String solution = "";
	
	public static String user;

	
	public Combo combo_layer,combo_user, combo_plug,combo_solution;

	/**
	 * Create the dialog.
	 * @param parent
	 * @param style
	 */
	public GotLayerAndUserDialog(Shell parent, int style) {
		super(parent, style);
		setText("编辑范围");
	}

	/**
	 * Open the dialog.
	 * @return the result
	 */
	public boolean open() {
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return result;
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents() {
		shell = new Shell(getParent(), getStyle()|SWT.APPLICATION_MODAL);
		shell.setSize(237, 228);
		shell.setText(getText());
		
        Monitor monitor = shell.getMonitor();  
        Rectangle bounds = monitor.getBounds ();
        Rectangle rect = shell.getBounds ();
        int x = bounds.x + (bounds.width - rect.width) / 2;  
        int y = bounds.y + (bounds.height - rect.height) / 2;  
        shell.setLocation (x, y);
        
		combo_layer = new Combo(shell, SWT.READ_ONLY);
		combo_layer.setBounds(60, 15, 140, 25);
		
		combo_layer.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				setDef();
			}
		});
		
		Label lblNewLabel = new Label(shell, SWT.RIGHT);
		lblNewLabel.setBounds(5, 18, 47, 17);
		lblNewLabel.setText("层");
		
		Label label = new Label(shell, SWT.RIGHT);
		label.setText("应用");
		label.setBounds(5, 51, 47, 17);
		
		combo_solution = new Combo(shell, SWT.READ_ONLY);
		combo_solution.setBounds(60, 46, 140, 25);
		
		combo_solution.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				setPlug();
				setUser();
			}
		});
		combo_solution.setEnabled(false);
		
		Label label_2 = new Label(shell, SWT.RIGHT);
		label_2.setText("插件");
		label_2.setBounds(5, 80, 47, 17);
		
		combo_plug = new Combo(shell, SWT.READ_ONLY);
		combo_plug.setBounds(60, 77, 140, 25);
		combo_plug.setEnabled(false);
		combo_plug.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				combo_user.removeAll();
				setUser();
			}
			
		});
		
		Label label_1 = new Label(shell, SWT.RIGHT);
		label_1.setText("用户");
		label_1.setBounds(5, 110, 47, 17);
		
		combo_user = new Combo(shell, SWT.READ_ONLY);
		combo_user.setBounds(60, 107, 140, 25);
		
		Button btn_cancel = new Button(shell, SWT.NONE);
		btn_cancel.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
//				GOTService gotServices = ObjectContainer.getInstance(GOTService.class);
//				gotServices.isSafeMode();
//				FormDataSyn.stopGot();
				ConfigComposite.configComposite.button_restart.setEnabled(true);
				shell.close();
			}
		});
//		btn_cancel.setEnabled(false);
		btn_cancel.setText("取消");
		btn_cancel.setBounds(125, 152, 80, 27);
		
		Button btn_confirm = new Button(shell, SWT.NONE);
		btn_confirm.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(!ConfigComposite.configComposite.text_unsave_info.getText().equals("")){
					GOTMessageDialog.alert("存在未保存的节点，禁止切换编辑层");
					return;
				}
				
				String text = combo_layer.getText();
				if(combo_layer.getText().equals("") || combo_user.getText().equals("")){
					GOTMessageDialog.alert("层或者用户不能为空");
					return;
				}
				if(text.equals(LayerConstants.SOLUTION_LAYER)){
					if(combo_solution.getText().equals("")){
						GOTMessageDialog.alert("方案不能为空");
						return;
					}
				}else if(text.equals(LayerConstants.SOLUTION_EXTENSION_LAYER)){
					if(combo_solution.getText().equals("")){
						GOTMessageDialog.alert("方案不能为空");
						return;
					}
				}
				
				LayerService layerService = ObjectContainer.getInstance(LayerService.class);
				layerService.switchEditScope(combo_layer.getText(), combo_solution.getText(), combo_plug.getText(), combo_user.getText());
				String str = "";
				if (LayerConstants.SOLUTION_LAYER.equals(combo_layer.getText())) {
					str = "层：" + combo_layer.getText() + "  方案：" + combo_solution.getText() + "  用户：" + combo_user.getText();
				} else if (LayerConstants.SOLUTION_PLUGIN_LAYER.equals(combo_layer.getText())) {
					str = String.format("层：%s  方案：%s  插件：%s  用户：%s", 
							combo_layer.getText(), 
							combo_solution.getText(), 
							combo_plug.getText(), 
							combo_user.getText());
				} else if (LayerConstants.SOLUTION_EXTENSION_LAYER.equals(combo_layer.getText())) {
					str = "层：" + combo_layer.getText() + "  方案：" + combo_solution.getText() + "  用户：" + combo_user.getText();
				} else {
					str = "层：" + combo_layer.getText() + "  用户：" + combo_user.getText();
				}

				if(str != null && !"".equals(result) && !ConfigComposite.configComposite.isDisposed()){
					ConfigComposite.configComposite.layer_label.setText(str);
					ConfigComposite.configComposite.button_restart.setEnabled(true);
				}
				result = true;
				layer = text;
				solution = combo_solution.getText();
				user = combo_user.getText();
				if(FormDataSyn.treeUis.size() > 0){
					GOTMessageDialog.showExchangeLayer();
				}
				if(!shell.isDisposed()){
					shell.close();
				}
			}
		});
		btn_confirm.setText("确定");
		btn_confirm.setBounds(22, 152, 80, 27);
		GOTMessageDialog.shells.add(shell);
		init();
		
	}
	
	private void init(){
		LayerService layerService = ObjectContainer.getInstance(LayerService.class);
		List<String> array = layerService.getCanEditLayerList();
		String[] item = array.toArray(new String[array.size()]);
		combo_layer.setItems(item);
		if(item.length == 1 ){
			combo_layer.setText(item[0]);
			setDef();
		}
	}
	
	private void setPlug(){
		String text = combo_layer.getText();
		if(text.equals("plg")){
			combo_plug.setEnabled(true);
			combo_plug.removeAll();
			LayerService layerService = ObjectContainer.getInstance(LayerService.class);
			List<String> plugs = layerService.getCanEditSolutionPluginList(combo_solution.getText());
			combo_plug.setItems(plugs.toArray(new String[plugs.size()]));
			if(plugs.size() > 0){
				combo_plug.setText(plugs.get(0));
			}
		}else{
			combo_plug.setEnabled(false);
			combo_plug.removeAll();
		}
	}
	
	private void setUser(){
		List<String> user = LoadXmlCore.gotServices.getEditUsers(combo_layer.getText(), combo_solution.getText(), combo_plug.getText());
		String[] item = user.toArray(new String[user.size()]);
		combo_user.setItems(item);
		if(item.length == 1){
			combo_user.setText(item[0]);
		}
	}

	private void setDef(){
		String text = combo_layer.getText();
		if(text.equals(LayerConstants.SOLUTION_LAYER)){
			combo_solution.removeAll();
			combo_plug.removeAll();
			
			LayerService layerService = ObjectContainer.getInstance(LayerService.class);
			List<String> array = layerService.getCanEditSolutionList();
			String[] item = array.toArray(new String[array.size()]);
			combo_solution.setEnabled(true);
			combo_solution.setItems(item);
			if(item.length == 1){
				combo_solution.setText(item[0]);
				setPlug();
				setUser();
			}
		}else if(text.equals(LayerConstants.SOLUTION_EXTENSION_LAYER)){
			combo_solution.removeAll();
			
			LayerService layerService = ObjectContainer.getInstance(LayerService.class);
			List<String> array = layerService.getCanEditExtensionList();
			String[] item = array.toArray(new String[array.size()]);
			combo_solution.setEnabled(true);
			combo_solution.setItems(item);
			if(item.length == 1){
				combo_solution.setText(item[0]);
				setUser();
			}
		}else if(text.equals(LayerConstants.SOLUTION_PLUGIN_LAYER)){
			combo_solution.removeAll();
			
			LayerService layerService = ObjectContainer.getInstance(LayerService.class);
			List<String> array = layerService.getSolutionListForSourcePlugin();
			String[] item = array.toArray(new String[array.size()]);
			combo_solution.setEnabled(true);
			combo_solution.setItems(item);
			if(item.length > 0){
				combo_solution.setText(item[0]);
				setPlug();
				setUser();
			}
		}else {
			combo_solution.removeAll();
			combo_user.removeAll();
			combo_plug.removeAll();
			combo_solution.setEnabled(false);
			combo_plug.setEnabled(false);
			List<String> user = LoadXmlCore.gotServices.getEditUsers(combo_layer.getText(), combo_solution.getText(), combo_plug.getText());
			String[] item = user.toArray(new String[user.size()]);
			combo_user.setItems(item);
			if(item.length == 1){
				combo_user.setText(item[0]);
			}
		}
	}

}
